#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/iolib/bstrout.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.6
 | File mod date:    1997.11.29 23:10:41
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  iolib
 |
 | Purpose:          Bounded-output strings
 `------------------------------------------------------------------------|#

(define-class <bounded-string-output-port> (<output-port>)
  current-buffer
  current-buffer-index
  overflow-procedure)

(define (bounded-string-port-overflowed port)
 ((overflow-procedure port) (current-buffer port)))

(define-glue (bounded-string-output-port-close port)
{
  REG0 = BSOP_close(port);
  RETURN1();
})

(define-method close-output-port ((self <bounded-string-output-port>))
  (string-output-port-close self))

(define (open-output-bounded-string proc (n <fixnum>))
  (make <bounded-string-output-port>
	current-buffer: (bvec-alloc <string> (add1 n))
	current-buffer-index: 0
	overflow-procedure: proc))

(define-glue (bounded-string-output-port-write-char port the_char)
 literals: ((& bounded-string-port-overflowed))
{
char ch;

    ch = GET_IMMEDIATE_VALUE(the_char);
    if (!BSOP_write( port, &ch, 1 ))
      APPLY(1,TLREF(0));
    else
      RETURN0();
})

(define-method output-port-write-char ((self <bounded-string-output-port>) 
				       (ch <ascii-char>))
  (bounded-string-output-port-write-char self ch))


(define-glue (bounded-string-output-port-write-string port the_str)
 literals: ((& bounded-string-port-overflowed))
{
    if (!BSOP_write( port, string_text(the_str), string_length(the_str) ))
      APPLY(1,TLREF(0));
    else
      RETURN0();
})

(define-method write-string ((self <bounded-string-output-port>) 
			     (str <string>))
  (bounded-string-output-port-write-string self str))


(define-glue (bounded-string-output-port-write-int port the_int)
 literals: ((& bounded-string-port-overflowed))
{
char temp[20];

    sprintf( temp, "%d", fx2int(the_int) );
    if (!BSOP_write( port, temp, strlen(temp) ))
      APPLY(1,TLREF(0));
    else
      RETURN0();
})

(define-method write-int ((self <bounded-string-output-port>) (int <fixnum>))
  (bounded-string-output-port-write-int self int))

;;
;;  friendly functions...
;;

(define (with-bounded-string-port* size proc finish-proc1 finish-proc2)
  (call-with-current-continuation
   (lambda (exit)
     (let ((port (open-output-bounded-string (lambda (result)
					       (exit (finish-proc2 result)))
					     size)))
       (proc port)
       (finish-proc1 (bounded-string-output-port-close port))))))

(define (bstr-negarg fn len)
  (error "~s: arg `len' must be non-negative, not ~d"
	 fn
	 len))

(define (object->bounded-string (len <fixnum>) thing)
  (if (fixnum<? len 0)
      (bstr-negarg 'object->bounded-string len)
      (with-bounded-string-port* 
       len
       (lambda (p) (write-object thing p))
       identity
       (lambda (str) (string-append str "...")))))

(define (display->bounded-string (len <fixnum>) thing)
  (if (fixnum<? len 0)
      (bstr-negarg 'display->bounded-string len)
      (with-bounded-string-port* 
       len
       (lambda (p) (display-object thing p))
       identity
       identity)))
