#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/iolib/console.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.6
 | File mod date:    1997.11.29 23:10:40
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  iolib
 |
 | Purpose:          "console" I/O ports
 `------------------------------------------------------------------------|#

(define $standard-input-port
  (make <std-input-port>
	file-stream: (stdin)
	peeked-char: #f))

(define $standard-output-port
  (make <std-output-port>
	file-stream: (stdout)))

(define $standard-error-port
  (make <std-output-port>
	file-stream: (stderr)))

;; analogue of unix's fd 0, 1, 2

(define-fluid *input-port* $standard-input-port)
(define-fluid *output-port* $standard-output-port)
(define-fluid *error-port* $standard-error-port)
 
(define (current-input-port)
  (fluid-ref *input-port* $standard-input-port))

(define (current-output-port)
  (fluid-ref *output-port* $standard-output-port))

(define (current-error-port)
  (fluid-ref *error-port* $standard-error-port))

;; analogue of unix's /dev/tty

(define-fluid *console-input-port* $standard-input-port)
(define-fluid *console-output-port* $standard-output-port)
(define-fluid *console-error-port* $standard-error-port)

;; backward compatibility

(define $console-input-port $standard-input-port)
(define $console-output-port $standard-output-port)
(define $console-error-port $standard-error-port)
