#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/objsys/genericf.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.15
 | File mod date:    1997.11.29 23:10:38
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  objsys
 |
 | Purpose:          Generic function dispatcher and find-method
 `------------------------------------------------------------------------|#

#|
   This is the default generic function dispatcher

   It's what gets called when a generic function is
   invoked.  The environment, as set up by the 
   define-generic-function compiler, consists (initially)
   of a single frame, which contains a pointer to
   the <generic-function> instance (a back-pointer to 
   the function, since the function ptr is lost in our
   calling convention), and a slot with initialize value ()
   which may be used for caching or whatever.
|#

(define-safe-glue (get-gf-lru-histogram resetq)
{
  REG0 = collect_gf_cache_histogram( truish(resetq) );
  RETURN1();
})

(define-glue (generic-function-dispatch) :template
{
  return rs_gf_dispatch( envt_reg );
})

(define-safe-glue (pre-compute-dispatch (gf <generic-function>) rcvr #rest)
  literals: ((& load-cache))
{
  obj m;

  m = rs_gf_find_method( gf, rcvr );
  if (EQ(m,FALSE_OBJ))
    {
      COLLECT1();
      APPLYF( 2, TLREF(0) );
    }
  else
    {
      REG0 = m;
      RETURN1();
    }
})

(define (call-gf-with-zero-args (gf <generic-function>))
  (error "~s: generic function called with no arguments"
	 (generic-function-name gf)))

(define (does-not-understand (gf <generic-function>) (args <list>))
  (error "~s: generic function doesn't understand ~s\n(rest are ~s)"
	 (generic-function-name gf)
	 (car args) (cdr args)))

(%strategy ccode

(define-syntax (method-key-class m)
  (car (gvec-ref m 2)))

(define-syntax (method-function-specializers m)
  (gvec-ref m 2))

(define (find-method-by-class (gf <generic-function>) class)
  (let loop ((i (generic-function-methods gf)))
    (if (pair? i)
	(if (subclass? class (method-key-class (car i)))
	    (car i)
	    (loop (cdr i)))
	#f)))

(define (find-method (gf <generic-function>) (args <pair>))
  (find-method-by-class gf (object-class (car args))))

(define (load-cache (gf <generic-function>) (args <pair>))
  (set-miss-count! gf (add1 (miss-count gf)))
  (let ((m (find-method-by-class gf (object-class (car args)))))
    (if m
	;;
	;; store it in the cache..
	;;
	(let* (((c <<class>>) (object-class (car args)))
	       ((ix <fixnum>) (fixnum+ 4 (bitwise-and (class-hash c) #b110))))
	  (let-syntax ((do-overflow (syntax-form ()
				      (set-gf-cache-overflow! 
				       gf
				       (%make <vector> 
					      (gf-cache-overflow gf)
					      (gf-cache-V-k gf)
					      (gf-cache-V-v gf)))))
		       (do-victim (syntax-form ()
				    (set-gf-cache-V-v! gf 
						       (gvec-ref gf (add1 ix)))
				    (set-gf-cache-V-k! gf 
						       (gvec-ref gf ix))))
		       (do-primary (syntax-form ()
				     (gvec-set! gf ix c)
				     (gvec-set! gf (add1 ix) m)
				     m)))
	    (if (gvec-ref gf ix)
		(if (gf-cache-V-k gf)
		    (begin
		      (do-overflow)
		      (do-victim)
		      (do-primary))
		    (begin
		      (do-victim)
		      (do-primary)))
		(do-primary))))
	(does-not-understand gf args))))

(define (load-cache-and-call (gf <generic-function>) (args <pair>))
  (apply* args (load-cache gf args)))
)

;;

(define (clear-gf-cache! (gf <generic-function>))
  (set-gf-cache-0-k! gf #f) (set-gf-cache-0-v! gf #f)
  (set-gf-cache-1-k! gf #f) (set-gf-cache-1-v! gf #f)
  (set-gf-cache-2-k! gf #f) (set-gf-cache-2-v! gf #f)
  (set-gf-cache-3-k! gf #f) (set-gf-cache-3-v! gf #f)
  (set-gf-cache-V-k! gf #f) (set-gf-cache-V-v! gf #f)
  (set-gf-cache-overflow! gf #f))
