#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/regex/unformat.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.4
 | File mod date:    1997.11.29 23:10:31
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  regex
 |
 `------------------------------------------------------------------------|#


(define (unformat->proc str . opts)
  (let* ((anywhere? (if (pair? opts)
			(car opts)
			#f))
	 (structure (parse-format-string str))
	 (handler '())
	 (pat (cons 'seq
		    (map (lambda (elem)
			   (if (string? elem)
			       elem
			       (bind ((unf pat (unfmtch->pat elem)))
				 (set! handler
				       (cons unf handler))
				 (list 'let (gensym) pat))))
			 structure)))
	 (matcher (reg-expr->proc
		   (if anywhere?
		       pat
		       (list 'entire pat)))))
    (if (null? handler)
	(error "unformat->proc: no format specifiers in ~s" str))
    (if anywhere?
	(mk-unformatter matcher (reverse handler))
	(mk-unformatter-exact matcher (reverse handler)))))

(define (mk-unformatter matcher unformatters)
  (lambda (str)
    (bind ((s e #rest ps (matcher str)))
      (if s
	  (list->values
	   (cons* s e (map (lambda (proc arg)
			     (proc arg))
			   unformatters
			   ps)))
	  (values)))))

(define (mk-unformatter-exact matcher unformatters)
  (lambda (str)
    (bind ((s e #rest ps (matcher str)))
      (if s
	  (list->values
	   (map (lambda (proc arg)
		  (proc arg))
		unformatters
		ps))
	  (values)))))

(define (unformat/a (str <string>))
  str)

(define (unformat/s (str <string>))
  (let ((item (read (open-input-string str))))
    (if (eof-object? item)
	(error "unformat/s: ~s has no readable content" str)
	item)))
  
(define (unformat/d (str <string>))
  (or (string->number str)
      (error "unformat/d: ~s is not a number" str)))

(define *default-unformatters*
  (list (list #\a unformat/a '(* any))
	(list #\s unformat/s '(* any))
	(list #\d unformat/d '(+ (or digit #\.)))))

(define (unfmtch->pat ch)
  (let ((x (assq ch *default-unformatters*)))
    (if x
	(values (cadr x) (caddr x))
	(error "invalid unformat char: ~s" ch))))
