(define (echo-responder remains query data)
  (html
   (title (display "RScheme Query Responder"))
   (header-1 (display "Query Responder"))
   (format #t "remaining path: ")
   (code (bold (display (string-join #\/ remains))))
   (par)
   (unnumbered-list
    (list-item (display "First item\n"))
    (list-item (display "Second ")
	       (bold (display "item"))
	       (display ".\n")))
   (format #t "This is the foo bar page.  How is it?\n")
   (par)
   (format #t "This is another paragraph.\n")
   (header-2 (display "Section 1."))
   (format #t "This is section 1.\n")
   (format #t "This is still section 1.\n")
   (format #t "Here is a ")
   (output-port-control (current-output-port) 'ref "quux/33")
   (format #t "<link>")
   (output-port-control (current-output-port) 'ref #f)
   (format #t "!\n")
   (par)
   (display "Here is ")
   (hyperlink ("/side/x")
	      (display "a side link"))
   (display ".\n")
   (par)
   (display "And here is a short form: ")
   (input-form (POST "http://kali.tkg.com:8080/g/goo")
	       (bold (display "user-id"))
	       (display ": ")
	       (input-field name 12)
	       (submit-button 'go1 "Go!")
	       (submit-button 'go2 "Go Fast!")
	       (par)
	       (display "You can enter a program here:")
	       (par)
	       (big-text-field 'pgm 10 50 "(cons 1 2)"))
   (header-2 (display "Section 2."))
   (format #t "This is section 2.")
   (header-1 (display "Received Data"))
   (header-2 (display "Section 1. Header"))
   (unnumbered-list
    (for-each (lambda (q)
		(list-item (format #t "~s => ~s" (car q) (cdr q))))
	      query))
   (header-2 (display "Section 2. Data"))
   (if data
       (begin
	 (format #t "~d bytes were received\n" (string-length data))
	 (preformatted (print data)))
       (format #t "no data was received\n"))
   (if (and (not (null? query))
	    (eq? 'POST (cdr (assq 'request-type query))))
       (begin
	 (header-2 (display "Section 3. POST data"))
	 (display "This section lists the parsed ")
	 (bold (display "POST"))
	 (display " data\n")
	 (unnumbered-list
	  (for-each (lambda (ent)
		      (list-item (format #t "~s => ~s" (car ent) (cdr ent))))
		    (parse-POST-args data)))))))

