/*
 * FILE : ../_gnomeuimodule.c
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 (Patch 2)
 * 
 * Portions Copyright (c) 1995-1997
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : PYTHON */

#define SWIGPYTHON
#include <string.h>
#include <stdlib.h>
/***********************************************************************
 * $Header:$
 * swig_lib/python/python.cfg
 *
 * This file contains coded needed to add variable linking to the
 * Python interpreter.   C variables are added as a new kind of Python
 * datatype.
 *
 * Also contains supporting code for building python under Windows
 * and things like that.
 *
 * $Log:$
 ************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif
#include "Python.h"
#ifdef __cplusplus
}
#endif

/* Definitions for Windows/Unix exporting */
#if defined(__WIN32__)
#   if defined(_MSC_VER)
#	define SWIGEXPORT(a,b) __declspec(dllexport) a b
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a,b) a _export b
#	else
#	    define SWIGEXPORT(a,b) a b
#	endif
#   endif
#else
#   define SWIGEXPORT(a,b) a b
#endif

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif

typedef struct {
  char  *name;
  PyObject *(*get_attr)(void);
  int (*set_attr)(PyObject *);
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar **vars;
  int      nvars;
  int      maxvars;
} swig_varlinkobject;

/* ----------------------------------------------------------------------
   swig_varlink_repr()

   Function for python repr method
   ---------------------------------------------------------------------- */

static PyObject *
swig_varlink_repr(swig_varlinkobject *v)
{
  v = v;
  return PyString_FromString("<Global variables>");
}

/* ---------------------------------------------------------------------
   swig_varlink_print()

   Print out all of the global variable names
   --------------------------------------------------------------------- */

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags)
{

  int i = 0;
  flags = flags;
  fprintf(fp,"Global variables { ");
  while (v->vars[i]) {
    fprintf(fp,"%s", v->vars[i]->name);
    i++;
    if (v->vars[i]) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

/* --------------------------------------------------------------------
   swig_varlink_getattr
 
   This function gets the value of a variable and returns it as a
   PyObject.   In our case, we'll be looking at the datatype and
   converting into a number or string
   -------------------------------------------------------------------- */

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n)
{
  int i = 0;
  char temp[128];

  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->get_attr)();
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return NULL;
}

/* -------------------------------------------------------------------
   swig_varlink_setattr()

   This function sets the value of a variable.
   ------------------------------------------------------------------- */

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p)
{
  char temp[128];
  int i = 0;
  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->set_attr)(p);
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return 1;
}

statichere PyTypeObject varlinktype = {
/*  PyObject_HEAD_INIT(&PyType_Type)  Note : This doesn't work on some machines */
  PyObject_HEAD_INIT(0)              
  0,
  "varlink",                          /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */

SWIGSTATIC PyObject *
SWIG_newvarlink(void)
{
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  /*  _Py_NewReference(result);  Does not seem to be necessary */
  result->nvars = 0;
  result->maxvars = 64;
  result->vars = (swig_globalvar **) malloc(64*sizeof(swig_globalvar *));
  result->vars[0] = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGSTATIC void
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p))
{
  swig_varlinkobject *v;
  v= (swig_varlinkobject *) p;
	
  if (v->nvars >= v->maxvars -1) {
    v->maxvars = 2*v->maxvars;
    v->vars = (swig_globalvar **) realloc(v->vars,v->maxvars*sizeof(swig_globalvar *));
    if (v->vars == NULL) {
      fprintf(stderr,"SWIG : Fatal error in initializing Python module.\n");
      exit(1);
    }
  }
  v->vars[v->nvars] = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  v->vars[v->nvars]->name = (char *) malloc(strlen(name)+1);
  strcpy(v->vars[v->nvars]->name,name);
  v->vars[v->nvars]->get_attr = get_attr;
  v->vars[v->nvars]->set_attr = set_attr;
  v->nvars++;
  v->vars[v->nvars] = 0;
}



/* remove swig pointer handling code */
#define SWIG_RegisterMapping(o,n,f)
#define SWIG_MakePtr(b,p,t)
#define SWIG_GetPtr(b,p,t) NULL

#define SWIG_init    init_gnomeui

#define SWIG_name    "_gnomeui"

#include "gnome.h"
#include "sysmodule.h"

typedef struct {
  PyObject_HEAD
  GtkObject *obj;
} PyGtk_Object;
static PyTypeObject *PyGtk_Type;

typedef struct {
  PyObject_HEAD
  GtkAccelGroup *obj;
} PyGtkAccelGroup_Object;
static PyTypeObject *PyGtkAccelGroup_Type;

typedef struct {
  PyObject_HEAD
  GtkStyle *obj;
} PyGtkStyle_Object;
static PyTypeObject *PyGtkStyle_Type;

typedef struct {
  PyObject_HEAD
  GdkFont *obj;
} PyGdkFont_Object;
static PyTypeObject *PyGdkFont_Type;

typedef struct {
  PyObject_HEAD
  GdkColor obj;
} PyGdkColor_Object;
static PyTypeObject *PyGdkColor_Type;

typedef struct {
  PyObject_HEAD
  GdkEvent *obj;
        PyObject *attrs;
} PyGdkEvent_Object;
static PyTypeObject *PyGdkEvent_Type;

typedef struct {
  PyObject_HEAD
  GdkWindow *obj;
} PyGdkWindow_Object;
static PyTypeObject *PyGdkWindow_Type;

typedef struct {
  PyObject_HEAD
  GdkGC *obj;
} PyGdkGC_Object;
static PyTypeObject *PyGdkGC_Type;

typedef struct {
  PyObject_HEAD
  GdkColormap *obj;
} PyGdkColormap_Object;
static PyTypeObject *PyGdkColormap_Type;

#define PyGtk_Check(v) ((v)->ob_type == PyGtk_Type)
#define PyGtk_Get(v) (((PyGtk_Object *)(v))->obj)
#define PyGtkAccelGroup_Check(v) ((v)->ob_type == PyGtkAccelGroup_Type)
#define PyGtkAccelGroup_Get(v) (((PyGtkAccelGroup_Object *)(v))->obj)
#define PyGtkStyle_Check(v) ((v)->ob_type == PyGtkStyle_Type)
#define PyGtkStyle_Get(v) (((PyGtkStyle_Object *)(v))->obj)
#define PyGdkFont_Check(v) ((v)->ob_type == PyGdkFont_Type)
#define PyGdkFont_Get(v) (((PyGdkFont_Object *)(v))->obj)
#define PyGdkColor_Check(v) ((v)->ob_type == PyGdkColor_Type)
#define PyGdkColor_Get(v) (&((PyGdkColor_Object *)(v))->obj)
#define PyGdkEvent_Check(v) ((v)->ob_type == PyGdkEvent_Type)
#define PyGdkEvent_Get(v) (((PyGdkEvent_Object *)(v))->obj)
#define PyGdkWindow_Check(v) ((v)->ob_type == PyGdkWindow_Type)
#define PyGdkWindow_Get(v) (((PyGdkWindow_Object *)(v))->obj)
#define PyGdkGC_Check(v) ((v)->ob_type == PyGdkGC_Type)
#define PyGdkGC_Get(v) (((PyGdkGC_Object *)(v))->obj)
#define PyGdkColormap_Check(v) ((v)->ob_type == PyGdkColormap_Type)
#define PyGdkColormap_Get(v) (((PyGdkColormap_Object *)(v))->obj)

static PyObject *(*PyGtk_New)(GtkObject *)=0;
static PyObject *(*PyGtkAccelGroup_New)(GtkAccelGroup *)=0;
static PyObject *(*PyGtkStyle_New)(GtkStyle *)=0;
static PyObject *(*PyGdkFont_New)(GdkFont *)=0;
static PyObject *(*PyGdkColor_New)(GdkColor *)=0;
static PyObject *(*PyGdkEvent_New)(GdkEvent *)=0;
static PyObject *(*PyGdkWindow_New)(GdkWindow *)=0;
static PyObject *(*PyGdkGC_New)(GdkGC *)=0;
static PyObject *(*PyGdkColormap_New)(GdkColormap *)=0;

static void (*PyGtk_CallbackMarshal)(GtkObject *o, gpointer data,
				     int nargs, GtkArg *args)=0;
static void (*PyGtk_DestroyNotify)(gpointer data)=0;

static PyObject *(*GtkArgs_AsTuple)(int nparams, GtkArg *args)=0;
static int (*GtkArgs_FromSequence)(GtkArg *args, int nparams, PyObject *seq)=0;
static int (*GtkArg_FromPyObject)(GtkArg *arg, PyObject *obj)=0;
static PyObject *(*GtkArg_AsPyObject)(GtkArg *arg)=0;
static void (*GtkRet_FromPyObject)(GtkArg *ret, PyObject *py_ret)=0;
static PyObject *(*GtkRet_AsPyObject)(GtkArg *ret)=0;

static int (*PyGtkEnum_get_value)(GtkType type, PyObject *obj, gint *val)=0;
static int (*PyGtkFlag_get_value)(GtkType type, PyObject *obj, gint *val)=0;

static GtkArg *(*PyDict_AsGtkArgs)(PyObject *dict, GtkType type, gint*nargs)=0;

static void pygtk_init() {
  PyObject *gtkbase, *dict, *func, *ret;

  gtkbase = PyImport_ImportModule("_gtkbase");
  dict = PyModule_GetDict(gtkbase);
  Py_DECREF(gtkbase);

  ret = PyObject_CallObject(PyDict_GetItemString(dict, "gtk_init"), NULL);
  Py_DECREF(ret);

  /* extract the types */
  PyGtk_Type = (PyTypeObject *)PyDict_GetItemString(dict, "GtkObjectType");
  Py_INCREF(PyGtk_Type);
  PyGtkAccelGroup_Type = (PyTypeObject *)PyDict_GetItemString(dict,
						"GtkAccelGroupType");
  Py_INCREF(PyGtkAccelGroup_Type);
  PyGtkStyle_Type = (PyTypeObject *)PyDict_GetItemString(dict, "GtkStyleType");
  Py_INCREF(PyGtkStyle_Type);
  PyGdkFont_Type = (PyTypeObject *)PyDict_GetItemString(dict, "GdkFontType");
  Py_INCREF(PyGdkFont_Type);
  PyGdkColor_Type = (PyTypeObject *)PyDict_GetItemString(dict, "GdkColorType");
  Py_INCREF(PyGdkColor_Type);
  PyGdkEvent_Type = (PyTypeObject *)PyDict_GetItemString(dict, "GdkEventType");
  Py_INCREF(PyGdkEvent_Type);
  PyGdkWindow_Type = (PyTypeObject*)PyDict_GetItemString(dict,"GdkWindowType");
  Py_INCREF(PyGdkWindow_Type);
  PyGdkGC_Type = (PyTypeObject *)PyDict_GetItemString(dict, "GdkGCType");
  Py_INCREF(PyGdkGC_Type);
  PyGdkColormap_Type = (PyTypeObject *)PyDict_GetItemString(dict,
							    "GdkColormapType");
  Py_INCREF(PyGdkColormap_Type);

  dict = PyDict_GetItemString(dict, "_private");
  PyGtk_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGtk_New"));
  PyGtkAccelGroup_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGtkAccelGroup_New"));
  PyGtkStyle_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGtkStyle_New"));
  PyGdkFont_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGdkFont_New"));
  PyGdkColor_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGdkColor_New"));
  PyGdkEvent_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGdkEvent_New"));
  PyGdkWindow_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGdkWindow_New"));
  PyGdkGC_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGdkGC_New"));
  PyGdkColormap_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGdkColormap_New"));

  PyGtk_DestroyNotify = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGtk_DestroyNotify"));
  PyGtk_CallbackMarshal = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGtk_CallbackMarshal"));

  GtkArgs_AsTuple = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"GtkArgs_AsTuple"));
  GtkArgs_FromSequence = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"GtkArgs_FromSequence"));
  GtkRet_FromPyObject = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"GtkRet_FromPyObject"));
  GtkRet_AsPyObject = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"GtkRet_AsPyObject"));

  PyGtkEnum_get_value = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGtkEnum_get_value"));
  PyGtkFlag_get_value = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGtkFlag_get_value"));

  PyDict_AsGtkArgs = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyDict_AsGtkArgs"));
}


/* This is needed because a NULL signal handler is taken to mean that the
 * python signal handler should be called using the user data as a function.
 * This function is used to prevent seg faults where we really don't want a
 * python signal handler invoked.
 */
static void dummy_handler(GtkWidget *w, gpointer data) {
}

static GnomeUIInfo *list_to_ui_info(PyObject *list) {
  GnomeUIInfo *ret, *sub;
  PyObject *item, *moreinfo;
  int len, i;
  int type, pix_type;
  char buf[100];

  if (!PyList_Check(list)) {
    PyErr_SetString(PyExc_TypeError, "object not a list");
    return NULL;
  }
  len = PyList_Size(list);
  ret = g_new(GnomeUIInfo, len + 1);
  ret[len].type = GNOME_APP_UI_ENDOFINFO; /* set terminator */
  
  for (i = 0; i < len; i++) {
    item = PyList_GetItem(list, i);
    if (!PyTuple_Check(item) || !PyArg_ParseTuple(item, "izzOizci",
						  &(ret[i].type),
						  &(ret[i].label),
						  &(ret[i].hint),
						  &moreinfo,
						  &(ret[i].pixmap_type),
						  &(ret[i].pixmap_info),
						  &(ret[i].accelerator_key),
						  &(ret[i].ac_mods))) {
      PyErr_Clear();
      sprintf(buf, "badly formed tuple for \"%s\" (type %i)", ret[i].label,
              ret[i].type);
      PyErr_SetString(PyExc_TypeError, buf);
      g_free(ret);
      return NULL;
    }
    type = ret[i].type; pix_type = ret[i].pixmap_type;
    if (type < GNOME_APP_UI_ENDOFINFO || type > GNOME_APP_UI_JUSTIFY_RIGHT ||
	pix_type < GNOME_APP_PIXMAP_NONE ||
	pix_type > GNOME_APP_PIXMAP_FILENAME ||
	pix_type == GNOME_APP_PIXMAP_DATA) {
      sprintf(buf, "bad info or pixmap type for label \"%s\"", ret[i].label);
      PyErr_SetString(PyExc_TypeError, buf);
      g_free(ret);
      return NULL;
    }
    switch(type) {
    case GNOME_APP_UI_ENDOFINFO:
    case GNOME_APP_UI_SEPARATOR:
    case GNOME_APP_UI_JUSTIFY_RIGHT:
      ret[i].moreinfo = dummy_handler;
      ret[i].user_data = NULL;
      break;
    case GNOME_APP_UI_ITEM:
    case GNOME_APP_UI_TOGGLEITEM:
      if (moreinfo == Py_None) {
        ret[i].moreinfo = dummy_handler;
        ret[i].user_data = NULL;
        break;
      }
      if (!PyCallable_Check(moreinfo)) {
	sprintf(buf, "additional info not callable (label \"%s\")",
		ret[i].label);
	PyErr_SetString(PyExc_TypeError, buf);
	g_free(ret);
	return NULL;
      }
      ret[i].moreinfo = NULL;
      Py_INCREF(moreinfo);
      ret[i].user_data = moreinfo;
      break;
    case GNOME_APP_UI_RADIOITEMS:
      sub = list_to_ui_info(moreinfo);
      if (sub == NULL) {
	g_free(ret);
	return NULL;
      }
      ret[i].moreinfo = sub;
      break;
    case GNOME_APP_UI_SUBTREE:
      sub = list_to_ui_info(moreinfo);
      if (sub == NULL) {
	g_free(ret);
	return NULL;
      }
      ret[i].moreinfo = sub;
      break;
    case GNOME_APP_UI_HELP:
      if (moreinfo != Py_None && !PyString_Check(moreinfo)) {
	PyErr_SetString(PyExc_TypeError, "additional info should be a string for help");
	g_free(ret);
	return NULL;
      }
      if (moreinfo == Py_None)
	ret[i].moreinfo = NULL;
      else
	ret[i].moreinfo = PyString_AsString(moreinfo);
      break;
    }
  }
  return ret;
}

static void free_ui_info(GnomeUIInfo *inf) {
  int i = 0;
  
  while (inf[i].type != GNOME_APP_UI_ENDOFINFO) {
    if (inf[i].type == GNOME_APP_UI_RADIOITEMS ||
	inf[i].type == GNOME_APP_UI_SUBTREE)
      if (inf[i].moreinfo !=  NULL)
	free_ui_info(inf[i].moreinfo);
    i++;
  }
  g_free(inf);
}

#pragma }

typedef struct {
  int type;
  union {
    char *ch_pp;
    int int_p;
    double dbl_p;
    PyObject *tuple; /* of form (callback, userdata). Type set to CALLBACK */
  } d;
} cauldron_result;
typedef struct {
  PyObject *args;
  int arg_len, pos, num_results, num_rets;
  cauldron_result *results;
} cauldron_data;

static GtkWidget *PyGtk_cauldron_callback(GtkWidget *self, PyObject *tuple) {
  PyObject *ret, *params;
  GtkWidget *wret;

  ret = PyTuple_New(1);
  PyTuple_SetItem(ret, 0, PyGtk_New((GtkObject *)self));
  params = PySequence_Concat(ret, PyTuple_GetItem(tuple, 1));
  Py_DECREF(ret);

  ret = PyObject_CallObject(PyTuple_GetItem(tuple, 0), params);
  Py_DECREF(params);
  if (ret == NULL) {
    PyErr_Print();
    PyErr_Clear();
    return NULL;
  }

  if (ret == Py_None) { /* this should only be returned by 'c' type callbacks*/
    Py_DECREF(ret);
    return NULL;
  } else if (PyGtk_Check(ret)) {
    wret = GTK_WIDGET(PyGtk_Get(ret));
    /* the returned widget should still have its floating reference set */
    Py_DECREF(ret);
    return wret;
  } else if ((params = PyObject_GetAttrString(ret, "_o")) &&
	     PyGtk_Check(params)) { /* for Gtkinter */
    wret = GTK_WIDGET(PyGtk_Get(params));
    Py_DECREF(params);
    Py_DECREF(ret);
    return wret;
  }
  Py_XDECREF(params);
  Py_DECREF(ret);
  return NULL;
}

static void next_arg(gint type, cauldron_data *data, void *result) {
  PyObject *item;

  /* there doesn't seem to be any error reporting mechanism -- just fudge it */
  if (data->pos >= data->arg_len) {
    *((int *)result) = 0;
    return;
  }
  item = PyTuple_GetItem(data->args, data->pos++);
  switch (type) {
  case GTK_CAULDRON_TYPE_CHAR_P:
    if (PyString_Check(item))
      *((gchar **)result) = PyString_AsString(item);
    else {
      g_warning("expected string argument, got %s", item->ob_type->tp_name);
      *((gchar **)result) = "";
    }
    break;
  case GTK_CAULDRON_TYPE_CHAR_P_P:
    data->results[data->num_results].type = type;
    if (PyString_Check(item))
      data->results[data->num_results].d.ch_pp = PyString_AsString(item);
    else {
      g_warning("expected string argument, got %s", item->ob_type->tp_name);
      data->results[data->num_results].d.ch_pp = "";
    }
    data->num_rets++;
    *((gchar ***)result) = &(data->results[data->num_results++].d.ch_pp);
    break;
  case GTK_CAULDRON_TYPE_INT:
    if (PyInt_Check(item))
      *((gint *)result) = PyInt_AsLong(item);
    else {
      g_warning("expected int argument, got %s", item->ob_type->tp_name);
      *((gint *)result) = 0;
    }
    break;
  case GTK_CAULDRON_TYPE_INT_P:
    data->results[data->num_results].type = type;
    if (PyInt_Check(item))
      data->results[data->num_results].d.int_p = PyInt_AsLong(item);
    else {
      g_warning("expected int argument, got %s", item->ob_type->tp_name);
      data->results[data->num_results].d.int_p = 0;
    }
    data->num_rets++;
    *((gint **)result) = &(data->results[data->num_results++].d.int_p);
    break;
  case GTK_CAULDRON_TYPE_DOUBLE:
    if (PyFloat_Check(item))
      *((gdouble *)result) = PyFloat_AsDouble(item);
    else {
      g_warning("expected float argument, got %s", item->ob_type->tp_name);
      *((gdouble *)result) = 0.0;
    }
    break;
  case GTK_CAULDRON_TYPE_DOUBLE_P:
    data->results[data->num_results].type = type;
    if (PyFloat_Check(item))
      data->results[data->num_results].d.dbl_p = PyFloat_AsDouble(item);
    else {
      g_warning("expected float argument, got %s", item->ob_type->tp_name);
      data->results[data->num_results].d.dbl_p = 0.0;
    }
    data->num_rets++;
    *((gdouble **)result) = &(data->results[data->num_results++].d.dbl_p);
    break;
  case GTK_CAULDRON_TYPE_CALLBACK:
    data->results[data->num_results].type = type;
    data->results[data->num_results].d.tuple = PyTuple_New(2);
    Py_INCREF(item);
    PyTuple_SetItem(data->results[data->num_results++].d.tuple, 0, item);
    *((gpointer*)result) = PyGtk_cauldron_callback;
    break;
  case GTK_CAULDRON_TYPE_USERDATA_P:
    g_assert(data->results[data->num_results-1].type == GTK_CAULDRON_TYPE_CALLBACK);
    Py_INCREF(item);
    PyTuple_SetItem(data->results[data->num_results-1].d.tuple, 1, item);
    *((PyObject **)result) = data->results[data->num_results-1].d.tuple;
    break;
  }
}

static PyObject *gtk__dialog_cauldron(PyObject *self, PyObject *args) {
  PyObject *ret;
  char *title, *fmt;
  int options, i, j;
  cauldron_data data;
  char *result;

  if (!PyArg_ParseTuple(args, "sisO!:gtk_dialog_cauldron", &title,
			&options, &fmt, &PyTuple_Type, &(data.args)))
    return NULL;
  data.arg_len = PyTuple_Size(data.args);
  data.pos = data.num_results = 0;
  data.num_rets = 1; /* we always return at least a string */
  data.results = g_new(cauldron_result, data.arg_len);
  result = gtk_dialog_cauldron_parse(title, options, fmt,
				     (GtkCauldronNextArgCallback)next_arg,
				     &data);
  if (!result) result = "";
  if (data.num_rets == 1)
    ret = PyString_FromString(result);
  else {
    ret = PyTuple_New(data.num_rets);
    j = 0;
    PyTuple_SetItem(ret, j, PyString_FromString(result));
    for (i = 0; i < data.num_results; i++) {
      switch (data.results[i].type) {
      case GTK_CAULDRON_TYPE_CHAR_P_P:
	PyTuple_SetItem(ret, ++j,PyString_FromString(data.results[i].d.ch_pp));
	break;
      case GTK_CAULDRON_TYPE_INT_P:
	PyTuple_SetItem(ret, ++j, PyInt_FromLong(data.results[i].d.int_p));
	break;
      case GTK_CAULDRON_TYPE_DOUBLE_P:
	PyTuple_SetItem(ret, ++j, PyFloat_FromDouble(data.results[i].d.dbl_p));
	break;
      case GTK_CAULDRON_TYPE_CALLBACK:
	Py_DECREF(data.results[i].d.tuple);
	break;
      default:
	g_assert_not_reached();
	Py_INCREF(Py_None);
	PyTuple_SetItem(ret, ++j, Py_None);
      }
    }
  }
  g_free(data.results);
  return ret;
}


static PyObject *gnome__canvas_get_scroll_region(PyObject *self,
						 PyObject *args) {
  PyObject *obj;
  double x1, y1, x2, y2;
  if (!PyArg_ParseTuple(args, "O!:gnome_canvas_get_scroll_region", PyGtk_Type,
			&obj))
    return NULL;
  gnome_canvas_get_scroll_region(GNOME_CANVAS(PyGtk_Get(obj)), &x1, &y1,
				 &x2,&y2);
  return Py_BuildValue("(dddd)", x1, y1, x2, y2);
}

static PyObject *gnome__canvas_get_scroll_offsets(PyObject *self,
						  PyObject *args) {
  PyObject *obj;
  int cx, cy;
  if (!PyArg_ParseTuple(args, "O!:gnome_canvas_get_scroll_offsets", PyGtk_Type,
			&obj))
    return NULL;
  gnome_canvas_get_scroll_offsets(GNOME_CANVAS(PyGtk_Get(obj)), &cx, &cy);
  return Py_BuildValue("(ii)", cx, cy);
}

static PyObject *gnome__canvas_w2c(PyObject *self, PyObject *args) {
  PyObject *obj;
  int cx, cy;
  double wx, wy;
  if (!PyArg_ParseTuple(args, "O!dd:gnome_canvas_w2c", PyGtk_Type, &obj,wx,wy))
    return NULL;
  gnome_canvas_w2c(GNOME_CANVAS(PyGtk_Get(obj)), wx, wy, &cx, &cy);
  return Py_BuildValue("(ii)", cx, cy);
}
static PyObject *gnome__canvas_c2w(PyObject *self, PyObject *args) {
  PyObject *obj;
  int cx, cy;
  double wx, wy;
  if (!PyArg_ParseTuple(args, "O!ii:gnome_canvas_w2c", PyGtk_Type, &obj,cx,cy))
    return NULL;
  gnome_canvas_c2w(GNOME_CANVAS(PyGtk_Get(obj)), cx, cy, &wx, &wy);
  return Py_BuildValue("(dd)", wx, wy);
}
static PyObject *gnome__canvas_get_color(PyObject *self, PyObject *args) {
  PyObject *obj;
  char *spec;
  GdkColor color;
  if (!PyArg_ParseTuple(args, "O!s:gnome_canvas_get_color", PyGtk_Type, &obj,
			&spec));
  if (gnome_canvas_get_color(GNOME_CANVAS(PyGtk_Get(obj)), spec, &color))
    return PyGdkColor_New(&color);
  PyErr_SetString(PyExc_TypeError, "invalid colour specification");
  return NULL;
} 

static PyObject *gnome__canvas_item_new(PyObject *self, PyObject *args) {
  PyObject *parent, *dict, *ret;
  GtkType type;
  gint nargs;
  GtkArg *arg;
  if (!PyArg_ParseTuple(args, "O!iO!:gnome_canvas_item_new", PyGtk_Type,
			&parent, &type, &PyDict_Type, &dict))
    return NULL;
  arg = PyDict_AsGtkArgs(dict, type, &nargs);
  if (arg == NULL && nargs != 0)
    return NULL;
  ret = PyGtk_New((GtkObject *)gnome_canvas_item_newv(
				GNOME_CANVAS_GROUP(PyGtk_Get(parent)),
				type, nargs, arg));
  g_free(arg);
  return ret;
}
static PyObject *gnome__canvas_item_set(PyObject *self, PyObject *args) {
  PyObject *obj, *dict;
  GtkType type;
  gint nargs;
  GtkArg *arg;
  if (!PyArg_ParseTuple(args, "O!O!:gnome_canvas_item_new", PyGtk_Type,
			&obj, &PyDict_Type, &dict))
    return NULL;
  type = GTK_OBJECT_TYPE(PyGtk_Get(obj));
  arg = PyDict_AsGtkArgs(dict, type, &nargs);
  if (arg == NULL && nargs != 0)
    return NULL;
  gnome_canvas_item_setv(GNOME_CANVAS_ITEM(PyGtk_Get(obj)), nargs, arg);
  g_free(arg);
  Py_INCREF(Py_None);
  return Py_None;
}

  /* I can't wrap argp, since there are no hooks.  So instead I just collect
     any unclaimed arguments and stick them into a new argv list */
static PyObject *newargv = NULL;
static error_t collectArg(int key, char *arg, struct argp_state *state) {
  int i;
  if (key == ARGP_KEY_FINI)
    for (i = state->next; i < state->argc; i++)
      PyList_Append(newargv, PyString_FromString(state->argv[i]));
  else if (key == ARGP_KEY_ARG)
    PyList_Append(newargv, PyString_FromString(arg));
  else
    return ARGP_ERR_UNKNOWN;
  return 0;
}
static struct argp_option options[] = {
  { NULL, 0, NULL, 0, NULL, 0 }
};
static struct argp parser = {
  options, collectArg, "[Python]", NULL, NULL, NULL, NULL
};
  
static PyObject *gnome__init(PyObject *self, PyObject *args) {
  char *app_id;
  int argc, i;
  char **argv;
  PyObject *av;

  if (!PyArg_ParseTuple(args, "s:gnome_init", &app_id))
    return NULL;

  av = PySys_GetObject("argv");
  argc = PyList_Size(av);
  argv = g_new(char *, argc);
  for (i = 0; i < argc; i++)
    argv[i] = g_strdup(PyString_AsString(PyList_GetItem(av, i)));

  /* set up argv collector */
  newargv = PyList_New(1);
  PyList_SetItem(newargv, 0, PyString_FromString(argv[0]));

  if (gnome_user_dir) g_free(gnome_user_dir);
  gnome_init(app_id, &parser, argc, argv, ARGP_SILENT | ARGP_IN_ORDER, NULL);
  for (i = 0; i < argc; i++)
    g_free(argv[i]);
  g_free(argv);

  /* install new argv */
  PySys_SetObject("argv", newargv);
  newargv = NULL;

  /* setup python types for this module */
  pygtk_init();

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *gnome__about_new(PyObject *self, PyObject *args) {
  char *title, *version, *copyright, **authors, *comments, *logo;
  PyObject *list, *item, *ret;
  int len, i;

  if (!PyArg_ParseTuple(args, "zzzOzz", &title, &version, &copyright,
			&list, &comments, &logo))
    return NULL;
  if (!PySequence_Check(list)) {
    PyErr_SetString(PyExc_TypeError, "forth argument not a sequence");
    return NULL;
  }
  len = PySequence_Length(list);
  authors = g_new(char *, len+1);
  authors[len] = NULL;
  for (i = 0; i < len; i++) {
    item = PySequence_GetItem(list, i);
    if (!PyString_Check(item)) {
      PyErr_SetString(PyExc_TypeError, "sequence member is not a string");
      g_free(authors);
      return NULL;
    }
    authors[i] = PyString_AsString(item);
  }
  ret= PyGtk_New((GtkObject *)gnome_about_new(title, version, copyright,
					      (const char **)authors,
					      comments, logo));
  g_free(authors);
  return ret;
}

#define pygnome_popup_menu_attach(pop,child) gnome_popup_menu_attach(pop,child,NULL)

#define client_set_cmd(name,py_name)                                          \
  static PyObject *py_name(PyObject *self, PyObject *args) {                  \
    PyObject *ob, *av = Py_None, *item;                                       \
    int argc = 0, i;                                                          \
    char **argv = NULL;                                                       \
    if (!PyArg_ParseTuple(args, "O!|O:" #name, PyGtk_Type, &ob, &av))         \
      return NULL;                                                            \
    if (av != Py_None && !PySequence_Check(av)) {                             \
      PyErr_SetString(PyExc_TypeError, "2nd argument not None or a sequence");\
      return NULL;                                                            \
    }                                                                         \
    if (av != Py_None) {                                                      \
      argc = PySequence_Length(av);                                           \
      argv = g_new(char *, argc);                                             \
      for (i = 0; i < argc; i++) {                                            \
        item = PySequence_GetItem(av, i);                                     \
        if (!PyString_Check(item)) {                                          \
          PyErr_SetString(PyExc_TypeError, "sequence member not a string");   \
          g_free(argv);                                                       \
          return NULL;                                                        \
        }                                                                     \
        argv[i] = PyString_AsString(item);                                    \
      }                                                                       \
    }                                                                         \
    name(GNOME_CLIENT(PyGtk_Get(ob)), argc, argv);                            \
    if (argv) g_free(argv);                                                   \
    Py_INCREF(Py_None);                                                       \
    return Py_None;                                                           \
  }
client_set_cmd(gnome_client_set_clone_command,
	       gnome__client_set_clone_command)
client_set_cmd(gnome_client_set_discard_command,
	       gnome__client_set_discard_command)
client_set_cmd(gnome_client_set_restart_command,
	       gnome__client_set_restart_command)
client_set_cmd(gnome_client_set_resign_command,
	       gnome__client_set_resign_command)
client_set_cmd(gnome_client_set_shutdown_command,
	       gnome__client_set_shutdown_command)
#undef client_set_cmd

static void PyGnome_interact_function(gpointer a, PyObject *func, int nargs,
				      GtkArg *args) {
  PyObject *ret;
  /* this is the correct implementation, but gnome_client is done wrong */
  /*ret = PyObject_CallFunction(func, "(Oii)",
			      PyGtk_New(GTK_VALUE_OBJECT(args[1])),
			      GTK_VALUE_INT(args[2]),
			      GTK_VALUE_ENUM(args[3])); */
  ret = PyObject_CallFunction(func, "(Oii)",
			      PyGtk_New(*GTK_RETLOC_OBJECT(args[1])),
			      *GTK_RETLOC_INT(args[2]),
			      *GTK_RETLOC_ENUM(args[3]));
  if (ret == NULL) {
    PyErr_Print();
    PyErr_Clear();
    return;
  }
  Py_DECREF(ret);
}
static void PyGnome_destroy_notify(PyObject *data) {
  Py_DECREF(data);
}
static PyObject *gnome__client_request_interaction(PyObject *self,
						   PyObject *args) {
  PyObject *client, *func, *py_dialog;
  GnomeDialogType dialog;
  if (!PyArg_ParseTuple(args, "O!OO", PyGtk_Type, &client, &py_dialog, &func))
    return NULL;
  if (PyGtkEnum_get_value(GTK_TYPE_GNOME_DIALOG_TYPE, py_dialog,(gint*)dialog))
    return NULL;
  if (!PyCallable_Check(func)) {
    PyErr_SetString(PyExc_TypeError, "third argument not callbable");
    return NULL;
  }
  Py_INCREF(func);
  gnome_client_request_interaction_interp(GNOME_CLIENT(PyGtk_Get(client)),
			dialog,
			(GtkCallbackMarshal) PyGnome_interact_function,
			func,
			(GtkDestroyNotify) PyGnome_destroy_notify);
  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *gnome__color_picker_get_d(PyObject *self, PyObject *args) {
  PyObject *obj;
  double r, g, b, a;
  if (!PyArg_ParseTuple(args, "O!:gnome_color_picker_get_d", PyGtk_Type, &obj))
    return NULL;
  gnome_color_picker_get_d(GNOME_COLOR_PICKER(PyGtk_Get(obj)), &r, &g, &b, &a);
  return Py_BuildValue("(dddd)", r, g, b, a);
}
static PyObject *gnome__color_picker_get_i8(PyObject *self, PyObject *args) {
  PyObject *obj;
  int r, g, b, a;
  if (!PyArg_ParseTuple(args, "O!:gnome_color_picker_get_i8", PyGtk_Type,&obj))
    return NULL;
  gnome_color_picker_get_i8(GNOME_COLOR_PICKER(PyGtk_Get(obj)), &r, &g, &b,&a);
  return Py_BuildValue("(iiii)", r, g, b, a);
}
static PyObject *gnome__color_picker_get_i16(PyObject *self, PyObject *args) {
  PyObject *obj;
  int r, g, b, a;
  if (!PyArg_ParseTuple(args, "O!:gnome_color_picker_get_i16",PyGtk_Type,&obj))
    return NULL;
  gnome_color_picker_get_i16(GNOME_COLOR_PICKER(PyGtk_Get(obj)), &r, &g,&b,&a);
  return Py_BuildValue("(iiii)", r, g, b, a);
}

static PyObject *gnome__dentry_edit_save_file(PyObject *self, PyObject *args) {
  PyObject *obj;
  char *fname;
  GnomeDesktopEntry *de;
  if (!PyArg_ParseTuple(args, "O!s:gnome_dentry_edit_save_file", PyGtk_Type,
			&obj, &fname))
    return NULL;
  de = gnome_dentry_get_dentry(GNOME_DENTRY_EDIT(PyGtk_Get(obj)));
  de->location = g_strdup(fname);
  gnome_desktop_entry_save(de);
  gnome_desktop_entry_free(de);
  Py_INCREF(Py_None);
  return Py_None;
}

#define gnome_dialog_get_vbox(o) ((o)->vbox)
static PyObject *gnome__dialog_button_connect(PyObject *self, PyObject *args) {
  PyObject *obj, *callback;
  int button;

  if (!PyArg_ParseTuple(args, "O!iO:gnome_dialog_button_connect", PyGtk_Type,
			&obj, &button, &callback))
    return NULL;
  if (!PyCallable_Check(callback)) {
    PyErr_SetString(PyExc_TypeError, "third argument not callable");
    return NULL;
  }
  gnome_dialog_button_connect(GNOME_DIALOG(PyGtk_Get(obj)), button, NULL,
			      callback);
  Py_INCREF(Py_None);
  return Py_None;
}

static void PyGnome_reply(gint reply, gpointer data) {
  PyObject *ret = PyObject_CallFunction((PyObject *)data, "i", reply);
  if (ret == NULL) {
    PyErr_Print();
    PyErr_Clear();
  } else
    Py_DECREF(ret);
}
static void PyGnome_string(gchar *string, gpointer data) {
  PyObject *ret = PyObject_CallFunction((PyObject *)data, "s", string);
  if (ret == NULL) {
    PyErr_Print();
    PyErr_Clear();
  } else
    Py_DECREF(ret);
  g_free(string);
}
#define create_func(name, py_name, cbh) static PyObject *name(PyObject *self, \
                                                       PyObject *args) { \
  PyObject *cb; \
  char *msg; \
  if (!PyArg_ParseTuple(args, "sO:" # py_name, &msg, &cb)) \
    return NULL; \
  if (!PyCallable_Check(cb)) { \
    PyErr_SetString(PyExc_TypeError, "second argument not callable"); \
    return NULL; \
  } \
  return PyGtk_New((GtkObject *)py_name(msg, cbh, cb)); \
}
create_func(gnome__question_dialog, gnome_question_dialog, PyGnome_reply)
create_func(gnome__question_dialog_modal, gnome_question_dialog_modal,
	    PyGnome_reply)
create_func(gnome__ok_cancel_dialog, gnome_ok_cancel_dialog, PyGnome_reply)
create_func(gnome__ok_cancel_dialog_modal, gnome_ok_cancel_dialog_modal,
	    PyGnome_reply)
create_func(gnome__request_string_dialog, gnome_request_string_dialog,
	    PyGnome_string)
create_func(gnome__request_password_dialog, gnome_request_password_dialog,
	    PyGnome_string)

  /* these functions coded explicitly to prevent memory leak */
static PyObject *gnome__font_selector_get_selected(PyObject *self,
						   PyObject *args) {
  PyObject *ob, *ret;
  char *font;
  if (!PyArg_ParseTuple(args, "O!:gnome_font_selector_get_selected",
			PyGtk_Type, &ob))
    return NULL;
  font = gnome_font_selector_get_selected(GNOME_FONT_SELECTOR(PyGtk_Get(ob)));
  ret = PyString_FromString(font);
  g_free(font);
  return ret;
}
static PyObject *gnome__font_select(PyObject *self, PyObject *args) {
  PyObject *ret;
  char *font;
  if (!PyArg_ParseTuple(args, ":gnome_font_select"))
    return NULL;
  font = gnome_font_select();
  ret = PyString_FromString(font);
  g_free(font);
  return ret;
}
static PyObject *gnome__font_select_with_default(PyObject *self,
						 PyObject *args) {
  PyObject *ret;
  char *font, *dflt;
  if (!PyArg_ParseTuple(args, "s:gnome_font_select", &dflt))
    return NULL;
  font = gnome_font_select_with_default(dflt);
  ret = PyString_FromString(font);
  g_free(font);
  return ret;
}

static PyObject *gnome__icon_list_set_icon_data(PyObject *self,
						PyObject *args) {
  PyObject *ilist, *data;
  int pos;
  if (!PyArg_ParseTuple(args, "O!iO:gnome_icon_list_set_icon_data", PyGtk_Type,
			&ilist, &pos, &data))
    return NULL;
  Py_INCREF(data);
  gnome_icon_list_set_icon_data_full(GNOME_ICON_LIST(PyGtk_Get(ilist)), pos,
				     data, (GtkDestroyNotify)
				     PyGnome_destroy_notify);
  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *gnome__scores_new(PyObject *self, PyObject *args) {
  PyObject *list, *item;
  guint num, i, clear;
  gchar **names;
  gfloat *scores;
  time_t *times;
  GtkWidget *ret;
  if (!PyArg_ParseTuple(args, "O!i:gnome_scores_new", &PyList_Type, &list,
			&clear))
    return NULL;
  num = PyList_Size(list);
  names = g_new(gchar *, num);
  scores = g_new(gfloat, num);
  times = g_new(time_t, num);
  for (i = 0; i < num; i++) {
    item = PyList_GetItem(list, i);
    if (!PyArg_ParseTuple(item, "sfi", &names[i], &scores[i], &times[i])) {
      PyErr_Clear();
      g_free(names);
      g_free(scores);
      g_free(times);
      PyErr_SetString(PyExc_TypeError,"list items should be (name,score,time");
      return NULL;
    }
  }
  ret = gnome_scores_new(num, names, scores, times, clear);
  g_free(names);
  g_free(scores);
  g_free(times);
  return PyGtk_New((GtkObject *)ret);
}

static PyObject *gnome__stock_menu_accel(PyObject *self, PyObject *args) {
  char *type;
  guchar key;
  guint8 mod;
  gboolean ret;

  if (!PyArg_ParseTuple(args, "s:gnome_stock_menu_accel", &type))
    return NULL;
  ret = gnome_stock_menu_accel(type, &key, &mod);
  if (!ret) {
    PyErr_SetString(PyExc_KeyError, type);
    return NULL;
  }
  return Py_BuildValue("(ci)", key, mod);
}

static PyObject *gtk__calendar_get_date(PyObject *self, PyObject *args) {
  PyObject *cal;
  int year, month, day;
  if (!PyArg_ParseTuple(args, "O!:gtk_calendar_get_date", PyGtk_Type, &cal))
    return NULL;
  gtk_calendar_get_date(GTK_CALENDAR(PyGtk_Get(cal)), &year, &month, &day);
  return Py_BuildValue("(iii)", year, month, day);
}
static PyObject *_wrap_gnome_canvas_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_canvas_get_type")) 
        return NULL;
    _result = (int )gnome_canvas_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_canvas_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_canvas_new")) 
        return NULL;
    _result = (GtkWidget *)gnome_canvas_new();
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_canvas_root(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeCanvasItem * _result;
    GnomeCanvas * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_canvas_root",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CANVAS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GnomeCanvasItem *)gnome_canvas_root(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gnome_canvas_set_scroll_region(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeCanvas * _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddd:gnome_canvas_set_scroll_region",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CANVAS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_canvas_set_scroll_region(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_canvas_set_pixels_per_unit(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeCanvas * _arg0;
    double  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Od:gnome_canvas_set_pixels_per_unit",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CANVAS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_canvas_set_pixels_per_unit(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_canvas_set_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeCanvas * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gnome_canvas_set_size",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CANVAS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_canvas_set_size(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_canvas_scroll_to(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeCanvas * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gnome_canvas_scroll_to",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CANVAS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_canvas_scroll_to(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_canvas_update_now(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeCanvas * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_canvas_update_now",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CANVAS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_canvas_update_now(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_canvas_item_move(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeCanvasItem * _arg0;
    double  _arg1;
    double  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odd:gnome_canvas_item_move",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CANVAS_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_canvas_item_move(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_canvas_item_raise(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeCanvasItem * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_canvas_item_raise",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CANVAS_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_canvas_item_raise(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_canvas_item_lower(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeCanvasItem * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_canvas_item_lower",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CANVAS_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_canvas_item_lower(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_canvas_item_raise_to_top(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeCanvasItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_canvas_item_raise_to_top",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CANVAS_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_canvas_item_raise_to_top(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_canvas_item_lower_to_bottom(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeCanvasItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_canvas_item_lower_to_bottom",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CANVAS_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_canvas_item_lower_to_bottom(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_canvas_item_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_canvas_item_get_type")) 
        return NULL;
    _result = (int )gnome_canvas_item_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_canvas_group_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_canvas_group_get_type")) 
        return NULL;
    _result = (int )gnome_canvas_group_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_canvas_image_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_canvas_image_get_type")) 
        return NULL;
    _result = (int )gnome_canvas_image_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_canvas_line_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_canvas_line_get_type")) 
        return NULL;
    _result = (int )gnome_canvas_line_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_canvas_re_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_canvas_re_get_type")) 
        return NULL;
    _result = (int )gnome_canvas_re_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_canvas_rect_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_canvas_rect_get_type")) 
        return NULL;
    _result = (int )gnome_canvas_rect_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_canvas_ellipse_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_canvas_ellipse_get_type")) 
        return NULL;
    _result = (int )gnome_canvas_ellipse_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_canvas_text_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_canvas_text_get_type")) 
        return NULL;
    _result = (int )gnome_canvas_text_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_canvas_widget_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_canvas_widget_get_type")) 
        return NULL;
    _result = (int )gnome_canvas_widget_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_about_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_about_get_type")) 
        return NULL;
    _result = (int )gnome_about_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_app_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_app_get_type")) 
        return NULL;
    _result = (int )gnome_app_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_app_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;
    char * _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:gnome_app_new",&_arg0,&_arg1)) 
        return NULL;
    _result = (GtkWidget *)gnome_app_new(_arg0,_arg1);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_app_set_menus(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeApp * _arg0;
    GtkMenuBar * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_app_set_menus",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_APP(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_MENU_BAR(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_app_set_menus(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_app_set_toolbar(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeApp * _arg0;
    GtkToolbar * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_app_set_toolbar",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_APP(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_TOOLBAR(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_app_set_toolbar(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_app_set_statusbar(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeApp * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_app_set_statusbar",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_APP(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGtk_Check(_obj1))
    _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkObject");
    return NULL;
  }
}
    gnome_app_set_statusbar(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_app_set_contents(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeApp * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_app_set_contents",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_APP(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGtk_Check(_obj1))
    _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkObject");
    return NULL;
  }
}
    gnome_app_set_contents(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_app_toolbar_set_position(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeApp * _arg0;
    GnomeAppWidgetPositionType * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_app_toolbar_set_position",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_APP(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GnomeAppWidgetPositionType tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_GNOME_APP_WIDGET_POSITION_TYPE, _obj1,(gint*)_arg1))
    return NULL;
}
    gnome_app_toolbar_set_position(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_app_menu_set_position(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeApp * _arg0;
    GnomeAppWidgetPositionType * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_app_menu_set_position",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_APP(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GnomeAppWidgetPositionType tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_GNOME_APP_WIDGET_POSITION_TYPE, _obj1,(gint*)_arg1))
    return NULL;
}
    gnome_app_menu_set_position(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_app_create_menus(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeApp * _arg0;
    GnomeUIInfo * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_app_create_menus",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_APP(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if ((_arg1 = list_to_ui_info(_obj1)) == NULL)
    return NULL;
}
    gnome_app_create_menus(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
  free_ui_info(_arg1);
  /* _obj1 */
}
    return _resultobj;
}

static PyObject *_wrap_gnome_app_create_toolbar(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeApp * _arg0;
    GnomeUIInfo * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_app_create_toolbar",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_APP(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if ((_arg1 = list_to_ui_info(_obj1)) == NULL)
    return NULL;
}
    gnome_app_create_toolbar(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
  free_ui_info(_arg1);
  /* _obj1 */
}
    return _resultobj;
}

static PyObject *_wrap_gnome_app_insert_menus(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeApp * _arg0;
    char * _arg1;
    GnomeUIInfo * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OsO:gnome_app_insert_menus",&_obj0,&_arg1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_APP(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if ((_arg2 = list_to_ui_info(_obj2)) == NULL)
    return NULL;
}
    gnome_app_insert_menus(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
  free_ui_info(_arg2);
  /* _obj2 */
}
    return _resultobj;
}

static PyObject *_wrap_gnome_app_remove_menus(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeApp * _arg0;
    char * _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Osi:gnome_app_remove_menus",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_APP(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_app_remove_menus(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_popup_menu_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GnomeUIInfo * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_popup_menu_new",&_obj0)) 
        return NULL;
{
  if ((_arg0 = list_to_ui_info(_obj0)) == NULL)
    return NULL;
}
    _result = (GtkWidget *)gnome_popup_menu_new(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
{
  free_ui_info(_arg0);
  /* _obj0 */
}
    return _resultobj;
}

static PyObject *_wrap_gnome_popup_menu_attach(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_popup_menu_attach",&_obj0,&_obj1)) 
        return NULL;
{
  if (PyGtk_Check(_obj0))
    _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkObject");
    return NULL;
  }
}
{
  if (PyGtk_Check(_obj1))
    _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkObject");
    return NULL;
  }
}
    pygnome_popup_menu_attach(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_appbar_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_appbar_get_type")) 
        return NULL;
    _result = (int )gnome_appbar_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GNOME_APPBAR_INTERACTIVE(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GnomeAppBar * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GNOME_APPBAR_INTERACTIVE",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_APPBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GNOME_APPBAR_INTERACTIVE(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_appbar_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    int  _arg0;
    int  _arg1;
    GnomePreferencesType * _arg2;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"iiO:gnome_appbar_new",&_arg0,&_arg1,&_obj2)) 
        return NULL;
{
  static GnomePreferencesType tmp; _arg2 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_GNOME_PREFERENCES_TYPE, _obj2,(gint*)_arg2))
    return NULL;
}
    _result = (GtkWidget *)gnome_appbar_new(_arg0,_arg1,*_arg2);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_appbar_set_status(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeAppBar * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_appbar_set_status",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_APPBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_appbar_set_status(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_appbar_set_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeAppBar * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_appbar_set_default",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_APPBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_appbar_set_default(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_appbar_push(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeAppBar * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_appbar_push",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_APPBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_appbar_push(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_appbar_pop(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeAppBar * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_appbar_pop",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_APPBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_appbar_pop(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_appbar_clear_stack(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeAppBar * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_appbar_clear_stack",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_APPBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_appbar_clear_stack(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_appbar_set_progress(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeAppBar * _arg0;
    double  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Od:gnome_appbar_set_progress",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_APPBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_appbar_set_progress(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_appbar_refresh(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeAppBar * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_appbar_refresh",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_APPBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_appbar_refresh(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_appbar_set_prompt(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeAppBar * _arg0;
    char * _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Osi:gnome_appbar_set_prompt",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_APPBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_appbar_set_prompt(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_appbar_clear_prompt(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeAppBar * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_appbar_clear_prompt",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_APPBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_appbar_clear_prompt(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_appbar_get_response(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GnomeAppBar * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_appbar_get_response",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_APPBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (char *)gnome_appbar_get_response(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gnome_calculator_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_calculator_get_type")) 
        return NULL;
    _result = (int )gnome_calculator_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_calculator_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_calculator_new")) 
        return NULL;
    _result = (GtkWidget *)gnome_calculator_new();
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_calculator_clear(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeCalculator * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_calculator_clear",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CALCULATOR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_calculator_clear(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_calculator_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeCalculator * _arg0;
    double  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Od:gnome_calculator_set",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CALCULATOR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_calculator_set(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_calculator_get_result(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    GnomeCalculator * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_calculator_get_result",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CALCULATOR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (double )gnome_calculator_get_result(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_client_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_client_get_type")) 
        return NULL;
    _result = (int )gnome_client_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_client_disable_master_connection(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_client_disable_master_connection")) 
        return NULL;
    gnome_client_disable_master_connection();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_master_client(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeClient * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_master_client")) 
        return NULL;
    _result = (GnomeClient *)gnome_master_client();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gnome_cloned_client(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeClient * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_cloned_client")) 
        return NULL;
    _result = (GnomeClient *)gnome_cloned_client();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gnome_client_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeClient * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_client_new")) 
        return NULL;
    _result = (GnomeClient *)gnome_client_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gnome_client_new_without_connection(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeClient * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_client_new_without_connection")) 
        return NULL;
    _result = (GnomeClient *)gnome_client_new_without_connection();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gnome_client_connect(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeClient * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_client_connect",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CLIENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_client_connect(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_client_disconnect(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeClient * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_client_disconnect",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CLIENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_client_disconnect(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_client_set_id(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeClient * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_client_set_id",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CLIENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_client_set_id(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_client_get_id(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GnomeClient * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_client_get_id",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CLIENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (char *)gnome_client_get_id(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gnome_client_get_previous_id(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GnomeClient * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_client_get_previous_id",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CLIENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (char *)gnome_client_get_previous_id(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gnome_client_get_config_prefix(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GnomeClient * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_client_get_config_prefix",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CLIENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (char *)gnome_client_get_config_prefix(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gnome_client_get_global_config_prefix(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GnomeClient * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_client_get_global_config_prefix",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CLIENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (char *)gnome_client_get_global_config_prefix(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gnome_client_set_environment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeClient * _arg0;
    char * _arg1;
    char * _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oss:gnome_client_set_environment",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CLIENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_client_set_environment(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_client_set_current_directory(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeClient * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_client_set_current_directory",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CLIENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_client_set_current_directory(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_client_set_process_id(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeClient * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_client_set_process_id",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CLIENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_client_set_process_id(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_client_set_program(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeClient * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_client_set_program",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CLIENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_client_set_program(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_client_set_restart_style(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeClient * _arg0;
    GnomeRestartStyle * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_client_set_restart_style",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CLIENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GnomeRestartStyle tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_GNOME_RESTART_STYLE,_obj1,(gint*)_arg1))
    return NULL;
}
    gnome_client_set_restart_style(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_client_set_user_id(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeClient * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_client_set_user_id",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CLIENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_client_set_user_id(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_client_request_phase_2(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeClient * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_client_request_phase_2",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CLIENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_client_request_phase_2(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_interaction_key_return(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ii:gnome_interaction_key_return",&_arg0,&_arg1)) 
        return NULL;
    gnome_interaction_key_return(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_client_request_save(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeClient * _arg0;
    GnomeSaveStyle * _arg1;
    int  _arg2;
    GnomeInteractStyle * _arg3;
    int  _arg4;
    int  _arg5;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOiOii:gnome_client_request_save",&_obj0,&_obj1,&_arg2,&_obj3,&_arg4,&_arg5)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CLIENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GnomeSaveStyle tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_GNOME_SAVE_STYLE, _obj1,(gint*)_arg1))
    return NULL;
}
{
  static GnomeInteractStyle tmp; _arg3 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_GNOME_INTERACT_STYLE, _obj3,(gint*)_arg3))
    return NULL;
}
    gnome_client_request_save(_arg0,*_arg1,_arg2,*_arg3,_arg4,_arg5);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_client_flush(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeClient * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_client_flush",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_CLIENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_client_flush(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_color_picker_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_color_picker_get_type")) 
        return NULL;
    _result = (int )gnome_color_picker_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_color_picker_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_color_picker_new")) 
        return NULL;
    _result = (GtkWidget *)gnome_color_picker_new();
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_color_picker_set_d(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeColorPicker * _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddd:gnome_color_picker_set_d",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_COLOR_PICKER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_color_picker_set_d(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_color_picker_set_i8(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeColorPicker * _arg0;
    int  _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oiiii:gnome_color_picker_set_i8",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_COLOR_PICKER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_color_picker_set_i8(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_color_picker_set_i16(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeColorPicker * _arg0;
    int  _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oiiii:gnome_color_picker_set_i16",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_COLOR_PICKER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_color_picker_set_i16(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_color_picker_set_dither(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeColorPicker * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_color_picker_set_dither",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_COLOR_PICKER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_color_picker_set_dither(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_color_picker_set_use_alpha(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeColorPicker * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_color_picker_set_use_alpha",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_COLOR_PICKER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_color_picker_set_use_alpha(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_color_picker_set_title(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeColorPicker * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_color_picker_set_title",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_COLOR_PICKER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_color_picker_set_title(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_date_edit_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_date_edit_get_type")) 
        return NULL;
    _result = (int )gnome_date_edit_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_date_edit_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    int  _arg0;
    int  _arg1;
    int  _arg2;

    self = self;
    if(!PyArg_ParseTuple(args,"iii:gnome_date_edit_new",&_arg0,&_arg1,&_arg2)) 
        return NULL;
    _result = (GtkWidget *)gnome_date_edit_new(_arg0,_arg1,_arg2);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_date_edit_set_time(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeDateEdit * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_date_edit_set_time",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DATE_EDIT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_date_edit_set_time(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_date_edit_set_popup_range(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeDateEdit * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gnome_date_edit_set_popup_range",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DATE_EDIT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_date_edit_set_popup_range(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_date_edit_get_date(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GnomeDateEdit * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_date_edit_get_date",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DATE_EDIT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gnome_date_edit_get_date(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_dentry_edit_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_dentry_edit_get_type")) 
        return NULL;
    _result = (int )gnome_dentry_edit_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_dentry_edit_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkObject * _result;
    GtkNotebook * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_dentry_edit_new",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkObject *)gnome_dentry_edit_new(_arg0);
{
  _resultobj = PyGtk_New(_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_dentry_edit_clear(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeDEntryEdit * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_dentry_edit_clear",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DENTRY_EDIT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_dentry_edit_clear(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_dentry_edit_load_file(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeDEntryEdit * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_dentry_edit_load_file",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DENTRY_EDIT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_dentry_edit_load_file(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_dentry_edit_get_icon(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GnomeDEntryEdit * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_dentry_edit_get_icon",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DENTRY_EDIT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (char *)gnome_dentry_edit_get_icon(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gnome_dentry_edit_get_name(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GnomeDEntryEdit * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_dentry_edit_get_name",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DENTRY_EDIT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (char *)gnome_dentry_edit_get_name(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gnome_dialog_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_dialog_get_type")) 
        return NULL;
    _result = (int )gnome_dialog_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_dialog_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;
    char * _arg1 = NULL;
    char * _arg2 = NULL;
    char * _arg3 = NULL;
    char * _arg4 = NULL;
    char * _arg5 = NULL;
    char * _arg6 = NULL;
    char * _arg7 = NULL;
    char * _arg8 = NULL;
    char * _arg9 = NULL;
    char * _arg10 = NULL;
    char * _arg11 = NULL;

    self = self;
    if(!PyArg_ParseTuple(args,"s|sssssssssss:gnome_dialog_new",&_arg0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5,&_arg6,&_arg7,&_arg8,&_arg9,&_arg10,&_arg11)) 
        return NULL;
    _result = (GtkWidget *)gnome_dialog_new(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7,_arg8,_arg9,_arg10,_arg11);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_dialog_get_vbox(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GnomeDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_dialog_get_vbox",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gnome_dialog_get_vbox(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_dialog_set_parent(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeDialog * _arg0;
    GtkWindow * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_dialog_set_parent",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WINDOW(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_dialog_set_parent(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_dialog_set_modal(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_dialog_set_modal",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_dialog_set_modal(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_dialog_run(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GnomeDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_dialog_run",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gnome_dialog_run(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_dialog_run_modal(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GnomeDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_dialog_run_modal",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gnome_dialog_run_modal(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_dialog_run_and_hide(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GnomeDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_dialog_run_and_hide",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gnome_dialog_run_and_hide(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_dialog_run_and_destroy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GnomeDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_dialog_run_and_destroy",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gnome_dialog_run_and_destroy(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_dialog_set_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeDialog * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_dialog_set_default",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_dialog_set_default(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_dialog_set_sensitive(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeDialog * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gnome_dialog_set_sensitive",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_dialog_set_sensitive(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_dialog_set_accelerator(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeDialog * _arg0;
    int  _arg1;
    char  _arg2;
    int  _arg3;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oici:gnome_dialog_set_accelerator",&_obj0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_dialog_set_accelerator(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_dialog_close(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_dialog_close",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_dialog_close(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_dialog_close_hides(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeDialog * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_dialog_close_hides",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_dialog_close_hides(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_dialog_set_close(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeDialog * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_dialog_set_close",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_dialog_set_close(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_dialog_editable_enters(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeDialog * _arg0;
    GtkEditable * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_dialog_editable_enters",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_EDITABLE(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_dialog_editable_enters(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_dialog_set_destroy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeDialog * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_dialog_set_destroy",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_dialog_set_destroy(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_dialog_append_buttons(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeDialog * _arg0;
    char * _arg1 = NULL;
    char * _arg2 = NULL;
    char * _arg3 = NULL;
    char * _arg4 = NULL;
    char * _arg5 = NULL;
    char * _arg6 = NULL;
    char * _arg7 = NULL;
    char * _arg8 = NULL;
    char * _arg9 = NULL;
    char * _arg10 = NULL;
    char * _arg11 = NULL;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O|sssssssssss:gnome_dialog_append_buttons",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5,&_arg6,&_arg7,&_arg8,&_arg9,&_arg10,&_arg11)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_dialog_append_buttons(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7,_arg8,_arg9,_arg10,_arg11);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_dialog_append_button(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeDialog * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_dialog_append_button",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_dialog_append_button(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_ok_dialog(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_ok_dialog",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gnome_ok_dialog(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_error_dialog(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_error_dialog",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gnome_error_dialog(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_warning_dialog(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_warning_dialog",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gnome_warning_dialog(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_entry_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_entry_get_type")) 
        return NULL;
    _result = (int )gnome_entry_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_entry_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_entry_new",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gnome_entry_new(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_entry_gtk_entry(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GnomeEntry * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_entry_gtk_entry",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gnome_entry_gtk_entry(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_entry_set_history_id(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeEntry * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_entry_set_history_id",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_entry_set_history_id(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_entry_prepend_history(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeEntry * _arg0;
    int  _arg1;
    char * _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ois:gnome_entry_prepend_history",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_entry_prepend_history(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_entry_append_history(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeEntry * _arg0;
    int  _arg1;
    char * _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ois:gnome_entry_append_history",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_entry_append_history(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_entry_load_history(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeEntry * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_entry_load_history",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_entry_load_history(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_entry_save_history(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeEntry * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_entry_save_history",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_entry_save_history(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_file_entry_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_file_entry_get_type")) 
        return NULL;
    _result = (int )gnome_file_entry_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_file_entry_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;
    char * _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:gnome_file_entry_new",&_arg0,&_arg1)) 
        return NULL;
    _result = (GtkWidget *)gnome_file_entry_new(_arg0,_arg1);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_file_entry_gnome_entry(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GnomeFileEntry * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_file_entry_gnome_entry",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_FILE_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gnome_file_entry_gnome_entry(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_file_entry_gtk_entry(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GnomeFileEntry * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_file_entry_gtk_entry",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_FILE_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gnome_file_entry_gtk_entry(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_file_entry_set_title(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeFileEntry * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_file_entry_set_title",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_FILE_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_file_entry_set_title(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_font_selector_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_font_selector_get_type")) 
        return NULL;
    _result = (int )gnome_font_selector_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_font_selector_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_font_selector_new")) 
        return NULL;
    _result = (GtkWidget *)gnome_font_selector_new();
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_ice_init(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_ice_init")) 
        return NULL;
    gnome_ice_init();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_icon_list_get_type")) 
        return NULL;
    _result = (int )gnome_icon_list_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_icon_list_new")) 
        return NULL;
    _result = (GtkWidget *)gnome_icon_list_new();
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_set_selection_mode(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconList * _arg0;
    GtkSelectionMode * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_icon_list_set_selection_mode",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkSelectionMode tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_SELECTION_MODE, _obj1, (gint*)_arg1))
    return NULL;
}
    gnome_icon_list_set_selection_mode(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_set_policy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconList * _arg0;
    GtkPolicyType * _arg1;
    GtkPolicyType * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOO:gnome_icon_list_set_policy",&_obj0,&_obj1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkPolicyType tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_POLICY_TYPE, _obj1, (gint*)_arg1))
    return NULL;
}
{
  static GtkPolicyType tmp; _arg2 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_POLICY_TYPE, _obj2, (gint*)_arg2))
    return NULL;
}
    gnome_icon_list_set_policy(_arg0,*_arg1,*_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_append(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconList * _arg0;
    char * _arg1;
    char * _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oss:gnome_icon_list_append",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_icon_list_append(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_insert(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconList * _arg0;
    int  _arg1;
    char * _arg2;
    char * _arg3;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oiss:gnome_icon_list_insert",&_obj0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_icon_list_insert(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_remove(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_icon_list_remove",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_icon_list_remove(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_clear(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_icon_list_clear",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_icon_list_clear(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_get_icon_data(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    GnomeIconList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_icon_list_get_icon_data",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (PyObject *)gnome_icon_list_get_icon_data(_arg0,_arg1);
{ Py_INCREF(_result); _resultobj = _result; }
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_find_icon_from_data(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GnomeIconList * _arg0;
    PyObject * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_icon_list_find_icon_from_data",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{ _arg1 = _obj1; }
    _result = (int )gnome_icon_list_find_icon_from_data(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_select_icon(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_icon_list_select_icon",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_icon_list_select_icon(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_unselect_icon(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_icon_list_unselect_icon",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_icon_list_unselect_icon(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_freeze(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_icon_list_freeze",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_icon_list_freeze(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_thaw(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_icon_list_thaw",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_icon_list_thaw(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_moveto(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconList * _arg0;
    int  _arg1;
    double  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oid:gnome_icon_list_moveto",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_icon_list_moveto(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_icon_is_visible(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GnomeIconList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_icon_list_icon_is_visible",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gnome_icon_list_icon_is_visible(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_set_foreground(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconList * _arg0;
    int  _arg1;
    GdkColor * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OiO:gnome_icon_list_set_foreground",&_obj0,&_arg1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGdkColor_Check(_obj2))
    _arg2 = PyGdkColor_Get(_obj2);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkColor");
    return NULL;
  }
}
    gnome_icon_list_set_foreground(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_set_background(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconList * _arg0;
    int  _arg1;
    GdkColor * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OiO:gnome_icon_list_set_background",&_obj0,&_arg1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGdkColor_Check(_obj2))
    _arg2 = PyGdkColor_Get(_obj2);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkColor");
    return NULL;
  }
}
    gnome_icon_list_set_background(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_set_row_spacing(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_icon_list_set_row_spacing",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_icon_list_set_row_spacing(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_set_col_spacing(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_icon_list_set_col_spacing",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_icon_list_set_col_spacing(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_set_text_spacing(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_icon_list_set_text_spacing",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_icon_list_set_text_spacing(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_set_icon_border(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_icon_list_set_icon_border",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_icon_list_set_icon_border(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_set_separators(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconList * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_icon_list_set_separators",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_icon_list_set_separators(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_set_mode(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconList * _arg0;
    GnomeIconListMode * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_icon_list_set_mode",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GnomeIconListMode tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_GNOME_ICON_LIST_MODE, _obj1,(gint*)_arg1))
    return NULL;
}
    gnome_icon_list_set_mode(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_set_border(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconList * _arg0;
    GtkShadowType * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_icon_list_set_border",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkShadowType tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_SHADOW_TYPE, _obj1, (gint*)_arg1))
    return NULL;
}
    gnome_icon_list_set_border(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_list_get_icon_at(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GnomeIconList * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gnome_icon_list_get_icon_at",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gnome_icon_list_get_icon_at(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_selection_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_icon_selection_get_type")) 
        return NULL;
    _result = (int )gnome_icon_selection_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_selection_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_icon_selection_new")) 
        return NULL;
    _result = (GtkWidget *)gnome_icon_selection_new();
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_selection_add_defaults(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_icon_selection_add_defaults",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_icon_selection_add_defaults(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_selection_add_directory(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconSelection * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_icon_selection_add_directory",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_icon_selection_add_directory(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_selection_show_icons(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_icon_selection_show_icons",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_icon_selection_show_icons(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_selection_clear(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_icon_selection_clear",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_icon_selection_clear(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_selection_get_icon(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GnomeIconSelection * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_icon_selection_get_icon",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (char *)gnome_icon_selection_get_icon(_arg0,_arg1);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gnome_icon_selection_select_icon(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeIconSelection * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_icon_selection_select_icon",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_ICON_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_icon_selection_select_icon(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_lamp_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_lamp_get_type")) 
        return NULL;
    _result = (int )gnome_lamp_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_lamp_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_lamp_new")) 
        return NULL;
    _result = (GtkWidget *)gnome_lamp_new();
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_lamp_new_with_color(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GdkColor * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_lamp_new_with_color",&_obj0)) 
        return NULL;
{
  if (PyGdkColor_Check(_obj0))
    _arg0 = PyGdkColor_Get(_obj0);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkColor");
    return NULL;
  }
}
    _result = (GtkWidget *)gnome_lamp_new_with_color(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_lamp_new_with_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_lamp_new_with_type",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gnome_lamp_new_with_type(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_lamp_set_color(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeLamp * _arg0;
    GdkColor * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_lamp_set_color",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_LAMP(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGdkColor_Check(_obj1))
    _arg1 = PyGdkColor_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkColor");
    return NULL;
  }
}
    gnome_lamp_set_color(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_lamp_set_sequence(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeLamp * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_lamp_set_sequence",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_LAMP(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_lamp_set_sequence(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_lamp_set_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeLamp * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_lamp_set_type",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_LAMP(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_lamp_set_type(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_lamp_set_window_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWindow * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_lamp_set_window_type",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WINDOW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_lamp_set_window_type(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_less_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_less_get_type")) 
        return NULL;
    _result = (int )gnome_less_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_less_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_less_new")) 
        return NULL;
    _result = (GtkWidget *)gnome_less_new();
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_less_clear(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeLess * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_less_clear",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_LESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_less_clear(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_less_show_file(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeLess * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_less_show_file",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_LESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_less_show_file(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_less_show_command(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeLess * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_less_show_command",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_LESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_less_show_command(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_less_show_string(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeLess * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_less_show_string",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_LESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_less_show_string(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_less_show_filestream(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GnomeLess * _arg0;
    FILE * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_less_show_filestream",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_LESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyFile_Check(_obj1))
    _arg1 = PyFile_AsFile(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "argument not a file stream");
    return NULL;
  }
}
    _result = (int )gnome_less_show_filestream(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_less_set_font(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeLess * _arg0;
    GdkFont * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_less_set_font",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_LESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGdkFont_Check(_obj1))
    _arg1 = PyGdkFont_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkFont");
    return NULL;
  }
}
    gnome_less_set_font(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_less_set_fixed_font(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeLess * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_less_set_fixed_font",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_LESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_less_set_fixed_font(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_less_reshow(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeLess * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_less_reshow",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_LESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_less_reshow(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_less_fixed_font(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeLess * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_less_fixed_font",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_LESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_less_fixed_font(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_mdi_get_type")) 
        return NULL;
    _result = (int )gnome_mdi_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkObject * _result;
    char * _arg0;
    char * _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:gnome_mdi_new",&_arg0,&_arg1)) 
        return NULL;
    _result = (GtkObject *)gnome_mdi_new(_arg0,_arg1);
{
  _resultobj = PyGtk_New(_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_set_mode(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeMDI * _arg0;
    GnomeMDIMode * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_mdi_set_mode",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GnomeMDIMode tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_GNOME_MDI_MODE, _obj1,(gint*)_arg1))
    return NULL;
}
    gnome_mdi_set_mode(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_set_tab_pos(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeMDI * _arg0;
    GtkPositionType * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_mdi_set_tab_pos",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkPositionType tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_POSITION_TYPE, _obj1,(gint*)_arg1))
    return NULL;
}
    gnome_mdi_set_tab_pos(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_set_menu_template(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeMDI * _arg0;
    GnomeUIInfo * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_mdi_set_menu_template",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if ((_arg1 = list_to_ui_info(_obj1)) == NULL)
    return NULL;
}
    gnome_mdi_set_menu_template(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
}
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_set_toolbar_template(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeMDI * _arg0;
    GnomeUIInfo * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_mdi_set_toolbar_template",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if ((_arg1 = list_to_ui_info(_obj1)) == NULL)
    return NULL;
}
    gnome_mdi_set_toolbar_template(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
}
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_set_child_menu_path(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeMDI * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_mdi_set_child_menu_path",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_mdi_set_child_menu_path(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_set_child_list_path(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeMDI * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_mdi_set_child_list_path",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_mdi_set_child_list_path(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_active_child(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeMDIChild * _result;
    GnomeMDI * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_mdi_active_child",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GnomeMDIChild *)gnome_mdi_active_child(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_add_view(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GnomeMDI * _arg0;
    GnomeMDIChild * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_mdi_add_view",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GNOME_MDI_CHILD(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gnome_mdi_add_view(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_remove_view(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GnomeMDI * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOi:gnome_mdi_remove_view",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGtk_Check(_obj1))
    _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkObject");
    return NULL;
  }
}
    _result = (int )gnome_mdi_remove_view(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_active_view(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GnomeMDI * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_mdi_active_view",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gnome_mdi_active_view(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_set_active_view(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeMDI * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_mdi_set_active_view",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGtk_Check(_obj1))
    _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkObject");
    return NULL;
  }
}
    gnome_mdi_set_active_view(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_add_child(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GnomeMDI * _arg0;
    GnomeMDIChild * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_mdi_add_child",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GNOME_MDI_CHILD(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gnome_mdi_add_child(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_remove_child(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GnomeMDI * _arg0;
    GnomeMDIChild * _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOi:gnome_mdi_remove_child",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GNOME_MDI_CHILD(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gnome_mdi_remove_child(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_remove_all(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GnomeMDI * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_mdi_remove_all",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gnome_mdi_remove_all(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_update_child(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeMDI * _arg0;
    GnomeMDIChild * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_mdi_update_child",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GNOME_MDI_CHILD(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_mdi_update_child(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_find_child(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeMDIChild * _result;
    GnomeMDI * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_mdi_find_child",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GnomeMDIChild *)gnome_mdi_find_child(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_register(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeMDI * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_mdi_register",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGtk_Check(_obj1))
    _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkObject");
    return NULL;
  }
}
    gnome_mdi_register(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_unregister(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeMDI * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_mdi_unregister",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGtk_Check(_obj1))
    _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkObject");
    return NULL;
  }
}
    gnome_mdi_unregister(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_get_app_from_view(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeApp * _result;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_mdi_get_app_from_view",&_obj0)) 
        return NULL;
{
  if (PyGtk_Check(_obj0))
    _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkObject");
    return NULL;
  }
}
    _result = (GnomeApp *)gnome_mdi_get_app_from_view(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_get_child_from_view(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeMDIChild * _result;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_mdi_get_child_from_view",&_obj0)) 
        return NULL;
{
  if (PyGtk_Check(_obj0))
    _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkObject");
    return NULL;
  }
}
    _result = (GnomeMDIChild *)gnome_mdi_get_child_from_view(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_child_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_mdi_child_get_type")) 
        return NULL;
    _result = (int )gnome_mdi_child_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_child_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeMDIChild * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_mdi_child_new")) 
        return NULL;
    _result = (GnomeMDIChild *)gnome_mdi_child_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_child_add_view(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GnomeMDIChild * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_mdi_child_add_view",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI_CHILD(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gnome_mdi_child_add_view(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_child_remove_view(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeMDIChild * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_mdi_child_remove_view",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI_CHILD(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGtk_Check(_obj1))
    _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkObject");
    return NULL;
  }
}
    gnome_mdi_child_remove_view(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_child_set_name(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeMDIChild * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_mdi_child_set_name",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI_CHILD(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_mdi_child_set_name(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_mdi_child_set_menu_template(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeMDIChild * _arg0;
    GnomeUIInfo * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_mdi_child_set_menu_template",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_MDI_CHILD(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if ((_arg1 = list_to_ui_info(_obj1)) == NULL)
    return NULL;
}
    gnome_mdi_child_set_menu_template(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
}
    return _resultobj;
}

static PyObject *_wrap_gnome_message_box_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_message_box_get_type")) 
        return NULL;
    _result = (int )gnome_message_box_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_message_box_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;
    char * _arg1;
    char * _arg2 = NULL;
    char * _arg3 = NULL;
    char * _arg4 = NULL;
    char * _arg5 = NULL;
    char * _arg6 = NULL;
    char * _arg7 = NULL;
    char * _arg8 = NULL;
    char * _arg9 = NULL;
    char * _arg10 = NULL;
    char * _arg11 = NULL;
    char * _arg12 = NULL;

    self = self;
    if(!PyArg_ParseTuple(args,"ss|sssssssssss:gnome_message_box_new",&_arg0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5,&_arg6,&_arg7,&_arg8,&_arg9,&_arg10,&_arg11,&_arg12)) 
        return NULL;
    _result = (GtkWidget *)gnome_message_box_new(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7,_arg8,_arg9,_arg10,_arg11,_arg12);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_number_entry_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_number_entry_get_type")) 
        return NULL;
    _result = (int )gnome_number_entry_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_number_entry_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;
    char * _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:gnome_number_entry_new",&_arg0,&_arg1)) 
        return NULL;
    _result = (GtkWidget *)gnome_number_entry_new(_arg0,_arg1);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_number_entry_gnome_entry(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GnomeNumberEntry * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_number_entry_gnome_entry",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_NUMBER_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gnome_number_entry_gnome_entry(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_number_entry_gtk_entry(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GnomeNumberEntry * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_number_entry_gtk_entry",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_NUMBER_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gnome_number_entry_gtk_entry(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_number_entry_set_title(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeNumberEntry * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_number_entry_set_title",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_NUMBER_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_number_entry_set_title(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_number_entry_get_number(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    GnomeNumberEntry * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_number_entry_get_number",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_NUMBER_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (double )gnome_number_entry_get_number(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_pixmap_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_pixmap_get_type")) 
        return NULL;
    _result = (int )gnome_pixmap_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_pixmap_new_from_file(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_pixmap_new_from_file",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gnome_pixmap_new_from_file(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_pixmap_new_from_file_at_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;
    int  _arg1;
    int  _arg2;

    self = self;
    if(!PyArg_ParseTuple(args,"sii:gnome_pixmap_new_from_file_at_size",&_arg0,&_arg1,&_arg2)) 
        return NULL;
    _result = (GtkWidget *)gnome_pixmap_new_from_file_at_size(_arg0,_arg1,_arg2);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_pixmap_load_file(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomePixmap * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_pixmap_load_file",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_PIXMAP(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_pixmap_load_file(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_pixmap_load_file_at_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomePixmap * _arg0;
    char * _arg1;
    int  _arg2;
    int  _arg3;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Osii:gnome_pixmap_load_file_at_size",&_obj0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_PIXMAP(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_pixmap_load_file_at_size(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_property_box_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_property_box_get_type")) 
        return NULL;
    _result = (int )gnome_property_box_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_property_box_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_property_box_new")) 
        return NULL;
    _result = (GtkWidget *)gnome_property_box_new();
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_property_box_changed(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomePropertyBox * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gnome_property_box_changed",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_PROPERTY_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_property_box_changed(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_property_box_append_page(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomePropertyBox * _arg0;
    GtkWidget * _arg1;
    GtkWidget * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOO:gnome_property_box_append_page",&_obj0,&_obj1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_PROPERTY_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGtk_Check(_obj1))
    _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkObject");
    return NULL;
  }
}
{
  if (PyGtk_Check(_obj2))
    _arg2 = GTK_WIDGET(PyGtk_Get(_obj2));
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkObject");
    return NULL;
  }
}
    gnome_property_box_append_page(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_rootwin_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_rootwin_get_type")) 
        return NULL;
    _result = (int )gnome_rootwin_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_rootwin_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_rootwin_new")) 
        return NULL;
    _result = (GtkWidget *)gnome_rootwin_new();
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_scores_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_scores_get_type")) 
        return NULL;
    _result = (int )gnome_scores_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_scores_display(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;
    char * _arg1;
    char * _arg2;
    int  _arg3;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ssOi:gnome_scores_display",&_arg0,&_arg1,&_obj2,&_arg3)) 
        return NULL;
{
  if (_obj2 == Py_None)
    _arg2 = NULL;
  else if (PyString_Check(_obj2))
    _arg2 = PyString_AsString(_obj2);
  else {
    PyErr_SetString(PyExc_TypeError, "argument not a string or None");
    return NULL;
  }
}
    gnome_scores_display(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_scores_set_logo_label(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeScores * _arg0;
    char * _arg1;
    char * _arg2;
    GdkColor * _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OssO:gnome_scores_set_logo_label",&_obj0,&_arg1,&_arg2,&_obj3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_SCORES(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGdkColor_Check(_obj3))
    _arg3 = PyGdkColor_Get(_obj3);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkColor");
    return NULL;
  }
}
    gnome_scores_set_logo_label(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_scores_set_logo_pixmap(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeScores * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_scores_set_logo_pixmap",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_SCORES(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_scores_set_logo_pixmap(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_scores_set_logo_widget(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeScores * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_scores_set_logo_widget",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_SCORES(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGtk_Check(_obj1))
    _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkObject");
    return NULL;
  }
}
    gnome_scores_set_logo_widget(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_scores_set_color(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeScores * _arg0;
    int  _arg1;
    GdkColor * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OiO:gnome_scores_set_color",&_obj0,&_arg1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_SCORES(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGdkColor_Check(_obj2))
    _arg2 = PyGdkColor_Get(_obj2);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkColor");
    return NULL;
  }
}
    gnome_scores_set_color(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_scores_set_def_color(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeScores * _arg0;
    GdkColor * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gnome_scores_set_def_color",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_SCORES(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGdkColor_Check(_obj1))
    _arg1 = PyGdkColor_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkColor");
    return NULL;
  }
}
    gnome_scores_set_def_color(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_scores_set_logo_label_title(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeScores * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_scores_set_logo_label_title",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_SCORES(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_scores_set_logo_label_title(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_scores_set_current_player(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeScores * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gnome_scores_set_current_player",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_SCORES(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_scores_set_current_player(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_startup_acquire_token(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    char * _arg0;
    char * _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:gnome_startup_acquire_token",&_arg0,&_arg1)) 
        return NULL;
    _result = (int )gnome_startup_acquire_token(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_stock_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_stock_get_type")) 
        return NULL;
    _result = (int )gnome_stock_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_stock_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_stock_new")) 
        return NULL;
    _result = (GtkWidget *)gnome_stock_new();
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_stock_new_with_icon(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_stock_new_with_icon",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gnome_stock_new_with_icon(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_stock_set_icon(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GnomeStock * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gnome_stock_set_icon",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GNOME_STOCK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gnome_stock_set_icon(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_stock_button(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_stock_button",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gnome_stock_button(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_stock_or_ordinary_button(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_stock_or_ordinary_button",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gnome_stock_or_ordinary_button(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_stock_menu_item(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;
    char * _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:gnome_stock_menu_item",&_arg0,&_arg1)) 
        return NULL;
    _result = (GtkWidget *)gnome_stock_menu_item(_arg0,_arg1);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gnome_stock_menu_accel_parse(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_stock_menu_accel_parse",&_arg0)) 
        return NULL;
    gnome_stock_menu_accel_parse(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_stock_transparent_window(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;
    char * _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:gnome_stock_transparent_window",&_arg0,&_arg1)) 
        return NULL;
    _result = (GtkWidget *)gnome_stock_transparent_window(_arg0,_arg1);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gtk_calendar_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_calendar_get_type")) 
        return NULL;
    _result = (int )gtk_calendar_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_calendar_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_calendar_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_calendar_new();
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gtk_calendar_select_month(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkCalendar * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_calendar_select_month",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CALENDAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_calendar_select_month(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_calendar_select_day(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCalendar * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_calendar_select_day",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CALENDAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_calendar_select_day(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_calendar_mark_day(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkCalendar * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_calendar_mark_day",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CALENDAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_calendar_mark_day(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_calendar_unmark_day(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkCalendar * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_calendar_unmark_day",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CALENDAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_calendar_unmark_day(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_calendar_clear_marks(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCalendar * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_calendar_clear_marks",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CALENDAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_calendar_clear_marks(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_calendar_display_options(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCalendar * _arg0;
    GtkCalendarDisplayOptions * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_calendar_display_options",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CALENDAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkCalendarDisplayOptions tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_CALENDAR_DISPLAY_OPTIONS, _obj1,(gint*)_arg1))
    return NULL;
}
    gtk_calendar_display_options(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_calendar_freeze(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCalendar * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_calendar_freeze",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CALENDAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_calendar_freeze(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_calendar_thaw(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCalendar * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_calendar_thaw",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CALENDAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_calendar_thaw(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clock_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_clock_get_type")) 
        return NULL;
    _result = (int )gtk_clock_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_clock_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkClockType * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_clock_new",&_obj0)) 
        return NULL;
{
  static GtkClockType tmp; _arg0 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_CLOCK_TYPE, _obj0,(gint*)_arg0))
    return NULL;
}
    _result = (GtkWidget *)gtk_clock_new(*_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gtk_clock_set_format(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkClock * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_clock_set_format",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLOCK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clock_set_format(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clock_set_seconds(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkClock * _arg0;
    long  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ol:gtk_clock_set_seconds",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLOCK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clock_set_seconds(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clock_set_update_interval(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkClock * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_clock_set_update_interval",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLOCK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clock_set_update_interval(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clock_start(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkClock * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_clock_start",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLOCK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clock_start(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clock_stop(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkClock * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_clock_stop",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLOCK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clock_stop(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_dial_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_dial_get_type")) 
        return NULL;
    _result = (int )gtk_dial_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_dial_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkAdjustment * _arg0 = NULL;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"|O:gtk_dial_new",&_obj0)) 
        return NULL;
    if (_obj0)
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_dial_new(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gtk_dial_get_adjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _result;
    GtkDial * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_dial_get_adjustment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_DIAL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkAdjustment *)gtk_dial_get_adjustment(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_dial_set_update_policy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkDial * _arg0;
    GtkUpdateType * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_dial_set_update_policy",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_DIAL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkUpdateType tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_UPDATE_TYPE, _obj1,(gint*)_arg1))
    return NULL;
}
    gtk_dial_set_update_policy(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_dial_set_adjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkDial * _arg0;
    GtkAdjustment * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_dial_set_adjustment",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_DIAL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_dial_set_adjustment(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_dial_set_percentage(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    float  _result;
    GtkDial * _arg0;
    float  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Of:gtk_dial_set_percentage",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_DIAL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (float )gtk_dial_set_percentage(_arg0,_arg1);
    _resultobj = Py_BuildValue("f",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_dial_get_percentage(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    float  _result;
    GtkDial * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_dial_get_percentage",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_DIAL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (float )gtk_dial_get_percentage(_arg0);
    _resultobj = Py_BuildValue("f",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_dial_set_value(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    float  _result;
    GtkDial * _arg0;
    float  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Of:gtk_dial_set_value",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_DIAL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (float )gtk_dial_set_value(_arg0,_arg1);
    _resultobj = Py_BuildValue("f",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_dial_get_value(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    float  _result;
    GtkDial * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_dial_get_value",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_DIAL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (float )gtk_dial_get_value(_arg0);
    _resultobj = Py_BuildValue("f",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_dial_set_view_only(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkDial * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_dial_set_view_only",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_DIAL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_dial_set_view_only(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_layout_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_layout_get_type")) 
        return NULL;
    _result = (int )gtk_layout_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_layout_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkAdjustment * _arg0 = NULL;
    GtkAdjustment * _arg1 = NULL;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"|OO:gtk_layout_new",&_obj0,&_obj1)) 
        return NULL;
    if (_obj0)
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    if (_obj1)
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_layout_new(_arg0,_arg1);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gtk_layout_put(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkLayout * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    int  _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOii:gtk_layout_put",&_obj0,&_obj1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LAYOUT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGtk_Check(_obj1))
    _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkObject");
    return NULL;
  }
}
    gtk_layout_put(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_layout_move(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkLayout * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    int  _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOii:gtk_layout_move",&_obj0,&_obj1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LAYOUT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGtk_Check(_obj1))
    _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkObject");
    return NULL;
  }
}
    gtk_layout_move(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_layout_set_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkLayout * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_layout_set_size",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LAYOUT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_layout_set_size(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_layout_freeze(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkLayout * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_layout_freeze",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LAYOUT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_layout_freeze(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_layout_thaw(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkLayout * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_layout_thaw",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LAYOUT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_layout_thaw(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_layout_get_hadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _result;
    GtkLayout * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_layout_get_hadjustment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LAYOUT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkAdjustment *)gtk_layout_get_hadjustment(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_layout_get_vadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _result;
    GtkLayout * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_layout_get_vadjustment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LAYOUT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkAdjustment *)gtk_layout_get_vadjustment(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_layout_set_hadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkLayout * _arg0;
    GtkAdjustment * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_layout_set_hadjustment",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LAYOUT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_layout_set_hadjustment(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_layout_set_vadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkLayout * _arg0;
    GtkAdjustment * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_layout_set_vadjustment",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LAYOUT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_layout_set_vadjustment(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_plug_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_plug_get_type")) 
        return NULL;
    _result = (int )gtk_plug_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_plug_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    unsigned int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_plug_new",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_plug_new(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gtk_socket_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_socket_get_type")) 
        return NULL;
    _result = (int )gtk_socket_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_socket_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_socket_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_socket_new();
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gtk_socket_steal(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkSocket * _arg0;
    unsigned int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_socket_steal",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SOCKET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_socket_steal(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_spell_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_spell_get_type")) 
        return NULL;
    _result = (int )gtk_spell_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_spell_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_spell_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_spell_new();
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gtk_spell_check(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkSpell * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_spell_check",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPELL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_spell_check(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_spell_accept(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkSpell * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_spell_accept",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPELL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_spell_accept(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_spell_insert(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkSpell * _arg0;
    char * _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Osi:gtk_spell_insert",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPELL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_spell_insert(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_spell_next(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkSpell * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_spell_next",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPELL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_spell_next(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_spell_kill(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkSpell * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_spell_kill",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPELL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_spell_kill(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_ted_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_ted_get_type")) 
        return NULL;
    _result = (int )gtk_ted_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_ted_set_app_name(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_ted_set_app_name",&_arg0)) 
        return NULL;
    gtk_ted_set_app_name(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_ted_prepare(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTed * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_ted_prepare",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TED(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_ted_prepare(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_ted_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_ted_new",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_ted_new(_arg0);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gtk_ted_new_layout(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;
    char * _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:gtk_ted_new_layout",&_arg0,&_arg1)) 
        return NULL;
    _result = (GtkWidget *)gtk_ted_new_layout(_arg0,_arg1);
{
  _resultobj = PyGtk_New((GtkObject *)_result);
}
    return _resultobj;
}

static PyObject *_wrap_gtk_ted_add(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTed * _arg0;
    GtkWidget * _arg1;
    char * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOs:gtk_ted_add",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TED(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGtk_Check(_obj1))
    _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkObject");
    return NULL;
  }
}
    gtk_ted_add(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyMethodDef _gnomeuiMethods[] = {
	 { "gtk_ted_add", _wrap_gtk_ted_add, 1 },
	 { "gtk_ted_new_layout", _wrap_gtk_ted_new_layout, 1 },
	 { "gtk_ted_new", _wrap_gtk_ted_new, 1 },
	 { "gtk_ted_prepare", _wrap_gtk_ted_prepare, 1 },
	 { "gtk_ted_set_app_name", _wrap_gtk_ted_set_app_name, 1 },
	 { "gtk_ted_get_type", _wrap_gtk_ted_get_type, 1 },
	 { "gtk_spell_kill", _wrap_gtk_spell_kill, 1 },
	 { "gtk_spell_next", _wrap_gtk_spell_next, 1 },
	 { "gtk_spell_insert", _wrap_gtk_spell_insert, 1 },
	 { "gtk_spell_accept", _wrap_gtk_spell_accept, 1 },
	 { "gtk_spell_check", _wrap_gtk_spell_check, 1 },
	 { "gtk_spell_new", _wrap_gtk_spell_new, 1 },
	 { "gtk_spell_get_type", _wrap_gtk_spell_get_type, 1 },
	 { "gtk_socket_steal", _wrap_gtk_socket_steal, 1 },
	 { "gtk_socket_new", _wrap_gtk_socket_new, 1 },
	 { "gtk_socket_get_type", _wrap_gtk_socket_get_type, 1 },
	 { "gtk_plug_new", _wrap_gtk_plug_new, 1 },
	 { "gtk_plug_get_type", _wrap_gtk_plug_get_type, 1 },
	 { "gtk_layout_set_vadjustment", _wrap_gtk_layout_set_vadjustment, 1 },
	 { "gtk_layout_set_hadjustment", _wrap_gtk_layout_set_hadjustment, 1 },
	 { "gtk_layout_get_vadjustment", _wrap_gtk_layout_get_vadjustment, 1 },
	 { "gtk_layout_get_hadjustment", _wrap_gtk_layout_get_hadjustment, 1 },
	 { "gtk_layout_thaw", _wrap_gtk_layout_thaw, 1 },
	 { "gtk_layout_freeze", _wrap_gtk_layout_freeze, 1 },
	 { "gtk_layout_set_size", _wrap_gtk_layout_set_size, 1 },
	 { "gtk_layout_move", _wrap_gtk_layout_move, 1 },
	 { "gtk_layout_put", _wrap_gtk_layout_put, 1 },
	 { "gtk_layout_new", _wrap_gtk_layout_new, 1 },
	 { "gtk_layout_get_type", _wrap_gtk_layout_get_type, 1 },
	 { "gtk_dial_set_view_only", _wrap_gtk_dial_set_view_only, 1 },
	 { "gtk_dial_get_value", _wrap_gtk_dial_get_value, 1 },
	 { "gtk_dial_set_value", _wrap_gtk_dial_set_value, 1 },
	 { "gtk_dial_get_percentage", _wrap_gtk_dial_get_percentage, 1 },
	 { "gtk_dial_set_percentage", _wrap_gtk_dial_set_percentage, 1 },
	 { "gtk_dial_set_adjustment", _wrap_gtk_dial_set_adjustment, 1 },
	 { "gtk_dial_set_update_policy", _wrap_gtk_dial_set_update_policy, 1 },
	 { "gtk_dial_get_adjustment", _wrap_gtk_dial_get_adjustment, 1 },
	 { "gtk_dial_new", _wrap_gtk_dial_new, 1 },
	 { "gtk_dial_get_type", _wrap_gtk_dial_get_type, 1 },
	 { "gtk_clock_stop", _wrap_gtk_clock_stop, 1 },
	 { "gtk_clock_start", _wrap_gtk_clock_start, 1 },
	 { "gtk_clock_set_update_interval", _wrap_gtk_clock_set_update_interval, 1 },
	 { "gtk_clock_set_seconds", _wrap_gtk_clock_set_seconds, 1 },
	 { "gtk_clock_set_format", _wrap_gtk_clock_set_format, 1 },
	 { "gtk_clock_new", _wrap_gtk_clock_new, 1 },
	 { "gtk_clock_get_type", _wrap_gtk_clock_get_type, 1 },
	 { "gtk_calendar_thaw", _wrap_gtk_calendar_thaw, 1 },
	 { "gtk_calendar_freeze", _wrap_gtk_calendar_freeze, 1 },
	 { "gtk_calendar_get_date", gtk__calendar_get_date, 1 },
	 { "gtk_calendar_display_options", _wrap_gtk_calendar_display_options, 1 },
	 { "gtk_calendar_clear_marks", _wrap_gtk_calendar_clear_marks, 1 },
	 { "gtk_calendar_unmark_day", _wrap_gtk_calendar_unmark_day, 1 },
	 { "gtk_calendar_mark_day", _wrap_gtk_calendar_mark_day, 1 },
	 { "gtk_calendar_select_day", _wrap_gtk_calendar_select_day, 1 },
	 { "gtk_calendar_select_month", _wrap_gtk_calendar_select_month, 1 },
	 { "gtk_calendar_new", _wrap_gtk_calendar_new, 1 },
	 { "gtk_calendar_get_type", _wrap_gtk_calendar_get_type, 1 },
	 { "gnome_stock_transparent_window", _wrap_gnome_stock_transparent_window, 1 },
	 { "gnome_stock_menu_accel_parse", _wrap_gnome_stock_menu_accel_parse, 1 },
	 { "gnome_stock_menu_accel", gnome__stock_menu_accel, 1 },
	 { "gnome_stock_menu_item", _wrap_gnome_stock_menu_item, 1 },
	 { "gnome_stock_or_ordinary_button", _wrap_gnome_stock_or_ordinary_button, 1 },
	 { "gnome_stock_button", _wrap_gnome_stock_button, 1 },
	 { "gnome_stock_set_icon", _wrap_gnome_stock_set_icon, 1 },
	 { "gnome_stock_new_with_icon", _wrap_gnome_stock_new_with_icon, 1 },
	 { "gnome_stock_new", _wrap_gnome_stock_new, 1 },
	 { "gnome_stock_get_type", _wrap_gnome_stock_get_type, 1 },
	 { "gnome_startup_acquire_token", _wrap_gnome_startup_acquire_token, 1 },
	 { "gnome_scores_set_current_player", _wrap_gnome_scores_set_current_player, 1 },
	 { "gnome_scores_set_logo_label_title", _wrap_gnome_scores_set_logo_label_title, 1 },
	 { "gnome_scores_set_def_color", _wrap_gnome_scores_set_def_color, 1 },
	 { "gnome_scores_set_color", _wrap_gnome_scores_set_color, 1 },
	 { "gnome_scores_set_logo_widget", _wrap_gnome_scores_set_logo_widget, 1 },
	 { "gnome_scores_set_logo_pixmap", _wrap_gnome_scores_set_logo_pixmap, 1 },
	 { "gnome_scores_set_logo_label", _wrap_gnome_scores_set_logo_label, 1 },
	 { "gnome_scores_new", gnome__scores_new, 1 },
	 { "gnome_scores_display", _wrap_gnome_scores_display, 1 },
	 { "gnome_scores_get_type", _wrap_gnome_scores_get_type, 1 },
	 { "gnome_rootwin_new", _wrap_gnome_rootwin_new, 1 },
	 { "gnome_rootwin_get_type", _wrap_gnome_rootwin_get_type, 1 },
	 { "gnome_property_box_append_page", _wrap_gnome_property_box_append_page, 1 },
	 { "gnome_property_box_changed", _wrap_gnome_property_box_changed, 1 },
	 { "gnome_property_box_new", _wrap_gnome_property_box_new, 1 },
	 { "gnome_property_box_get_type", _wrap_gnome_property_box_get_type, 1 },
	 { "gnome_pixmap_load_file_at_size", _wrap_gnome_pixmap_load_file_at_size, 1 },
	 { "gnome_pixmap_load_file", _wrap_gnome_pixmap_load_file, 1 },
	 { "gnome_pixmap_new_from_file_at_size", _wrap_gnome_pixmap_new_from_file_at_size, 1 },
	 { "gnome_pixmap_new_from_file", _wrap_gnome_pixmap_new_from_file, 1 },
	 { "gnome_pixmap_get_type", _wrap_gnome_pixmap_get_type, 1 },
	 { "gnome_number_entry_get_number", _wrap_gnome_number_entry_get_number, 1 },
	 { "gnome_number_entry_set_title", _wrap_gnome_number_entry_set_title, 1 },
	 { "gnome_number_entry_gtk_entry", _wrap_gnome_number_entry_gtk_entry, 1 },
	 { "gnome_number_entry_gnome_entry", _wrap_gnome_number_entry_gnome_entry, 1 },
	 { "gnome_number_entry_new", _wrap_gnome_number_entry_new, 1 },
	 { "gnome_number_entry_get_type", _wrap_gnome_number_entry_get_type, 1 },
	 { "gnome_message_box_new", _wrap_gnome_message_box_new, 1 },
	 { "gnome_message_box_get_type", _wrap_gnome_message_box_get_type, 1 },
	 { "gnome_mdi_child_set_menu_template", _wrap_gnome_mdi_child_set_menu_template, 1 },
	 { "gnome_mdi_child_set_name", _wrap_gnome_mdi_child_set_name, 1 },
	 { "gnome_mdi_child_remove_view", _wrap_gnome_mdi_child_remove_view, 1 },
	 { "gnome_mdi_child_add_view", _wrap_gnome_mdi_child_add_view, 1 },
	 { "gnome_mdi_child_new", _wrap_gnome_mdi_child_new, 1 },
	 { "gnome_mdi_child_get_type", _wrap_gnome_mdi_child_get_type, 1 },
	 { "gnome_mdi_get_child_from_view", _wrap_gnome_mdi_get_child_from_view, 1 },
	 { "gnome_mdi_get_app_from_view", _wrap_gnome_mdi_get_app_from_view, 1 },
	 { "gnome_mdi_unregister", _wrap_gnome_mdi_unregister, 1 },
	 { "gnome_mdi_register", _wrap_gnome_mdi_register, 1 },
	 { "gnome_mdi_find_child", _wrap_gnome_mdi_find_child, 1 },
	 { "gnome_mdi_update_child", _wrap_gnome_mdi_update_child, 1 },
	 { "gnome_mdi_remove_all", _wrap_gnome_mdi_remove_all, 1 },
	 { "gnome_mdi_remove_child", _wrap_gnome_mdi_remove_child, 1 },
	 { "gnome_mdi_add_child", _wrap_gnome_mdi_add_child, 1 },
	 { "gnome_mdi_set_active_view", _wrap_gnome_mdi_set_active_view, 1 },
	 { "gnome_mdi_active_view", _wrap_gnome_mdi_active_view, 1 },
	 { "gnome_mdi_remove_view", _wrap_gnome_mdi_remove_view, 1 },
	 { "gnome_mdi_add_view", _wrap_gnome_mdi_add_view, 1 },
	 { "gnome_mdi_active_child", _wrap_gnome_mdi_active_child, 1 },
	 { "gnome_mdi_set_child_list_path", _wrap_gnome_mdi_set_child_list_path, 1 },
	 { "gnome_mdi_set_child_menu_path", _wrap_gnome_mdi_set_child_menu_path, 1 },
	 { "gnome_mdi_set_toolbar_template", _wrap_gnome_mdi_set_toolbar_template, 1 },
	 { "gnome_mdi_set_menu_template", _wrap_gnome_mdi_set_menu_template, 1 },
	 { "gnome_mdi_set_tab_pos", _wrap_gnome_mdi_set_tab_pos, 1 },
	 { "gnome_mdi_set_mode", _wrap_gnome_mdi_set_mode, 1 },
	 { "gnome_mdi_new", _wrap_gnome_mdi_new, 1 },
	 { "gnome_mdi_get_type", _wrap_gnome_mdi_get_type, 1 },
	 { "gnome_less_fixed_font", _wrap_gnome_less_fixed_font, 1 },
	 { "gnome_less_reshow", _wrap_gnome_less_reshow, 1 },
	 { "gnome_less_set_fixed_font", _wrap_gnome_less_set_fixed_font, 1 },
	 { "gnome_less_set_font", _wrap_gnome_less_set_font, 1 },
	 { "gnome_less_show_filestream", _wrap_gnome_less_show_filestream, 1 },
	 { "gnome_less_show_string", _wrap_gnome_less_show_string, 1 },
	 { "gnome_less_show_command", _wrap_gnome_less_show_command, 1 },
	 { "gnome_less_show_file", _wrap_gnome_less_show_file, 1 },
	 { "gnome_less_clear", _wrap_gnome_less_clear, 1 },
	 { "gnome_less_new", _wrap_gnome_less_new, 1 },
	 { "gnome_less_get_type", _wrap_gnome_less_get_type, 1 },
	 { "gnome_lamp_set_window_type", _wrap_gnome_lamp_set_window_type, 1 },
	 { "gnome_lamp_set_type", _wrap_gnome_lamp_set_type, 1 },
	 { "gnome_lamp_set_sequence", _wrap_gnome_lamp_set_sequence, 1 },
	 { "gnome_lamp_set_color", _wrap_gnome_lamp_set_color, 1 },
	 { "gnome_lamp_new_with_type", _wrap_gnome_lamp_new_with_type, 1 },
	 { "gnome_lamp_new_with_color", _wrap_gnome_lamp_new_with_color, 1 },
	 { "gnome_lamp_new", _wrap_gnome_lamp_new, 1 },
	 { "gnome_lamp_get_type", _wrap_gnome_lamp_get_type, 1 },
	 { "gnome_icon_selection_select_icon", _wrap_gnome_icon_selection_select_icon, 1 },
	 { "gnome_icon_selection_get_icon", _wrap_gnome_icon_selection_get_icon, 1 },
	 { "gnome_icon_selection_clear", _wrap_gnome_icon_selection_clear, 1 },
	 { "gnome_icon_selection_show_icons", _wrap_gnome_icon_selection_show_icons, 1 },
	 { "gnome_icon_selection_add_directory", _wrap_gnome_icon_selection_add_directory, 1 },
	 { "gnome_icon_selection_add_defaults", _wrap_gnome_icon_selection_add_defaults, 1 },
	 { "gnome_icon_selection_new", _wrap_gnome_icon_selection_new, 1 },
	 { "gnome_icon_selection_get_type", _wrap_gnome_icon_selection_get_type, 1 },
	 { "gnome_icon_list_get_icon_at", _wrap_gnome_icon_list_get_icon_at, 1 },
	 { "gnome_icon_list_set_border", _wrap_gnome_icon_list_set_border, 1 },
	 { "gnome_icon_list_set_mode", _wrap_gnome_icon_list_set_mode, 1 },
	 { "gnome_icon_list_set_separators", _wrap_gnome_icon_list_set_separators, 1 },
	 { "gnome_icon_list_set_icon_border", _wrap_gnome_icon_list_set_icon_border, 1 },
	 { "gnome_icon_list_set_text_spacing", _wrap_gnome_icon_list_set_text_spacing, 1 },
	 { "gnome_icon_list_set_col_spacing", _wrap_gnome_icon_list_set_col_spacing, 1 },
	 { "gnome_icon_list_set_row_spacing", _wrap_gnome_icon_list_set_row_spacing, 1 },
	 { "gnome_icon_list_set_background", _wrap_gnome_icon_list_set_background, 1 },
	 { "gnome_icon_list_set_foreground", _wrap_gnome_icon_list_set_foreground, 1 },
	 { "gnome_icon_list_icon_is_visible", _wrap_gnome_icon_list_icon_is_visible, 1 },
	 { "gnome_icon_list_moveto", _wrap_gnome_icon_list_moveto, 1 },
	 { "gnome_icon_list_thaw", _wrap_gnome_icon_list_thaw, 1 },
	 { "gnome_icon_list_freeze", _wrap_gnome_icon_list_freeze, 1 },
	 { "gnome_icon_list_unselect_icon", _wrap_gnome_icon_list_unselect_icon, 1 },
	 { "gnome_icon_list_select_icon", _wrap_gnome_icon_list_select_icon, 1 },
	 { "gnome_icon_list_find_icon_from_data", _wrap_gnome_icon_list_find_icon_from_data, 1 },
	 { "gnome_icon_list_get_icon_data", _wrap_gnome_icon_list_get_icon_data, 1 },
	 { "gnome_icon_list_set_icon_data", gnome__icon_list_set_icon_data, 1 },
	 { "gnome_icon_list_clear", _wrap_gnome_icon_list_clear, 1 },
	 { "gnome_icon_list_remove", _wrap_gnome_icon_list_remove, 1 },
	 { "gnome_icon_list_insert", _wrap_gnome_icon_list_insert, 1 },
	 { "gnome_icon_list_append", _wrap_gnome_icon_list_append, 1 },
	 { "gnome_icon_list_set_policy", _wrap_gnome_icon_list_set_policy, 1 },
	 { "gnome_icon_list_set_selection_mode", _wrap_gnome_icon_list_set_selection_mode, 1 },
	 { "gnome_icon_list_new", _wrap_gnome_icon_list_new, 1 },
	 { "gnome_icon_list_get_type", _wrap_gnome_icon_list_get_type, 1 },
	 { "gnome_ice_init", _wrap_gnome_ice_init, 1 },
	 { "gnome_font_select_with_default", gnome__font_select_with_default, 1 },
	 { "gnome_font_select", gnome__font_select, 1 },
	 { "gnome_font_selector_get_selected", gnome__font_selector_get_selected, 1 },
	 { "gnome_font_selector_new", _wrap_gnome_font_selector_new, 1 },
	 { "gnome_font_selector_get_type", _wrap_gnome_font_selector_get_type, 1 },
	 { "gnome_file_entry_set_title", _wrap_gnome_file_entry_set_title, 1 },
	 { "gnome_file_entry_gtk_entry", _wrap_gnome_file_entry_gtk_entry, 1 },
	 { "gnome_file_entry_gnome_entry", _wrap_gnome_file_entry_gnome_entry, 1 },
	 { "gnome_file_entry_new", _wrap_gnome_file_entry_new, 1 },
	 { "gnome_file_entry_get_type", _wrap_gnome_file_entry_get_type, 1 },
	 { "gnome_entry_save_history", _wrap_gnome_entry_save_history, 1 },
	 { "gnome_entry_load_history", _wrap_gnome_entry_load_history, 1 },
	 { "gnome_entry_append_history", _wrap_gnome_entry_append_history, 1 },
	 { "gnome_entry_prepend_history", _wrap_gnome_entry_prepend_history, 1 },
	 { "gnome_entry_set_history_id", _wrap_gnome_entry_set_history_id, 1 },
	 { "gnome_entry_gtk_entry", _wrap_gnome_entry_gtk_entry, 1 },
	 { "gnome_entry_new", _wrap_gnome_entry_new, 1 },
	 { "gnome_entry_get_type", _wrap_gnome_entry_get_type, 1 },
	 { "gnome_request_password_dialog", gnome__request_password_dialog, 1 },
	 { "gnome_request_string_dialog", gnome__request_string_dialog, 1 },
	 { "gnome_ok_cancel_dialog_modal", gnome__ok_cancel_dialog_modal, 1 },
	 { "gnome_ok_cancel_dialog", gnome__ok_cancel_dialog, 1 },
	 { "gnome_question_dialog_modal", gnome__question_dialog_modal, 1 },
	 { "gnome_question_dialog", gnome__question_dialog, 1 },
	 { "gnome_warning_dialog", _wrap_gnome_warning_dialog, 1 },
	 { "gnome_error_dialog", _wrap_gnome_error_dialog, 1 },
	 { "gnome_ok_dialog", _wrap_gnome_ok_dialog, 1 },
	 { "gnome_dialog_append_button", _wrap_gnome_dialog_append_button, 1 },
	 { "gnome_dialog_append_buttons", _wrap_gnome_dialog_append_buttons, 1 },
	 { "gnome_dialog_set_destroy", _wrap_gnome_dialog_set_destroy, 1 },
	 { "gnome_dialog_editable_enters", _wrap_gnome_dialog_editable_enters, 1 },
	 { "gnome_dialog_set_close", _wrap_gnome_dialog_set_close, 1 },
	 { "gnome_dialog_close_hides", _wrap_gnome_dialog_close_hides, 1 },
	 { "gnome_dialog_close", _wrap_gnome_dialog_close, 1 },
	 { "gnome_dialog_set_accelerator", _wrap_gnome_dialog_set_accelerator, 1 },
	 { "gnome_dialog_set_sensitive", _wrap_gnome_dialog_set_sensitive, 1 },
	 { "gnome_dialog_set_default", _wrap_gnome_dialog_set_default, 1 },
	 { "gnome_dialog_run_and_destroy", _wrap_gnome_dialog_run_and_destroy, 1 },
	 { "gnome_dialog_run_and_hide", _wrap_gnome_dialog_run_and_hide, 1 },
	 { "gnome_dialog_run_modal", _wrap_gnome_dialog_run_modal, 1 },
	 { "gnome_dialog_run", _wrap_gnome_dialog_run, 1 },
	 { "gnome_dialog_set_modal", _wrap_gnome_dialog_set_modal, 1 },
	 { "gnome_dialog_button_connect", gnome__dialog_button_connect, 1 },
	 { "gnome_dialog_set_parent", _wrap_gnome_dialog_set_parent, 1 },
	 { "gnome_dialog_get_vbox", _wrap_gnome_dialog_get_vbox, 1 },
	 { "gnome_dialog_new", _wrap_gnome_dialog_new, 1 },
	 { "gnome_dialog_get_type", _wrap_gnome_dialog_get_type, 1 },
	 { "gnome_dentry_edit_get_name", _wrap_gnome_dentry_edit_get_name, 1 },
	 { "gnome_dentry_edit_get_icon", _wrap_gnome_dentry_edit_get_icon, 1 },
	 { "gnome_dentry_edit_save_file", gnome__dentry_edit_save_file, 1 },
	 { "gnome_dentry_edit_load_file", _wrap_gnome_dentry_edit_load_file, 1 },
	 { "gnome_dentry_edit_clear", _wrap_gnome_dentry_edit_clear, 1 },
	 { "gnome_dentry_edit_new", _wrap_gnome_dentry_edit_new, 1 },
	 { "gnome_dentry_edit_get_type", _wrap_gnome_dentry_edit_get_type, 1 },
	 { "gnome_date_edit_get_date", _wrap_gnome_date_edit_get_date, 1 },
	 { "gnome_date_edit_set_popup_range", _wrap_gnome_date_edit_set_popup_range, 1 },
	 { "gnome_date_edit_set_time", _wrap_gnome_date_edit_set_time, 1 },
	 { "gnome_date_edit_new", _wrap_gnome_date_edit_new, 1 },
	 { "gnome_date_edit_get_type", _wrap_gnome_date_edit_get_type, 1 },
	 { "gnome_color_picker_set_title", _wrap_gnome_color_picker_set_title, 1 },
	 { "gnome_color_picker_set_use_alpha", _wrap_gnome_color_picker_set_use_alpha, 1 },
	 { "gnome_color_picker_set_dither", _wrap_gnome_color_picker_set_dither, 1 },
	 { "gnome_color_picker_get_i16", gnome__color_picker_get_i16, 1 },
	 { "gnome_color_picker_get_i8", gnome__color_picker_get_i8, 1 },
	 { "gnome_color_picker_get_d", gnome__color_picker_get_d, 1 },
	 { "gnome_color_picker_set_i16", _wrap_gnome_color_picker_set_i16, 1 },
	 { "gnome_color_picker_set_i8", _wrap_gnome_color_picker_set_i8, 1 },
	 { "gnome_color_picker_set_d", _wrap_gnome_color_picker_set_d, 1 },
	 { "gnome_color_picker_new", _wrap_gnome_color_picker_new, 1 },
	 { "gnome_color_picker_get_type", _wrap_gnome_color_picker_get_type, 1 },
	 { "gnome_client_flush", _wrap_gnome_client_flush, 1 },
	 { "gnome_client_request_save", _wrap_gnome_client_request_save, 1 },
	 { "gnome_interaction_key_return", _wrap_gnome_interaction_key_return, 1 },
	 { "gnome_client_request_interaction", gnome__client_request_interaction, 1 },
	 { "gnome_client_request_phase_2", _wrap_gnome_client_request_phase_2, 1 },
	 { "gnome_client_set_user_id", _wrap_gnome_client_set_user_id, 1 },
	 { "gnome_client_set_restart_style", _wrap_gnome_client_set_restart_style, 1 },
	 { "gnome_client_set_program", _wrap_gnome_client_set_program, 1 },
	 { "gnome_client_set_process_id", _wrap_gnome_client_set_process_id, 1 },
	 { "gnome_client_set_current_directory", _wrap_gnome_client_set_current_directory, 1 },
	 { "gnome_client_set_environment", _wrap_gnome_client_set_environment, 1 },
	 { "gnome_client_set_shutdown_command", gnome__client_set_shutdown_command, 1 },
	 { "gnome_client_set_resign_command", gnome__client_set_resign_command, 1 },
	 { "gnome_client_set_restart_command", gnome__client_set_restart_command, 1 },
	 { "gnome_client_set_discard_command", gnome__client_set_discard_command, 1 },
	 { "gnome_client_set_clone_command", gnome__client_set_clone_command, 1 },
	 { "gnome_client_get_global_config_prefix", _wrap_gnome_client_get_global_config_prefix, 1 },
	 { "gnome_client_get_config_prefix", _wrap_gnome_client_get_config_prefix, 1 },
	 { "gnome_client_get_previous_id", _wrap_gnome_client_get_previous_id, 1 },
	 { "gnome_client_get_id", _wrap_gnome_client_get_id, 1 },
	 { "gnome_client_set_id", _wrap_gnome_client_set_id, 1 },
	 { "gnome_client_disconnect", _wrap_gnome_client_disconnect, 1 },
	 { "gnome_client_connect", _wrap_gnome_client_connect, 1 },
	 { "gnome_client_new_without_connection", _wrap_gnome_client_new_without_connection, 1 },
	 { "gnome_client_new", _wrap_gnome_client_new, 1 },
	 { "gnome_cloned_client", _wrap_gnome_cloned_client, 1 },
	 { "gnome_master_client", _wrap_gnome_master_client, 1 },
	 { "gnome_client_disable_master_connection", _wrap_gnome_client_disable_master_connection, 1 },
	 { "gnome_client_get_type", _wrap_gnome_client_get_type, 1 },
	 { "gnome_calculator_get_result", _wrap_gnome_calculator_get_result, 1 },
	 { "gnome_calculator_set", _wrap_gnome_calculator_set, 1 },
	 { "gnome_calculator_clear", _wrap_gnome_calculator_clear, 1 },
	 { "gnome_calculator_new", _wrap_gnome_calculator_new, 1 },
	 { "gnome_calculator_get_type", _wrap_gnome_calculator_get_type, 1 },
	 { "gnome_appbar_get_response", _wrap_gnome_appbar_get_response, 1 },
	 { "gnome_appbar_clear_prompt", _wrap_gnome_appbar_clear_prompt, 1 },
	 { "gnome_appbar_set_prompt", _wrap_gnome_appbar_set_prompt, 1 },
	 { "gnome_appbar_refresh", _wrap_gnome_appbar_refresh, 1 },
	 { "gnome_appbar_set_progress", _wrap_gnome_appbar_set_progress, 1 },
	 { "gnome_appbar_clear_stack", _wrap_gnome_appbar_clear_stack, 1 },
	 { "gnome_appbar_pop", _wrap_gnome_appbar_pop, 1 },
	 { "gnome_appbar_push", _wrap_gnome_appbar_push, 1 },
	 { "gnome_appbar_set_default", _wrap_gnome_appbar_set_default, 1 },
	 { "gnome_appbar_set_status", _wrap_gnome_appbar_set_status, 1 },
	 { "gnome_appbar_new", _wrap_gnome_appbar_new, 1 },
	 { "GNOME_APPBAR_INTERACTIVE", _wrap_GNOME_APPBAR_INTERACTIVE, 1 },
	 { "gnome_appbar_get_type", _wrap_gnome_appbar_get_type, 1 },
	 { "gnome_popup_menu_attach", _wrap_gnome_popup_menu_attach, 1 },
	 { "gnome_popup_menu_new", _wrap_gnome_popup_menu_new, 1 },
	 { "gnome_app_remove_menus", _wrap_gnome_app_remove_menus, 1 },
	 { "gnome_app_insert_menus", _wrap_gnome_app_insert_menus, 1 },
	 { "gnome_app_create_toolbar", _wrap_gnome_app_create_toolbar, 1 },
	 { "gnome_app_create_menus", _wrap_gnome_app_create_menus, 1 },
	 { "gnome_app_menu_set_position", _wrap_gnome_app_menu_set_position, 1 },
	 { "gnome_app_toolbar_set_position", _wrap_gnome_app_toolbar_set_position, 1 },
	 { "gnome_app_set_contents", _wrap_gnome_app_set_contents, 1 },
	 { "gnome_app_set_statusbar", _wrap_gnome_app_set_statusbar, 1 },
	 { "gnome_app_set_toolbar", _wrap_gnome_app_set_toolbar, 1 },
	 { "gnome_app_set_menus", _wrap_gnome_app_set_menus, 1 },
	 { "gnome_app_new", _wrap_gnome_app_new, 1 },
	 { "gnome_app_get_type", _wrap_gnome_app_get_type, 1 },
	 { "gnome_about_new", gnome__about_new, 1 },
	 { "gnome_about_get_type", _wrap_gnome_about_get_type, 1 },
	 { "gnome_init", gnome__init, 1 },
	 { "gnome_canvas_widget_get_type", _wrap_gnome_canvas_widget_get_type, 1 },
	 { "gnome_canvas_text_get_type", _wrap_gnome_canvas_text_get_type, 1 },
	 { "gnome_canvas_ellipse_get_type", _wrap_gnome_canvas_ellipse_get_type, 1 },
	 { "gnome_canvas_rect_get_type", _wrap_gnome_canvas_rect_get_type, 1 },
	 { "gnome_canvas_re_get_type", _wrap_gnome_canvas_re_get_type, 1 },
	 { "gnome_canvas_line_get_type", _wrap_gnome_canvas_line_get_type, 1 },
	 { "gnome_canvas_image_get_type", _wrap_gnome_canvas_image_get_type, 1 },
	 { "gnome_canvas_group_get_type", _wrap_gnome_canvas_group_get_type, 1 },
	 { "gnome_canvas_item_get_type", _wrap_gnome_canvas_item_get_type, 1 },
	 { "gnome_canvas_item_lower_to_bottom", _wrap_gnome_canvas_item_lower_to_bottom, 1 },
	 { "gnome_canvas_item_raise_to_top", _wrap_gnome_canvas_item_raise_to_top, 1 },
	 { "gnome_canvas_item_lower", _wrap_gnome_canvas_item_lower, 1 },
	 { "gnome_canvas_item_raise", _wrap_gnome_canvas_item_raise, 1 },
	 { "gnome_canvas_item_move", _wrap_gnome_canvas_item_move, 1 },
	 { "gnome_canvas_item_set", gnome__canvas_item_set, 1 },
	 { "gnome_canvas_item_new", gnome__canvas_item_new, 1 },
	 { "gnome_canvas_get_color", gnome__canvas_get_color, 1 },
	 { "gnome_canvas_c2w", gnome__canvas_c2w, 1 },
	 { "gnome_canvas_w2c", gnome__canvas_w2c, 1 },
	 { "gnome_canvas_update_now", _wrap_gnome_canvas_update_now, 1 },
	 { "gnome_canvas_get_scroll_offsets", gnome__canvas_get_scroll_offsets, 1 },
	 { "gnome_canvas_scroll_to", _wrap_gnome_canvas_scroll_to, 1 },
	 { "gnome_canvas_set_size", _wrap_gnome_canvas_set_size, 1 },
	 { "gnome_canvas_set_pixels_per_unit", _wrap_gnome_canvas_set_pixels_per_unit, 1 },
	 { "gnome_canvas_get_scroll_region", gnome__canvas_get_scroll_region, 1 },
	 { "gnome_canvas_set_scroll_region", _wrap_gnome_canvas_set_scroll_region, 1 },
	 { "gnome_canvas_root", _wrap_gnome_canvas_root, 1 },
	 { "gnome_canvas_new", _wrap_gnome_canvas_new, 1 },
	 { "gnome_canvas_get_type", _wrap_gnome_canvas_get_type, 1 },
	 { "gtk_dialog_cauldron", gtk__dialog_cauldron, 1 },
	 { NULL, NULL }
};
static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void,init_gnomeui)() {
	 PyObject *m, *d;
	 SWIG_globals = SWIG_newvarlink();
	 m = Py_InitModule("_gnomeui", _gnomeuiMethods);
	 d = PyModule_GetDict(m);
/*
 * These are the pointer type-equivalency mappings. 
 * (Used by the SWIG pointer type-checker).
 */
	 SWIG_RegisterMapping("_signed_long","_long",0);
	 SWIG_RegisterMapping("_long","_unsigned_long",0);
	 SWIG_RegisterMapping("_long","_signed_long",0);
	 SWIG_RegisterMapping("_unsigned_long","_long",0);
	 SWIG_RegisterMapping("_signed_int","_int",0);
	 SWIG_RegisterMapping("_unsigned_short","_short",0);
	 SWIG_RegisterMapping("_signed_short","_short",0);
	 SWIG_RegisterMapping("_unsigned_int","_int",0);
	 SWIG_RegisterMapping("_short","_unsigned_short",0);
	 SWIG_RegisterMapping("_short","_signed_short",0);
	 SWIG_RegisterMapping("_int","_unsigned_int",0);
	 SWIG_RegisterMapping("_int","_signed_int",0);
}
