import sys; _sys = sys; del sys
import _libgnomeui
import Gtkinter; _Gtkinter = Gtkinter; del Gtkinter
import _gnomeui

# lets get our constants ...
from uiconsts import *

_obj2inst = _Gtkinter._obj2inst
_filtprops = _Gtkinter._filtprops

class GnomeCanvasItem(_Gtkinter.GtkObject):
	get_type = _gnomeui.gnome_canvas_item_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
	def set(self, **args):
		_fileprops(args)
		_gnomeui.gnome_canvas_item_set(self._o, args)
	def move(self, dx, dy):
		_gnomeui.gnome_canvas_item_move(self._o, dx, dy)
	def raise_(self, positions):
		_gnomeui.gnome_canvas_item_raise(self._o, positions)
	def lower(self, positions):
		_gnomeui.gnome_canvas_item_lower(self._o, positions)
	def raise_to_top(self):
		_gnomeui.gnome_canvas_item_raise_to_top(self._o)
	def lower_to_bottom(self):
		_gnomeui.gnome_canvas_item_lower_to_bottom(self._o)
_Gtkinter._name2cls['GnomeCanvasItem'] = GnomeCanvasItem

class GnomeCanvasGroup(GnomeCanvasItem):
	"""has arguments 'x' and 'y'.  eg you can go new_item('group', x=4)"""
	get_type = _gnomeui.gnome_canvas_group_get_type
	def new_item(self, tp, **args):
		types = {
			'item':    _gnomeui.gnome_canvas_item_get_type,
			'group':   _gnomeui.gnome_canvas_group_get_type,
			'image':   _gnomeui.gnome_canvas_image_get_type,
			'line':    _gnomeui.gnome_canvas_line_get_type,
			're':      _gnomeui.gnome_canvas_re_get_type,
			'rect':    _gnomeui.gnome_canvas_rect_get_type,
			'ellipse': _gnomeui.gnome_canvas_ellipse_get_type,
			'text':    _gnomeui.gnome_canvas_text_get_type,
			'widget':  _gnomeui.gnome_canvas_widget_get_type
		}
		if type(tp) == type('string'):
			tp = types[tp]()
		_filtprops(args)
		return _obj2inst(_gnomeui.gnome_canvas_item_new(self._o,
								tp, args))
_Gtkinter._name2cls['GnomeCanvasGroup'] = GnomeCanvasGroup

class GnomeCanvasImage(GnomeCanvasItem):
	"""has arguments image (unfortunately a pointer type - not useable yet)
	'x', 'y', 'width', 'height', 'anchor'"""
	get_type = _gnomeui.gnome_canvas_image_get_type
_Gtkinter._name2cls['GnomeCanvasImage'] = GnomeCanvasItem

class GnomeCanvasLine(GnomeCanvasItem):
	"""has arguments 'points' (a pointer -- doh), 'fill_color',
	'width_pixels', 'width_units', 'cap_style', 'join_style',
	'first_arrowhead', 'last_arrowhead', 'smooth', 'spline_steps',
	'arrow_shape_a', 'arrow_shape_b', 'arrow_shape_c'"""
	get_type = _gnomeui.gnome_canvas_line_get_type
_Gtkinter._name2cls['GnomeCanvasLine'] = GnomeCanvasLine

class GnomeCanvasRE(GnomeCanvasItem):
	"""has arguments 'x1', 'y1', 'x2', 'y2', 'fill_color', 'outline_color',
	'width_pixels', 'width_units'"""
	get_type = _gnomeui.gnome_canvas_re_get_type
_Gtkinter._name2cls['GnomeCanvasRE'] = GnomeCanvasRE

class GnomeCanvasRect(GnomeCanvasRE):
	"""has arguments of GnomeCanvasRE"""
	get_type = _gnomeui.gnome_canvas_rect_get_type
_Gtkinter._name2cls['GnomeCanvasRect'] = GnomeCanvasRect

class GnomeCanvasEllipse(GnomeCanvasRE):
	"""has arguments of GnomeCanvasRE"""
	get_type = _gnomeui.gnome_canvas_ellipse_get_type
_Gtkinter._name2cls['GnomeCanvasEllipse'] = GnomeCanvasEllipse

class GnomeCanvasText(GnomeCanvasItem):
	"""has arguments 'text', 'x', 'y', 'font', 'anchor', 'justification',
	'fill_color'"""
	get_type = _gnomeui.gnome_canvas_text_get_type
_Gtkinter._name2cls['GnomeCanvasText'] = GnomeCanvasText

class GnomeCanvasWidget(GnomeCanvasItem):
	"""has arguments 'widget', 'x', 'y', 'width', 'height', 'anchor',
	'size_pixels'"""
	get_type = _gnomeui.gnome_canvas_widget_get_type
_Gtkinter._name2cls['GnomeCanvasWidget'] = GnomeCanvasWidget

class GnomeDialog(_Gtkinter.GtkWindow):
	get_type = _gnomeui.gnome_dialog_get_type
	def __init__(self, title='', b1=None, b2=None, b3=None, b4=None,
		     b5=None, b6=None, b7=None, b8=None, b9=None, b10=None,
		     _obj=None):
		if _obj: self._o = _obj; return
		buttons = filter(lambda x: x, (b1,b2,b3,b4,b5,b6,b7,b8,b9,b10))
		self._o = apply(_gnomeui.gnome_dialog_new, (title,) + buttons)
	def __getattr__(self, attr):
		attrs = {
			"vbox": _gnomeui.gnome_dialog_get_vbox,
		}
		if attrs.has_key(attr):
			return _obj2inst(attrs[attr](self._o))
		raise AttributeError, attr
	def set_parent(self, parent):
		_gnomeui.gnome_dialog_set_parent(self._o, parent._o)
	def run_modal(self):
		return _gnomeui.gnome_dialog_run_modal(self._o)
	def run(self):
		return _gnomeui.gnome_dialog_run(self._o)
	def run_and_hide(self):
		return _gnomeui.gnome_dialog_run_and_hide(self._o)
	def run_and_destroy(self):
		return _gnomeui.gnome_dialog_run_and_destroy(self._o)
	def button_connect(self, button, callback):
		_gnomeui.gnome_dialog_button_connect(self._o, button, callback)
	def set_modal(self):
		_gnomeui.gnome_dialog_set_modal(self._o)
	def set_default(self, button):
		_gnomeui.gnome_dialog_set_default(self._o)
	def set_sensitive(self, button, setting):
		_gnomeui.gnome_dialog_set_sensitive(self._o, button, setting)
	def set_destroy(self, self_destruct):
		print "Deprecated -- use set_close"
		_gnomeui.gnome_dialog_set_destroy(self._o, self_destruct)
	def set_accelerator(self, button, ac_key, ac_mods):
		_gnomeui.gnome_dialog_set_accelerator(self._o, button, ac_key,
						      ac_mods)
	def close(self, obj=None):
		_gnomeui.gnome_dialog_close(self._o)
	def close_hides(self, just_hide):
		_gnomeui.gnome_dialog_close_hides(self._o, just_hide)
	def set_close(self, click_closes):
		_gnomeui.gnome_dialog_set_close(self._o, click_closes)
	def editable_enters(self, editable):
		_gnomeui.gnome_dialog_editable_enters(self._o, editable._o)
	def append_buttons(self, b1=None, b2=None, b3=None, b4=None, b5=None,
			   b6=None, b7=None, b8=None, b9=None, b10=None):
		buttons = filter(lambda x: x, (b1,b2,b3,b4,b5,b6,b7,b8,b9,b10))
		apply(_gnomeui.gnome_dialog_append_buttons, (self._o,)+buttons)
	def append_button(self, name):
		_gnomeui.gnome_dialog_append_button(self._o, name)
_Gtkinter._name2cls['GnomeDialog'] = GnomeDialog

# these are wrappers for the convenience functions.  They really return
# GnomeDialog's.
class GnomeOkDialog(GnomeDialog):
	def __init__(self, msg):
		self._o = _gnomeui.gnome_ok_dialog(msg)
class GnomeErrorDialog(GnomeDialog):
	def __init__(self, error):
		self._o = _gnomeui.gnome_error_dialog(error)
class GnomeWarningDialog(GnomeDialog):
	def __init__(self, warning):
		self._o = _gnomeui.gnome_warning_dialog(warning)
class GnomeQuestionDialog(GnomeDialog):
	def __init__(self, question, cb, modal=_Gtkinter.FALSE):
		if modal:
			self._o = _gnomeui.gnome_question_dialog_modal(
				question, cb)
		else:
			self._o = _gnomeui.gnome_question_dialog(question, cb)
class GnomeOkCancelDialog(GnomeDialog):
	def __init__(self, message, cb, modal=_Gtkinter.FALSE):
		if modal:
			self._o = _gnomeui.gnome_ok_cancel_dialog_modal(
				message, cb)
		else:
			self._o = _gnomeui.gnome_ok_cancel_dialog(message, cb)
class GnomeRequestStringDialog(GnomeDialog):
	def __init__(self, prompt, cb):
		self._o = _gnomeui.gnome_request_string_dialog(prompt, cb)
class GnomeRequestPasswordDialog(GnomeDialog):
	def __init__(self, prompt, cb):
		self._o = _gnomeui.gnome_request_password_dialog(prompt, cb)

class GnomeAbout(GnomeDialog):
	get_type = _gnomeui.gnome_about_get_type
	def __init__(self, title=None, version=None, copyright=None, list=[],
		     comments=None, logo=None, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gnome_about_new(title, version, copyright,
						   list, comments, logo)
_Gtkinter._name2cls['GnomeAbout'] = GnomeAbout

class GnomeApp(_Gtkinter.GtkWindow):
	get_type = _gnomeui.gnome_app_get_type
	def __init__(self, appname='', title='', _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gnome_app_new(appname, title)
	def set_menus(self, menubar):
		_gnomeui.gnome_app_set_menus(self._o, menubar._o)
	def set_toolbar(self, toolbar):
		_gnomeui.gnome_app_set_toolbar(self._o, toolbar._o)
	def set_statusbar(self, statusbar):
		_gnomeui.gnome_app_set_statusbar(self._o, statusbar._o)
	def set_contents(self, contents):
		_gnomeui.gnome_app_set_contents(self._o, contents._o)
	def toolbar_set_position(self, pos_toolbar):
		_gnomeui.gnome_app_toolbar_set_position(self._o, pos_toolbar)
	def menu_set_position(self, pos_menu):
		_gnomeui.gnome_app_menu_set_position(self._o, pos_menu)
	def create_menus(self, menuinfo):
		_gnomeui.gnome_app_create_menus(self._o, menuinfo)
	def create_toolbar(self, toolbarinfo):
		_gnomeui.gnome_app_create_toolbar(self._o, toolbarinfo)
	def remove_menus(self, path, num):
		_gnomeui.gnome_app_remove_menus(self._o, path, num)
	def insert_menus(self, path, menuinfo):
		_gnomeui.gnome_app_insert_menus(self._o, path, menuinfo)
_Gtkinter._name2cls['GnomeApp'] = GnomeApp

class GnomeAppBar(_Gtkinter.GtkHBox):
	get_type = _gnomeui.gnome_appbar_get_type
	def __init__(self, has_progress=1, has_status=1,
		     interactivity=PREFERENCES_USER, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gnome_appbar_new(has_progress, has_status,
						    interactivity)
	def interactive(self):
		return _gnomeui.GNOME_APPBAR_INTERACTIVE(self._o)
	def set_status(self, status):
		_gnomeui.gnome_appbar_set_status(self._o, status)
	def set_default(self, default_status):
		_gnomeui.gnome_appbar_set_default(self._o, default_status)
	def push(self, status):
		_gnomeui.gnome_appbar_push(self._o, status)
	def pop(self):
		_gnomeui.gnome_appbar_pop(self._o)
	def clear_stack(self):
		_gnomeui.gnome_appbar_clear_stack(self._o)
	def set_progress(self, percentage):
		_gnomeui.gnome_appbar_set_progress(self._o, percentage)
	def refresh(self):
		_gnomeui.gnome_appbar_refresh(self._o)
	def set_prompt(self, prompt, modal=_Gtkinter.FALSE):
		_gnomeui.gnome_appbar_set_prompt(self._o, prompt, modal)
	def clear_prompt(self):
		_gnomeui.gnome_appbar_clear_prompt(self._o)
	def get_response(self):
		return _gnomeui.gnome_appbar_get_response(self._o)
_Gtkinter._name2cls['GnomeAppBar'] = GnomeAppBar

class GnomeCalculator(_Gtkinter.GtkVBox):
	get_type = _gnomeui.gnome_calculator_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gnome_calculator_new()
	def clear(self, reset=1):
		_gnomeui.gnome_calculator_clear(self._o, reset)
	def set(self, result):
		_gnomeui.gnome_calculator_set(self._o, result)
	def get_result(self):
		return _gnomeui.gnome_calculator_get_result(self._o)
_Gtkinter._name2cls['GnomeCalculator'] = GnomeCalculator

class GnomeClient(_Gtkinter.GtkObject):
	get_type = _gnomeui.gnome_client_get_type
	def __init__(self, connected=_Gtkinter.TRUE, _obj=None):
		if _obj: self._o = _obj; return
		if connected:
		    self._o = _gnomeui.gnome_client_new()
		else:
		    self._o = _gnomeui.gnome_client_new_without_connection()
	def connect(self):
		_gnomeui.gnome_client_connect(self._o)
	def disconnect(self):
		_gnomeui.gnome_client_disconnect(self._o)
	def set_id(self, client_id):
		_gnomeui.gnome_client_set_id(self._o, client_id)
	def get_id(self):
		return _gnomeui.gnome_client_get_id(self._o)
	def get_previous_id(self):
		return _gnomeui.gnome_client_get_previous_id(self._o)
	def get_config_prefix(self):
		return _gnomeui.gnome_client_get_config_prefix(self._o)
	def get_global_config_prefix(self):
		return _gnomeui.gnome_client_get_global_config_prefix(self._o)
	def set_clone_command(self, vector):
		_gnomeui.gnome_client_set_clone_command(self._o, vector)
	def set_discard_command(self, vector):
		_gnomeui.gnome_client_set_discard_command(self._o, vector)
	def set_environment(self, name, value):
		_gnomeui.gnome_client_set_environment(self._o, name, value)
	def set_restart_command(self, vector):
		_gnomeui.gnome_client_set_restart_command(self._o, vector)
	def set_resign_command(self, vector):
		_gnomeui.gnome_client_set_resign_command(self._o, vector)
	def set_shutdown_command(self, vector):
		_gnomeui.gnome_client_set_shutdown_command(self._o, vector)
	def set_current_directory(self, dir):
		_gnomeui.gnome_client_set_current_directory(self._o, dir)
	def set_process_id(self, pid):
		_gnomeui.gnome_client_set_process_id(self._o, pid)
	def set_program(self, program):
		_gnomeui.gnome_client_set_program(self._o, program)
	def set_restart_style(self, style):
		_gnomeui.gnome_client_set_restart_style(self._o, style)
	def set_user_id(self, user_id):
		_gnomeui.gnome_client_set_user_id(self._o, user_id)
	def request_phase_2(self):
		_gnomeui.gnome_client_request_phase_2(self._o)
	def request_interaction(self, dialog, func):
		_gnomeui.gnome_client_request_interaction(self._o,dialog,func)
	def request_save(self, save_style, shutdown, interact_style, fast,
			 is_global):
		_gnomeui.gnome_client_request_save(self._o, save_style,
						   shutdown, interact_style,
						   fast, is_global)
	def flush(self):
		_gnomeui.gnome_client_flush(self._o)
_Gtkinter._name2cls['GnomeClient'] = GnomeClient

def interaction_key_return(key, cancel_shutdown):
	_gnomeui.gnome_interaction_key_return(key, cancel_shutdown)
# set up the default SM client
if hasattr(_libgnomeui, 'default_client'):
	default_client = GnomeClient(_obj=_libgnomeui.default_client)

class GnomeClonedClient(GnomeClient):
	def __init__(self):
		self._o = _gnomeui.gnome_cloned_client()

class GnomeColorPicker(_Gtkinter.GtkButton):
	get_type = _gnomeui.gnome_color_picker_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gnome_color_picker_new()
	def set_d(self, r, g, b, a):
		_gnomeui.gnome_color_picker_set_d(self._o, r, g, b, a)
	def get_d(self):
		return _gnomeui.gnome_color_picker_get_d(self._o)
	def set_i8(self, r, g, b, a):
		_gnomeui.gnome_color_picker_set_i8(self._o, r, g, b, a)
	def get_i8(self):
		return _gnomeui.gnome_color_picker_get_i8(self._o)
	def set_i16(self, r, g, b, a):
		_gnomeui.gnome_color_picker_set_i16(self._o, r, g, b, a)
	def get_i16(self):
		return _gnomeui.gnome_color_picker_get_i16(self._o)
	def set_dither(self, dither):
		_gnomeui.gnome_color_picker_set_dither(self._o, dither)
	def set_use_alpha(self, use_alpha):
		_gnomeui.gnome_color_picker_set_use_alpha(self._o, use_alpha)
	def set_title(self, title):
		_gnomeui.gnome_color_picker_set_title(self._o, title)
_Gtkinter._name2cls['GnomeColorPicker'] = GnomeColorPicker

class GnomeDateEdit(_Gtkinter.GtkHBox):
	get_type = _gnomeui.gnome_date_edit_get_type
	def __init__(self, the_time=0, show_time=0, use_24=0, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gnome_date_edit_new(the_time, show_time,
						       use_24)
	def set_time(self, the_time):
		_gnomeui.gnome_date_edit_set_time(self._o, the_time)
	def set_popup_range(self, low_hour, up_hour):
		_gnomeui.gnome_date_edit_set_popup_range(self._o, low_hour,
							 up_hour)
	def get_date(self):
		return _gnomeui.gnome_date_edit_get_date(self._o)
_Gtkinter._name2cls['GnomeDateEdit'] = GnomeDateEdit

class GnomeDEntryEdit(_Gtkinter.GtkObject):
	get_type = _gnomeui.gnome_dentry_edit_get_type
	def __init__(self, notebook=None, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gnome_dentry_edit_new(notebook._o)
	def clear(self):
		_gnomeui.gnome_dentry_edit_clear(self._o)
	def load_file(self, filename):
		_gnomeui.gnome_dentry_edit_load_file(self._o, filename)
	# this is provided, because I haven't added dentry support to the
	# _gnome low-level module.
	def save_file(self, filename):
		_gnomeui.gnome_dentry_edit_save_file(self._o, filename)
	def get_icon(self):
		return _gnomeui.gnome_dentry_edit_get_icon(self._o)
	def get_name(self):
		return _gnomeui.gnome_dentry_edit_get_name(self._o)
_Gtkinter._name2cls['GnomeDEntryEdit'] = GnomeDEntryEdit

class GnomeEntry(_Gtkinter.GtkCombo):
	get_type = _gnomeui.gnome_entry_get_type
	def __init__(self, history_id='', _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gnome_entry_new(history_id)
	def gtk_entry(self):
		return _obj2inst(_gnomeui.gnome_entry_gtk_entry(self._o))
	def set_history_id(self, history_id):
		_gnomeui.gnome_entry_set_history_id(self._o, history_id)
	def prepend_history(self, save, text):
		_gnomeui.gnome_entry_prepend_history(self._o, save, text)
	def append_history(self, save, text):
		_gnomeui.gnome_entry_append_history(self._o, save, text)
	def load_history(self):
		_gnomeui.gnome_entry_load_history(self._o)
	def save_history(self):
		_gnomeui.gnome_entry_save_history(self._o)
_Gtkinter._name2cls['GnomeEntry'] = GnomeEntry

class GnomeFileEntry(_Gtkinter.GtkHBox):
	get_type = _gnomeui.gnome_file_entry_get_type
	def __init__(self, history_id='', browse_dialog_title='', _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gnome_file_entry_new(history_id,
							browse_dialog_title)
	def gnome_entry(self):
		return _obj2inst(_gnomeui.gnome_file_entry_gnome_entry(
			self._o))
	def gtk_entry(self):
		return _obj2inst(_gnomeui.gnome_file_entry_gtk_entry(self._o))
	def set_title(self, browse_dialog_title):
		_gnomeui.gnome_file_entry_set_title(self._o,
						    browse_dialog_title)
_Gtkinter._name2cls['GnomeFileEntry'] = GnomeFileEntry

class GnomeFontSelector(_Gtkinter.GtkDialog):
	get_type = _gnomeui.gnome_font_selector_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gnome_font_selector_new()
	def get_selected(self):
		return _gnomeui.gnome_font_selector_get_selected(self._o)
_Gtkinter._name2cls['GnomeFontSelector'] = GnomeFontSelector
# quick access method ...
def font_select():
	return _gnomeui.gnome_font_select()
def font_select_with_default(default):
	return _gnomeui.gnome_font_select_with_default(default)

class GnomeIconList(_Gtkinter.GtkContainer):
	get_type = _gnomeui.gnome_icon_list_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gnome_icon_list_new()
	def set_selection_mode(self, mode):
		_gnomeui.gnome_icon_list_set_selection_mode(self._o, mode)
	def set_policy(self, v_policy, h_policy):
		_gnomeui.gnome_icon_list_set_policy(self._o, v_policy,
						    h_policy)
	def append(self, icon_filename, text):
		_gnomeui.gnome_icon_list_append(self._o, icon_filename, text)
	def insert(self, pos, icon_filename, text):
		_gnomeui.gnome_icon_list_insert(self._o, pos, icon_filename,
						text)
	def remove(self, pos):
		_gnomeui.gnome_icon_list_remove(self._o, pos)
	def set_icon_data(self, pos, data):
		_gnomeui.gnome_icon_list_set_icon_data(self._o, pos, data)
	def get_icon_data(self, pos):
		return _gnomeui.gnome_icon_list_get_icon_data(self._o, pos)
	def find_icon_from_data(self, data):
		return _gnomeui.gnome_icon_list_find_icon_from_data(self._o,
								    data)
	def select_icon(self, pos):
		_gnomeui.gnome_icon_list_select_icon(self._o, pos)
	def unselect_icon(self, pos):
		_gnomeui.gnome_icon_list_unselect_icon(self._o, pos)
	def freeze(self):
		_gnomeui.gnome_icon_list_freeze(self._o)
	def thaw(self):
		_gnomeui.gnome_icon_list_thaw(self._o)
	def moveto(self, pos, yalign=0.5):
		_gnomeui.gnome_icon_list_moveto(self._o, pos, yalign)
	def icon_is_visible(self, pos):
		return _gnomeui.gnome_icon_list_icon_is_visible(self._o, pos)
	def set_foreground(self, pos, color):
		_gnomeui.gnome_icon_list_set_foreground(self._o, pos, color)
	def set_background(self, pos, color):
		_gnomeui.gnome_icon_list_set_background(self._o, pos, color)
	def set_row_spacing(self, spacing):
		_gnomeui.gnome_icon_list_set_row_spacing(self._o, pos, spacing)
	def set_col_spacing(self, spacing):
		_gnomeui.gnome_icon_list_set_col_spacing(self._o, pos, spacing)
	def set_text_spacing(self, spacing):
		_gnomeui.gnome_icon_list_set_text_spacing(self._o,pos,spacing)
	def set_icon_border(self, spacing):
		_gnomeui.gnome_icon_list_set_icon_border(self._o, pos, spacing)
	def set_separators(self, separators):
		_gnomeui.gnome_icon_list_set_separators(self._o, separators)
	def set_mode(self, mode):
		_gnomeui.gnome_icon_list_set_mode(self._o, mode)
	def set_border(self, border):
		_gnomeui.gnome_icon_list_set_border(self._o, border)
	def get_icon_at(self, x, y):
		return _gnomeui.gnome_icon_list_get_icon_at(self._o, x, y)
_Gtkinter._name2cls['GnomeIconList'] = GnomeIconList

class GnomeIconSelection(_Gtkinter.GtkVBox):
	get_type = _gnomeui.gnome_icon_selection_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gnome_icon_selection_new()
	def add_defaults(self):
		_gnomeui.gnome_icon_selection_add_defaults(self._o)
	def add_directory(self, dir):
		_gnomeui.gnome_icon_selection_add_directory(self._o, dir)
	def show_icons(self):
		_gnomeui.gnome_icon_selection_show_icons(self._o)
	def clear(self):
		_gnomeui.gnome_icon_selection_clear(self._o)
	def get_icon(self, full_path=_Gtkinter.TRUE):
		_gnomeui.gnome_icon_selection_get_icon(self._o, full_path)
	def select_icon(self, filename):
		_gnomeui.gnome_icon_selection_select_icon(self._o, filename)
_Gtkinter._name2cls['GnomeIconSelection'] = GnomeIconSelection

class GnomeLess(_Gtkinter.GtkVBox):
	get_type = _gnomeui.gnome_less_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gnome_less_new()
	def show_file(self, path):
		_gnomeui.gnome_less_show_file(self._o, path)
	def show_command(self, command_line):
		_gnomeui.gnome_less_show_command(self._o, command_line)
	def show_string(self, string):
		_gnomeui.gnome_less_show_string(self._o, string)
	def show_filestream(self, fp):
		return _gnomeui.gnome_less_show_filestream(self._o, fp)
	def fixed_font(self):
		_gnomeui.gnome_less_fixed_font(self._o)
	def set_font(self, font):
		_gnomeui.gnome_less_set_font(self._o, font)
	def set_fixed_font(self, fixed):
		_gnomeui.gnome_less_set_fixed_font(self._o, fixed)
	def reshow(self):
		_gnomeui.gnome_less_reshow(self._o)
_Gtkinter._name2cls['GnomeLess'] = GnomeLess

class GnomeMDI(_Gtkinter.GtkObject):
	get_type = _gnomeui.gnome_mdi_get_type
	def __init__(self, appname=None, title=None, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gnome_mdi_new(appname, title)
	def set_mode(self, mode):
		_gnomeui.gnome_mdi_set_mode(self._o, mode)
	def set_tab_pos(self, pos):
		_gnomeui.gnome_mdi_set_tab_pos(self._o, pos)
	def set_menu_template(self, info):
		_gnomeui.gnome_mdi_set_menu_template(self._o, info)
	def set_toolbar_template(self, info):
		_gnomeui.gnome_mdi_set_toolbar_template(self._o, info)
	def set_child_menu_path(self, path):
		_gnomeui.gnome_mdi_set_child_menu_path(self._o, path)
	def set_child_list_path(self, path):
		_gnomeui.gnome_mdi_set_child_list_path(self._o, path)
	def active_child(self):
		return GnomeMDIChild(
			_obj=_gnomeui.gnome_mdi_active_child(self._o))
	def find_child(self, name):
		return GnomeMDIChild(
			_obj=_gnomeui.gnome_mdi_find_child(self._o, name))
	def add_view(self, child):
		return _gnomeui.gnome_mdi_add_view(self._o, child._o)
	def remove_view(self, wid, force):
		return _gnomeui.gnome_mdi_remove_view(self._o, wid._o, force)
	def add_child(self, child):
		return _gnomeui.gnome_mdi_add_child(self._o, child._o)
	def remove_child(self, child, force):
		return _gnomeui.gnome_mdi_remove_child(self._o, child._o,force)
	def remove_all(self, force):
		return _gnomeui.gnome_mdi_remove_all(self._o, force)
	def update_child(self, child):
		_gnomeui.gnome_mdi_update_child(self._o, child._o)
	def register(self, wid):
		_gnomeui.gnome_mdi_register(self._o, wid._o)
	def unregister(self, wid):
		_gnomeui.gnome_mdi_unregister(self._o, wid._o)
	def get_app_from_view(self, view):
		return GnomeApp(_obj=
				_gnomeui.gnome_mdi_get_app_from_view(view._o))
	def get_child_from_view(self, view):
		return GnomeMDIChild(_obj=
				     _gnomeui.gnome_mdi_get_child_from_view(
					     view._o))
	def set_active_view(self, view):
		_gnomeui.gnome_mdi_set_active_view(self._o, view._o)
	def get_active_view(self):
		return _obj2inst(_gnomeui.gnome_mdi_get_active_view(self._o))
_Gtkinter._name2cls['GnomeMDI'] = GnomeMDI

class GnomeMDIChild(_Gtkinter.GtkObject):
	get_type = _gnomeui.gnome_mdi_child_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gnome_mdi_child_new()
	def add_view(self):
		return _obj2inst(_gnomeui.gnome_mdi_child_add_view(self._o))
	def remove_view(self, view):
		_gnomeui.gnome_mdi_child_remove_view(self._o, view._o)
	def set_name(self, name):
		_gnomeui.gnome_mdi_child_set_name(self._o, name)
	def set_menu_template(self, info):
		_gnomeui.gnome_mdi_child_set_menu_template(self._o, info)
_Gtkinter._name2cls['GnomeMDIChild'] = GnomeMDIChild

class GnomeMessageBox(GnomeDialog):
	get_type = _gnomeui.gnome_message_box_get_type
	def __init__(self, message='', messagebox_type='', b1=None, b2=None,
		     b3=None, b4=None, b5=None, b6=None, b7=None, b8=None,
		     b9=None, b10=None, _obj=None):
		if _obj: self._o = _obj; return
		buttons = filter(lambda x: x, (b1,b2,b3,b4,b5,b6,b7,b8,b9,b10))
		self._o = apply(_gnomeui.gnome_message_box_new,
				(message, messagebox_type) + buttons)
_Gtkinter._name2cls['GnomeMessageBox'] = GnomeMessageBox

class GnomeNumberEntry(_Gtkinter.GtkHBox):
	get_type = _gnomeui.gnome_number_entry_get_type
	def __init__(self, history_id=None, dlg_title=None, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gnome_number_entry_new(history_id,
							  dlg_title)
	def gnome_entry(self):
		return GnomeEntry(
			_obj=_gnomeui.gnome_number_entry_gnome_entry(self._o))
	def gtk_entry(self):
		return _Gtkinter.GtkEntry(
			_obj=_gnomeui.gnome_number_entry_gtk_entry(self._o))
	def set_title(self, dlg_title):
		_gnomeui.gnome_number_entry_set_title(self._o, dlg_title)
	def get_number(self):
		return _gnomeui.gnome_number_entry_get_number(self._o)
_Gtkinter._name2cls['GnomeNumberEntry'] = GnomeNumberEntry

class GnomePixmap(_Gtkinter.GtkWidget):
	get_type = _gnomeui.gnome_pixmap_get_type
	def __init__(self, filename='', width=-1, height=-1, _obj=None):
		if _obj: self._o = _obj; return
		if (width, height) == (-1, -1):
			self._o = _gnomeui.gnome_pixmap_new_from_file(
				filename)
		else:
			self._o = _gnomeui.gnome_pixmap_new_from_file_at_size(
				filename, width, height)
	def load_file(self, filename, width=-1, height=-1):
		if (width, heigth) == (-1, -1):
			_gnomeui.gnome_pixmap_load_file(self._o, filename)
		else:
			_gnomeui.gnome_pixmap_load_file_at_size(self._o,
						filename, width, height)
_Gtkinter._name2cls['GnomePixmap'] = GnomePixmap

class GnomeLamp(GnomePixmap):
	get_type = _gnomeui.gnome_lamp_get_type
	def __init__(self, type_or_color=None, _obj=None):
		if _obj: self._o = _obj; return
		if type_or_color == None:
			self._o = _gnomeui.gnome_lamp_new()
		elif type(type_or_color) == type('abc'):
			self._o = _gnomeui.gnome_lamp_new_with_type(
				type_or_color)
		else:
			self._o = _gnomeui.gnome_lamp_new_with_color(
				type_or_color)
	def set_color(self, color):
		_gnomeui.gnome_lamp_set_color(self._o, color)
	def set_sequence(self, seq):
		_gnomeui.gnome_lamp_set_sequence(self._o, seq)
	def set_type(self, tp):
		_gnomeui.gnome_lamp_set_type(self._o, tp)
_Gtkinter._name2cls['GnomeLamp'] = GnomeLamp

# add lamp stuff to GtkWindow class ...
def set_lamp_type(self, type):
	_gnomeui.gnome_lamp_set_window_set_window_type(self._o, type)
_Gtkinter.GtkWindow.__dict__['set_lamp_type'] = set_lamp_type
del set_lamp_type

# this will probably not work in the code -- the user_data field in the
# uiinfo structures gets overwritten by gnome_popup_menu_new.
# Seriously broke
class GnomePopupMenu(_Gtkinter.GtkMenu):
	def __init__(self, uiinfo):
		self._o = _gnomeui.gnome_popup_menu_new(uiinfo)
	def attach(self, child):
		_gnomeui.gnome_popup_menu_attach(self._o, child._o)

class GnomePropertyBox(GnomeDialog):
	get_type = _gnomeui.gnome_property_box_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gnome_property_box_new()
	def changed(self, obj=None):
		_gnomeui.gnome_property_box_changed(self._o)
	def append_page(self, child, tab_label):
		_gnomeui.gnome_property_box_append_page(self._o, child._o,
							tab_label._o)
_Gtkinter._name2cls['GnomePropertyBox'] = GnomePropertyBox

class GnomeRootWin(_Gtkinter.GtkWindow):
	get_type = _gnomeui.gnome_rootwin_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gnome_rootwin_new()
_Gtkinter._name2cls['GnomeRootWin'] = GnomeRootWin

class GnomeScores(GnomeDialog):
	get_type = _gnomeui.gnome_scores_get_type
	def __init__(self, scores=[], clear=_Gtkinter.FALSE, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gnome_scores_new(scores, clear)
	def set_logo_label(self, txt, font, color):
		_gnomeui.gnome_scores_set_logo_label(self._o, txt, font, color)
	def set_logo_pixmap(self, logo):
		_gnomeui.gnome_scores_set_logo_pixmap(self._o, logo)
	def set_logo_widget(self, w):
		_gnomeui.gnome_scores_set_logo_widget(self._o, w._o)
	def set_color(self, pos, color):
		_gnomeui.gnome_scores_set_color(self._o, pos, color)
	def set_def_color(self, color):
		_gnomeui.gnome_scores_set_def_color(self._o, color)
	def set_logo_label_title(self, txt):
		_gnomeui.gnome_scores_set_logo_label_title(self._o, txt)
	def set_current_player(self, pos):
		_gnomeui.gnome_scores_set_current_player(self._o, pos)
_Gtkinter._name2cls['GnomeScores'] = GnomeScores

def scores_display(title, app_name, level=None, pos=-1):
	_gnomeui.gnome_scores_display(title, app_name, level, pos)

# gnome startup stuff
def startup_acquire_token(property_name, sm_id):
	_gnomeui.gnome_startup_acquire_token(property_name, sm_id)

class GnomeStock(GnomePixmap):
	get_type = _gnomeui.gnome_stock_get_type
	def __init__(self, icon=None, _obj=None):
		if _obj: self._o = _obj; return
		if icon:
			self._o = _gnomeui.gnome_stock_new_with_icon(icon)
		else:
			self._o = _gnomeui.gnome_stock_new()
	def set_icon(self, icon):
		_gnomeui.gnome_stock_set_icon(self._o, icon)
_Gtkinter._name2cls['GnomeStock'] = GnomeStock

def GnomeStockPixmapWidget(win, icon=None):
	print "Deprecated -- use GnomeStock instead of GnomeStockPixmapWidget"
	return GnomeStock(icon)

# these aren't really different types, but having different classes is easier
class GnomeStockButton(_Gtkinter.GtkButton):
	def __init__(self, type):
		self._o = _gnomeui.gnome_stock_button(type)
class GnomeStockMenuItem(_Gtkinter.GtkMenuItem):
	def __init__(self, type, text):
		self.type = type
		self._o = _gnomeui.gnome_stock_menu_item(type, text)
	def get_accel(self):
		return _gnomeui.gnome_stock_menu_accel(self.type)
class GnomeStockTransparentWindow(_Gtkinter.GtkWindow):
	def __init__(self, icon, subtype):
		self._o = _gnomeui.gnome_stock_transparent_window(icon,subtype)

def stock_menu_accel(type):
	return _gnomeui.gnome_stock_menu_accel(type)
def stock_menu_accel_parse(section):
	_gnomeui.gnome_stock_menu_accel_parse(section)

class GtkCalendar(_Gtkinter.GtkWidget):
	get_type = _gnomeui.gtk_calendar_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gtk_calendar_new()
	def select_month(self, month, year):
		return _gnomeui.gtk_calendar_select_month(self._o, month, year)
	def select_day(self, day):
		_gnomeui.gtk_calendar_select_day(self._o, day)
	def mark_day(self, day):
		return _gnomeui.gtk_calendar_mark_day(self._o, day)
	def unmark_day(self, day):
		return _gnomeui.gtk_calendar_unmark_day(self._o, day)
	def clear_marks(self):
		_gnomeui.gtk_calendar_clear_marks(self._o)
	def display_options(self, flags):
		_gnomeui.gtk_calendar_display_options(self._o, flags)
	def get_date(self):
		return _gnomeui.gtk_calendar_get_date(self._o)
	def freeze(self):
		_gnomeui.gtk_calendar_freeze(self._o)
	def thaw(self):
		_gnomeui.gtk_calendar_thaw(self._o)
_Gtkinter._name2cls['GtkCalendar'] = GtkCalendar

class GtkClock(_Gtkinter.GtkLabel):
	get_type = _gnomeui.gtk_clock_get_type
	def __init__(self, type=CLOCK_REALTIME, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gtk_clock_new(type)
	def set_format(self, fmt):
		_gnomeui.gtk_clock_set_format(self._o, fmt)
	def set_seconds(self, seconds):
		_gnomeui.gtk_clock_set_seconds(self._o, seconds)
	def set_update_interval(self, seconds):
		_gnomeui.gtk_clock_set_update_interval(self._o, seconds)
	def start(self):
		_gnomeui.gtk_clock_start(self._o)
	def stop(self):
		_gnomeui.gtk_clock_stop(self._o)
_Gtkinter._name2cls['GtkClock'] = GtkClock

class GtkDial(_Gtkinter.GtkWidget):
	get_type = _gnomeui.gtk_dial_get_type
	def __init__(self, adj=None, _obj=None):
		if _obj: self._o = _obj; return
		if adj:
			self._o = _gnomeui.gtk_dial_new(adj._o)
		else:
			self._o = _gnomeui.gtk_dial_new()
	def get_adjustment(self):
		return _obj2inst(_gnomeui.gtk_dial_get_adjustment(self._o))
	def set_update_policy(self, policy):
		_gnomeui.gtk_dial_set_update_policy(self._o, policy)
	def set_adjustment(self, adj):
		_gnomeui.gtk_dial_set_adjustment(self._o, adj._o)
	def set_percentage(self, pcnt):
		return _gnomeui.gtk_dial_set_percentage(self._o, pcnt)
	def get_percentage(self):
		return _gnomeui.gtk_dial_get_percentage(self._o)
	def set_value(self, value):
		return _gnomeui.gtk_dial_set_value(self._o, value)
	def get_value(self):
		return _gnomeui.gtk_dial_get_value(self._o)
	def set_view_only(self, view_only):
		_gnomeui.gtk_dial_set_view_only(self._o, view_only)
_Gtkinter._name2cls['GtkDial'] = GtkDial

class GtkLayout(_Gtkinter.GtkContainer):
	get_type = _gnomeui.gtk_layout_get_type
	def __init__(self, hadj=None, vadj=None, _obj=None):
		if _obj: self._o = _obj; return
		if hadj and vadj:
			self._o = _gnomeui.gtk_layout_new(hadj._o, vadj._o)
		else:
			self._o = _gnomeui.gtk_layout_new()
	def put(self, child, x, y):
		_gnomeui.gtk_layout_put(self._o, child._o, x, y)
	def move(self, child, x, y):
		_gnomeui.gtk_layout_move(self._o, child._o, x, y)
	def set_size(self, width, height):
		_gnomeui.gtk_layout_set_size(self._o, width, height)
	def freeze(self):
		_gnomeui.gtk_layout_freeze(self._o)
	def thaw(self):
		_gnomeui.gtk_layout_thaw(self._o)
	def get_hadjustment(self):
		return _Gtkinter.GtkAdjustment(
			_obj=_gnomeui.gtk_layout_get_hadjustment(self._o))
	def get_vadjustment(self):
		return _Gtkinter.GtkAdjustment(
			_obj=_gnomeui.gtk_layout_get_vadjustment(self._o))
	def set_hadjustment(self, adj):
		_gnomeui.gtk_layout_set_hadjustment(self._o, adj._o)
	def set_vadjustment(self, adj):
		_gnomeui.gtk_layout_set_vadjustment(self._o, adj._o)
_Gtkinter._name2cls['GtkLayout'] = GtkLayout

class GnomeCanvas(GtkLayout):
	get_type = _gnomeui.gnome_canvas_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gnome_canvas_new()
	def root(self):
		return GnomeCanvasGroup(
			_obj=_gnomeui.gnome_canvas_root(self._o))
	def set_scroll_region(self, x1,y1, x2,y2):
		_gnomeui.gnome_canvas_set_scroll_region(self._o, x1,y1, x2,y2)
	def get_scroll_region(self):
		return _gnomeui.gnome_canvas_get_scroll_region(self._o)
	def set_pixels_per_unit(self, n):
		_gnomeui.gnome_canvas_set_pixels_per_unit(self._o, n)
	def set_size(self, width, height):
		_gnomeui.gnome_canvas_set_size(self._o, width, height)
	def scroll_to(self, cx, cy):
		_gnomeui.gnome_canvas_scroll_to(self._o, cx, cy)
	def get_scroll_offsets(self):
		return _gnomeui.gnome_canvas_get_scroll_offsets(self._o)
	def w2c(self, wx, wy):
		return _gnomeui.gnome_canvas_w2c(self._o, wx, wy)
	def c2w(self, cx, cy):
		return _gnomeui.gnome_canvas_c2w(self._o, cx, cy)
	def get_color(self, spec):
		return _gnomeui.gnome_canvas_get_color(self._o, spec)
_Gtkinter._name2cls['GnomeCanvas'] = GnomeCanvas

class GtkPlug(_Gtkinter.GtkWindow):
	get_type = _gnomeui.gtk_plug_get_type
	def __init__(self, socket_id=-1, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gtk_plug_new(socket_id)
_Gtkinter._name2cls['GtkPlug'] = GtkPlug

class GtkSocket(_Gtkinter.GtkContainer):
	get_type = _gnomeui.gtk_socket_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gtk_socket_new()
	def steal(self, wid):
		_gnomeui.gtk_socket_steal(self._o, wid)
_Gtkinter._name2cls['GtkSocket'] = GtkSocket

class GtkSpell(_Gtkinter.GtkVBox):
	get_type = _gnomeui.gtk_spell_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gnomeui.gtk_spell_new()
	def check(self, string):
		return _gnomeui.gtk_spell_check(self._o, string)
	def accept(self, word):
		_gnomeui.gtk_spell_accept(self._o, word)
	def insert(self, word, lowercase):
		_gnomeui.gtk_spell_insert(self._o, word, lowercase)
	def next(self):
		_gnomeui.gtk_spell_next(self._o)
	def kill(self):
		_gnomeui.gtk_spell_kill(self._o)
_Gtkinter._name2cls['GtkSpell'] = GtkSpell

class GtkTed(_Gtkinter.GtkTable):
	get_type = _gnomeui.gtk_ted_get_type
	def __init__(self, dialog_name='', layout=None, _obj=None):
		# last unnamed widget number
		self.__last = 0

		if _obj: self._o = _obj; return

		# set the app name for GtkTed
		if not hasattr(_libgnomeui, 'ted_setup') or \
		   not _libgnomeui.ted_setup:
			import sys
			_gnomeui.gtk_ted_set_app_name(sys.app_id)
			_libgnomeui.ted_setup = _Gtkinter.TRUE

		if layout == None:
			self._o = _gnomeui.gtk_ted_new(dialog_name)
		else:
			self._o = _gnomeui.gtk_ted_new_layout(dialog_name,
							      layout)
	def prepare(self):
		_gnomeui.gtk_ted_prepare(self._o)
	def add(self, child, name=None):
		if name == None:
			name = 'wid' + str(self.__last)
			self.__last = self.__last + 1
		_gnomeui.gtk_ted_add(self._o, child._o, name)
_Gtkinter._name2cls['GtkTed'] = GtkTed


def dialog_cauldron(title, options, fmt, *args):
	return _gnomeui.gtk_dialog_cauldron(title, options, fmt, args)
