%{
#pragma }

typedef struct {
  int type;
  union {
    char *ch_pp;
    int int_p;
    double dbl_p;
    PyObject *tuple; /* of form (callback, userdata). Type set to CALLBACK */
  } d;
} cauldron_result;
typedef struct {
  PyObject *args;
  int arg_len, pos, num_results, num_rets;
  cauldron_result *results;
} cauldron_data;

static GtkWidget *PyGtk_cauldron_callback(GtkWidget *self, PyObject *tuple) {
  PyObject *ret, *params;
  GtkWidget *wret;

  ret = PyTuple_New(1);
  PyTuple_SetItem(ret, 0, PyGtk_New((GtkObject *)self));
  params = PySequence_Concat(ret, PyTuple_GetItem(tuple, 1));
  Py_DECREF(ret);

  ret = PyObject_CallObject(PyTuple_GetItem(tuple, 0), params);
  Py_DECREF(params);
  if (ret == NULL) {
    PyErr_Print();
    PyErr_Clear();
    return NULL;
  }

  if (ret == Py_None) { /* this should only be returned by 'c' type callbacks*/
    Py_DECREF(ret);
    return NULL;
  } else if (PyGtk_Check(ret)) {
    wret = GTK_WIDGET(PyGtk_Get(ret));
    /* the returned widget should still have its floating reference set */
    Py_DECREF(ret);
    return wret;
  } else if ((params = PyObject_GetAttrString(ret, "_o")) &&
	     PyGtk_Check(params)) { /* for Gtkinter */
    wret = GTK_WIDGET(PyGtk_Get(params));
    Py_DECREF(params);
    Py_DECREF(ret);
    return wret;
  }
  Py_XDECREF(params);
  Py_DECREF(ret);
  return NULL;
}

static void next_arg(gint type, cauldron_data *data, void *result) {
  PyObject *item;

  /* there doesn't seem to be any error reporting mechanism -- just fudge it */
  if (data->pos >= data->arg_len) {
    *((int *)result) = 0;
    return;
  }
  item = PyTuple_GetItem(data->args, data->pos++);
  switch (type) {
  case GTK_CAULDRON_TYPE_CHAR_P:
    if (PyString_Check(item))
      *((gchar **)result) = PyString_AsString(item);
    else {
      g_warning("expected string argument, got %s", item->ob_type->tp_name);
      *((gchar **)result) = "";
    }
    break;
  case GTK_CAULDRON_TYPE_CHAR_P_P:
    data->results[data->num_results].type = type;
    if (PyString_Check(item))
      data->results[data->num_results].d.ch_pp = PyString_AsString(item);
    else {
      g_warning("expected string argument, got %s", item->ob_type->tp_name);
      data->results[data->num_results].d.ch_pp = "";
    }
    data->num_rets++;
    *((gchar ***)result) = &(data->results[data->num_results++].d.ch_pp);
    break;
  case GTK_CAULDRON_TYPE_INT:
    if (PyInt_Check(item))
      *((gint *)result) = PyInt_AsLong(item);
    else {
      g_warning("expected int argument, got %s", item->ob_type->tp_name);
      *((gint *)result) = 0;
    }
    break;
  case GTK_CAULDRON_TYPE_INT_P:
    data->results[data->num_results].type = type;
    if (PyInt_Check(item))
      data->results[data->num_results].d.int_p = PyInt_AsLong(item);
    else {
      g_warning("expected int argument, got %s", item->ob_type->tp_name);
      data->results[data->num_results].d.int_p = 0;
    }
    data->num_rets++;
    *((gint **)result) = &(data->results[data->num_results++].d.int_p);
    break;
  case GTK_CAULDRON_TYPE_DOUBLE:
    if (PyFloat_Check(item))
      *((gdouble *)result) = PyFloat_AsDouble(item);
    else {
      g_warning("expected float argument, got %s", item->ob_type->tp_name);
      *((gdouble *)result) = 0.0;
    }
    break;
  case GTK_CAULDRON_TYPE_DOUBLE_P:
    data->results[data->num_results].type = type;
    if (PyFloat_Check(item))
      data->results[data->num_results].d.dbl_p = PyFloat_AsDouble(item);
    else {
      g_warning("expected float argument, got %s", item->ob_type->tp_name);
      data->results[data->num_results].d.dbl_p = 0.0;
    }
    data->num_rets++;
    *((gdouble **)result) = &(data->results[data->num_results++].d.dbl_p);
    break;
  case GTK_CAULDRON_TYPE_CALLBACK:
    data->results[data->num_results].type = type;
    data->results[data->num_results].d.tuple = PyTuple_New(2);
    Py_INCREF(item);
    PyTuple_SetItem(data->results[data->num_results++].d.tuple, 0, item);
    *((gpointer*)result) = PyGtk_cauldron_callback;
    break;
  case GTK_CAULDRON_TYPE_USERDATA_P:
    g_assert(data->results[data->num_results-1].type == GTK_CAULDRON_TYPE_CALLBACK);
    Py_INCREF(item);
    PyTuple_SetItem(data->results[data->num_results-1].d.tuple, 1, item);
    *((PyObject **)result) = data->results[data->num_results-1].d.tuple;
    break;
  }
}

static PyObject *gtk__dialog_cauldron(PyObject *self, PyObject *args) {
  PyObject *ret;
  char *title, *fmt;
  int options, i, j;
  cauldron_data data;
  char *result;

  if (!PyArg_ParseTuple(args, "sisO!:gtk_dialog_cauldron", &title,
			&options, &fmt, &PyTuple_Type, &(data.args)))
    return NULL;
  data.arg_len = PyTuple_Size(data.args);
  data.pos = data.num_results = 0;
  data.num_rets = 1; /* we always return at least a string */
  data.results = g_new(cauldron_result, data.arg_len);
  result = gtk_dialog_cauldron_parse(title, options, fmt,
				     (GtkCauldronNextArgCallback)next_arg,
				     &data);
  if (!result) result = "";
  if (data.num_rets == 1)
    ret = PyString_FromString(result);
  else {
    ret = PyTuple_New(data.num_rets);
    j = 0;
    PyTuple_SetItem(ret, j, PyString_FromString(result));
    for (i = 0; i < data.num_results; i++) {
      switch (data.results[i].type) {
      case GTK_CAULDRON_TYPE_CHAR_P_P:
	PyTuple_SetItem(ret, ++j,PyString_FromString(data.results[i].d.ch_pp));
	break;
      case GTK_CAULDRON_TYPE_INT_P:
	PyTuple_SetItem(ret, ++j, PyInt_FromLong(data.results[i].d.int_p));
	break;
      case GTK_CAULDRON_TYPE_DOUBLE_P:
	PyTuple_SetItem(ret, ++j, PyFloat_FromDouble(data.results[i].d.dbl_p));
	break;
      case GTK_CAULDRON_TYPE_CALLBACK:
	Py_DECREF(data.results[i].d.tuple);
	break;
      default:
	g_assert_not_reached();
	Py_INCREF(Py_None);
	PyTuple_SetItem(ret, ++j, Py_None);
      }
    }
  }
  g_free(data.results);
  return ret;
}

%}

%native(gtk_dialog_cauldron) PyObject *gtk__dialog_cauldron(PyObject *self,
							    PyObject *args);
