/* Bezerk
 * Copyright (C) 1998 Tony Gale.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
 
#ifndef __CHANNEL_H__
#define __CHANNEL_H__

#include <glib.h>

extern _Connection;
extern _BezChannelWindow;

#define MODELEN 20

typedef enum {
 NOT_JOINING,
 JOINING,
 JOINED,
} Join_Status;

typedef struct _ChannelInfo {
  struct _BezChannelWindow *window;
  char *name;
  Join_Status status;
  char *topic;
  char mode[MODELEN+1];
  GSList *members;
  int selected_member;
  struct _Connection *connection;
} ChannelInfo;

typedef struct _UserInfo {
  char *nick;
  char *address;
/*   char mode[MODELEN+1]; */
  unsigned status;
} UserInfo;

/* NOTE, the value of these is important. They are used to decide the sort order of
 *  the nicks list */
#define USERBASIC 0
#define USERVOICE 1
#define USEROPER 2

#define ERR_BADNICK -5
#define ERR_NOTREG -4
#define ERR_NOTCONN -3
#define ERR_FATAL -2
#define ERR_GENERAL -1
#define MSG_NUMERIC 1
#define MSG_COMMAND 2
#define MSG_ERROR 3
#define MSG_REPLY 4
#define MSG_INFO 5

void channel_issue_message(struct _Connection *connection);
void channel_init();

#endif /* __CHANNEL_H__ */
