/**************************************************************************
 * LPRng IFHP Filter
 * Copyright 1994-1997 Patrick Powell, San Diego, CA <papowell@astart.com>
 *
 * Based on the CTI printer filters.
 *  See COPYRIGHT for details.
 *
 * pfu.c,v 3.2 1998/03/19 14:21:36 papowell Exp
 */

#include "portable.h"
#include "common.h"
#include "hp4.h"


/*
 *
 */

void update_pfu(pfu_filename,fontfilename)
char *pfu_filename, *fontfilename;
{
	FILE *pfu;

	log(4,"pfu file '%s' value '%s'",
			pfu_filename, fontfilename );
	if ((pfu=fopen(pfu_filename,"w")) == NULL) {
		logerr(1,"Cannot open/create pfu file : %s",pfu_filename);
	} else {
		fprintf(pfu,"%s",fontfilename?fontfilename:"");
		fclose(pfu);
		log(4,"pfu file '%s' updated successfully", pfu_filename );
	}
}

void delete_pfu(pfu_filename)
	char *pfu_filename;
{
	log(4,"delete_pfu: unlinking '%s'", pfu_filename );
	if( unlink(pfu_filename) == -1){
		logerr(2,"Cannot unlink pfu file '%', possibly already deleted",
			pfu_filename);
	}
}

