/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
*/

#include <stdio.h>
#include <syslog.h>

#include "mserver.h"

extern FILE *outsock;
FILE *tfile;

// This function will execute the kill script for a connection or if the
// connection is unknown (or a kill method is undefined)  it will execute the
// default kill method
void mserver_kill(void)
{
	if (getstat())
	{
		int i;
		int n;
				
		char cname[1024];
		char defkill[1024];
		char kill_action[1024];
		char temp[1024];
		
		config_getvalue ("defkill", defkill, 1024);

		config_getvalue ("confile", temp, 1024);
		tfile = fopen(temp, "r");

		if (tfile == NULL)
		{
			strncpy(kill_action, defkill, 1024);
		}
		else
		{
	
			fgets(temp, 1024, tfile);
			fclose (tfile);

			for (i = 0; i < strlen(temp) && (temp[i] != ':'); i++)
			{
				cname[i] = temp[i];
			}
			cname[i] = '\0';
			

			if (!auth_check(cname))
			{
				fprintf(outsock, "ERROR: You are not authorized to manipulate this connection!!\n");
				return;
			}
	
			snprintf(temp, 1024, "%s_kill", cname);
			config_getvalue(temp, kill_action, 1024);
			if (!strncmp(kill_action, "", 1024))
			{
				strncpy(kill_action, defkill, 1024);	
			}
		}

		if (!strncmp(kill_action, "internal", 1024))
		{	
			FILE *lock;

			char kill_sig[1024];
			char temp[1024];
			char pidtemp[1024];
			char lockfile[1024];

			int i;
			int pid;

			config_getvalue("killsig", kill_sig, 1024);
			config_getvalue("lockfile", lockfile, 1024);

			lock = fopen(lockfile, "r");

			if (lock == NULL)
			{
				syslog(LOG_WARNING, "Internal kill method did not correctly kill connection.");
				fprintf(outsock, "ERROR: Internal kill method did not correctly kill connection, please notify your sysadmin!\n");
				return;
			}

			fgets(temp, 1024, lock);
			fclose (lock);

			pid = atoi(temp);

			snprintf(kill_action, 1024, "kill %s %d", kill_sig, pid);

			util_system_wait (kill_action);

			if (!getstat())
			{
				fprintf(outsock, "SUCCESS\n");
			}
			else
			{
				syslog (LOG_WARNING, "Script (%s) did not correctly kill connection", kill_action);
				fprintf(outsock, "ERROR: Script did not correctly kill connection, please notify your sysadmin!\n");
			}
		}
		else
		{
			util_system_wait (kill_action);
			if (!getstat())
			{
				fprintf(outsock, "SUCCESS\n");
			}
			else
			{
				syslog (LOG_WARNING, "Script (%s) did not correctly kill connection", kill_action);
				fprintf(outsock, "ERROR: Script did not correctly kill connection, please notify your sysadmin!\n");
			}
		}
	}
	else
	{
		fprintf (outsock, "ERROR: There is no active connection!\n");	
	}
}
