/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
*/
#include <unistd.h>
#include <errno.h>
#include <time.h>
#include <netdb.h>
#include <netinet/in.h>
#include <stdio.h>
#include <syslog.h>

#include "mserver.h"

// Ripped from system man page
int util_system_wait (const char *command)
{
	extern char **environ;

	int pid, status;
	char my_command[1024];

	strncpy(my_command, command, 1024);

	if (command == 0)
	{
		return 1;
	}

    	pid = fork();

	if (pid == -1)
	{
        	return -1;
	}

	if (pid == 0)
	{
		char *myargv[4];
		myargv[0] = "sh";
		myargv[1] = "-c";
		myargv[2] = my_command;
		myargv[3] = 0;
		execve("/bin/sh", myargv, environ);
		exit(127);
	}

	do
	{
		if (waitpid(pid, &status, 0) == -1)
		{
			if (errno != EINTR)
			{
				return -1;
			}
		}
		else
		{
			return status;
		}
	}
	while(1);

	return 0;
}

// Taken from man system(3), and modified to execute in the background
int util_system (const char *command)
{
	extern char **environ;

	int pid, status;
	char my_command[1024];

	strncpy(my_command, command, 1024);

	if (command == 0)
	{
		return 1;
	}

    	pid = fork();

	if (pid == -1)
	{
        	return -1;
	}

	if (pid == 0)
	{
		char *myargv[4];
		myargv[0] = "sh";
		myargv[1] = "-c";
		myargv[2] = my_command;
		myargv[3] = 0;
		execve("/bin/sh", myargv, environ);
		exit(127);
	}

	return 0;
}

// Sleep doesn't work directly from the mserver_* subroutines for some reason, this really doesn't make too much sense, but this is my kludgy answer to that.
void util_sleep(int sec)
{
	int retval;
#ifdef DEBUG
	time_t cur_time;
	time(&cur_time);
	syslog (LOG_DEBUG, "Sleeping [%d]! (%d): ", sec, cur_time);
#endif
	retval = sleep (sec);

#ifdef DEBUG
	time(&cur_time);
	syslog (LOG_DEBUG, "Sleeping over [%d]! (%d)", retval, cur_time);
#endif
}
