/*
  $Id: fileop.c,v 1.1 1996/08/20 14:55:32 luik Exp $

  fileop.c - system call wrappers which catch EINTR error and retry.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "common.h"

#if defined(RCSID) && !defined(lint)
static char rcsid[] UNUSED__ = "$Id: fileop.c,v 1.1 1996/08/20 14:55:32 luik Exp $";
#endif /* defined(RCSID) && !defined(lint) */

#include <errno.h>
#include <stdio.h>
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <utime.h>
#include "fileop.h"


int Chmod(const char *path, mode_t mode)
{
    int result;

  again:
    result = chmod(path, mode);
    if (result == -1 && errno == EINTR)
	goto again;
    return result;
}

int Chown(const char *path, uid_t owner, gid_t group)
{
    int result;

  again:
    result = chown(path, owner, group);
    if (result == -1 && errno == EINTR)
	goto again;
    return result;
}

int Link(const char *path, const char *newpath)
{
    int result;

  again:
    result = link(path, newpath);
    if (result == -1 && errno == EINTR)
	goto again;
    return result;
}

int Lstat(const char *path, struct stat *buf)
{
    int result;

  again:
    result = lstat(path, buf);
    if (result == -1 && errno == EINTR)
	goto again;
    return result;
}

int Mkdir(const char *path, mode_t mode)
{
    int result;

  again:
    result = mkdir(path, mode);
    if (result == -1 && errno == EINTR)
	goto again;
    return result;
}

int Mknod(const char *path, mode_t mode, dev_t dev)
{
    int result;

  again:
    result = mknod(path, mode, dev);
    if (result == -1 && errno == EINTR)
	goto again;
    return result;
}

int Readlink(const char *path, void *buf, size_t bufsiz)
{
    int result;

  again:
    result = readlink(path, buf, bufsiz);
    if (result == -1 && errno == EINTR)
	goto again;
    return result;
}

int Rename(const char *path, const char *newpath)
{
    int result;

  again:
    result = rename(path, newpath);
    if (result == -1 && errno == EINTR)
	goto again;
    return result;
}

int Rmdir(const char *path)
{
    int result;

  again:
    result = rmdir(path);
    if (result == -1 && errno == EINTR)
	goto again;
    return result;
}

int Stat(const char *path, struct stat *buf)
{
    int result;

  again:
    result = stat(path, buf);
    if (result == -1 && errno == EINTR)
	goto again;
    return result;
}

int Symlink(const char *link, const char *path)
{
    int result;

  again:
    result = symlink(link, path);
    if (result == -1 && errno == EINTR)
	goto again;
    return result;
}

int Unlink(const char *path)
{
    int result;

  again:
    result = unlink(path);
    if (result == -1 && errno == EINTR)
	goto again;
    return result;
}

int Utime(const char *path, struct utimbuf *times)
{
    int result;

  again:
    result = utime(path, times);
    if (result == -1 && errno == EINTR)
	goto again;
    return result;
}

