# A person who can create things.

package Builder;
use strict;
use vars qw(@ISA);
use Person;
use Verb;
use VerbCall;
use Generics;
use UNIVERSAL qw(isa can);
@ISA=qw{Person};

sub new {
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my $this  = Person::new($class,@_);
	bless ($this, $class);
	return $this;
}

# Create a new object.
sub verb_create {
	my $this=shift;
	my $verbcall=shift;

	return Error->new("No way.") if ($this != ActiveUser::getactive);

	if (! $verbcall->direct_object) {
		return "Unable to create an object without a template object.";
	}

	unless ($verbcall->direct_object->fertile || isa($this,"Wizard")) {
		return "Cannot make a copy of that.";
	}

	my @aliases=split(',',$verbcall->word('indirect_object'));
	# Validate name/aliases
	if (! @aliases) {
		return Error->new("Must specify a name for the object.");
	}
	foreach (@aliases) {
		if ($verbcall->direct_object->is_invalid_name($_)) {
			return $verbcall->direct_object->is_invalid_name($_);
		}
	}
	my $new=$verbcall->direct_object->new(
		owner => $this,
		parent => $verbcall->direct_object,
	);
	
	$new->name(shift @aliases);
	$new->aliases([@aliases]);
	$this->contents_add($new);
	return "You now have ".$new->name." with object number #".$new->id.", parent ".$verbcall->direct_object->name." (#".$verbcall->direct_object->id.") and of type ".ref($new).".";
}

# Build rooms and exits.
sub verb_dig {
	my $this=shift;
	my $verbcall=shift;
	my $exit;

	return Error->new("No way.") if ($this != ActiveUser::getactive);

	my @ret;

	# TODO: only allow digging out of rooms you own, etc.
	
	my @roomnames=split(",",$verbcall->word('indirect_object'));
	my ($fromexits,$backexits)=split(/\|/,$verbcall->word('direct_object'),2);
	my @fromexits=split(",",$fromexits);
	my @backexits=split(",",$backexits);
	
	# Validate all exit names and aliases.
	foreach $exit (@fromexits,@backexits) {
		if (Exit->is_invalid_name($exit)) {
			return Exit->is_invalid_name($exit);
		}
	}
	
	# check for dup exits in a room with same name/aliases.
	foreach $exit (@fromexits) {
		if (grep($_ eq $exit, map($_ && ($_->name,@{$_->aliases}), @{$this->location->exits}))) {
			return Error->new("There's an exit in that direction ($exit) already");
		}
	}
	# Only need to check backexits if the room we are linking to already
	# exists.
	if ($verbcall->indirect_object) {
		foreach $exit (@backexits) {
			if (grep($_ eq $exit, map($_ && ($_->name,@{$_->aliases}), @{$verbcall->indirect_object->exits}))) {
				return Error->new("There's an exit in that direction ($exit) already");
			}	
		}
	}

	if (! @roomnames) {
		return Error->new("Must specify a name for the room.");
	}
	
	my $room;
	if (! $verbcall->indirect_object) {
		# Validate room name/aliases.
		foreach (@roomnames) {
			if (Room->is_invalid_name($_)) {
				return Room->is_invalid_name($_);
			}						
		}
	
		$room=Room->new(
			owner => $this,
			parent => Generics::findgeneric("Room"),
		);
		$room->name(shift @roomnames);
		$room->aliases([@roomnames]);
		push @ret,"Created room ".$room->name." with object number #".$room->id.".";
	}
	else {
		# Use existing room as destination.
		$room=$verbcall->indirect_object;
		if (! isa($room,"Room")) {
			return "Cannot dig an exit to a non-room object.";
		}
	}
	if (@fromexits) {
		my $fromexit=Exit->new(
			owner => $this,
			parent => Generics::findgeneric("Exit"),
		);
		$fromexit->name(shift @fromexits);
		$fromexit->aliases([@fromexits]);
		$fromexit->destination($room);
		$this->location->contents_add($fromexit);
		push @ret,"Created exit ".$fromexit->name." with object number #".$fromexit->id.", linking ".$this->location->name." (#".$this->location->id.") to ".$room->name." (#".$room->id.").";
	}
	if (@backexits) {
		my $backexit=Exit->new(
			owner => $this,
			parent => Generics::findgeneric("Exit"),
		);
		$backexit->name(shift @backexits);
		$backexit->aliases([@backexits]);
		$backexit->destination($this->location);
		$room->contents_add($backexit);
		push @ret,"Created exit ".$backexit->name." with object number #".$backexit->id.", linking ".$room->name." (#".$room->id.") to ".$this->location->name." (#".$this->location->id.").";
	}

	return @ret;
}

my $SHOW_MAX_DEPTH = 10;
my $SHOW_MAX_OBJECT_DEPTH = 0;

# Show a thingie and any sub-thingies.
# Takes a reference to the thingie (or the thingie itself if it's a scalar),
# a reference to an array of references already explored, and a depth.
sub show_thingie {
	my $thingie = shift;
	my $seen = shift || [];
	my $depth = shift || 0;
	my $indent = " " x ($depth * 2);
	my $already = "";

	# Don't go expanding stuff we've already seen.
	$already = "Already seen" if grep ($_ == $thingie, @$seen);
	# Keep track of stuff we've already seen.
	push @$seen, $thingie if ref($thingie);
	return "max depth reached" if $depth > $SHOW_MAX_DEPTH;

	if (ref($thingie)) {
		if (ref($thingie) eq "REF" || ref($thingie) eq "SCALAR") {
			# Dereference and try again.
			return $already if $already;
			return show_thingie($$thingie, $seen, $depth);

		} elsif (ref($thingie) eq "ARRAY") {
			return "Empty array" if @$thingie == ();
			return "Array with ". ($#$thingie + 1). " elements" if $already;
			my $ret;
			foreach (@$thingie) {
				$ret .= "\r\n  $indent". show_thingie($_, $seen, $depth + 1);
			}
			return $ret;

		} elsif (ref($thingie) eq "HASH") {
			my %hash = %{$thingie};
			my @keys = sort keys %hash;
			return "Empty hash" if $#keys < 0;
			return "Hash with $#keys elements" if $already;
			my $ret;
			foreach (@keys) {
				$ret .= "\r\n  $indent$_ = ". show_thingie($hash{$_}, $seen, $depth + 1);
			}
			return $ret;

		} elsif (ref($thingie) eq "CODE" || ref($thingie) eq "GLOB") {
			# How to be intelligent about these?
			return "$thingie";

		} else {
			# Reference to an object.
			# Get the object's hash (if it even supports that method).
			my %data = eval { local $SIG{__DIE__}; %{$thingie->all()} };
			if ($@) {
				# Don't know what to do with this. Just say what type it is and be done.
				return ref($thingie);

			} else {
				# Object's name, id number.
				my $ret = ref($thingie). " named \"". $thingie->name(). "\" (#".
					  $thingie->id(). ")";
				if ($depth <= $SHOW_MAX_OBJECT_DEPTH && !$already) {
					# Only expand objects if we're not very deep down.
					$ret .= ": ". show_thingie(\%data, $seen, $depth);
				}
				return $ret;
			}

		}

	} else {
		# It's just a regular scalar.
		$thingie =~ s/\n/\\n/g;
		$thingie =~ s/\r/\\r/g;
		$thingie =~ s/\t/\\t/g;
		return "\"$thingie\"";
	}
}

sub verb_show {
	my $this=shift;
	my $verbcall=shift;

	return Error->new("No way.") if ($this != ActiveUser::getactive);

	return show_thingie($verbcall->direct_object);
}

1
