/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997, 1998 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#include <time.h>
#if defined HAVE_GLIB || defined OSF1
#include <sys/time.h>
#endif
#include "main.h"

/*
 * Get Client's hostname.
 */
void import(char *filename, unsigned long filesize, unsigned long ci, int strnum)
{
#ifdef USE_POSIX_THREAD
   if (!ci) {
      OUTPUT++;
      (*statstr+strnum)->output = OUTPUT;
      (*statstr)->RECEIVING = 1;
   }
#endif

#ifdef USE_POSIX_THREAD
   if ((*(statstr+strnum))->lol) {
      if ((*statstr+strnum)->output == OUTPUT) fputc(slfp == stderr ? '\r': '\n', slfp);
      else if ((*statstr)->RECEIVING) fputc('\n', slfp);
      (*statstr)->RECEIVING = 0;
   }
#else
   if ((*(statstr+strnum))->lol) fputc('\r', slfp);
#endif
   fflush(slfp);

   if (ci > 0) fprintf(slfp, "+ %s (%ld bytes) %s from %s.\n", filename, ci, (*(statstr+strnum))->_SKIP_ > 1 ? "skipped": "received", (*(statstr+strnum))->REMOTEHOSTNAME);
   else if (!ci && (*(statstr+strnum))->lol) {
      fprintf(slfp, "\n** Receiving %s from %s failed.\n", filename, (*(statstr+strnum))->REMOTEHOSTNAME);
      if (pftplog) {
         FILE *fe=slfp;
         if ((fe = fopen(pftplog, "a")) != NULL) {
            fprintf(fe, "\n** Receiving %s from %s failed.\n", filename, (*(statstr+strnum))->REMOTEHOSTNAME);
            fclose(fe);
         }
      }
   }
   else {
      if (!(*(statstr+strnum))->_STANDARD_INPUT_ || *filename != '|') (*(statstr+strnum))->lol = 1;
      if (slfp == stderr) {
         if (filesize) fprintf(slfp, "* %s %s (%ld bytes) from %s", (*(statstr+strnum))->_SKIP_ > 1 ? "Skipping": "Receiving", filename, filesize, (*(statstr+strnum))->REMOTEHOSTNAME);
         else fprintf(slfp, "* %s %s from %s", (*(statstr+strnum))->_SKIP_ > 1 ? "Skipping": "Receiving", filename, (*(statstr+strnum))->REMOTEHOSTNAME);
      }
   }
   if (!ci && (*(statstr+strnum))->_STANDARD_INPUT_ && !filesize) fprintf(slfp, "\n");
   fflush(slfp);
}

void timing(int strnum, double *sum_bytes)
{
#ifdef USE_POSIX_THREAD
   double start;
#else
   static double start;
#endif
   double diff=0;
   double rate=0;
#ifdef OSF1
   struct {
      time_t tv_sec;
      int tv_usec;
   } tv;
#else
   struct {
      long tv_sec;
      long tv_usec;
   } tv;
#endif

   if (!*sum_bytes) {
      tv.tv_sec  = 1;
      tv.tv_usec = 1;
      gettimeofday((struct timeval *)&tv, (struct timezone *)NULL);
      start = (double) tv.tv_sec + ((double) tv.tv_usec / 1000000.0F);
#ifdef USE_POSIX_THREAD
      (*(statstr+strnum))->start = start;
#endif
   }
   else {
#ifdef USE_POSIX_THREAD
      start = (*(statstr+strnum))->start;
#endif
      gettimeofday((struct timeval *)&tv, (struct timezone *)NULL);
      diff  = (double) tv.tv_sec + ((double) tv.tv_usec / 1000000.0F);
      diff -= start;
      rate  = *sum_bytes / diff;
      rate /= (double)1024;
      if ((*statstr)->_PFTP_DAEMON_) {
         fprintf(slfp, " (%ldb %.2fs %.2fKb/s)\n", (unsigned long)*sum_bytes, diff, rate);
      }
      else {
         fprintf(slfp, " (%ldb %.2fs %.2fKb/s) closed.\n", (unsigned long)*sum_bytes, diff, rate);
      }
   }
}

char *time_string(void)
{
   time_t secs=1;
   char *str=NULL, *rstr=NULL;

   time(&secs);
   str = asctime(localtime(&secs))+4;
   for (rstr=str; *rstr && *rstr != '\n'; rstr++);
   *rstr = '\0';

   return str;
}


/* This function is executed by the client */
void check_bandwidth(double bytes)
{
   static double ct=0;
   double current_time=0;
   double ttw=0; /* time to wait */
#ifdef OSF1
   struct {
      time_t tv_sec;
      int tv_usec;
   } tv;
#else
   struct {
      long tv_sec;
      long tv_usec;
   } tv;
#endif

   gettimeofday((struct timeval *)&tv, (struct timezone *)NULL);
#ifdef HAVE_USLEEP
   /* in microseconds */
   current_time = ((double) tv.tv_sec * 1000000.0F) + (double) tv.tv_usec;
   if (ct) {
      ttw = ((bytes * 1000000.0F) / ((double)(*statstr)->_BANDWIDTH_)) - (current_time - ct);
      if (ttw > 0) usleep((unsigned long) ttw);
   }
   else ct = current_time;
#else
   /* in seconds */
   current_time = (double) tv.tv_sec + ((double) tv.tv_usec / 1000000.0F);
   if (ct) {
      ttw = (bytes / ((double)(*statstr)->_BANDWIDTH_)) - (current_time - ct);
      if (ttw > 0) sleep((unsigned int) ttw);
   }
   else ct = current_time;
#endif
}
