/*  cdrdao - write audio CD-Rs in disc-at-once mode
 *
 *  Copyright (C) 1998  Andreas Mueller <mueller@daneb.ping.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * $Log: ScsiIf.h,v $
 * Revision 1.2  1998/08/13 19:13:28  mueller
 * Added member function 'timout()' to set timeout of SCSI commands.
 *
 */

#ifndef __SCSIIF_H__
#define __SCSIIF_H__

class ScsiIfImpl;

class ScsiIf {
public:
  ScsiIf(const char *dev);
  ~ScsiIf();

  const char *vendor() const { return vendor_; }
  const char *product() const { return product_; }
  const char *revision() const { return revision_; }
  const char *revisionDate() const { return revisionDate_; }

  int init();
  
  int maxDataLen() const { return maxDataLen_; }

  int sendCmd(const unsigned char *cmd, int cmdLen,
	      const unsigned char *dataOut, int dataOutLen,
	      unsigned char *dataIn, int dataInLen);

  const unsigned char *getSense(int &len) const;
  
  // sets new timeout (seconds) and returns old timeout
  int timeout(int);

private:
  char vendor_[9];
  char product_[17];
  char revision_[5];
  char revisionDate_[9];

  int maxDataLen_;

  int inquiry();

  ScsiIfImpl *impl_;
};

#endif
