/*  cdrdao - write audio CD-Rs in disc-at-once mode
 *
 *  Copyright (C) 1998  Andreas Mueller <mueller@daneb.ping.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * $Log: util.h,v $
 * Revision 1.2  1998/09/06 12:00:26  mueller
 * Used 'message' function for messages.
 *
 */

#ifndef __UTIL_H__
#define __UTIL_H__

class Sample;

char *strdupCC(const char *s);
long fullRead(int fd, void *buf, long count);
int audioDataLength(const char *fname, unsigned long *length);
int audioFileType(const char *filename);
long waveHeaderLength(const char *filename);
void swapSamples(Sample *buf, unsigned long len);

void message(int level, const char *fmt, ...);

#endif

