"""
  PDA.Palm.Conduit.HotSync - Synchronization Manager
  $Id: HotSync.py,v 1.7 1998/09/01 11:02:50 rob Exp $

  Copyright 1998 Rob Tillotson <rob@io.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License, version 2,
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.

"""

import PDA.Palm
import PDA.Palm.Conduit
import PDA.Palm.Config

import time, string, re

class SyncManager(PDA.Palm.Conduit.Conduit):
    def __init__(self):
	PDA.Palm.Conduit.Conduit.__init__(self)

	self.name = 'SyncManager'
	self.version = '0.1'
	self.author = 'Rob Tillotson <rob@io.com>'
	self.url = ''
	self.description = 'Manages a series of other conduits.'

	self.dlp = None
	self.user_info = None

    def __call__(self, conduits=[], conduit_options={}):
	if not self.dlp:
	    raise RuntimeError, 'not connected'
	
	username = self.user_info['name']
	
	if not conduits and self.registry:
	    conduits = []
	    for c in filter(None, map(string.strip,
				      re.split('\s*,\s*',
					       self.registry.get('PalmPython',
								 'HotSync.conduits', '')))):
		exec 'import PDA.Palm.Conduit.%s' % c
		co = eval('PDA.Palm.Conduit.%s.Conduit' % c)
		if co not in conduits: conduits.append(co)
	    
	for conduit in conduits:
	    if type(conduit) == type(self.__class__):
		c = conduit()
	    else:
		c = conduit

	    if self.registry:
		c.configure(self.registry)
		
	    if conduit_options.has_key(c.name):
		c.configure(self.conduit_options[c.name])

	    c(self.dlp, username)

	self.log('done.')
	
    def connect(self, port=None, user=None, uid=None, match_default_user=0,
		prompt=1):
	"""Connect to a remote PalmPilot, loading configuration at the
	same time.  Use the supplied port or the default; if a user is
	supplied, will disconnect and throw an exception if it does not
	match the one on the device.
	"""
	r = PDA.Palm.Config.PalmRegistry()
	r.load()

	if not port:
	    port = r.port()
	    if not port: raise ValueError, 'no port specified'

	def_user = r.get('defaults', 'user', None)
	def_uid = r.get('defaults', 'uid', None)

	if prompt:
	    print "Waiting for connection on %s (press HotSync now)..." % port
	    
	dlp = PDA.Palm.DLP(port)

	self.log('Identifying user...')
	
	uinfo = dlp.getUserInfo()

	self.log('User Name: %s' % uinfo['name'])
	self.log('Last Sync: %s' % time.ctime(uinfo['lastSyncDate']))
	self.log('Last Successful Sync: %s' % time.ctime(uinfo['successfulSyncDate']))
	self.log('UID: %s  VID: %s  LastSyncPC: 0x%08x' % (uinfo['userID'],
							   uinfo['viewerID'],
							   uinfo['lastSyncPC']))

	if (user is not None and user != uinfo['name']) or \
	   (match_default_user and def_user is not None and def_user != uinfo['name']):
	    raise RuntimeError, 'user name mismatch (%s)' % uinfo['name']
	if (uid is not None and uid != uinfo['userID']) or \
	   (match_default_user and def_uid is not None and def_uid != uinfo['userID']):
	    raise RuntimeError, 'user id mismatch (%s)' % uinfo['userID']

	r.load_user(uinfo['name'], uinfo['userID'])

	self.dlp = dlp
	self.user_info = uinfo

	self.configure(r)

    def disconnect(self, successful=1, log='Sync completed.'):
	if self.dlp:
	    self.user_info['lastSyncPC'] = 0x00010000
	    self.user_info['lastSyncDate'] = time.time()
	    if successful:
		self.user_info['successfulSyncDate'] = self.user_info['lastSyncDate']
	    self.dlp.setUserInfo(self.user_info)
	    self.dlp.log(log)

	    self.dlp.close()
	    
	    self.dlp = None
	    self.uinfo = None
	    
	
