"""
  PDA.Palm.Conduit.Install - Installs databases from a spool directory
  $Id: Install.py,v 1.6 1998/09/13 05:12:12 rob Exp $

  Copyright 1998 Rob Tillotson <rob@io.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License, version 2,
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.


  This conduit performs program and database installation in much the
  same way as the Palm Desktop.  Files which are to be installed are
  copied (by a separate application, possibly with a GUI) into a spool
  directory.  When this conduit is called during HotSync, each file
  in the spool directory is installed and then deleted from the spool.
"""

import PDA.Palm
import PDA.Palm.Conduit
import PDA.Palm.Config
from PDA.Palm import Options

import os, string, sys, stat

install_dir = None

def copyfile(src, dst):
    """Copy data from src to dst"""
    # copied from shutil.py
    fsrc = None
    fdst = None
    try:
	fsrc = open(src, 'rb')
	fdst = open(dst, 'wb')
	while 1:
	    buf = fsrc.read(16*1024)
	    if not buf:
		break
	    fdst.write(buf)
    finally:
	if fdst:
	    fdst.close()
	if fsrc:
	    fsrc.close()

class Conduit(PDA.Palm.Conduit.Conduit):
    def __init__(self):
	PDA.Palm.Conduit.Conduit.__init__(self)

	self.name = 'Install'
	self.version = '0.1'
	self.author = 'Rob Tillotson <rob@io.com>'
	self.url = ''
	self.description = 'Installs databases on the PalmOS device.'

	#self.options = ['install_dir']
	self.define_options([
#	    Options.Filename('install_dir', None, 'Installation Directory')
	    ])

    def __call__(self, dlp, username):
	path = os.path.join(self.registry.user_directory(username),'install')
	    
	try:
	    os.stat(path)
	except os.error:
	    return None

	dblist = os.listdir(path)

	if not dblist:
	    self.log('nothing to install.')
	    return None
	
	for fn in dblist:
	    fp = os.path.join(path, fn)
	    try:
		f = PDA.Palm.openFile(fp)
		self.log('installing "%s" [%s]' % (f.info['name'], fn))
	    except:
		self.log('error installing %s' % fn)
		continue
		
	    try:
		f.install(dlp)
	    except:
		self.log('failed to install %s' % fn)
		continue

	    try:
		os.unlink(fp)
	    except:
		self.log('error removing %s' % fp)
	
	self.log('done.')
	
    def install(self, username, fname, move=0):
	"""Install the specified file into install_dir.  If move=true,
	moves the file, otherwise copies it.  Later this function may be
	expanded to deal with ZIPs, gzipped PDBs, etc."""
	path = os.path.join(self.registry.user_directory(username),'install')
	    
	os.stat(path)  # raise exception if install directory not found
	
	st = os.stat(fname)  # raises exception if file not found

	if not stat.S_ISREG(st[stat.ST_MODE]):
	    raise IOError, 'can only install a normal file'

	target = os.path.join(path, os.path.split(fname)[1])

	if move:
	    os.rename(fname, target)
	else:
	    copyfile(fname, target)
	

#########

def install_files(files, user=None):
    r, user, uid = PDA.Palm.Config.load(user)

    if not user:
	raise RuntimeError, 'no username specified'

    installer = Conduit()
    installer.configure(r)

    l = []
    for f in files:
	try:
	    installer.install(user, f)
	    l.append(0)
	except:
	    l.append(1)

    return l
