"""
  PDA.Palm.Tk.UserMgr - user management dialog
  $Id$

  Copyright 1998 Rob Tillotson <rob@io.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License, version 2,
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.


"""

__version__ = '$Id$'

from Tkinter import *
import tkSimpleDialog, tkMessageBox

import sys, os, string

class UserDialog(tkSimpleDialog.Dialog):
    def __init__(self, parent, registry, title='Users'):
	self.registry = registry
	self.user_list = []
	self.user = None
	tkSimpleDialog.Dialog.__init__(self, parent, title)
	
    def body(self, p):
	# left side: user list
	left = Frame(p)
	self.listbox = Listbox(left, selectmode=BROWSE)
	self.listbox.grid(row=0, column=0, sticky='news')
	self.listbox.bind('<Double-1>', self.doubleclick)
	self.vscroll = Scrollbar(left, orient='vertical',
				 command=self.listbox.yview)
	self.vscroll.grid(row=0, column=1, sticky='ns')
	self.hscroll = Scrollbar(left, orient='horizontal',
				 command=self.listbox.xview)
	self.hscroll.grid(row=1, column=0, sticky='ew')
	self.listbox.configure(xscrollcommand=self.hscroll.set,
			       yscrollcommand=self.vscroll.set)

	self.fill_listbox()

	right = Frame(p)
	w = Button(right, text="Add...", command=self.button_add)
	w.grid(row=0, column=0, sticky='ew')
	w = Button(right, text="Delete...", command=self.button_delete)
	w.grid(row=1, column=0, sticky='ew')
	w = Button(right, text="Rename...", command=self.button_rename)
	w.grid(row=2, column=0, sticky='ew')

	left.grid(column=0, row=0, sticky='news')
	right.grid(column=1, row=0, sticky='ne')
	p.columnconfigure(0, weight=1)

	return self.listbox

    def fill_listbox(self):
	l = self.listbox
	l.delete(0, END)

	self.user_list = self.registry.list_users()
	
	for x in self.user_list:
	    l.insert(END, x)

    def button_add(self):
	s = string.strip(tkSimpleDialog.askstring("Add User","User name to add",
						  parent=self))
	if s in self.user_list:
	    tkMessageBox.showerror("Add User",'User "%s" already exists.' % s,
				   parent=self)
	elif s:
	    self.registry.add_user(s)
	    self.fill_listbox()

    def button_delete(self):
	l = self.curselection()
	if l:
	    u = self.user_list[l[0]]
	    if tkMessageBox.askyesno("Delete User",
	      'This will remove all data for user "%s". Are you sure?' % u,
				     parent=self):
		self.registry.delete_user(u)
		self.fill_listbox()

    def button_rename(self):
	l = self.curselection()
	if l:
	    u = self.user_list[l[0]]
	    s = string.strip(tkSimpleDialog.askstring("Rename User",
						      'Rename "%s" to:' % u,
						      parent=self))
	    if s:
		self.registry.rename_user(u, s)
		self.fill_listbox()

    def doubleclick(self, event):
	self.ok()

    def apply(self):
	l = self.curselection()
	if l: self.user = self.user_list[l[0]]
	else: self.user = None
	
    def curselection(self):
	l = self.listbox.curselection()
	try: l = map(string.atoi, l)
	except ValueError: pass
	return l

    

#######
def askuser(parent, *a, **kw):
    return apply(UserDialog, (parent,)+a, kw).user

def test():
    import PDA.Palm.Config
    r = PDA.Palm.Config.PalmRegistry()
    r.load()
    return askuser(Tk(), r)
