# Module: MkInfo.tcl
# 22.03.97 tn


# draw an overview of all scsi and ide-devices 

proc MkInfo { w } {
global scsidevices
global idedevices
global scanscsi_number

	# how many columns of scsi-devices need to be displayed
	if { [expr $scanscsi_number % 8] == 0} {
		# its a factor of 8
		set columns [expr $scanscsi_number / 8]
	} else {
		set columns [expr ($scanscsi_number / 8) + 1]
	}

	# display at least 2 columns
	if { $columns < 2 } {
		set columns 2
	}

	label $w.1 -text " SCSI-Devices:" 
	tixForm $w.1 -fill x

	tixScrolledWindow $w.2 -scrollbar x
	tixForm $w.2 -left %0 -right %100 -top %4 -bottom %67 
	set f [$w.2 subwidget window]

	for { set k 0 } { $k < $columns } { incr k } {
		for { set i 0 } { $i < 8 } { incr i } {
			set j [expr $i + ($k * 8)]
			frame $f.$j -bd 1 -relief sunken

			set dify [expr $i*36]
			set dify2 [expr [expr $i+1]*36]
			set difx [expr $k*325]
			set difx2 [expr [expr $k+1]*325]
			tixForm $f.$j -left $difx -right $difx2 \
				-top $dify -b $dify2
		}
	}

	label $w.3 -text " IDE-Devices:"
	tixForm $w.3 -top %67 -fill x

	frame $w.4
	tixForm $w.4 -left %0 -right %100 -top %71 -bottom %100

	for { set i 0 } { $i < 4 } { incr i } {
		set j [expr $i + 4]
		frame $w.4.$i -bd 1 -relief sunken
		frame $w.4.$j -bd 1 -relief sunken
		set dify [expr $i*36]
		set dify2 [expr [expr $i+1]*36]
		tixForm $w.4.$i -left %0 -right %50 -top $dify -b $dify2
		tixForm $w.4.$j -left %50 -right %100 -top $dify -b $dify2
	}

	# fill the fields
	fillscsi $f
	fillide $w.4
}


# fill the grid with the scsi-devices

proc fillscsi { w } {
global scsidevices

	set i 0
	while { $scsidevices($i,0) != "x" } {

		set devtype $scsidevices($i,2)
		set removeable $scsidevices($i,3)
		set vendor $scsidevices($i,4)
		set model $scsidevices($i,5)
		set rev $scsidevices($i,6)
		set num $scsidevices($i,9)
		set idlist [split $scsidevices($i,10)]

		# pick the right icon
		if { $devtype == "0" } {
			if { $removeable == "0" } {
				set icon icon0
			} else {
				set icon icon01
			}
		} elseif { $devtype == "1" } {
			set icon icon1 
		} elseif { $devtype == "5" } {
			set icon icon5 
		} elseif { $devtype == "4" } {
			set icon icon4 
		} else {
			set icon iconx
		}

		label $w.$i.ico -image $icon -relief groove
		message $w.$i.msg -text "$vendor $num\n$model $rev" \
			-font "-*-fixed-bold-*-*--15-*-*-*-*-*-*-*" \
			-width 200
		message $w.$i.msg2 -text "Host: [lindex $idlist 0]\
\nChannel: [lindex $idlist 1]\nId: [lindex $idlist 2] Lun: [lindex $idlist 3]" \
			-font "-*-fixed-*-*-*--10-*-*-*-*-*-*-*" \
			-width 150
			
		#pack $w.$i.ico $w.$i.msg $w.$i.msg2 -side left 
		tixForm $w.$i.ico -left 0 -right 36
		tixForm $w.$i.msg -left 36 -right 235
		tixForm $w.$i.msg2 -left 235 -right 323

		incr i
	}
}


# fill the grid with the ide-devices

proc fillide { w } {
global idedevices

	set i 0
	while { $idedevices($i,0) != "x" } {

		set dev $idedevices($i,0)
		set devtype $idedevices($i,1)
		set model [string trim $idedevices($i,2)]
		set model "$model $idedevices($i,5)"
		set rev $idedevices($i,3)
		set serno $idedevices($i,4)

		if { $devtype == "0" || $devtype == "5" } {
			set icon icon5
		} elseif { $devtype == "1" } {
			set icon icon1
		} else {
			set icon icon0
		}

		label $w.$i.ico -image $icon -relief groove
		message $w.$i.msg -text "$model\n$rev            ($dev)" \
			-font "-*-fixed-bold-*-*--15-*-*-*-*-*-*-*" \
			-width 400 -anchor w 
		pack $w.$i.ico $w.$i.msg -side left 

		incr i 
	}
}

