;; $Id: dbgraph.dsl 1.5 1998/09/02 17:34:06 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ==================== GRAPHICS ====================

(define (graphic-file filename)
  (let ((ext (file-extension filename)))
    (if (or (not filename)
	    (not %graphic-default-extension%)
	    (member ext %graphic-extensions%))
	filename
	(string-append filename "." %graphic-default-extension%))))

(define ($graphic$ fileref 
		   #!optional (format #f) (alt "") (align #f))
  (let ((img-attr  (append
		    (list (list "SRC" (graphic-file fileref)))
		    (if align 
			(list (list "ALIGN" align)) 
			'())
		    (if alt
			(list (list "ALT" alt))
			(list (list "ALT" ""))))))
    (make empty-element gi: "IMG"
	  attributes: img-attr)))

(define ($include$ fileref)
  (let* (;; Yes, the next line really ends with "#", "\", "[newline]"
	 (newline #\
)
	 (file-content  (read-entity fileref))
	 (file-charlist (string->list file-content))
	 (file-length   (length file-charlist))
	 (file-headlist (list-head file-charlist (- file-length 1)))
	 (file-taillist (list-tail file-charlist (- file-length 1)))
	 ;; If the last char is a newline, drop it, otherwise print it...
	 (content (if (equal? newline (car file-taillist))
		      (list->string file-headlist)
		      file-content)))
    (make sequence
      (literal content))))

(define ($img$ #!optional (nd (current-node)) (alt ""))
  ;; This function now supports an extension to DocBook.  It's
  ;; either a clever trick or an ugly hack, depending on your
  ;; point of view, but it'll hold us until XLink is finalized
  ;; and we can extend DocBook the "right" way.
  ;;
  ;; If the entity passed to GRAPHIC has the FORMAT
  ;; "LINESPECIFIC", either because that's what's specified or
  ;; because it's the notation of the supplied ENTITYREF, then
  ;; the text of the entity is inserted literally (via Jade's
  ;; read-entity external procedure).
  ;;
  (let* ((fileref   (attribute-string (normalize "fileref") nd))
	 (entityref (attribute-string (normalize "entityref") nd))
	 (format    (if (attribute-string (normalize "format") nd)
			(attribute-string (normalize "format") nd)
			(if entityref
			    (entity-notation entityref)
			    #f)))
	 (align     (attribute-string (normalize "align") nd)))
    (if (or fileref entityref)
	(if (equal? format (normalize "linespecific"))
	    (if fileref 
		($include$ fileref)
		($include$ (entity-generated-system-id entityref)))
	    (if fileref
		($graphic$ fileref format alt align)
		($graphic$ (entity-generated-system-id entityref)
			   format alt align)))
	(empty-sosofo))))

(element graphic
  (make element gi: "P"
	($img$)))

(element inlinegraphic
  ($img$))
