<!-- Fragment document type declaration subset:
ArborText, Inc., 1988-1998, v.4001
<!DOCTYPE SET PUBLIC "-//Davenport//DTD DocBook V3.0//EN" [
<!ENTITY html SYSTEM "html.sgm">
<!ENTITY print SYSTEM "print.sgm">
<!ENTITY dlibhtm "<?html-filename lib-ver.htm>">
<!ENTITY dhtmhtm "<?html-filename html-ver.htm>">
<!ENTITY dcmnhtm "<?html-filename cmn-ver.htm>">
<!ENTITY doc-dblib SYSTEM "dblib.sgm">
<!ENTITY doc-dbparam SYSTEM "dbparam.sgm">
<!ENTITY html-version SYSTEM "n:\share\dsssl\docbook\html\version.dsl">
<!ENTITY common-version SYSTEM "n:\share\dsssl\docbook\common\version.sgm">
<!ENTITY lib-version SYSTEM "n:\share\dsssl\docbook\lib\version.sgm">
<!ENTITY dprhtm "<?html-filename index.html>">
<!ENTITY % dsssl-source "IGNORE">
<!ENTITY % dsssl-documentation "INCLUDE">
]>
-->
<?Pub Inc>
<?Pub CX set(book(title()bookinfo()chapter(title()>
<![ %dsssl-source; [;; $Id: version.dsl 1.27 1998/09/02 17:50:30 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.nwalsh.com/docbook/dsssl/
;;

;; If **ANY** change is made to this file, you _MUST_ alter the
;; following definition:

(define %stylesheet-version%
  "Modular DocBook Print Stylesheet version 1.13")

]]><![ %dsssl-documentation; [<para>This document summarizes the changes made
to the Modular DocBook Print Stylesheet:</para><variablelist>
<varlistentry><term>Version 1.11, 18 Aug 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Modified presentation of <sgmltag>ClassName</sgmltag>, <sgmltag>
Function</sgmltag>, <sgmltag>Citation</sgmltag>, and <sgmltag>Email</sgmltag>.
I think these are improvements.</para>
</listitem>
<listitem><para>Increased the <sgmltag>%line-spacing-factor%</sgmltag> so
that underscores wouldn't disappear in <application>Word</application>.</para>
</listitem>
<listitem><para>Removed the &ldquo;asis&rdquo; presentation of lines in <sgmltag>
RefSynopsisDiv</sgmltag>. That's just wrong; <sgmltag>RefSynopsisDiv</sgmltag>
is more like a <sgmltag>RefSect1</sgmltag> than anything else.</para>
</listitem>
<listitem><para>If the root element of your instance is a section element,
it'll now get a <literal>simple-page-sequence</literal>.</para>
</listitem>
<listitem><para><sgmltag>Article</sgmltag> titles will now be bigger than <sgmltag>
Sect1</sgmltag> titles.</para>
</listitem>
</itemizedlist><?Pub Caret1>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.10, 31 Jul 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Improved handling of <sgmltag class="attribute">override</sgmltag>/<sgmltag
class="attribute">mark</sgmltag> on <sgmltag>ItemizedList</sgmltag>s.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.09, 19 Jul 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Added <literal>%page-n-columns%</literal> parameter.</para>
</listitem>
<listitem><para>Fixed bug in graphic scaling.</para>
</listitem>
<listitem><para>Added &ldquo;<literal>tiny</literal>&rdquo; to the list of
recognized <literal>%visual-acuity%</literal>s.</para>
</listitem>
<listitem><para>Added &ldquo;<literal>USlandscape</literal>&rdquo; to the
list of recognized <literal>%paper-type%</literal>s.</para>
</listitem>
<listitem><para>Changed the default <literal>footer-margin</literal> from
3pi to 4pi.</para>
</listitem>
<listitem><para>Fixed bug in handling of multiple <sgmltag>Parameter</sgmltag>s
in a single <sgmltag>ParamDef</sgmltag>.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.08, 12 Jun 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Reworked <sgmltag>Article</sgmltag> titlepage support; added
parameters to select whether or not the titlepage should appear on a page
of its own or at the top of the document and to control the TOC.</para>
</listitem>
<listitem><para>Added support for formatting an <sgmltag>Index</sgmltag>.
Note: This <emphasis>does not</emphasis> include support for building an index
from <sgmltag>IndexTerm</sgmltag> tags; only for formatting an index coded
in SGML. And even that support's not great.</para>
</listitem>
<listitem><para>Made further attempts to handle <sgmltag>ListItem</sgmltag>s
that begin with block objects. This support is still not very successful.
</para>
</listitem>
<listitem><para>Added <literal>%article-page-number-restart%</literal>, <literal>
%generate-article-titlepage-on-separate-page%</literal>, and <literal>%generate-article-toc-on-titlepage%
</literal>.</para>
</listitem>
<listitem><para>Added hooks for printing out section-level &ldquo;titlepages&rdquo;.
</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.08beta8, 13 May 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Sweeping changes to make it possible to use these stylesheets
with both SGML and XML instances. All element names have been lowercased and
most strings are now <literal>(normalized "")</literal> before comparisons.
A number of variables are now functions because normalization can only occur
after a <literal>(current-node)</literal> exists.</para>
</listitem>
<listitem><para>Fixed start-indent in endnotes.</para>
</listitem>
<listitem><para><sgmltag>RefSect*</sgmltag>'s are never auto-numbered.</para>
</listitem>
<listitem><para>Documented <literal>%left-margin%</literal> and <literal>
%right-margin%</literal>. Used them.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.08beta7, 06 May 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Completely rewrote support for title pages. Title pages are
now supported on all division&mdash; and component-level elements. Title pages
are now supported on <sgmltag>Article</sgmltag>s, for example.</para>
</listitem>
<listitem><para>Fixed the TOC header to be the correct size in <sgmltag>Article
</sgmltag>s and <sgmltag>Part</sgmltag>s. Added support for RTF heading-level
to TOC header.</para>
</listitem>
<listitem><para>Added support for <sgmltag>PubDate</sgmltag> in <sgmltag>
BiblioEntry</sgmltag>s. If <sgmltag>PubDate</sgmltag> is present, it will
be used. Otherwise the <sgmltag>Year</sgmltag> in the <sgmltag>Copyright</sgmltag>
will be used.</para>
</listitem>
<listitem><para>Added support for the <sgmltag class="attribute">Scale</sgmltag>
attribute on <sgmltag>Graphic</sgmltag> and <sgmltag>InlineGraphic</sgmltag>.
</para>
</listitem>
<listitem><para>Added French localization.</para>
</listitem>
<listitem><para>I think I had the distinction between ANSI and K&amp;R style
function synopsis backwards. So I reversed it.</para>
</listitem>
<listitem><para>Added <literal>%funcsynopsis-decoration%</literal> to control
whether or not the elements in a <sgmltag>FuncSynopsis</sgmltag> should be
decorated (return types bold, parameters italic, etc.).</para>
</listitem>
<listitem><para>Removed <literal>%generate-titlepage%</literal>. Added <literal>
%generate-<replaceable>element</replaceable>-titlepage%</literal> for <sgmltag>
Set</sgmltag>, <sgmltag>Book</sgmltag>, <sgmltag>Part</sgmltag>, <sgmltag>
Reference</sgmltag>, and <sgmltag>Article</sgmltag>.</para>
</listitem>
<listitem><para>Replaced <sgmltag>%generate-toc%</sgmltag> with <literal>
%generate-<replaceable>element</replaceable>-toc%</literal></para>
</listitem>
<listitem><para>Replaced <sgmltag>%generate-lot-list%</sgmltag> with <literal>
%generate-<replaceable>element</replaceable>-lot-list%</literal></para>
</listitem>
<listitem><para>Added <literal>%titlepage-in-info-order%</literal>. If true,
then the elements on a generated titlepage occur in the order that they appear
in the corresponding <sgmltag>*Info</sgmltag> element. Otherwise, they appear
in a fixed (but configurable) order specified by the stylesheet.</para>
</listitem>
<listitem><para>Added <literal>%generate-part-toc-on-titlepage%</literal>
and <literal>%generate-reference-toc-on-titlepage%</literal>. If true then
the TOC for <sgmltag>Part</sgmltag>s and <sgmltag>Reference</sgmltag>s occur
on the title page for those elements, otherwise they appear on a page sequence
following the title page.</para>
</listitem>
<listitem><para>Added <literal>%generate-partinfo-on-titlepage%</literal>.
If true then the contents of the <sgmltag>PartIntro</sgmltag> element occurs
on the title page of the containing element (<sgmltag>Part</sgmltag> or <sgmltag>
Reference</sgmltag>).</para>
</listitem>
<listitem><para>Added <literal>%generate-heading-level%</literal>. If true,
the Jade extension which outputs the <application>Word</application> heading
level is used on the titles of divisions and components.</para>
</listitem>
<listitem><para>Added <literal>%cals-display-align%</literal> to control the
horizontal alignment of CALS tables on the page. The default is <literal>
'start</literal>.</para>
</listitem>
<listitem><para>Added html-filenames to all the REFENTRY comments in the <filename>
prparam.dsl</filename> file so that they can be propagated to the documentation.
I'm basically sacraficing any attempt at maintaining 8.3 filenames in the
documentation in favor of consistent filenames. Since switching to <literal>
all-element-number</literal>, the filenames for the <sgmltag>RefEntry</sgmltag>s
change completely with every release which is a bit of a maintainance headache.
</para>
</listitem>
<listitem><para>Fixed some table bugs. Missing cells should now be generated
within and at the end of rows.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.08beta6, 08 Apr 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Fixed bogus handling of <literal>space-after</literal> in
component titles.</para>
</listitem>
<listitem><para>It is now legal to have a <sgmltag>Graphic</sgmltag> element
with neither <sgmltag class="attribute">FileRef</sgmltag> nor <sgmltag class="attribute">
EntityRef</sgmltag>. If so, no output is generated.</para>
</listitem>
<listitem><para>Improved handling of list numbers. List numbers are now right-justified
and the width required is adjusted according to the number of elements in
the list.</para>
</listitem>
<listitem><para>Added a semicolon between subtitles if a book has multiple
subtitles.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.08beta5, 29 Mar 1998</term>
<listitem>
<para>Updated documentation.</para>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.08beta4, 29 Mar 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Changed public identifier for the ISO Latin 1 entity set so
that it matches the public identifier used by DocBook.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.08beta3, 26 Mar 1998</term>
<listitem>
<itemizedlist>
<listitem><para>More changes to support multiple languages simultaneously.
</para>
</listitem>
<listitem><para>Titles in <sgmltag>Bibliography</sgmltag>s are now properly
italic, rather than underlined.</para>
</listitem>
<listitem><para><sgmltag>RevHistory</sgmltag>s outside of metadata are no
longer suppressed.</para>
</listitem>
<listitem><para><sgmltag>BlockQuote</sgmltag> is properly indented even when
nested within other elements.</para>
</listitem>
<listitem><para>Tweaked list indents so that they work reasonably even for
enumerated lists using capital letters.</para>
</listitem>
<listitem><para>Reworked list support so that verbatim environments that occur
as the first element of a <sgmltag>ListItem</sgmltag> are formatted correctly.
Additional adjustments may be necessary for certain other elements if they
occur at the very beginning of a <sgmltag>ListItem</sgmltag>.</para>
</listitem>
<listitem><para>Fixed formatting of <sgmltag>FuncSynopsis</sgmltag>.</para>
</listitem>
<listitem><para>Added support for flexible border widths in tables. Reworked
table handling, removing an ugly kludge and improving support for inline and
block markup in table cells.</para>
</listitem>
<listitem><para>Tweaked spacing around verbatim environments in table cells.
Maybe similar tweaks are needed in other places? Is it time to revisit element
pre- and post-space at a global level?</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.08beta1, 26 Feb 1998</term>
<listitem>
<para>Widespread changes to support multiple languages simultaneously.</para>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.07, 22 Feb 1998</term>
<listitem>
<para>There are no changes specific to the print version in this release,
but <filename>dbtable.dsl</filename> in the common directory did change.</para>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.06, 19 Feb 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Fixed an insidious bug in the handling of titles. If you put
markup in titles (including things like <sgmltag>InlineGraphic</sgmltag>),
it was being ignored. Now it won't be. However, graphics in titles are suppressed
in running headers and footers. This is probably a feature since they completely
confuse Word. Then again... ;-)</para>
</listitem>
<listitem><para>Added <literal>%verbatim-default-width%</literal> to <filename>
dbparam.dsl</filename>. This replaces the fixed constant &ldquo;80&rdquo;
in <filename>dbverb.dsl</filename>.</para>
</listitem>
<listitem><para>Use of the <sgmltag class="attribute">WIDTH</sgmltag> attribute
in verbatim environments now takes precedence over the setting of <literal>
%verbatim-size-factor%</literal>.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.05, 15 Feb 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Moved common localization functions into the common directory.
</para>
</listitem>
<listitem><para>Fixed a problem with the bottom-margin/footer-margin that
caused page numbers to get chopped off.</para>
</listitem>
<listitem><para>Created a public identifier for the print stylesheet: <screen>
-//Norman Walsh//DOCUMENT DocBook Print Stylesheet//EN</screen>and added a <filename>
CATALOG</filename> file to the distribution.</para>
</listitem>
<listitem><para>Changed <filename>plain.dsl</filename> to refer to <filename>
docbook.dsl</filename> by public identifier.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.04, 08 Feb 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Fixed some bugs with admonitions. If a <sgmltag>Title</sgmltag>
is present on an admonition, it is used <emphasis>in place of</emphasis> the
automatically generated title. This was the intended behavior in the past,
but it was not implemented properly. Admonitions containing <sgmltag>SimPara
</sgmltag> now work.</para>
</listitem>
<listitem><para>Changed heuristic for finding <sgmltag>Title</sgmltag> and <sgmltag>
SubTitle</sgmltag> elements in <sgmltag>*Info</sgmltag> nodes. The stylesheet
now unwraps one level of <sgmltag>BookBiblio</sgmltag>, <sgmltag>BiblioMisc
</sgmltag>, or <sgmltag>BiblioSet</sgmltag>.</para>
</listitem>
<listitem><para><sgmltag>Editor</sgmltag>s are now supported in the book meta.
They appear on the title page verso.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.03, 06 Feb 1998</term>
<listitem>
<para>Fixed a small problem with <sgmltag>RevHistory</sgmltag> in <sgmltag>
BookBiblio</sgmltag>; the construction rule in <filename>dbinfo.dsl</filename>
was more specific than the rule in <filename>dbbibl.dsl</filename>, so the
wrong rule was firing. Fixed by making the construction rule in <filename>
dbinfo.dsl</filename> call a function defined in <filename>dbbibl.dsl</filename>.
</para>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.02, 03 Feb 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Changed default formatting of <sgmltag>Emphasis</sgmltag>
and <sgmltag>FirstTerm</sgmltag> to italic rather than bold.</para>
</listitem>
<listitem><para>Restored support for <literal>PGWIDE</literal> on <sgmltag>
Table</sgmltag>. It was lost accidentally.</para>
</listitem>
<listitem><para>Fixed a bug in the support for graphics if <literal>fileref
</literal> is unspecified.</para>
</listitem>
<listitem><para>Fixed bug that prevented processing instructions from being
allowed between table rows and entries.</para>
</listitem>
<listitem><para>Added <literal>use: para-style</literal> to the <literal>
simple-page-sequence</literal> construction rules so that environments that
inherit from them will have the correct <literal>%bf-size%</literal>, etc.
</para>
</listitem>
<listitem><para>Added <literal>%chapter-autolabel%</literal> to control enumeration
of <sgmltag>Chapter</sgmltag>s. Fixed a bug which caused the running header
of a <sgmltag>Chapter</sgmltag> with a <sgmltag>DocInfo</sgmltag> to be wrong.
</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>1.01, 07 Jan 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Made automatic TOC formatting obey <literal>%section-autolabel%
</literal>.</para>
</listitem>
<listitem><para>Made <sgmltag>LegalNotice</sgmltag> and <sgmltag>SideBar</sgmltag> <literal>
$semiformal-object$</literal>s.</para>
</listitem>
<listitem><para>Fixed handling of section <sgmltag>Title</sgmltag>s and <sgmltag>
SubTitle</sgmltag>s. The previous handling was <emphasis>very</emphasis> poor.
</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>1.0, 06 Jan 1998</term>
<listitem>
<para>Changes to the print stylesheet:<itemizedlist>
<listitem><para>Happy New Year!</para>
</listitem>
<listitem><para>Added some additional space below subtitles in components.
</para>
</listitem>
<listitem><para>Added fairly extensive documentation to  <filename>dbparam.dsl
</filename>.  See <filename>dbparam.sgm</filename>.</para>
</listitem>
<listitem><para>Added <literal>%refentry-keep%</literal> parameter.</para>
</listitem>
<listitem><para>Moved table footnote code and the <sgmltag>TABLE</sgmltag>
and <sgmltag>INFORMALTABLE</sgmltag> element rules to <filename>dbblock.dsl
</filename>. Like the changes to <filename>dbcommon.dsl</filename>, these
changes make it easier to reuse the CALS table handling code in <filename>
dbtable.dsl</filename> with other DTDs.</para>
</listitem>
<listitem><para>Added a new parameter, <literal>%table-element-list%</literal>
to specify what element names are CALS tables.</para>
</listitem>
<listitem><para>Fixed indentation in <sgmltag>Step</sgmltag>s in <sgmltag>
Procedure</sgmltag>s.</para>
</listitem>
<listitem><para>Fixed bug in <filename>dbverb.dsl</filename> where inheriting <literal>
first-line-start-indent</literal> sometimes caused the first line of a verbatim
environment to indent incorrectly.</para>
</listitem>
<listitem><para>Added <filename>common/dbtable.dsl</filename> to the DocBook
stylesheet.</para>
</listitem>
</itemizedlist></para>
</listitem>
</varlistentry>
<varlistentry><term>0.97, 29 Dec 1997</term>
<listitem>
<para>Changes to the print stylesheet:<itemizedlist>
<listitem><para>Added <literal>%block-start-indent%</literal> to add an extra
indent to block elements (tables, figures, lists, verbatim environments, etc.).
</para>
</listitem>
<listitem><para>Fixed small formatting bug in Bibliographies, where a comma
(<literal>%biblsep%</literal>) was output after the <literal>[abbrev]</literal>.
</para>
</listitem>
<listitem><para>Fixed size of endnote-title in <sgmltag>RefEntry</sgmltag>s.
</para>
</listitem>
<listitem><para>Handle <sgmltag>Title</sgmltag> on <sgmltag>Sidebar</sgmltag>.
</para>
</listitem>
<listitem><para>Set <sgmltag>Callout</sgmltag> numbers as white numerals in
a black circle. (If <literal>%callout-fancy-bug%</literal> is <literal>#t
</literal>.)</para>
</listitem>
<listitem><para>Handle <literal>IDREFS</literal> on <sgmltag>Callout</sgmltag>s.
</para>
</listitem>
<listitem><para>Fixed bug in formatting of running headers and footers. Now
properly obeys <literal>%chap-app-running-head-autolabel%</literal>.</para>
</listitem>
<listitem><para>Added <literal>%graphic-default-extension%</literal> to allow
stylesheets to select the appropriate format of graphics in print vs. HTML
stylesheets.</para>
</listitem>
<listitem><para>Changed <literal>%verbatim-font-size%</literal> parameter
to <literal>%verbatim-size-factor%</literal> so that it works reasonably well
with different <literal>%visual-acuity%</literal>s.</para>
</listitem>
<listitem><para>Added <literal>%simplelist-column-width%</literal> to set
width of columns in <sgmltag>SimpleList</sgmltag>s.</para>
</listitem>
<listitem><para>Improved handling of <sgmltag>RefMeta</sgmltag>.</para>
</listitem>
<listitem><para>Improved handling of sections so that <sgmltag>RefSect1</sgmltag>,
etc., could be <literal>$section$</literal>s instead of <literal>$block-container$
</literal>s.</para>
</listitem>
<listitem><para>Added <literal>%cals-frame-default%</literal> and changed
default for column and row rules to depend on the setting of the frame.</para>
</listitem>
<listitem><para>Added <filename>version.dsl</filename> to contain the change
log and the version.</para>
</listitem>
</itemizedlist></para>
</listitem>
</varlistentry>
<varlistentry><term>0.96, 04 Dec 1997</term>
<listitem>
<para>This release contains support for callouts, a few other enhancements,
a number of bug fixes, and a set of test documents.</para>
<para>Changes to <filename>dblib.dsl</filename>; the general function library:<itemizedlist>
<listitem><para>Fixed bug in <literal>has-ancestor-member?</literal>; it returned
precisely the opposite condition.</para>
</listitem>
<listitem><para>Added <literal>string->list</literal>, <literal>list->string
</literal>, and <literal>split</literal>.</para>
</listitem>
</itemizedlist></para>
<para>Changes to <filename>dbcommon.dsl</filename>; the common library:<itemizedlist>
<listitem><para>Added <literal>REFENTRY</literal> to <literal>major-component-element-list
</literal> to fix HTML navigation problems.</para>
</listitem>
<listitem><para>Added <literal>EQUATION</literal> to <literal>block-element-list
</literal> so that <literal>XREF</literal>s are possible.</para>
</listitem>
<listitem><para>Removed extraneous space in <literal>author-list-string</literal>.
</para>
</listitem>
<listitem><para>Added <literal>bibliodiv-autolabel</literal>, <literal>glossdiv-autolabel
</literal>, <literal>dedication-title-sosofo</literal>, and <literal>dedication-title
</literal>.</para>
</listitem>
</itemizedlist></para>
<para>Changes to the print stylesheet:<itemizedlist>
<listitem><para>Added more support for <literal>CALLOUT</literal>s. The support
is based on an old posting to the <ulink url="http://www.mulberrytech.com/">
dssslist</ulink> and is fairly fragile. See <filename>dbcallou.dsl</filename>.
</para>
</listitem>
<listitem><para>Added support for line numbers in linespecific displays. Like
the support for <literal>CALLOUT</literal>s, it's a bit fragile.</para>
</listitem>
<listitem><para>Added support for bibliography entries. The result probably
doesn't follow any particular, published bibliographic style, and may not
suit the needs of anyone, but at least the stylesheet <emphasis>tries</emphasis>
now. ;-)</para>
</listitem>
<listitem><para>Added a period to the end of titles in <literal>$runinhead$
</literal>s. (e.g., on <literal>FORMALPARA</literal>.)</para>
</listitem>
<listitem><para>Added, but left commented out, the ability to set <literal>
$runinhead$</literal>s in small caps.</para>
</listitem>
<listitem><para>Fixed bug that caused table footnotes to be enumerated incorrectly.
</para>
</listitem>
<listitem><para>Added endnotes to <literal>REFENTRY</literal>s; removed endnotes
from <literal>REFERENCES</literal> (so they aren't repeated).</para>
</listitem>
<listitem><para>Support for <literal>CALLOUT</literal>s to multiple <literal>
AREA</literal>s is broken. The stylesheet now outputs &ldquo;??&rdquo; to
indicate this.</para>
</listitem>
<listitem><para>Added support for <literal>TITLEABBREV</literal> in running
headers and footers.</para>
</listitem>
<listitem><para>Added <literal>%division-title-quadding%</literal>, <literal>
%division-subtitle-quadding%</literal>, <literal>%component-<replaceable>
title</replaceable>-quadding%</literal>, and <literal>%section-<replaceable>
title</replaceable>-quadding%</literal>.</para>
</listitem>
<listitem><para>Suppress <literal>ACRONYM</literal> and <literal>ABBREV</literal>
in the <emphasis>direct</emphasis> content model of <literal>GLOSSENTRY</literal>.
</para>
</listitem>
<listitem><para>Fixed bug, made <literal>GRAPHIC</literal> graphics &ldquo;display&rdquo;
rather than &ldquo;inline&rdquo;.</para>
</listitem>
<listitem><para>Added a <literal>%guilabel-font-family%</literal> so that
GUI type things can be printed in an alternate font. Fixed <literal>KEYCOMBO
</literal> so that a &ldquo;+&rdquo; is printed between its children.</para>
</listitem>
<listitem><para>Fixed a couple of typos in <filename>dbl1dege.dsl</filename>
and added support for <literal>$lot-title$</literal>s.</para>
</listitem>
<listitem><para>Improved <filename>dbl1ru.dsl</filename>.</para>
</listitem>
<listitem><para>Added <literal>DEDICATION</literal> and &ldquo;Pgs.&rdquo;
to <filename>dbl1usen.dsl</filename>.</para>
</listitem>
<listitem><para>Fixed numeration bug in <literal>ORDEREDLIST</literal>s.</para>
</listitem>
<listitem><para>Removed errant reference to <literal>%cals-cell-content-end-indent%
</literal> in <filename>dblists.dsl</filename>.</para>
</listitem>
<listitem><para>Improved support for <literal>INFORMALEQUATION</literal> and <literal>
INLINEEQUATION</literal>. Note that inline graphics don't seem to work in
the RTF backend.</para>
</listitem>
<listitem><para>Suppress <literal>MSGREL</literal>.</para>
</listitem>
<listitem><para>Made default setting of <literal>%verbatim-font-size%</literal>
dependent on <literal>%visual-acuity%</literal>.</para>
</listitem>
<listitem><para>Use of a monospaced font in inlines now respects <literal>
%verbatim-font-size%</literal>.</para>
</listitem>
</itemizedlist></para>
</listitem>
</varlistentry>
<varlistentry><term>0.95, 24 Nov 1997</term>
<listitem>
<para>The changes between 0.94 and 0.95 are quite extensive. Most dramatically,
support for tables has been rewritten from scratch; see <filename>dbtable.dsl
</filename> for more info.</para>
<para>Changes to <filename>dblib.dsl</filename>; the general function library:<itemizedlist>
<listitem><para>Added <literal>expand-children</literal> to replace elements
of a node list with the children of those elements. This is used, for example,
to make sure that a list of all the chapters of a book can be constructed
by expanding the <literal>PART</literal> elements in the node list returned
by <literal>(children book)</literal> with their children.</para>
</listitem>
<listitem><para>Moved <literal>book-start?</literal> to <filename>dbcommon.dsl
</filename>. It's specific to a particular class of DTDs (those with <literal>
BOOK</literal>s ;-).</para>
</listitem>
<listitem><para>Fixed a serious bug in case conversion; the letter &ldquo;A&rdquo;
couldn't be shifted to lower case.</para>
</listitem>
<listitem><para>Added <literal>constant-list</literal>, returns a list of
&ldquo;n&rdquo; copies of a specified value.</para>
</listitem>
<listitem><para>Added <literal>list-head</literal>, returns the first &ldquo;n&rdquo;
items from a list.</para>
</listitem>
<listitem><para>Added <literal>list-put</literal>, replaces a single value
in a list.</para>
</listitem>
<listitem><para>Added <literal>decrement-list-members</literal>. Maybe this
isn't so useful in general, but it decrements all the members of a list of
numbers by a specified value.</para>
</listitem>
<listitem><para>Added <literal>sgml-root-element</literal>. Returns the root
of the document. There's a better way to do this, right?</para>
</listitem>
<listitem><para>Added <literal>length-string-number-part</literal>. Given
a string of the form &ldquo;25pt&rdquo;, this function returns the &ldquo;25&rdquo;.
</para>
</listitem>
<listitem><para>Added <literal>length-string-unit-part</literal>. Given a
string of the form &ldquo;25pt&rdquo;, this function returns the &ldquo;pt&rdquo;.
</para>
</listitem>
</itemizedlist></para>
<para>Changes to <filename>dbcommon.dsl</filename>; the common library:<itemizedlist>
<listitem><para>Moved <literal>book-start?</literal> from <filename>dblib.dsl
</filename>.</para>
</listitem>
<listitem><para>Added <literal>first-chapter?</literal>. Returns true if the
node specified is the first <literal>CHAPTER</literal> of a <literal>BOOK
</literal>. (This includes the first chapter inside a <literal>PART</literal>.)
</para>
</listitem>
<listitem><para>Added <literal>major-component-element-list</literal> for
the revised &ldquo;fast forward&rdquo; code. See <literal>dbnavig.dsl</literal>.
</para>
</listitem>
<listitem><para>Added a whole bunch of functions for supporting CALS tables
that are shared between the HTML and print versions of the stylesheet.</para>
</listitem>
</itemizedlist></para>
<para>Changes to the print stylesheet:<itemizedlist>
<listitem><para>Completely rewrote table support.  (Note: the RCS version
number for <filename>dbtable.dsl</filename> is out-of-whack.)</para>
</listitem>
<listitem><para>Added support for table footnotes.</para>
</listitem>
<listitem><para>Added <literal>$inline-object$</literal>, <literal>$formal-object$
</literal>, and <literal>$semiformal-object$</literal>. Reorganized code for
informal and formal block obects to use these new functions. These functions
explicitly handle titles instead of relying on element construction rules
for the titles.</para>
</listitem>
<listitem><para>Rewrote support for alternating page headers/footers. They
actually work now. You can also specify headers and footers (and page number
formats) for automatically generated TOCs and LOTs.</para>
</listitem>
<listitem><para>Added support for a <literal>DEDICATION</literal> in the front
matter of a <literal>BOOK</literal>.</para>
</listitem>
<listitem><para>Added support for <literal>EQUATION</literal>s.</para>
</listitem>
<listitem><para>Made most links and <literal>XREF</literal>s into hot links
in RTF.</para>
</listitem>
<listitem><para>Added <literal>%verbatim-font-size%</literal>. If not <literal>
#f</literal>, it is used as the font size for verbatim text, regardless of
line length. When it is <literal>#f</literal>, the font size of each verbatim
chunk varies with the length of the longest line and the current start indent.
</para>
</listitem>
<listitem><para>Added support for callouts that use <literal>CO</literal>.
</para>
</listitem>
<listitem><para>Improved support for <literal>CMDSYNOPSIS</literal></para>
</listitem>
<listitem><para>Improved support for <literal>FUNCSYNOPSIS</literal></para>
</listitem>
<listitem><para>Added support for <literal>CLASS</literal> on <literal>SGMLTAG
</literal>.</para>
</listitem>
<listitem><para>Force <literal>LINEANNOTATION</literal>s to be in italic body
font, not the verbatim font.</para>
</listitem>
<listitem><para>Changed handling of bullets, numbers and callouts on lists
so that list items containing elements other than <literal>PARA</literal>
are handled correctly.</para>
</listitem>
</itemizedlist></para>
</listitem>
</varlistentry>
<varlistentry><term>0.94, 12 Nov 1997</term>
<listitem>
<para>The changes between 0.93 and 0.94 are so extensive that it would be
difficult to document them in detail. All of the files in this distribution
have been updated to have a version number of 0.94.</para>
<para>My primary goal in making these changes was to build a common library
of code for both the print and HTML stylesheets. To achieve this goal, a great
deal of code was moved around and reorganized.</para>
<para>What follows is a short list of the more dramatic changes:</para>
<itemizedlist>
<listitem><para>This style sheet now relies on the common <filename>dblib.dsl
</filename> and <filename>dbcommon.dsl</filename> libraries.</para>
</listitem>
<listitem><para>Changed formatting of division, component, and section titles
from &ldquo;passive&rdquo; to &ldquo;active&rdquo;. Rather than relying on
a rule for <literal>(<replaceable>element</replaceable> TITLE)</literal> to
process the titles, the rules that process the actually element wrappers now
process the titles. This allows optional titles to be formatted correctly.
</para>
</listitem>
<listitem><para>Added support for <literal>Subtitle</literal>s in many places.
</para>
</listitem>
<listitem><para>Added support for <literal>SimpleList</literal>s</para>
</listitem>
<listitem><para>Added support for <literal>GlossSee</literal> and <literal>
GlossSeeAlso</literal>.</para>
</listitem>
<listitem><para>Made most cross-references into &ldquo;links&rdquo; in the
RTF.</para>
</listitem>
<listitem><para>Christian Wallgren contributed support for horizontal alignment
in table cells.</para>
</listitem>
<listitem><para>Lots of other little bug fixes.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>0.93, 30 Sep 1997</term>
<listitem>
<itemizedlist>
<listitem><para>Added support for <literal>FOOTNOTE</literal>s as endnotes.
  (Thanks to Lassi A. Tuura for the idea.)</para>
</listitem>
<listitem><para>Replaced all the occurances of <literal>(process-children-trim)
</literal> with <literal>(process-children)</literal> in inlines (I suspect
this is needed elsewhere too).  Consider: "<literal>this &lt;emphasis>is &lt;/emphasis>a
test</literal>". (Thanks to Eduardo Gutentag for pointing out this error.)
</para>
</listitem>
<listitem><para>Added optional sosofo to <literal>$ss-seq$</literal> (for
use in footnotes).  Maybe the other character-sequence functions ought to
be done this way too?</para>
</listitem>
<listitem><para><literal>LINK</literal> text should now be a "clickable" cross
reference in  Word. (Thanks again to Lassi A. Tuura.)</para>
</listitem>
<listitem><para>Fixed <literal>line-fields</literal> in lists so that the
indent is done correctly. (I've thought for a while that this was broken and
finally tracked it down.)</para>
</listitem>
<listitem><para>Added <filename>TODO</filename> to the distribution.  Feel
free to contribute to it ;-).</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>In 0.92</term>
<listitem>
<itemizedlist>
<listitem><para>Fixed bug where <literal>TABLE</literal>s, <literal>FIGURE
</literal>s, and  <literal>EXAMPLES</literal>s that occured inside <literal>
PARA</literal>s didn't get properly added to the automatically generated TOC.
</para>
</listitem>
<listitem><para>Added <literal>%generate-titlepage%</literal> test in <literal>
BOOK</literal> where it was accidentally left out.</para>
</listitem>
<listitem><para>Changed <literal>FILENAME</literal> inline to be monospace
font instead of regular text font.</para>
</listitem>
<listitem><para>Added <literal>style-specification</literal> and <literal>
style-specification-body</literal> tags to <filename>docbook.dsl</filename>, <filename>
plain.dsl</filename>, <filename>notoc.dsl</filename>, and <filename>dbl1*.dsl
</filename> so that <literal>OMITTAG YES</literal> is no longer required in
the SGML declaration used by Jade.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>In 0.91</term>
<listitem>
<itemizedlist>
<listitem><para>Completely rewrote the automatic TOC code. Now supports lists
of other formal objects, see <literal>%generate-lot-list%</literal>.</para>
</listitem>
<listitem><para>Added <literal>book-start?</literal> to restart page numbering
on the first component or division.</para>
</listitem>
<listitem><para>Reorganized the code so that the title page and book TOC/LOT
code isn't duplicated in <literal>BOOK</literal> and <literal>BOOKINFO</literal>.
See the <literal>BOOK</literal> element.</para>
</listitem>
<listitem><para>Made <literal>CITETITLE</literal> italic.</para>
</listitem>
<listitem><para>Added <literal>BIBLIOGRAPHY</literal>, <literal>GLOSSARY</literal>,
and <literal>INDEX</literal> to <literal>gentext-element-name</literal> and <literal>
$lot-title$</literal> in <filename>dbl1usen.dsl</filename>. These are used
to produce the titles of the respective elements.</para>
</listitem>
<listitem><para>Added an optional <literal>force-label?</literal> parameter
to the automatic labeling functions. This allows the TOC generating code to
produce labels even if automatic labels are suppressed in the document.</para>
</listitem>
<listitem><para>Added <literal>component-child-number</literal> so that block-level
elements would be numbered correctly. (Simple <literal>child-number</literal>
doesn't work because it restarts at each wrapper and block numbering restarts
only at each component-level wrapper.)</para>
</listitem>
<listitem><para>Fixed indenting of verbatim environments.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>In 0.90</term>
<listitem>
<itemizedlist>
<listitem><para>Added <literal>%gentext-and%</literal> to localizations to
replace literal &ldquo;and&rdquo; in <filename>dbbibl.dsl</filename>.</para>
</listitem>
<listitem><para>Use <literal>(element-label)</literal> to calculate labels
in <filename>dbblock.dsl</filename>, <filename>dbcompon.dsl</filename>, and <filename>
dbsect.dsl</filename>.</para>
</listitem>
<listitem><para>Simplified title page generation in <filename>dbdivis.dsl
</filename>.</para>
</listitem>
<listitem><para>Updated localization layers.</para>
</listitem>
<listitem><para>Made several improvements to the code in <filename>dblink.dsl
</filename>: added xref sosofo mode to allow other sections of the style sheet
to to use the <literal>element-title</literal> functions without italics,
added <literal>-sosofo</literal> functions for use in sosofo contexts. Etc.
</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>In 0.89</term>
<listitem>
<itemizedlist>
<listitem><para> <emphasis>Totally</emphasis> changed how <sgmltag>XREF</sgmltag>
works. See below. NOTE: international versions of dbl1* are now <emphasis>
broken</emphasis>.</para>
</listitem>
<listitem><para> Changed numbering of <sgmltag>STEP</sgmltag>s within <sgmltag>
PROCEDURE</sgmltag>s so that they work for more than two levels. (suggested
by James Bostock)</para>
</listitem>
<listitem><para> Support <sgmltag>XREF</sgmltag> to <sgmltag>STEP</sgmltag>s
in a <sgmltag>PROCEDURE</sgmltag>.</para>
</listitem>
<listitem><para> Added <function>$hierarch-number-format$</function> to control
number format (1, a, I, etc.) in nested steps.</para>
</listitem>
<listitem><para> Added <sgmltag>ARTICLE</sgmltag>s to the auto TOC.</para>
</listitem>
<listitem><para> Tinkered with the appearance of <sgmltag>ABSTRACT</sgmltag>s
</para>
</listitem>
<listitem><para> Made printing of <sgmltag>BOOK</sgmltag>s of <sgmltag>ARTICLE
</sgmltag>s possible. May not be pretty yet.</para>
</listitem>
<listitem><para> Added <filename>dblib.dsl</filename>, a library of functions
that my have more general utility.</para>
</listitem>
<listitem><para> Added <function>%body-start-indent%</function> to verbatim
environments.</para>
</listitem>
<listitem><para> Added declaration for <function>(debug)</function> to <filename>
docbook.dsl</filename></para>
</listitem>
<listitem><para> Added "<filename>test</filename>" directory to the distribution,
for test files. Please supply your favorites.</para>
</listitem>
</itemizedlist>
<para>This description of linking is adapted from comments in dblink.dsl</para>
<sidebar>
<title>From the DocBook V3.0 Reference entry for element XREF:</title>
<para>Description</para>
<para> Cross reference link to another part of the document. XRef is empty,
and has common, Linkend, and Endterm attributes.</para>
<para> Processing Expectations</para>
<para> XRef must have a Linkend, but the Endterm is optional. If it is used,
the content of the element it points to is displayed as the text of the cross
reference; if it is absent, the XRefLabel of the cross-referenced object is
displayed.</para>
</sidebar>
<para>If neither the ENDTERM nor the XREFLABEL is present, then the cross
reference text is taken from the (gentext-xref-strings) function in the localization
file, like this</para>
<para>A cross reference to an element, the target, begins with the text returned
by (gentext-xref-strings (gi target)). Within that text, the following substitutions
are made:</para>
<variablelist>
<varlistentry><term><literal>%p</literal></term>
<listitem>
<para>is replaced by the number of the page on which target occurs</para>
</listitem>
</varlistentry>
<varlistentry><term><literal>%</literal><replaceable>[x]</replaceable><literal>
g</literal></term>
<listitem>
<para>is replaced by the (gentext-element-name)</para>
</listitem>
</varlistentry>
<varlistentry><term><literal>%</literal><replaceable>[x]</replaceable><literal>
n</literal></term>
<listitem>
<para>is replaced by the label</para>
</listitem>
</varlistentry>
<varlistentry><term><literal>%</literal><replaceable>[x]</replaceable><literal>
t</literal></term>
<listitem>
<para>is replaced by the title</para>
</listitem>
</varlistentry>
</variablelist>
<para>Where "x" is either absent, in which case the target is used, or one
of the following:</para>
<variablelist>
<varlistentry><term><literal>b</literal></term>
<listitem>
<para>the ancestral book</para>
</listitem>
</varlistentry>
<varlistentry><term><literal>c</literal></term>
<listitem>
<para>the ancestral component</para>
</listitem>
</varlistentry>
<varlistentry><term><literal>d</literal></term>
<listitem>
<para>the ancestral division</para>
</listitem>
</varlistentry>
<varlistentry><term><literal>k</literal></term>
<listitem>
<para>the ancestral block</para>
</listitem>
</varlistentry>
<varlistentry><term><literal>s</literal></term>
<listitem>
<para>the ancestral section</para>
</listitem>
</varlistentry>
</variablelist>
<para>So, <literal>%cn</literal> is replaced by the label (number) of the
chapter that contains target. <literal>%st</literal> is replaced by the title
of the section that contains target, <literal>%g</literal> is replaced by
the (gentext-element-name) of the target, etc.</para>
<para>What elements constitute a book, component, division, block, and section
are defined by the lists *-element-list.</para>
<para>As if this wasn't confusing enough, _one_ additional level of indirection
is available. If one of the special symbols, #b, #c, #d, #k, or #s occurs
in the (gentext-xref-strings) text, then it will be replaced by the appropriate
(gentext-xref-strings-indirect) text depending on whether or not the target
and the reference occur in the same element.</para>
<para>Here's a concrete example:</para>
<para>Given  <screen>(define (gentext-xref-strings-indirect key)
(case key
(("k") '(" in %kg %kn" ""))
(("s") '(" in %cg %cn" " in this %cg"))))</screen>  and  <screen>(define (gentext-xref-strings giname)
(case giname
(("STEP") "step %n#k")
(("SECT1") "the section called %t#s")))</screen></para>
<para>A cross reference to a step in the same procedure as the reference will
use the string "<literal>step %n</literal>" as the gentext-xref-strings text.
A cross reference to a step in another procedure will use the string "<literal>
step %n in %kg %kn</literal>".</para>
<para>So, a reference from step 5 to step 3 in the same procedure will appear
as "step 3". A reference to step 6 in the third procedure in the fourth chapter
from some other place will appear as "step 6 in procedure 4.3".</para>
<para>Likewise a reference to another section in the current chapter will
appear like this "the section called target-title in this Chapter", and a
reference to a section in an appendix will appear like this "the section called
target-title in Appendix B".</para>
</listitem>
</varlistentry>
<varlistentry><term>In 0.88</term>
<listitem>
<itemizedlist>
<listitem><para> Removed the forced page break after the automatically generated
TOC</para>
</listitem>
<listitem><para> Added gentext-xref-element-name, the string that should be
used in printed cross references to an element.</para>
</listitem>
<listitem><para> Put %writingmode% back into dbparam.dsl so that the page
header/footer code can test for writing mode</para>
</listitem>
<listitem><para> Change default font size for verbatim displays so that 80
character  lines will fit by default</para>
</listitem>
<listitem><para> Added $side-header$, $center-header$, $side-footer$, and
$center-footer$. These functions allow a stylesheet to easily override the
use and  placement of headers and footers on the left, center, and right side
 of pages.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>In 0.87</term>
<listitem>
<itemizedlist>
<listitem><para> Changed method for configuring generated text; this changed
a bunch of definitions in the localization module and rippled through many
other files. (See below)</para>
</listitem>
<listitem><para> Localization is now done by pointing to the complete style
sheet containing localization, rather than by entity reference. This allows
the localization layer to include parameter entities (e.g., ISO entity sets).
</para>
</listitem>
<listitem><para> Use gentext for labels and label seperators in dbsect.dsl
</para>
</listitem>
<listitem><para> Added localization for start and end quotation marks</para>
</listitem>
<listitem><para> Fixed bug where admonitions with titles got formatted oddly
</para>
</listitem>
<listitem><para> Support APPENDIXes, GLOSSARYs, BIBLIOGRAPHYs, and INDEXes
occuring after PARTs in the autotoc</para>
</listitem>
<listitem><para> Changed a whole slew of inlines from (empty-sosofo) to ($charseq$)
</para>
</listitem>
<listitem><para> Added limited support for REVHISTORY</para>
</listitem>
<listitem><para> Consolidated table-caption-mode (in dbtable.dsl) and figure-caption-mode
into a single block-caption mode.</para>
</listitem>
<listitem><para> Support TITLE on EXAMPLE with block-caption-mode</para>
</listitem>
<listitem><para> Added %two-side% to configure running heads appropriately
(James Bostock)</para>
</listitem>
<listitem><para> Redefined several page-attributes (is attributes the right
word?) as (declare-initial-value) instad of using a (define)d variable everywhere.
This method was suggested by Paul Prescod on dssslist. In the future, more
attributes may be initialized this way; I did the easy ones this time.</para>
</listitem>
<listitem><para> Made ARTHEADER (process-children) instead of (empty-sosofo)
so that (ARTHEADER TITLE) fires. (Ulrich Drepper)</para>
</listitem>
<listitem><para> Pass FORMAT notation on graphics to the back end (for TeX)
(Ulrich Drepper)</para>
</listitem>
<listitem><para> Added support for GLOSSTERM as an inline</para>
</listitem>
<listitem><para> Tried to make INLINEGRAPHIC actually inline. Doesn't work
in RTF, but looks like it should, IMHO ;-)</para>
</listitem>
<listitem><para> Added support for XREF. Works for many TITLE'd components.
Supports both lableled (enumerated) sections and unlabeled. Some generated
text in dblink.dsl will have to be changed for non-English styles using unlabled
sections, but it's not simply a text question, it's a grammar question, so
I haven't tried to extract it out into the localization files. In the non-labeled
style, XREFs produce text like this "the section called [section title] in
Chapter [#]".</para>
</listitem>
<listitem><para> Added support for NUMERATION on ORDEREDLIST</para>
</listitem>
<listitem><para> Incorporated patch for VARLISTENTRY LISTITEM spacing: in
VARLISTENTRY  there was a problem with the way indentation was calculated
when a  VARLISTENTRY included an ITEMIZEDLIST. (Ulrich Drepper)</para>
</listitem>
<listitem><para> Procedure STEPs are no longer bold.</para>
</listitem>
<listitem><para> Modularized title code in dbtitle.dsl, use that code to generate
REFNAMEs so they appear the same as other titles (James Bostock)</para>
</listitem>
<listitem><para> Made SYNOPSIS a $verbatim-display$, made CMDSYNOPSIS a $paragraph$
(for proper vertical spacing).</para>
</listitem>
<listitem><para> Added support ARG in CMDSYNOPSIS (James Bostock)</para>
</listitem>
<listitem><para> Made FUNCSYNOPSIS a $verbatim-display$. This is an inadequate
solution, but it looks a little better than (process-children)</para>
</listitem>
<listitem><para> Replaced %gentext-authored-by% and %gentext-copyright-by%
with  %gentext-by%</para>
</listitem>
<listitem><para> Fixed bug: use of the word "Page" in the page number was
erroneously dependent on the use of %page-number-restarts%</para>
</listitem>
</itemizedlist>
<para> Notes on generated text:</para>
<para> Using a different definition for each piece of generated text was rapidly
becoming unmanagable. Most generated text is keyed of the type of element
(the word "Chapter" for a CHAPTER, etc.) so one function takes the name of
the element and returns the appropriate string. Other functions were added
to configure things like the characters that occur in and between labels.
In a few cases I've stretched the rules a bit (gentext abuse, I suppose, to
missquote a colleage ;-), but the principle is to use a function keyed off
the element name (or pseudo-element name). There's some potential for this
to get unmanagable as well. Suggestions welcome.</para>
</listitem>
</varlistentry>
<varlistentry><term>In 0.86</term>
<listitem>
<itemizedlist>
<listitem><para> Added support for QUOTE</para>
</listitem>
<listitem><para> Added support for CORPAUTHOR</para>
</listitem>
<listitem><para> Added %refentry-name-font-family%, the font family used for
the refentry name. It's mono by default if %refentry-function% is true, body
 otherwise</para>
</listitem>
<listitem><para> Added %refentry-new-page%; controls whether or not each RefEntry
begins on a new page</para>
</listitem>
<listitem><para> Changed auto toc code to put References and RefEntrys in
the TOC (it seems to work, but I'm not real confident about it)</para>
</listitem>
<listitem><para> Made BOOK TITLE test for BOOKINFO and %generate-titlepage%
(in other words, BOOK TITLE will generate a title page if there is no BOOKINFO)
</para>
</listitem>
<listitem><para> Hacked REFERENCE TITLE to make it a $divtitlepage$ if each
RefEntry starts on its own page anyway</para>
</listitem>
<listitem><para> Changed the quadding on $divtitlepage$ to 'center</para>
</listitem>
<listitem><para> Made the "--" between RefName and RefPurpose a proper em-dash
</para>
</listitem>
<listitem><para> Added %default-simplesect-level% and adjusted the definition
of SECTLEVEL in dbsect.dsl so that simplesects would always appear at the
level below the section level that contains them. %default-simplesect-level%
is used for SimpleSects contained directly within chapter-level elements</para>
</listitem>
<listitem><para> Added ldquo, rdquo, em-space, and en-space to the list of
dingbats (would it be better to include the appropriate ISO entity set instead?)
</para>
</listitem>
<listitem><para> Fixed bug: if %gentext-chap-or-app% is "", don't output a
space after it</para>
</listitem>
<listitem><para> Added %gentext-title-label-sep%, the character sequence inserted
between generated title numbers and the actual title, ". " by default</para>
</listitem>
<listitem><para> Added %section-autolabel%, if true, all unlabeled sections
behave as though they are labeled AUTO. (Except that SimpleSects are never
auto numbered.)</para>
</listitem>
<listitem><para> Fixed bug in $sectitle$, it was looking for the RENDERAS
and LABEL  attributes on the TITLE, not the containing section element.</para>
</listitem>
<listitem><para> Added a comment to dbtable.dsl, you can make rules in tables
by setting %cals-rule-default% to 1.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>In 0.85</term>
<listitem>
<itemizedlist>
<listitem><para> Added %chap-app-running-heads% to control use of running
heads in components. </para>
</listitem>
<listitem><para> Added %chap-app-running-head-autolabel% to control LABEL
attributes. If chap-app-running-head-autolabel is #t, Chapters and Appendixes
 that do not specify a LABEL attribute will be treated as if they  specified
LABEL=AUTO. If this is #f, Chapters and Appendixes without a LABEL attribute
will have only the title in the running head. Based on a suggestion from James
Bostock.</para>
</listitem>
<listitem><para> Fixed bug in dbcompon.dsl where "Chapter" was compared to
"CHAPTER" and consequently all chapters and appendixes were labelled with
"A", "B", etc.</para>
</listitem>
<listitem><para> Added BUGS to the distribution. (yeah, yeah, har har har.
;-)</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>In 0.84</term>
<listitem>
<itemizedlist>
<listitem><para> Modularity achieved with entities rather than separate style
specifications.</para>
</listitem>
<listitem><para> Combined dbfeatr.dsl, dbmswin.dsl, and dbparam.dsl---customization
is easy with a style-specification so keeping these units separate no longer
seems necessary. See plain.dsl and notoc.dsl in the distribution.</para>
</listitem>
<listitem><para> Added support for SegmentedList (not for any particular reason;
after fiddling with modularity for several days, I just wanted to make something
new work ;-) </para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>In 0.83</term>
<listitem>
<itemizedlist>
<listitem><para> Use multiple style-specifications for customization. They <emphasis>
should</emphasis> otherwise be the same.</para>
</listitem>
<listitem><para> Fixed bug in dbcompon.dsl, HEAD-CHAP-APP-LABEL didn't handle
 l10n correctly. Thanks to Alexander Taranov.</para>
</listitem>
<listitem><para> Reordered use declarations in dbmain.dsl; I think this fixes
the problems of which element declarations are being used, but I'm far from
certain. (I'm working on a little tool that will report these problems.)</para>
</listitem>
<listitem><para> Some of the files still have internal version numbers that
are  misleading.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>In 0.82</term>
<listitem>
<itemizedlist>
<listitem><para> Added dbl10n.dsl, localization of generated text and placement
of TOC. Current version only contains us-english; send me your updates.</para>
</listitem>
<listitem><para> Changed functions that create bullets and other marks to
use Unicode  names, making them font/platform independent</para>
</listitem>
<listitem><para> Some of the files have internal version numbers of 0.81...that's
an  error and I expect to get them back in sync for the next version...</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>In 0.81</term>
<listitem>
<para> Includes several changes supplied by James Bostock (%default-quadding%,
%paper-type%, %page-number-restarts%, ande support for PROMPT).</para>
</listitem>
</varlistentry>
<varlistentry><term>In 0.80</term>
<listitem>
<para> A modular version of  <ulink url="http://sunsite.unc.edu/pub/sun-info/standards/dsssl/stylesheets/docbook/db070.dsl">
db070.dsl</ulink>. No other changes are intentional.</para>
</listitem>
</varlistentry>
</variablelist><para>This summary is fairly terse. If you have more detailed
questions, ask the maintainer ;-).</para>]]>
<?Pub *0000055428>
