define(WML_MAINTAINER_MODE,[dnl
AC_MSG_CHECKING([whether to enable maintainer-specific portions of Makefiles])
  dnl maintainer-mode is disabled by default
  AC_ARG_ENABLE(maintainer-mode,
[  --enable-maintainer-mode   enable make rules and dependencies not useful
                            (and sometimes confusing) to the casual installer],
      USE_MAINTAINER_MODE=$enableval,
      USE_MAINTAINER_MODE=no)
  AC_MSG_RESULT($USE_MAINTAINER_MODE)
  if test ".$USE_MAINTAINER_MODE" = .yes; then
    MAINT='#M#'
  else
    MAINT=
  fi
  AC_SUBST(MAINT)dnl
])dnl
define(AC_CONFIGURE_PART,[dnl
AC_MSG_RESULT()
AC_MSG_RESULT(__ $1 __)
])dnl
dnl
define(AC_CHECK_PERL_INTERPRETER,[dnl
AC_MSG_CHECKING([for Perl language])
AC_ARG_WITH(perl,dnl
[  --with-perl=PATH        force the usage of a specific Perl 5 interpreter],
perlprog=$with_perl
perlvers=`$perlprog -v | grep version | sed -e 's/.* version //' -e 's/ built.*//' -e 's/ with.*//'`
,
TMPFILE=/tmp/ac.$$
rm -f $TMPFILE
touch $TMPFILE
c=0
for dir in `echo $PATH | sed -e 's/:/ /g'` /tmp; do
    for perl in perl5 perl miniperl; do
         if test -f "$dir/$perl"; then
             if test -x "$dir/$perl"; then
                 perl="$dir/$perl"
                 version=`$perl -v | grep version | sed -e 's/.* version //' -e 's/ built.*//' -e 's/ with.*//'`
                 versionnum="`echo $version | sed -e 's/\.//g' -e 's/_//g'`"
                 versionnum=`expr $versionnum - $c`
                 echo "$versionnum $version $perl" >>$TMPFILE
             fi
         fi
    done
    c=`expr $c + 1`
done
perlvers="`cat $TMPFILE | sort -u | tail -1 | cut '-d ' -f2`"
perlprog="`cat $TMPFILE | sort -u | tail -1 | cut '-d ' -f3`"
rm -f $TMPFILE
)dnl
PATH_PERL=$perlprog
AC_MSG_RESULT([$perlprog v$perlvers])
AC_SUBST(PATH_PERL)
AC_SUBST(perlprog)
AC_SUBST(perlvers)
])dnl
dnl
define(AC_CHECK_PERL_MODULE,[dnl
AC_MSG_CHECKING([for Perl module $1 ($2)])
TMPFILE=/tmp/ac.$$
rm -f $TMPFILE
cat >$TMPFILE <<'EOT'
eval {
    require $1;
    if ('$2' ne 'ANY') {
        $1->require_version('$2');
    }
};
if ([$]@) {
    print "failed";
} else {
    print "ok";
}
EOT
rc=`$path_perl $TMPFILE`; 
rm -f $TMPFILE
if test ".$rc" = .ok; then
    have_$3=1
    AC_MSG_RESULT([found])
else
    have_$3=0
    AC_MSG_RESULT([not found])
fi
AC_SUBST(have_$3)
])dnl
define(AC_BUILT_PARAMS,[dnl

AC_CANONICAL_HOST
built_system=$host
AC_SUBST(built_system)

AC_MSG_CHECKING(for built user)
built_user="`$ac_aux_dir/buildinfo -n %u@%h%d`"
AC_SUBST(built_user)
AC_MSG_RESULT($built_user)

AC_MSG_CHECKING(for built date)
built_date="`$ac_aux_dir/buildinfo -n '%D-%m-%Y'`"
AC_MSG_RESULT($built_date)
AC_SUBST(built_date)

])dnl
dnl
