/*
 * Copyright (c) 1998 Rene Fichter <ceezaer@cyberspace.org>
 * Copyright (c) 1997 Guylhem Aznar <guylhem@oeil.qc.ca>
 * Copyright (c) 1994 Mike Finger <mfinger@mermaid.micro.umn.edu>
 *                    or <Mike_Finger@atk.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Struct definitions */
typedef struct button {
  char *title;
  char *truncate_title; /* valid only if truncatewidth > 0 */
  int up,needsupdate,tw,set,truncatewidth;
  struct button *next;
} Button;

typedef struct {
  int count;
  Button *head,*tail;
  int x,y,w,h;
} ButtonArray;

/* Function Prototypes */
void InitArray(ButtonArray *array,int x,int y,int w,int h);
void UpdateArray(ButtonArray *array,int x,int y,int w, int h);
int AddButton(ButtonArray *array, char *title, int up);
int UpdateButton(ButtonArray *array, int butnum, char *title, int up);
void RemoveButton(ButtonArray *array, int butnum);
Button *find_n(ButtonArray *array, int n);
void FreeButton(Button *ptr);
void FreeAllButtons(ButtonArray *array);
void DoButton(Button *ptr, int x, int y, int w, int h);
void DrawButtonArray(ButtonArray *array, int all);
void SwitchButton(ButtonArray *array,int butnum);
int WhichButton(ButtonArray *array,int x, int y);
void PrintButtons(ButtonArray *array);
