#include "E.h"
#ifdef ARRANGE_TEST
#include <gdk/gdk.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>
#endif

int                 ArrangeAddToList(int **array, int current_size, int value);
void                ArrangeSwapList(RectBox * list, int a, int b);

int
ArrangeAddToList(int **array, int current_size, int value)
{
   int                 i, j;

   EDBUG(8, "ArrangeAddToList");
   for (i = 0; i < current_size; i++)
     {
	if (value < (*array)[i])
	  {
	     for (j = current_size; j > i; j--)
		(*array)[j] = (*array)[j - 1];
	     (*array)[i] = value;
	     EDBUG_RETURN(current_size + 1);
	  }
	else if (value == (*array)[i])
	   EDBUG_RETURN(current_size);
     }
   (*array)[current_size] = value;
   EDBUG_RETURN(current_size + 1);
}

void
ArrangeSwapList(RectBox * list, int a, int b)
{
   RectBox             bb;

   EDBUG(8, "ArrangeSwapList");
   bb.data = list[a].data;
   bb.x = list[a].x;
   bb.y = list[a].y;
   bb.w = list[a].w;
   bb.h = list[a].h;
   list[a].data = list[b].data;
   list[a].x = list[b].x;
   list[a].y = list[b].y;
   list[a].w = list[b].w;
   list[a].h = list[b].h;
   list[b].data = bb.data;
   list[b].x = bb.x;
   list[b].y = bb.y;
   list[b].w = bb.w;
   list[b].h = bb.h;
   EDBUG_RETURN_;
}

void
ArrangeRects(RectBox * fixed, int fixed_count, RectBox * floating,
	     int floating_count, RectBox * sorted, int width, int height,
	     int policy)
{
   int                 num_sorted = 0;
   int                 xsize = 0, ysize = 0;
   int                *xarray = NULL, *yarray = NULL;
   int                *leftover;
   int                 i, j, k, x, y, x1, x2, y1, y2;
   char               *filled = NULL;
   RectBox            *spaces = NULL;
   int                 num_spaces = 0;
   int                 sort;
   int                 a1, a2;
   int                 num_leftover = 0;

   EDBUG(7, "ArrangeRects");
   switch (policy)
     {
     case ARRANGE_VERBATIM:
	break;
     case ARRANGE_BY_SIZE:
	sort = 0;
	while (!sort)
	  {
	     sort = 1;
	     for (i = 0; i < floating_count - 1; i++)
	       {
		  a1 = floating[i].w * floating[i].h;
		  a2 = floating[i + 1].w * floating[i + 1].h;
		  if (a2 > a1)
		    {
		       sort = 0;
		       ArrangeSwapList(floating, i, i + 1);
		    }
	       }
	  }
	break;
     case ARRANGE_BY_POSITION:
	sort = 0;
	while (!sort)
	  {
	     sort = 1;
	     for (i = 0; i < floating_count - 1; i++)
	       {
		  a1 = floating[i].x + floating[i].y;
		  a2 = (floating[i + 1].x + (floating[i + 1].w >> 1)) +
		     (floating[i + 1].y + (floating[i + 1].h >> 1));
		  if (a2 < a1)
		    {
		       sort = 0;
		       ArrangeSwapList(floating, i, i + 1);
		    }
	       }
	  }
	break;
     default:
	break;
     }
/* for every floating rect in order, "fit" it into the sorted list */
   i = ((fixed_count + floating_count) * 2) + 2;
   xarray = alloca(i * sizeof(int));
   yarray = alloca(i * sizeof(int));
   filled = alloca(i * i * sizeof(char));

   spaces = alloca(i * i * sizeof(RectBox));
   leftover = alloca(floating_count * sizeof(int));

   if (!xarray)
      EDBUG_RETURN_;
   if (!yarray)
      EDBUG_RETURN_;
   if (!filled)
      EDBUG_RETURN_;
   if (!spaces)
      EDBUG_RETURN_;
   if (!leftover)
      EDBUG_RETURN_;
/* copy "fixeD" rects into the sorted list */
   for (i = 0; i < fixed_count; i++)
     {
	sorted[num_sorted].data = fixed[i].data;
	sorted[num_sorted].x = fixed[i].x;
	sorted[num_sorted].y = fixed[i].y;
	sorted[num_sorted].w = fixed[i].w;
	sorted[num_sorted].h = fixed[i].h;
	num_sorted++;
     }
/* go through each floating rrect in order and "fit" it in */
   for (i = 0; i < floating_count; i++)
     {
	xsize = 0;
	ysize = 0;
/* put all the sorted rects into the xy arrays */
	xsize = ArrangeAddToList(&xarray, xsize, 0);
	xsize = ArrangeAddToList(&xarray, xsize, width);
	ysize = ArrangeAddToList(&yarray, ysize, 0);
	ysize = ArrangeAddToList(&yarray, ysize, height);
	for (j = 0; j < num_sorted; j++)
	  {
	     if (sorted[j].x < width)
		xsize = ArrangeAddToList(&xarray, xsize, sorted[j].x);
	     if ((sorted[j].x + sorted[j].w) < width)
		xsize = ArrangeAddToList(&xarray, xsize, sorted[j].x + sorted[j].w);
	     if (sorted[j].y < height)
		ysize = ArrangeAddToList(&yarray, ysize, sorted[j].y);
	     if ((sorted[j].y + sorted[j].h) < height)
		ysize = ArrangeAddToList(&yarray, ysize, sorted[j].y + sorted[j].h);
	  }
/* fill the allocation array */
	for (j = 0; j < (xsize - 1) * (ysize - 1); filled[j++] = 0);
	for (j = 0; j < num_sorted; j++)
	  {
	     x1 = -1;
	     x2 = -1;
	     y1 = -1;
	     y2 = -1;
	     for (k = 0; k < xsize - 1; k++)
	       {
		  if (sorted[j].x == xarray[k])
		    {
		       x1 = k;
		       x2 = k;
		    }
		  if (sorted[j].x + sorted[j].w == xarray[k + 1])
		     x2 = k;
	       }
	     for (k = 0; k < ysize - 1; k++)
	       {
		  if (sorted[j].y == yarray[k])
		    {
		       y1 = k;
		       y2 = k;
		    }
		  if (sorted[j].y + sorted[j].h == yarray[k + 1])
		     y2 = k;
	       }
	     if ((x1 >= 0) && (x2 >= 0) && (y1 >= 0) && (y2 >= 0))
	       {
		  for (y = y1; y <= y2; y++)
		    {
		       for (x = x1; x <= x2; x++)
			  filled[(y * (xsize - 1)) + x] = 1;
		    }
	       }
	  }
	num_spaces = 0;
/* creat list of all "spaces" */
	for (y = 0; y < ysize - 1; y++)
	  {
	     for (x = 0; x < xsize - 1; x++)
	       {
/* if the square is empty "grow" the space */
		  if (!filled[(y * (xsize - 1)) + x])
		    {
		       int                 can_expand_x = 1;
		       int                 can_expand_y = 1;

		       x1 = x + 1;
		       y1 = y + 1;
		       filled[(y * (xsize - 1)) + x] = 2;
		       if (x >= xsize - 2)
			  can_expand_x = 0;
		       if (y >= ysize - 2)
			  can_expand_y = 0;
		       while ((can_expand_x) || (can_expand_y))
			 {
			    if (x1 >= xsize - 1)
			       can_expand_x = 0;
			    if (y1 >= ysize - 1)
			       can_expand_y = 0;
			    if (can_expand_x)
			      {
				 for (j = y; j < y1; j++)
				   {
				      if (filled[(j * (xsize - 1)) + x1] != 0)
					 can_expand_x = 0;
				   }
			      }
			    if (can_expand_x)
			       x1++;
			    if (can_expand_y)
			      {
				 for (j = x; j < x1; j++)
				   {
				      if (filled[(y1 * (xsize - 1)) + j] != 0)
					 can_expand_y = 0;
				   }
			      }
			    if (can_expand_y)
			       y1++;
			 }
		       spaces[num_spaces].x = xarray[x];
		       spaces[num_spaces].y = yarray[y];
		       spaces[num_spaces].w = xarray[x1] - xarray[x];
		       spaces[num_spaces].h = yarray[y1] - yarray[y];
		       num_spaces++;
		    }
	       }
	  }
/* find the first space that fits */
	k = -1;
	sort = 0x7fffffff;
	for (j = 0; j < num_spaces; j++)
	  {
	     if ((spaces[j].w >= floating[i].w) &&
		 (spaces[j].h >= floating[i].h))
	       {
		  if (policy == ARRANGE_BY_POSITION)
		    {
		       a1 = (spaces[j].x + (spaces[j].w >> 1)) -
			  (floating[i].x + (floating[i].w >> 1));
		       a2 = (spaces[j].y + (spaces[j].h >> 1)) -
			  (floating[i].y + (floating[i].h >> 1));
		       if (a1 < 0)
			  a1 = -a1;
		       if (a2 < 0)
			  a2 = -a2;
		       if ((a1 + a2) < sort)
			 {
			    sort = a1 + a2;
			    k = j;
			 }
		    }
		  else
		    {
		       k = j;
		       j = num_spaces;
		    }
	       }
	  }
	if (k >= 0)
	  {
	     if (policy == ARRANGE_BY_POSITION)
	       {
		  a1 = (spaces[k].x + (spaces[k].w >> 1)) -
		     (floating[i].x + (floating[i].w >> 1));
		  a2 = (spaces[k].y + (spaces[k].h >> 1)) -
		     (floating[i].y + (floating[i].h >> 1));
		  if (a1 >= 0)
		     sorted[num_sorted].x = spaces[k].x;
		  else
		     sorted[num_sorted].x = spaces[k].x + spaces[k].w - floating[i].w;
		  if (a2 >= 0)
		     sorted[num_sorted].y = spaces[k].y;
		  else
		     sorted[num_sorted].y = spaces[k].y + spaces[k].h - floating[i].h;
	       }
	     else
	       {
		  sorted[num_sorted].x = spaces[k].x;
		  sorted[num_sorted].y = spaces[k].y;
	       }
	     sorted[num_sorted].data = floating[i].data;
	     sorted[num_sorted].w = floating[i].w;
	     sorted[num_sorted].h = floating[i].h;
	     num_sorted++;
	  }
	else
	   leftover[num_leftover++] = i;
     }
   for (i = 0; i < num_leftover; i++)
     {
	xsize = 0;
	ysize = 0;
/* put all the sorted rects into the xy arrays */
	xsize = ArrangeAddToList(&xarray, xsize, 0);
	xsize = ArrangeAddToList(&xarray, xsize, width);
	ysize = ArrangeAddToList(&yarray, ysize, 0);
	ysize = ArrangeAddToList(&yarray, ysize, height);
	for (j = 0; j < num_sorted; j++)
	  {
	     if (sorted[j].x < width)
		xsize = ArrangeAddToList(&xarray, xsize, sorted[j].x);
	     if ((sorted[j].x + sorted[j].w) < width)
		xsize = ArrangeAddToList(&xarray, xsize, sorted[j].x + sorted[j].w);
	     if (sorted[j].y < height)
		ysize = ArrangeAddToList(&yarray, ysize, sorted[j].y);
	     if ((sorted[j].y + sorted[j].h) < height)
		ysize = ArrangeAddToList(&yarray, ysize, sorted[j].y + sorted[j].h);
	  }
/* fill the allocation array */
	for (j = 0; j < (xsize - 1) * (ysize - 1); filled[j++] = 0);
	for (j = 0; j < num_sorted; j++)
	  {
	     x1 = -1;
	     x2 = -1;
	     y1 = -1;
	     y2 = -1;
	     for (k = 0; k < xsize - 1; k++)
	       {
		  if (sorted[j].x == xarray[k])
		    {
		       x1 = k;
		       x2 = k;
		    }
		  if (sorted[j].x + sorted[j].w == xarray[k + 1])
		     x2 = k;
	       }
	     for (k = 0; k < ysize - 1; k++)
	       {
		  if (sorted[j].y == yarray[k])
		    {
		       y1 = k;
		       y2 = k;
		    }
		  if (sorted[j].y + sorted[j].h == yarray[k + 1])
		     y2 = k;
	       }
	     if ((x1 >= 0) && (x2 >= 0) && (y1 >= 0) && (y2 >= 0))
	       {
		  for (y = y1; y <= y2; y++)
		    {
		       for (x = x1; x <= x2; x++)
			  filled[(y * (xsize - 1)) + x] = 1;
		    }
	       }
	  }
	num_spaces = 0;
/* creat list of all "spaces" */
	for (y = 0; y < ysize - 1; y++)
	  {
	     for (x = 0; x < xsize - 1; x++)
	       {
/* if the square is empty "grow" the space */
		  if (!filled[(y * (xsize - 1)) + x])
		    {
		       int                 can_expand_x = 1;
		       int                 can_expand_y = 1;

		       x1 = x + 1;
		       y1 = y + 1;
		       filled[(y * (xsize - 1)) + x] = 2;
		       if (x >= xsize - 2)
			  can_expand_x = 0;
		       if (y >= ysize - 2)
			  can_expand_y = 0;
		       while ((can_expand_x) || (can_expand_y))
			 {
			    if (x1 >= xsize - 1)
			       can_expand_x = 0;
			    if (y1 >= ysize - 1)
			       can_expand_y = 0;
			    if (can_expand_x)
			      {
				 for (j = y; j < y1; j++)
				   {
				      if (filled[(j * (xsize - 1)) + x1] != 0)
					 can_expand_x = 0;
				   }
			      }
			    if (can_expand_x)
			       x1++;
			    if (can_expand_y)
			      {
				 for (j = x; j < x1; j++)
				   {
				      if (filled[(y1 * (xsize - 1)) + j] != 0)
					 can_expand_y = 0;
				   }
			      }
			    if (can_expand_y)
			       y1++;
			 }
		       spaces[num_spaces].x = xarray[x];
		       spaces[num_spaces].y = yarray[y];
		       spaces[num_spaces].w = xarray[x1] - xarray[x];
		       spaces[num_spaces].h = yarray[y1] - yarray[y];
		       num_spaces++;
		    }
	       }
	  }
/* find the first space that fits */
	k = -1;
	sort = 0x7fffffff;
	a1 = floating[leftover[i]].w * floating[leftover[i]].h;
	k = -1;
	for (j = 0; j < num_spaces; j++)
	  {
	     a2 = spaces[j].w * spaces[j].h;
	     if ((a2 != 0) && ((a1 - a2) < sort))
	       {
		  k = j;
		  sort = a1 - a2;
	       }
	  }
	if (k >= 0)
	  {
	     sorted[num_sorted].x = spaces[k].x +
		((spaces[k].w - floating[leftover[i]].w) >> 1);
	     sorted[num_sorted].y = spaces[k].y +
		((spaces[k].h - floating[leftover[i]].h) >> 1);
	     sorted[num_sorted].data = floating[leftover[i]].data;
	     sorted[num_sorted].w = floating[leftover[i]].w;
	     sorted[num_sorted].h = floating[leftover[i]].h;
	     if ((sorted[num_sorted].x + sorted[num_sorted].w) > width)
		sorted[num_sorted].x = width - sorted[num_sorted].w;
	     if ((sorted[num_sorted].y + sorted[num_sorted].h) > height)
		sorted[num_sorted].y = height - sorted[num_sorted].h;
	     if (sorted[num_sorted].x < 0)
		sorted[num_sorted].x = 0;
	     if (sorted[num_sorted].y < 0)
		sorted[num_sorted].y = 0;
	     num_sorted++;
	  }
	else
	  {
	     sorted[num_sorted].data = floating[leftover[i]].data;
	     sorted[num_sorted].w = floating[leftover[i]].w;
	     sorted[num_sorted].h = floating[leftover[i]].h;
	     sorted[num_sorted].x = rand() % (width - sorted[num_sorted].w);
	     sorted[num_sorted].y = rand() % (height - sorted[num_sorted].h);
	     num_sorted++;
	  }
     }
   EDBUG_RETURN_;
}

#ifdef ARRANGE_TEST
int
main(int argc, char **argv)
{
   GdkWindowAttr       attr;
   GdkWindow          *win;
   GdkColor            col;
   RectBox            *boxes, *sorted;
   int                 num, pol;
   int                 w, h, i;

   EDBUG(0, "main (arrange.c)");
   gdk_init(&argc, &argv);
   if (argc <= 1)
     {
	printf("Usage:\n arrange number\n");
	exit(1);
     }
   num = atoi(argv[1]);
   pol = atoi(argv[2]);
   w = 640;
   h = 480;
   attr.window_type = GDK_WINDOW_TOPLEVEL;
   attr.wclass = GDK_INPUT_OUTPUT;
   attr.event_mask = GDK_STRUCTURE_MASK;
   attr.width = w;
   attr.height = h;
   win = gdk_window_new(NULL, &attr, 0);
   gdk_window_show(win);
   boxes = Emalloc(num * sizeof(RectBox));
   sorted = Emalloc(num * sizeof(RectBox));
   srand(time(NULL));
   for (i = 0; i < num; i++)
     {
	sorted[i].data = NULL;
	boxes[i].w = (rand() % 40) + 10;
	boxes[i].h = (rand() % 30) + 10;
	boxes[i].x = (rand() % (640 - (boxes[i].w - 1)));
	boxes[i].y = (rand() % (480 - (boxes[i].h - 1)));
	attr.window_type = GDK_WINDOW_CHILD;
	attr.wclass = GDK_INPUT_OUTPUT;
	attr.event_mask = 0;
	attr.width = boxes[i].w;
	attr.height = boxes[i].h;
	attr.x = boxes[i].x;
	attr.y = boxes[i].y;
	boxes[i].data = gdk_window_new(win, &attr, GDK_WA_X | GDK_WA_Y);
	col.pixel = rand() % 65535;
	col.red = rand() % 65535;
	col.green = rand() % 65535;
	col.blue = rand() % 65535;
	gdk_window_set_background(boxes[i].data, &col);
	gdk_window_show(boxes[i].data);

     }
   gdk_flush();
   printf("Scattered\n");
   sleep(1);
   printf("Arranging\n");
   ArrangeRects(NULL, 0, boxes, num, sorted, 640, 480, pol);
   printf("Arranged\n");
   for (i = 0; i < num; i++)
     {
	if (sorted[i].data)
	   gdk_window_move(sorted[i].data, sorted[i].x, sorted[i].y);
     }
   gdk_flush();
   sleep(20);
   EDBUG_RETURN(0);
}
#endif
