#include "E.h"

void
DrawEwinShape(EWin * ewin, int md, int x, int y, int w, int h, char firstlast)
{
   GC                  gc;
   XGCValues           gcv;
   int                 x1, y1, w1, h1, i, j;

   EDBUG(4, "DrawEwinShape");
/*   if (firstlast==0) XGrabServer(disp); */
   if ((mode.mode == MODE_RESIZE) ||
       (mode.mode == MODE_RESIZE_H) ||
       (mode.mode == MODE_RESIZE_V))
     {
	w1 = ewin->client.w;
	h1 = ewin->client.h;
	ewin->client.w = w;
	ewin->client.h = h;
	ICCCM_MatchSize(ewin);
	i = (x - ewin->x) / ewin->client.w_inc;
	j = (y - ewin->y) / ewin->client.h_inc;
	x = ewin->x + (i * ewin->client.w_inc);
	y = ewin->y + (j * ewin->client.h_inc);
	ewin->client.w = w1;
	ewin->client.h = h1;
     }
   switch (md)
     {
     case 0:
	MoveResizeEwin(ewin, x, y, w, h);
	break;
     case 1:
	x1 = ewin->x + desks.desk[ewin->desktop].x;
	y1 = ewin->y + desks.desk[ewin->desktop].y;
	w1 = ewin->client.w;
	h1 = ewin->client.h;
	ewin->x = x;
	ewin->y = y;
	ewin->client.w = w;
	ewin->client.h = h;
	ICCCM_MatchSize(ewin);
	ewin->w = ewin->client.w + ewin->border->border.left + ewin->border->border.right;
	ewin->h = ewin->client.h + ewin->border->border.top + ewin->border->border.bottom;
	x = ewin->x + desks.desk[ewin->desktop].x;
	y = ewin->y + desks.desk[ewin->desktop].y;
	w = ewin->client.w;
	h = ewin->client.h;
	gcv.function = GXxor;
	gcv.foreground = WhitePixel(disp, root.scr);
	if (gcv.foreground == 0)
	   gcv.foreground = 1;
	gcv.subwindow_mode = IncludeInferiors;
	gc = XCreateGC(disp, root.win, GCFunction | GCForeground | GCSubwindowMode, &gcv);
	if (firstlast > 0)
	  {
	     XDrawLine(disp, root.win, gc, x1, 0, x1, root.h);
	     XDrawLine(disp, root.win, gc,
		       x1 + w1 + ewin->border->border.left +
		       ewin->border->border.right - 1, 0,
		       x1 + w1 + ewin->border->border.left +
		       ewin->border->border.right - 1, root.h);
	     XDrawLine(disp, root.win, gc, 0, y1, root.w, y1);
	     XDrawLine(disp, root.win, gc, 0,
		       y1 + h1 + ewin->border->border.top +
		       ewin->border->border.bottom - 1, root.w,
		       y1 + h1 + ewin->border->border.top +
		       ewin->border->border.bottom - 1);
	     XDrawRectangle(disp, root.win, gc, x1 + ewin->border->border.left,
			    y1 + ewin->border->border.top, w1 - 1, h1 - 1);
	  }
	if (firstlast < 2)
	  {
	     XDrawLine(disp, root.win, gc, x, 0, x, root.h);
	     XDrawLine(disp, root.win, gc,
		       x + w + ewin->border->border.left +
		       ewin->border->border.right - 1, 0,
		       x + w + ewin->border->border.left +
		       ewin->border->border.right - 1, root.h);
	     XDrawLine(disp, root.win, gc, 0, y, root.w, y);
	     XDrawLine(disp, root.win, gc, 0,
		       y + h + ewin->border->border.top +
		       ewin->border->border.bottom - 1, root.w,
		       y + h + ewin->border->border.top +
		       ewin->border->border.bottom - 1);
	     XDrawRectangle(disp, root.win, gc, x + ewin->border->border.left,
			    y + ewin->border->border.top, w - 1, h - 1);
	  }
	if (firstlast == 2)
	   MoveResizeEwin(ewin, ewin->x, ewin->y, w, h);
	XFreeGC(disp, gc);
	break;
     default:
	break;
     }
/*   if (firstlast==2) XUngrabServer(disp); */
   EDBUG_RETURN_;
}

ImlibImage         *
ELoadImage(char *file)
{
   EDBUG(5, "ELoadImage");
   EDBUG_RETURN(ELoadImageImlibData(id, file));
}

ImlibImage         *
ELoadImageImlibData(ImlibData * imd, char *file)
{
   ImlibImage         *im;
   char               *f;

   EDBUG(5, "ELoadImageImlibData");
   f = FindFile(file);
   if (f)
     {
	im = Imlib_load_image(imd, f);
	Efree(f);
	EDBUG_RETURN(im);
     }
   EDBUG_RETURN(NULL);
}

struct _span
{
   int                 start;
   int                 end;
   struct _span       *next;
};

void
add_to_span(struct _span **s, int x, int xx)
{
   struct _span       *ptr1, *ptr2, *noo, *ss;
   char                spanning;

   EDBUG(8, "add_to_span");
   ptr2 = NULL;
   ptr1 = *s;
   spanning = 0;
   ss = NULL;
/* scan the spans for this line */
   while (ptr1)
     {
/* -- -> new span */
/* == -> existing span */
/* ## -> spans intersect */
	/* if we are in the middle of spanning the span into the line */
	if (spanning)
	  {
/* case: ---- ==== */
	     if (xx < ptr1->start - 1)
	       {
		  /* ends before next span - extend to here */
		  ss->end = xx;
		  EDBUG_RETURN_;
	       }
/* case: ----##=== */
	     else if (xx <= ptr1->end)
	       {
		  /* crosses into next span - delete next span and append */
		  ss->end = ptr1->end;
		  ss->next = ptr1->next;
		  Efree(ptr1);
		  EDBUG_RETURN_;
	       }
/* case: ---###--- */
	     else
	       {
		  /* overlaps next span - delete and keep checking */
		  ss->next = ptr1->next;
		  Efree(ptr1);
		  ptr1 = ss;
	       }
	  }
	/* otherwise havent started spanning it in yet */
	else
	  {
/* case: ---- ==== */
	     if (xx < ptr1->start - 1)
	       {
		  /* insert span here in list */
		  noo = Emalloc(sizeof(struct _span));

		  if (noo)
		    {
		       noo->start = x;
		       noo->end = xx;
		       noo->next = ptr1;
		       if (ptr2)
			  ptr2->next = noo;
		       else
			  *s = noo;
		    }
		  EDBUG_RETURN_;
	       }
/* case: ----##=== */
	     else if ((x < ptr1->start) && (xx <= ptr1->end))
	       {
		  /* expand this span to the left point of the new one */
		  ptr1->start = x;
		  EDBUG_RETURN_;
	       }
/* case: ===###=== */
	     else if ((x >= ptr1->start) && (xx <= ptr1->end))
	       {
		  /* throw the span away */
		  EDBUG_RETURN_;
	       }
/* case: ---###--- */
	     else if ((x < ptr1->start) && (xx > ptr1->end))
	       {
		  ss = ptr1;
		  spanning = 1;
		  ptr1->start = x;
		  ptr1->end = xx;
	       }
/* case: ===##---- */
	     else if ((x >= ptr1->start) && (x <= ptr1->end + 1) && (xx > ptr1->end))
	       {
		  ss = ptr1;
		  spanning = 1;
		  ptr1->end = xx;
	       }
/* case: ==== ---- */
	     /* case handled by next loop iteration - first case */
	  }
	ptr2 = ptr1;
	ptr1 = ptr1->next;
     }
/* it started in the middle but spans beyond your current list */
   if (spanning)
     {
	ptr2->end = xx;
	EDBUG_RETURN_;
     }
/* it does not start inside a span or in the middle, so add it to the end */
   noo = Emalloc(sizeof(struct _span));

   if (noo)
     {
	noo->start = x;
	noo->end = xx;
	if (ptr2)
	  {
	     noo->next = ptr2->next;
	     ptr2->next = noo;
	  }
	else
	  {
	     noo->next = NULL;
	     *s = noo;
	  }
     }
   EDBUG_RETURN_;
}

void
PropagateShapes(Window win)
{
   Window              rt, par, *list = NULL;
   int                 a, k, i, j, num = 0, num_rects = 0, rn = 0, ord;
   int                 x, y, contig, x1, y1, x2, y2;
   unsigned int        w, h, d;
   int                 baseh, basew;
   XRectangle         *rects = NULL, *rl = NULL;
   struct _span      **spans = NULL, *ptr1, *ptr2, *ptr3;

   EDBUG(6, "PropagateShapes");
   XGetGeometry(disp, win, &rt, &x, &y, &w, &h, &d, &d);
   if (h <= 0)
      EDBUG_RETURN_;
   basew = w;
   baseh = h;
   spans = Emalloc(sizeof(struct _span *) * h);

   for (i = 0; i < h; i++)
      spans[i] = NULL;
   XQueryTree(disp, win, &rt, &par, &list, (unsigned int *)&num);
   if (list)
     {
	/* go through all child windows and create/inset spans */
	for (i = 0; i < num; i++)
	  {
	     XGetGeometry(disp, list[i], &rt, &x, &y, &w, &h, &d, &d);
	     rl = XShapeGetRectangles(disp, list[i], ShapeBounding, &rn, &ord);
	     if (rl)
	       {
		  /* go through all clip rects in thsi window's shape */
		  for (k = 0; k < rn; k++)
		    {
		       /* for each clip rect, add it to each line's spans */
		       x1 = x + rl[k].x;
		       x2 = x + rl[k].x + (rl[k].width - 1);
		       y1 = y + rl[k].y;
		       y2 = y + rl[k].y + (rl[k].height - 1);
		       if (x1 < 0)
			  x1 = 0;
		       if (y1 < 0)
			  y1 = 0;
		       if (x2 >= basew)
			  x2 = basew - 1;
		       if (y2 >= baseh)
			  y2 = baseh - 1;
		       for (a = y1; a <= y2; a++)
			 {
			    if ((x2 - x1) >= 0)
			       add_to_span(&spans[a], x1, x2);
			 }
		    }
		  XFree(rl);
	       }
	  }
	/* go through the spans list and build a list of rects */
	rects = Emalloc(sizeof(XRectangle) * 256);
	num_rects = 0;
	for (i = 0; i < baseh; i++)
	  {
	     ptr1 = spans[i];
	     /* go through the line for all spans */
	     while (ptr1)
	       {
		  rects[num_rects].x = ptr1->start;
		  rects[num_rects].y = i;
		  rects[num_rects].width = ptr1->end - ptr1->start + 1;
		  rects[num_rects].height = 1;
		  j = i + 1;
		  /* if there are more lines */
		  contig = 1;
		  /* while contigous rects (same start/end coords) exist */
		  while ((contig) && (j < baseh))
		    {
		       /* search next line for spans matching this one */
		       contig = 0;
		       ptr2 = spans[j];
		       ptr3 = NULL;
		       while (ptr2)
			 {
			    /* if we have an exact span match set contig */
			    if ((ptr2->start == ptr1->start) &&
				(ptr2->end == ptr1->end))
			      {
				 contig = 1;
				 /* remove the span - not needed */
				 if (ptr3)
				   {
				      ptr3->next = ptr2->next;
				      Efree(ptr2);
				      ptr2 = NULL;
				   }
				 else
				   {
				      spans[j] = ptr2->next;
				      Efree(ptr2);
				      ptr2 = NULL;
				   }
				 break;
			      }
			    /* gone past the span point no point looking */
			    else if (ptr2->start < ptr1->start)
			       break;
			    if (ptr2)
			      {
				 ptr3 = ptr2;
				 ptr2 = ptr2->next;
			      }
			 }
		       /* if a contiguous span was found increase the rect h */
		       if (contig)
			 {
			    rects[num_rects].height++;
			    j++;
			 }
		    }
		  /* up the rect count */
		  num_rects++;
		  /* every 256 new rects increase the rect array */
		  if ((num_rects % 256) == 0)
		     rects = Erealloc(rects, sizeof(XRectangle) * (num_rects + 256));
		  ptr1 = ptr1->next;
	       }
	  }
	/* set the rects as the shape mask */
	if (rects)
	  {
	     XShapeCombineRectangles(disp, win, ShapeBounding, 0, 0, rects, num_rects,
				     ShapeSet, YXSorted);
	     Efree(rects);
	  }
	XFree(list);
     }
   /* free up all the spans we made */
   for (i = 0; i < baseh; i++)
     {
	ptr1 = spans[i];
	while (ptr1)
	  {
	     ptr2 = ptr1;
	     ptr1 = ptr1->next;
	     Efree(ptr2);
	  }
     }
   Efree(spans);
   EDBUG_RETURN_;
}
