#include "E.h"

void
ICCCM_GetTitle(EWin * ewin)
{
   XTextProperty       xtp;

   EDBUG(6, "ICCCM_GetTitle");
   if (ewin->client.title)
      Efree(ewin->client.title);
   if (XGetWMName(disp, ewin->client.win, &xtp))
      ewin->client.title = duplicate((char *)xtp.value);
   else
      ewin->client.title = duplicate("No title");
   XFree(xtp.value);
   EDBUG_RETURN_;
}

void
ICCCM_GetColormap(EWin * ewin)
{
   XWindowAttributes   xwa;

   EDBUG(6, "ICCCM_GetColormap");
   if (XGetWindowAttributes(disp, ewin->client.win, &xwa))
     {
	if (xwa.colormap)
	   ewin->client.cmap = xwa.colormap;
	else
	   ewin->client.cmap = 0;
     }
   else
      ewin->client.cmap = 0;
   EDBUG_RETURN_;
}

void
ICCCM_Delete(EWin * ewin)
{
   XClientMessageEvent ev;
   Atom                a1, a2, a3, *prop;
   unsigned long       lnum, ldummy;
   int                 num, i, del, dummy;

   EDBUG(6, "ICCCM_Delete");
   a1 = XInternAtom(disp, "WM_DELETE_WINDOW", False);
   a2 = XInternAtom(disp, "WM_PROTOCOLS", False);
   num = 0;
   prop = NULL;
   del = 0;
   if (!XGetWMProtocols(disp, ewin->client.win, &prop, &num))
     {
	XGetWindowProperty(disp, ewin->client.win, a2, 0, 10, False, a2, &a3, &dummy,
			   &lnum, &ldummy, (unsigned char **)&prop);
	num = (int)lnum;
     }
   if (prop)
     {
	for (i = 0; i < num; i++)
	   if (prop[i] == a1)
	      del = 1;
	XFree(prop);
     }
   if (del)
     {
	ev.type = ClientMessage;
	ev.window = ewin->client.win;
	ev.message_type = a2;
	ev.format = 32;
	ev.data.l[0] = a1;
	ev.data.l[1] = CurrentTime;
	XSendEvent(disp, ewin->client.win, False, 0, (XEvent *) & ev);
     }
   else
      XKillClient(disp, (XID) ewin->client.win);
   EDBUG_RETURN_;
}

void
ICCCM_Save(EWin * ewin)
{
   XClientMessageEvent ev;
   Atom                a1, a2;

   EDBUG(6, "ICCCM_Save");
   a1 = XInternAtom(disp, "WM_SAVE_YOURSELF", False);
   a2 = XInternAtom(disp, "WM_PROTOCOLS", False);
   ev.type = ClientMessage;
   ev.window = ewin->client.win;
   ev.message_type = a2;
   ev.format = 32;
   ev.data.l[0] = a1;
   ev.data.l[1] = CurrentTime;
   XSendEvent(disp, ewin->client.win, False, 0, (XEvent *) & ev);
   EDBUG_RETURN_;
}

void
ICCCM_Iconify(EWin * ewin)
{
   Atom                a;
   unsigned long       c[2];

   EDBUG(6, "ICCCM_Iconify");
   a = XInternAtom(disp, "WM_STATE", False);
   c[0] = IconicState;
   c[1] = 0;
   XChangeProperty(disp, ewin->client.win, a, a, 32, PropModeReplace,
		   (unsigned char *)c, 2);
   XUnmapWindow(disp, ewin->client.win);
   EDBUG_RETURN_;
}

void
ICCCM_DeIconfiy(EWin * ewin)
{
   Atom                a;
   unsigned long       c[2];

   EDBUG(6, "ICCCM_DeIconfiy");
   a = XInternAtom(disp, "WM_STATE", False);
   c[0] = NormalState;
   c[1] = 0;
   XChangeProperty(disp, ewin->client.win, a, a, 32, PropModeReplace,
		   (unsigned char *)c, 2);
   XMapWindow(disp, ewin->client.win);
   EDBUG_RETURN_;
}

void
ICCCM_MatchSize(EWin * ewin)
{
   int                 w, h;
   int                 i, j;
   double              aspect;

   EDBUG(6, "ICCCM_MatchSize");
   w = ewin->client.w;
   h = ewin->client.h;

   if (w < ewin->client.width.min)
      w = ewin->client.width.min;
   if (w > ewin->client.width.max)
      w = ewin->client.width.max;
   if (h < ewin->client.height.min)
      h = ewin->client.height.min;
   if (h > ewin->client.height.max)
      h = ewin->client.height.max;
   if ((w > 0) && (h > 0))
     {
	w -= ewin->client.base_w;
	h -= ewin->client.base_h;
	if ((w > 0) && (h > 0))
	  {
	     i = w / ewin->client.w_inc;
	     j = h / ewin->client.h_inc;
	     w = i * ewin->client.w_inc;
	     h = j * ewin->client.h_inc;
	     aspect = ((double)w) / ((double)h);
	     if (aspect < ewin->client.aspect_min)
		w = (int)((double)h * ewin->client.aspect_min);
	     else if (aspect > ewin->client.aspect_max)
		h = (int)((double)w / ewin->client.aspect_max);
	  }
	w += ewin->client.base_w;
	h += ewin->client.base_h;
     }
   ewin->client.w = w;
   ewin->client.h = h;
   EDBUG_RETURN_;
}

void
ICCCM_Configure(EWin * ewin)
{
   XEvent              ev;
   XWindowChanges      xwc;

   EDBUG(6, "ICCCM_Configure");
   xwc.x = ewin->border->border.left;
   xwc.y = ewin->border->border.top;
   xwc.width = ewin->client.w;
   xwc.height = ewin->client.h;
   XConfigureWindow(disp, ewin->client.win, CWX | CWY | CWWidth | CWHeight, &xwc);
   ev.type = ConfigureNotify;
   ev.xconfigure.display = disp;
   ev.xconfigure.event = ewin->client.win;
   ev.xconfigure.window = ewin->client.win;
   ev.xconfigure.x = desks.desk[ewin->desktop].x + ewin->x +
      ewin->border->border.left;
   ev.xconfigure.y = desks.desk[ewin->desktop].y + ewin->y +
      ewin->border->border.top;
   ev.xconfigure.width = ewin->client.w;
   ev.xconfigure.height = ewin->client.h;
   ev.xconfigure.border_width = 0;
   ev.xconfigure.above = ewin->win;
   ev.xconfigure.override_redirect = False;
   XSendEvent(disp, ewin->client.win, False, StructureNotifyMask, &ev);
   EDBUG_RETURN_;
}

void
ICCCM_Adopt(EWin * ewin, Window win)
{
   Atom                a;
   unsigned long       c[2];

   EDBUG(6, "ICCCM_Adopt");
   XAddToSaveSet(disp, win);
   XSetWindowBorderWidth(disp, win, 0);
   a = XInternAtom(disp, "WM_STATE", False);
   if (ewin->client.start_iconified)
      c[0] = IconicState;
   else
      c[0] = NormalState;
   c[1] = 0;
   XChangeProperty(disp, win, a, a, 32, PropModeReplace, (unsigned char *)c, 2);
   XReparentWindow(disp, win, ewin->win, ewin->border->border.left,
		   ewin->border->border.top);
   XSelectInput(disp, win, PropertyChangeMask | EnterWindowMask | LeaveWindowMask |
		FocusChangeMask | ResizeRedirectMask | StructureNotifyMask |
		ColormapChangeMask);
   XShapeSelectInput(disp, win, ShapeNotifyMask);
   ewin->x = ewin->client.x;
   ewin->y = ewin->client.y;
   ewin->w = ewin->client.w + ewin->border->border.left + ewin->border->border.right;
   ewin->h = ewin->client.h + ewin->border->border.top + ewin->border->border.bottom;
   EDBUG_RETURN_;
}

void
ICCCM_Focus(EWin * ewin)
{
   XClientMessageEvent ev;
   Atom                a1, a2, a3, *prop;
   unsigned long       lnum, ldummy;
   int                 num, i, foc, dummy;

   EDBUG(6, "ICCCM_Focus");
   a1 = XInternAtom(disp, "WM_TAKE_FOCUS", False);
   a2 = XInternAtom(disp, "WM_PROTOCOLS", False);
   num = 0;
   prop = NULL;
   foc = 0;
   if (!ewin)
     {
	XSetInputFocus(disp, root.win, RevertToPointerRoot, CurrentTime);
	if (mode.current_cmap)
	  {
	     XUninstallColormap(disp, mode.current_cmap);
	     mode.current_cmap = 0;
	  }
	EDBUG_RETURN_;
     }
   if (!XGetWMProtocols(disp, ewin->client.win, &prop, &num))
     {
	XGetWindowProperty(disp, ewin->client.win, a2, 0, 10, False, a2, &a3, &dummy,
			   &lnum, &ldummy, (unsigned char **)&prop);
	num = (int)lnum;
     }
   if (prop)
     {
	for (i = 0; i < num; i++)
	   if (prop[i] == a1)
	      foc = 1;
	XFree(prop);
     }
   if (foc)
     {
	ev.type = ClientMessage;
	ev.window = ewin->client.win;
	ev.message_type = a2;
	ev.format = 32;
	ev.data.l[0] = a1;
	ev.data.l[1] = CurrentTime;
	XSendEvent(disp, ewin->client.win, False, 0, (XEvent *) & ev);
     }
/*   else */
   XSetInputFocus(disp, ewin->client.win, RevertToPointerRoot, CurrentTime);
   if (ewin->client.cmap)
     {
	XInstallColormap(disp, ewin->client.cmap);
	mode.current_cmap = ewin->client.cmap;
     }
   EDBUG_RETURN_;
}

void
ICCCM_GetGeoms(EWin * ewin)
{
   XSizeHints          hint;
   Window              ww;
   long                mask;
   unsigned int        dummy, w, h;
   int                 x, y;

   EDBUG(6, "ICCCM_GetGeoms");
   XGetGeometry(disp, ewin->client.win, &ww, &x, &y, &w, &h, &dummy, &dummy);
   ewin->client.w = w;
   ewin->client.h = h;
   if (XGetWMNormalHints(disp, ewin->client.win, &hint, &mask))
     {
	if (!(ewin->client.already_placed))
	  {
	     if (((x != hint.x) || (y != hint.y)) && (hint.x != 0) && (hint.y != 0))
	       {
		  x = hint.x;
		  y = hint.y;
	       }
	     if ((hint.flags & USPosition) ||
		 ((hint.flags & PPosition) && (ewin->client.transient)))
	       {
		  if (hint.flags & PWinGravity)
		    {
		       switch (hint.win_gravity)
			 {
			 case NorthWestGravity:
			    ewin->client.x = x;
			    ewin->client.y = y;
			    break;
			 case NorthGravity:
			    ewin->client.x = x - (w >> 1);
			    ewin->client.y = y;
			    break;
			 case NorthEastGravity:
			    ewin->client.x = x - w;
			    ewin->client.y = y;
			    break;
			 case EastGravity:
			    ewin->client.x = x - w;
			    ewin->client.y = y - (h >> 1);
			    break;
			 case SouthEastGravity:
			    ewin->client.x = x - w;
			    ewin->client.y = y - h;
			    break;
			 case SouthGravity:
			    ewin->client.x = x - (w >> 1);
			    ewin->client.y = y - h;
			    break;
			 case SouthWestGravity:
			    ewin->client.x = x;
			    ewin->client.y = y - h;
			    break;
			 case WestGravity:
			    ewin->client.x = x;
			    ewin->client.y = y - (h >> 1);
			    break;
			 case CenterGravity:
			    ewin->client.x = x - (w >> 1);
			    ewin->client.y = y - (h >> 1);
			    break;
			 default:
			    break;
			 }
		    }
		  else
		    {
		       ewin->client.x = x;
		       ewin->client.y = y;
		    }
		  ewin->client.already_placed = 1;
	       }
	  }
	else
	  {
	     ewin->client.x = 0;
	     ewin->client.y = 0;
	     ewin->client.already_placed = 0;
	  }
	if (hint.flags & PMinSize)
	  {
	     ewin->client.width.min = hint.min_width;
	     ewin->client.height.min = hint.min_height;
	  }
	else
	  {
	     ewin->client.width.min = 0;
	     ewin->client.height.min = 0;
	  }
	if (hint.flags & PMaxSize)
	  {
	     ewin->client.width.max = hint.max_width;
	     ewin->client.height.max = hint.max_height;
	  }
	else
	  {
	     ewin->client.width.max = 65535;
	     ewin->client.height.max = 65535;
	  }
	if (hint.flags & PResizeInc)
	  {
	     ewin->client.w_inc = hint.width_inc;
	     ewin->client.h_inc = hint.height_inc;
	     if (ewin->client.w_inc < 1)
		ewin->client.w_inc = 1;
	     if (ewin->client.h_inc < 1)
		ewin->client.h_inc = 1;
	  }
	else
	  {
	     ewin->client.w_inc = 1;
	     ewin->client.h_inc = 1;
	  }
	if (hint.flags & PAspect)
	  {
	     if ((hint.min_aspect.y > 0.0) && (hint.min_aspect.x > 0.0))
	       {
		  ewin->client.aspect_min = ((double)hint.min_aspect.x) /
		     ((double)hint.min_aspect.y);
	       }
	     else
		ewin->client.aspect_min = 0.0;
	     if ((hint.max_aspect.y > 0.0) && (hint.max_aspect.x > 0.0))
	       {
		  ewin->client.aspect_max = ((double)hint.max_aspect.x) /
		     ((double)hint.max_aspect.y);
	       }
	     else
		ewin->client.aspect_max = 65535.0;
	  }
	else
	  {
	     ewin->client.aspect_min = 0.0;
	     ewin->client.aspect_max = 65535.0;
	  }
	if (hint.flags & PBaseSize)
	  {
	     if (!(hint.flags & PMaxSize))
	       {
		  ewin->client.width.min = hint.base_width;
		  ewin->client.height.min = hint.base_height;
	       }
	     ewin->client.base_w = hint.base_width;
	     ewin->client.base_h = hint.base_height;
	  }
	else
	  {
	     ewin->client.base_w = ewin->client.width.min;
	     ewin->client.base_h = ewin->client.height.min;
	  }
	if (ewin->client.width.min < 1)
	   ewin->client.width.min = 1;
	if (ewin->client.height.min < 1)
	   ewin->client.height.min = 1;
     }
   ewin->client.no_resize_h = 0;
   ewin->client.no_resize_v = 0;
   if (ewin->client.width.min == ewin->client.width.max)
      ewin->client.no_resize_h = 1;
   if (ewin->client.height.min == ewin->client.height.max)
      ewin->client.no_resize_v = 1;
   EDBUG_RETURN_;
}

void
ICCCM_GetInfo(EWin * ewin)
{
   XClassHint          hint;
   XTextProperty       xtp;
   int                 cargc, i, size;
   char              **cargv, *s;

   EDBUG(6, "ICCCM_GetInfo");
   if (XGetClassHint(disp, ewin->client.win, &hint))
     {
	if (ewin->client.name)
	   Efree(ewin->client.name);
	if (ewin->client.class)
	   Efree(ewin->client.class);
	ewin->client.name = duplicate(hint.res_name);
	ewin->client.class = duplicate(hint.res_class);
	XFree(hint.res_name);
	XFree(hint.res_class);
     }
   else
     {
	ewin->client.name = NULL;
	ewin->client.class = NULL;
     }
   if (XGetCommand(disp, ewin->client.win, &cargv, &cargc))
     {
	size = strlen(cargv[0]) + 1;
	s = Emalloc(size);
	strcpy(s, cargv[0]);
	for (i = 1; i < cargc; i++)
	  {
	     size += strlen(cargv[i]) + 1;
	     s = Erealloc(s, size);
	     strcat(s, " ");
	     strcat(s, cargv[i]);
	  }
	XFreeStringList(cargv);
	if (ewin->client.command)
	   Efree(ewin->client.command);
	ewin->client.command = s;
     }
   else
      ewin->client.command = NULL;
   if (XGetWMClientMachine(disp, ewin->client.win, &xtp))
     {
	if (ewin->client.machine)
	   Efree(ewin->client.machine);
	ewin->client.machine = duplicate((char *)xtp.value);
	XFree(xtp.value);
     }
   else
      ewin->client.machine = NULL;
   if (XGetWMIconName(disp, ewin->client.win, &xtp))
     {
	if (ewin->client.icon_name)
	   Efree(ewin->client.icon_name);
	ewin->client.icon_name = duplicate((char *)xtp.value);
	XFree(xtp.value);
     }
   else
      ewin->client.icon_name = NULL;
   EDBUG_RETURN_;
}

void
ICCCM_GetHints(EWin * ewin)
{
   XWMHints           *hint;
   Window              w;

   EDBUG(6, "ICCCM_GetHints");
   MWM_GetHints(ewin);
   GNOME_GetHints(ewin);
   hint = XGetWMHints(disp, ewin->client.win);
   if (!hint)
      EDBUG_RETURN_;
   if (hint->flags & InputHint)
     {
	if (hint->input)
	   ewin->client.need_input = 1;
	else
	   ewin->client.need_input = 0;
     }
   else
      ewin->client.need_input = 0;
   if (hint->flags & StateHint)
     {
	if (hint->initial_state == IconicState)
	   ewin->client.start_iconified = 1;
	else
	   ewin->client.start_iconified = 0;
     }
   else
      ewin->client.start_iconified = 0;
   if (hint->flags & IconPixmapHint)
      ewin->client.icon_pmap = hint->icon_pixmap;
   else
      ewin->client.icon_pmap = 0;
   if (hint->flags & IconMaskHint)
      ewin->client.icon_mask = hint->icon_mask;
   else
      ewin->client.icon_mask = 0;
   if (hint->flags & IconWindowHint)
      ewin->client.icon_win = hint->icon_window;
   else
      ewin->client.icon_win = 0;
   if (hint->flags & WindowGroupHint)
      ewin->client.group = hint->window_group;
   else
      ewin->client.group = 0;
   XFree(hint);
   if (XGetTransientForHint(disp, ewin->client.win, &w))
      ewin->client.transient = 1;
   else
      ewin->client.transient = 0;
   if (ewin->client.group == ewin->client.win)
      ewin->client.is_group_leader = 1;
   else
      ewin->client.is_group_leader = 0;
   EDBUG_RETURN_;
}

void
ICCCM_GetShapeInfo(EWin * ewin)
{
   XRectangle         *rl = NULL;
   int                 rn = 0, ord;
   int                 x, y;
   unsigned int        w, h, d;
   Window              rt;

   EDBUG(6, "ICCCM_GetShapeInfo");
   GrabX();
   XGetGeometry(disp, ewin->client.win, &rt, &x, &y, &w, &h, &d, &d);
   rl = XShapeGetRectangles(disp, ewin->client.win, ShapeBounding, &rn, &ord);
   UngrabX();
   if (rn < 1)
      ewin->client.shaped = 1;
   else if (rn == 1)
     {
	if ((rl[0].x == 0) && (rl[0].y == 0) &&
	    (rl[0].width == w) && (rl[0].height == h))
	   ewin->client.shaped = 0;
     }
   else
      ewin->client.shaped = 1;
   if ((rl) && (rn > 0))
      XFree(rl);
   EDBUG_RETURN_;
}

void
ICCCM_SetIconSizes()
{
   XIconSize          *is;

   EDBUG(6, "ICCCM_SetIconSizes");
   is = XAllocIconSize();
   is->min_width = 8;
   is->min_height = 8;
   is->max_width = 32;
   is->max_height = 32;
   is->width_inc = 1;
   is->height_inc = 1;
   XSetIconSizes(disp, root.win, is, 1);
   XFree(is);
   EDBUG_RETURN_;
}
