
#include "E.h"

typedef struct _WAVFormatChunk
  {
     char                chunkID[4];
     int                 chunkSize;

     short               wFormatTag;
     unsigned short      wChannels;
     unsigned int        dwSamplesPerSec;
     unsigned int        dwAvgBytesPerSec;
     unsigned short      wBlockAlign;
     unsigned short      wBitsPerSample;
  }
WAVFormatChunk;

Sample             *
LoadWav(char *file)
{
   FILE               *f;
   Sample             *s;
   char                buf[4];
   char                str[FILEPATH_LEN_MAX];
   char                found = 0;
   WAVFormatChunk      fmt;
   int                 skipl = 0;
   int                 skipr = 0;
   char                bytes = 0;
   char                stereo = 0;
   int                 len;

   /* int                 count; */

   EDBUG(5, "LoadWav");
#ifdef HAVE_LIBESD
   if (exists(file))
     {
	found = 1;
	Esnprintf(str, sizeof(str), "%s", file);
     }
   if (!found)
     {
	if (themepath[0])
	  {
	     Esnprintf(str, sizeof(str), "%s/%s", themepath, file);
	     if (exists(str))
	       {
		  found = 1;
	       }
	  }
	if (!found)
	  {
	     Esnprintf(str, sizeof(str), "%s/.enlightenment/%s", homedir(getuid()), file);
	     if (!exists(str))
	       {
		  Esnprintf(str, sizeof(str), "%s/config/%s", ENLIGHTENMENT_ROOT, file);
		  if (!exists(str))
		    {
		       Esnprintf(str, sizeof(str), "Warning!  Enlightenment was unable "
				 "to load the\nfollowing sound file:\n%s\n"
			   "Enlightenment will continue to operate, but you\n"
			   "may wish to check your configuration settings.\n",
				 file);
		       Alert(str);
		       Esnprintf(str, sizeof(str), "%s/config/%s", ENLIGHTENMENT_ROOT, file);
		    }
	       }
	  }
     }
   f = fopen(str, "r");
   if (!f)
      EDBUG_RETURN(NULL);
   s = Emalloc(sizeof(Sample));
   if (!s)
     {
	fclose(f);
	EDBUG_RETURN(NULL);
     }
   s->rate = 44100;
   s->format = ESD_STREAM | ESD_PLAY;
   s->samples = 0;
   s->data = NULL;
   s->id = 0;
   fread(buf, 1, 4, f);
   if ((buf[0] != 'R') ||
       (buf[1] != 'I') ||
       (buf[2] != 'F') ||
       (buf[3] != 'F'))
     {
	/* not a RIFF WAV file */
	fclose(f);
	Efree(s);
	EDBUG_RETURN(NULL);
     }
   fread(buf, 1, 4, f);
   fread(buf, 1, 4, f);
   fread(&fmt, sizeof(WAVFormatChunk), 1, f);
   if ((fmt.chunkID[0] == 'f') &&
       (fmt.chunkID[1] == 'm') &&
       (fmt.chunkID[2] == 't') &&
       (fmt.chunkID[3] == ' '))
      /* fmt chunk */
     {
	if (fmt.wFormatTag != 1)
	  {
	     /* unknown WAV encoding format - exit */
	     fclose(f);
	     Efree(s);
	     EDBUG_RETURN(NULL);
	  }
	skipl = 0;
	skipr = 0;
	bytes = 0;
	stereo = 0;
	if (fmt.wChannels == 1)
	   s->format |= ESD_MONO;
	else if (fmt.wChannels == 2)
	  {
	     stereo = 1;
	     s->format |= ESD_STEREO;
	  }
	else
	  {
	     stereo = 1;
	     s->format |= ESD_STEREO;
	     if (fmt.wChannels == 3)
	       {
		  skipl = 0;
		  skipr = 1;
	       }
	     else if (fmt.wChannels == 4)
	       {
		  skipl = 0;
		  skipr = 2;
	       }
	     else if (fmt.wChannels == 4)
	       {
		  skipl = 0;
		  skipr = 2;
	       }
	     else if (fmt.wChannels == 6)
	       {
		  skipl = 3;
		  skipr = 1;
	       }
	     else
	       {
		  /* unknown channel encoding */
		  fclose(f);
		  Efree(s);
		  EDBUG_RETURN(NULL);
	       }
	  }
	s->rate = fmt.dwSamplesPerSec;
	if (fmt.wBitsPerSample <= 8)
	  {
	     bytes = 1;
	     s->format |= ESD_BITS8;
	  }
	else if (fmt.wBitsPerSample <= 16)
	   s->format |= ESD_BITS16;
	else
	  {
	     /* unknown bits encoding encoding */
	     fclose(f);
	     Efree(s);
	     EDBUG_RETURN(NULL);
	  }
     }
   for (;;)
     {
	if (fread(buf, 1, 4, f) &&
	    fread(&len, 4, 1, f))
	  {
	     if ((buf[0] != 'd') ||
		 (buf[1] != 'a') ||
		 (buf[2] != 't') ||
		 (buf[3] != 'a'))
		fseek(f, len, SEEK_CUR);
	     else
	       {
		  s->data = Emalloc(len);
		  if (!s->data)
		    {
		       fclose(f);
		       Efree(s);
		       EDBUG_RETURN(NULL);
		    }
		  if ((skipl == 0) && (skipr == 0) && (!bytes))
		    {
		       fread(s->data, len, 1, f);
		    }
		  else
		    {
		    }
		  s->samples = len;
		  if (stereo)
		     s->samples /= 2;
		  if (!bytes)
		     s->samples /= 2;
		  fclose(f);
		  EDBUG_RETURN(s);
	       }
	  }
	else
	  {
	     fclose(f);
	     EDBUG_RETURN(NULL);
	  }
     }
   fclose(f);
   Efree(s);
   if (s->data)
      Efree(s->data);
#endif
   EDBUG_RETURN(NULL);
}

void
SoundPlay(Sample * s)
{
   int                 size;

   int                 confirm = 0;

   EDBUG(5, "SoundPlay");
#ifdef HAVE_LIBESD
   if ((sound_fd < 0) || (!mode.sound) || (!s))
      EDBUG_RETURN_;
   size = s->samples;
   if (s->format & ESD_STEREO)
      size *= 2;

   /* #if 1 for esound-0.2.3, #if 0 for esound > 0.2.3 */
#if 0
   if (!s->id)
     {
	int                 fd = -1;

	fd = esd_open_sound("Enlightenment");
	if (fd >= 0)
	  {
	     if (s->data)
	       {
		  s->id = esd_sample_cache(fd, s->format, s->rate, size * 2);
		  write(fd, s->data, size * 2);
		  Efree(s->data);
		  s->data = NULL;
	       }
	     close(fd);
	  }
     }
   esd_sample_play(sound_fd, s->id);
   fsync(sound_fd);
#else
   if (!s->id)
     {
	if (sound_fd >= 0)
	  {
	     if (s->data)
	       {
		  /* "name" of all samples is currently "E", should be name of sound 
		   * file, or event type, for later identification */
		  s->id = esd_sample_cache(sound_fd, s->format, s->rate,
					   size * 2, "E");
		  write(sound_fd, s->data, size * 2);
		  confirm = esd_confirm_sample_cache(sound_fd);
		  if (s->id <= 0 || confirm != s->id)
		    {
		       printf("SoundPlay: error caching sample <%d>!\n", s->id);
		       s->id = 0;
		    }
		  Efree(s->data);
		  s->data = NULL;
	       }
	  }
     }

   if (s->id > 0)
      esd_sample_play(sound_fd, s->id);

   fsync(sound_fd);
#endif

#endif
   EDBUG_RETURN_;
}

SoundClass         *
CreateSoundClass(char *name, char *file)
{
   SoundClass         *sclass;

   EDBUG(6, "CreateSoundClass");
   sclass = Emalloc(sizeof(SoundClass));
   if (!sclass)
      EDBUG_RETURN(NULL);
   sclass->name = duplicate(name);
   sclass->file = duplicate(file);
   sclass->sample = NULL;
   EDBUG_RETURN(sclass);
}

void
ApplySclass(SoundClass * sclass)
{
   char               *f;

   EDBUG(4, "ApplySclass");
   if (!sclass)
      EDBUG_RETURN_;
#ifdef HAVE_LIBESD
   if (!sclass->sample)
     {
	f = FindFile(sclass->file);
	if (f)
	  {
	     sclass->sample = LoadWav(f);
	     Efree(f);
	  }
     }
#endif
   SoundPlay(sclass->sample);
   EDBUG_RETURN_;
}

void
DestroySample(Sample * s)
{
   EDBUG(5, "DestroySample");

#ifdef HAVE_LIBESD
   if ((s->id) && (sound_fd >= 0))
     {
/*      Why the hell is this symbol not in esd? */
/*      it's in esd.h - evil evil evil */
/*      esd_sample_kill(sound_fd,s->id); */
	esd_sample_free(sound_fd, s->id);
     }
#endif
   if (s->data)
      Efree(s->data);
   Efree(s);
   EDBUG_RETURN_;
}

void
DestroySclass(SoundClass * sclass)
{
   if (!sclass)
      EDBUG_RETURN_;

   EDBUG(5, "DestroySclass");
   if (sclass->name)
      Efree(sclass->name);
   if (sclass->file)
      Efree(sclass->file);
   if (sclass->sample)
      DestroySample(sclass->sample);
   Efree(sclass);
   EDBUG_RETURN_;
}

void
SoundInit()
{
   int                 fd;

   EDBUG(5, "SoundInit");
#ifdef HAVE_LIBESD
   sound_fd = -1;
   if (!mode.sound)
      EDBUG_RETURN_;
   fd = esd_open_sound(NULL);
   if (fd >= 0)
      sound_fd = fd;
   else
     {
	execApplication("esd");
	sleep(2);
	fd = esd_open_sound(NULL);
	if (fd >= 0)
	   sound_fd = fd;
	else
	  {
	     Alert("Audio has been turned on for Enlightenment, but\n"
		   "Enlightenment is unable to find the ESD sound server or\n"
		   "run it.\n"
		   "As a result Audio will now be turned off.\n"
		   "You can safely hit Left Button for OK and Enlightenment\n"
		   "will continue to run without audio.\n"
		   "\n"
		   "Hitting middle or right button to Restart or Quit is\n"
		   "also an option if you believe ESD should be runing but\n"
		   "isn't and you wish to fix it.\n"
		   "It could be the esd executable is not in the PATH for\n"
		   "your shell.\n"
		   "\n"
		   "If audio is not meant to work on your system, then\n"
		   "please disable it now to avoid messages like this in\n"
		   "future\n");
	     mode.sound = 0;
	  }
     }
#else
   mode.sound = 0;
#endif
   EDBUG_RETURN_;
}

void
SoundExit()
{
   SoundClass        **lst;
   int                 num, i;

   EDBUG(6, "SoundExit");
   if (sound_fd >= 0)
     {
	lst = (SoundClass **) ListItemType(&num, LIST_TYPE_SCLASS);
	if (lst)
	  {
	     for (i = 0; i < num; i++)
	       {
		  if (lst[i]->sample)
		     DestroySample(lst[i]->sample);
		  lst[i]->sample = NULL;
	       }
	     Efree(lst);
	  }
	close(sound_fd);
	sound_fd = -1;
     }
   EDBUG_RETURN_;
}
