/*
	Copyright (C) 1994	Edward Der-Hua Liu, Hsin-Chu, Taiwan
*/

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>

extern void init_f(char *file);
extern void upload_keyword(KeySym kk, char *str);
extern void write_phr();


struct keystruc {
	char *kname;
	KeySym ksym;
} tran[]={
{"0", '0'}, {"1", '1'}, {"2", '2'}, {"3", '3'}, {"4", '4'}, {"5", '5'},
{"6", '6'}, {"7", '7'}, {"8", '8'}, {"9", '9'},
{"a", 'a'}, {"b", 'b'}, {"c", 'c'}, {"d", 'd'}, {"e", 'e'}, {"f", 'f'},
{"g", 'g'}, {"h", 'h'}, {"i", 'i'}, {"j", 'j'}, {"k", 'k'}, {"l", 'l'},
{"m", 'm'}, {"n", 'n'}, {"o", 'o'}, {"p", 'p'}, {"q", 'q'}, {"r", 'r'},
{"s", 's'}, {"t", 't'}, {"u", 'u'}, {"v", 'v'}, {"w", 'w'}, {"x", 'x'},
{"y", 'y'}, {"z", 'z'},
{",", '<'}, {".", '>'}, {";", ':'}, {"/", '?'}, {"[", '{'}, {"]", '}'},
{"f1",XK_F1},{"f2",XK_F2},{"f3",XK_F3},{"f4",XK_F4},{"f5",XK_F5},{"f6",XK_F6},
{"f7",XK_F7},{"f8",XK_F8},{"f9",XK_F9},{"f10",XK_F10},{"f11",XK_F11},
{"f12",XK_F12},
{"k_ins", XK_Insert}, {"k_del", XK_Delete},
{"k_end", XK_End}, {"k_down",XK_Down},{"k_pgdn",XK_Next},{"k_left",XK_Left},
{"k_5",XK_Begin},{"k_right", XK_Right}, {"k_home",XK_Home},
{"k_up",XK_Up}, {"k_pgup",XK_Prior},
{"kp0", XK_KP_0}, {"kp.", XK_KP_Decimal},
{"kp1", XK_KP_1}, {"kp2",XK_KP_2}, {"kp3",XK_KP_3}, {"kp4",XK_KP_4},
{"kp5", XK_KP_5}, {"kp6", XK_KP_6}, {"kp7", XK_KP_7},
{"kp8", XK_KP_8}, {"kp9", XK_KP_9},
{"kp/",XK_KP_Divide}, {"kp*", XK_KP_Multiply}, {"kp-", XK_KP_Subtract},
{"kp+",XK_KP_Add}, {"kpenter",XK_KP_Enter}
};

int keynum=sizeof(tran)/sizeof(struct keystruc);

int main(int argc, char **argv)
{
FILE *fp;
char kname[32];
char str[256];
/*KeySym ks;*/
char ttt[512];
int i, /*slen,*/j;

if (argc<=1) {
	printf("Usage:  %s phrase_file\n", argv[0]);
	exit(1);
}
	
if ((fp=fopen(argv[1],"r"))==NULL) {
  printf("cannot open %s\n", argv[1]); exit(-1);
}

init_f(argv[1]);

while (!feof(fp)) {
	kname[0]=str[0]=0;
	fgets(ttt, sizeof(ttt), fp);
	if (ttt[0]=='#') continue;
	for(i=0; ttt[i]!=' ' && ttt[i]!=9 && ttt[i]; i++)
		kname[i]=ttt[i];
	kname[i]=0;
        while((ttt[i]==' ' || ttt[i]==9) && ttt[i]) i++;
	for(j=0;ttt[i]!='\n' && ttt[i]; i++,j++)
		str[j]=ttt[i];
	if (!str[0] || !kname[0]) continue;
	str[j]=0;
	for(i=0;i<keynum;i++)
          if (!strcmp(kname,tran[i].kname)) {
/*		printf("%X %s:%d  %s\n",tran[i].ksym, 
			tran[i].kname,strlen(str), str); */
		upload_keyword(tran[i].ksym, str);
		break;
	}
	if (i==keynum) printf("unknown key: %s\n", kname);
}
write_phr();
return 0;
}
