;*=====================================================================*/
;*    serrano/prgm/project/bigloo/contrib/format/test.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Dirk Lutzebaeck                                   */
;*    Creation    :  Wed Mar  4 09:27:04 1998                          */
;*    Last change :  Thu Mar 12 07:41:08 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Various format tests.                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module test
   (import  (format "format.scm"))
   (main    test-format))

;*---------------------------------------------------------------------*/
;*    fmt-test ...                                                     */
;*---------------------------------------------------------------------*/
(define-macro (fmt-test expr res)
   `(let ((val (apply format ,expr)))
       (print "format: provided: " val
	      "  expected: " ,res
	      (if (equal? ,res val)
		  " ok."
		  " error."))))

;*---------------------------------------------------------------------*/
;*    test-format ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-format argv)
   (print "Testing format...")

   (set! format:symbol-case-conv #f)
   (set! format:iobj-case-conv #f)
   (set! format:read-proof #f)

   (fmt-test '("abc") "abc")
   (fmt-test '("~a" 10) "10")
   (fmt-test '("~a" -1.2) "-1.2")
   (fmt-test `("~a" ,(string->symbol "a")) "a")
   (fmt-test '("~a" #t) "#t")
   (fmt-test '("~a" #f) "#f")
   (fmt-test '("~a" "abc") "abc")
   (fmt-test '("~a" #(1 2 3)) "#(1 2 3)")
   (fmt-test '("~a" ()) "()")
   (fmt-test `("~a" ,(list (string->symbol "a"))) "(a)")
   (fmt-test `("~a" ,(list (string->symbol "a") (string->symbol "b"))) "(a b)")
   (fmt-test '("~a" (a (b c) d)) "(A (B C) D)")
   (fmt-test '("~a" (a . b)) "(A . B)")
   (fmt-test '("~a" (a (b c . d))) "(A (B . (C . D)))") 

					; # argument test

   (fmt-test '("~a ~a" 10 20) "10 20")
   (fmt-test '("~a abc ~a def" 10 20) "10 abc 20 def")

					; numerical test

   (fmt-test '("~d" 100) "100")
   (fmt-test '("~x" 100) "64")
   (fmt-test '("~o" 100) "144")
   (fmt-test '("~b" 100) "???")
   (fmt-test '("~@d" 100) "+100")
   (fmt-test '("~@d" -100) "-100")
   (fmt-test '("~@x" 100) "+64")
   (fmt-test '("~@o" 100) "+144")
   (fmt-test '("~@b" 100) "+???")
   (fmt-test '("~10d" 100) "       100")
   (fmt-test '("~:d" 123) "123")
   (fmt-test '("~:d" 1234) "1,234")
   (fmt-test '("~:d" 12345) "12,345")
   (fmt-test '("~:d" 123456) "123,456")
   (fmt-test '("~:d" 12345678) "12,345,678")
   (fmt-test '("~:d" -123) "-123")
   (fmt-test '("~:d" -1234) "-1,234")
   (fmt-test '("~:d" -12345) "-12,345")
   (fmt-test '("~:d" -123456) "-123,456")
   (fmt-test '("~:d" -12345678) "-12,345,678")
   (fmt-test '("~10:d" 1234) "     1,234")
   (fmt-test '("~10:d" -1234) "    -1,234")
   (fmt-test '("~10,'*d" 100) "*******100")
   (fmt-test '("~10,,'|:d" 12345678) "12|345|678")
   (fmt-test '("~10,,,2:d" 12345678) "12,34,56,78")
   (fmt-test '("~14,'*,'|,4:@d" 12345678) "****+1234|5678")
   (fmt-test '("~10r" 100) "100")
   (fmt-test '("~2r" 100) "???")
   (fmt-test '("~8r" 100) "144")
   (fmt-test '("~16r" 100) "64")
   (fmt-test '("~16,10,'*r" 100) "********64")

   ; roman numeral test

   (fmt-test '("~@r" 4) "IV")
   (fmt-test '("~@r" 19) "XIX")
   (fmt-test '("~@r" 50) "L")
   (fmt-test '("~@r" 100) "C")
   (fmt-test '("~@r" 1000) "M")
   (fmt-test '("~@r" 99) "XCIX")
   (fmt-test '("~@r" 1994) "MCMXCIV")

   ; old roman numeral test

   (fmt-test '("~:@r" 4) "IIII")
   (fmt-test '("~:@r" 5) "V")
   (fmt-test '("~:@r" 10) "X")
   (fmt-test '("~:@r" 9) "VIIII")

   ; cardinal/ordinal English number test

   (fmt-test '("~r" 4) "four")
   (fmt-test '("~r" 10) "ten")
   (fmt-test '("~r" 19) "nineteen")
   (fmt-test '("~r" 1984) "one thousand, nine hundred eighty-four")
   (fmt-test '("~:r" -1984) "minus one thousand, nine hundred eighty-fourth")

   ; character test
   
   (fmt-test '("~c" #\a) "a")
   (fmt-test '("~@c" #\a) "#\\a")
   (fmt-test `("~@c" ,(integer->char 32)) "#\\space")
   (fmt-test `("~@c" ,(integer->char 0)) "#\\nul")
   (fmt-test `("~@c" ,(integer->char 27)) "#\\esc")
   (fmt-test `("~@c" ,(integer->char 127)) "#\\del")
   (fmt-test `("~@c" ,(integer->char 128)) "#\\200")
   (fmt-test `("~@c" ,(integer->char 255)) "#\\377")
   (fmt-test '("~65c") "A")
   (fmt-test '("~7@c") "#\\bel")
   (fmt-test '("~:c" #\a) "a")
   (fmt-test `("~:c" ,(integer->char 1)) "^A")
   (fmt-test `("~:c" ,(integer->char 27)) "^[")
   (fmt-test '("~7:c") "^G")
   (fmt-test `("~:c" ,(integer->char 128)) "#\\200")
   (fmt-test `("~:c" ,(integer->char 127)) "#\\177")
   (fmt-test `("~:c" ,(integer->char 255)) "#\\377")


   ; plural test

   (fmt-test '("test~p" 1) "test")
   (fmt-test '("test~p" 2) "tests")
   (fmt-test '("test~p" 0) "tests")
   (fmt-test '("tr~@p" 1) "try")
   (fmt-test '("tr~@p" 2) "tries")
   (fmt-test '("tr~@p" 0) "tries")
   (fmt-test '("~a test~:p" 10) "10 tests")
   (fmt-test '("~a test~:p" 1) "1 test")

   ; tilde test

   (fmt-test '("~~~~") "~~")
   (fmt-test '("~3~") "~~~")

   ; whitespace character test

   (fmt-test '("~%") "
")
   (fmt-test '("~3%") "


")
   (fmt-test '("~&") "")
   (fmt-test '("abc~&") "abc
")
   (fmt-test '("abc~&def") "abc
def")
   (fmt-test '("~&") "
")
   (fmt-test '("~3&") "

")
   (fmt-test '("abc~3&") "abc


")
   (fmt-test '("~|") (string #a012))
   (fmt-test '("~_~_~_") "   ")
   (fmt-test '("~3_") "   ")
   (fmt-test '("~/") (string #a009))
   (fmt-test '("~3/") (make-string 3 #a009))

   ; tabulate test

   (fmt-test '("~0&~3t") "   ")
   (fmt-test '("~0&~10t") "          ")
   (fmt-test '("~10t") "")
   (fmt-test '("~0&1234567890~,8tABC")  "1234567890       ABC")
   (fmt-test '("~0&1234567890~0,8tABC") "1234567890      ABC")
   (fmt-test '("~0&1234567890~1,8tABC") "1234567890       ABC")
   (fmt-test '("~0&1234567890~2,8tABC") "1234567890ABC")
   (fmt-test '("~0&1234567890~3,8tABC") "1234567890 ABC")
   (fmt-test '("~0&1234567890~4,8tABC") "1234567890  ABC")
   (fmt-test '("~0&1234567890~5,8tABC") "1234567890   ABC")
   (fmt-test '("~0&1234567890~6,8tABC") "1234567890    ABC")
   (fmt-test '("~0&1234567890~7,8tABC") "1234567890     ABC")
   (fmt-test '("~0&1234567890~8,8tABC") "1234567890      ABC")
   (fmt-test '("~0&1234567890~9,8tABC") "1234567890       ABC")
   (fmt-test '("~0&1234567890~10,8tABC") "1234567890ABC")
   (fmt-test '("~0&1234567890~11,8tABC") "1234567890 ABC")
   (fmt-test '("~0&12345~,8tABCDE~,8tXYZ") "12345    ABCDE   XYZ")
   (fmt-test '("~,8t+++~,8t===") "     +++     ===")
   (fmt-test '("~0&ABC~,8,'.tDEF") "ABC......DEF")
   (fmt-test '("~0&~3,8@tABC") "        ABC")
   (fmt-test '("~0&1234~3,8@tABC") "1234    ABC")
   (fmt-test '("~0&12~3,8@tABC~3,8@tDEF") "12      ABC     DEF")

   ; indirection test

   (fmt-test '("~a ~? ~a" 10 "~a ~a" (20 30) 40) "10 20 30 40")
   (fmt-test '("~a ~@? ~a" 10 "~a ~a" 20 30 40) "10 20 30 40")

   ; field test

   (fmt-test '("~10a" "abc") "abc       ")
   (fmt-test '("~10@a" "abc") "       abc")
   (fmt-test '("~10a" "0123456789abc") "0123456789abc")
   (fmt-test '("~10@a" "0123456789abc") "0123456789abc")

   ; pad character test

   (fmt-test '("~10,,,'*a" "abc") "abc*******")
   (fmt-test '("~10,,,'Xa" "abc") "abcXXXXXXX")
   (fmt-test '("~10,,,42a" "abc") "abc*******")
   (fmt-test '("~10,,,'*@a" "abc") "*******abc")
   (fmt-test '("~10,,3,'*a" "abc") "abc*******")
   (fmt-test '("~10,,3,'*a" "0123456789abc") "0123456789abc***")
   (fmt-test '("~10,,3,'*@a" "0123456789abc") "***0123456789abc")

   ; colinc, minpad padding test

   (fmt-test '("~10,8,0,'*a" 123)  "123********")
   (fmt-test '("~10,9,0,'*a" 123)  "123*********")
   (fmt-test '("~10,10,0,'*a" 123) "123**********")
   (fmt-test '("~10,11,0,'*a" 123) "123***********")
   (fmt-test '("~8,1,0,'*a" 123) "123*****")
   (fmt-test '("~8,2,0,'*a" 123) "123******")
   (fmt-test '("~8,3,0,'*a" 123) "123******")
   (fmt-test '("~8,4,0,'*a" 123) "123********")
   (fmt-test '("~8,5,0,'*a" 123) "123*****")
   (fmt-test '("~8,1,3,'*a" 123) "123*****")
   (fmt-test '("~8,1,5,'*a" 123) "123*****")
   (fmt-test '("~8,1,6,'*a" 123) "123******")
   (fmt-test '("~8,1,9,'*a" 123) "123*********")

   ; slashify test

   (fmt-test '("~s" "abc") "\"abc\"")
   (fmt-test '("~s" "abc \\ abc") "\"abc \\\\ abc\"")
   (fmt-test '("~a" "abc \\ abc") "abc \\ abc")
   (fmt-test '("~s" "abc \" abc") "\"abc \\\" abc\"")
   (fmt-test '("~a" "abc \" abc") "abc \" abc")
   (fmt-test '("~s" #\space) "#\\space")
   (fmt-test '("~s" #\newline) "#\\newline")
   (fmt-test '("~s" #\tab) "#\\ht")
   (fmt-test '("~s" #\a) "#\\a")
   (fmt-test '("~a" (a "b" c)) "(A \"b\" C)")

   ; symbol case force test

   (define format:old-scc format:symbol-case-conv)
   (set! format:symbol-case-conv string-upcase)
   (fmt-test '("~a" abc) "ABC")
   (set! format:symbol-case-conv string-downcase)
   (fmt-test '("~s" abc) "abc")
   (set! format:symbol-case-conv string-capitalize)
   (fmt-test '("~s" abc) "Abc")
   (set! format:symbol-case-conv format:old-scc)


   ; continuation line test

   (fmt-test '("abc~
         123") "abc123")
   (fmt-test '("abc~
123") "abc123")
   (fmt-test '("abc~
") "abc")
   (fmt-test '("abc~:
         def") "abc         def")
   (fmt-test '("abc~@
         def")
	     "abc
def")

   ; string case conversion

   (fmt-test '("~a ~(~a~) ~a" "abc" "HELLO WORLD" "xyz") "abc hello world xyz")
   (fmt-test '("~a ~:(~a~) ~a" "abc" "HELLO WORLD" "xyz") "abc Hello World xyz")
   (fmt-test '("~a ~@(~a~) ~a" "abc" "HELLO WORLD" "xyz") "abc Hello world xyz")
   (fmt-test '("~a ~:@(~a~) ~a" "abc" "hello world" "xyz") "abc HELLO WORLD xyz")
   (fmt-test '("~:@(~a~)" (a b c)) "(A B C)")
   (fmt-test '("~:@(~x~)" 255) "FF")
   (fmt-test '("~:@(~p~)" 2) "S")
   (fmt-test '("~:(~a ~a ~a~) ~a" "abc" "xyz" "123" "world") "Abc Xyz 123 world")

   ; variable parameter

   (fmt-test '("~va" 10 "abc") "abc       ")
   (fmt-test '("~v,,,va" 10 42 "abc") "abc*******")

   ; number of remaining arguments as parameter

   (fmt-test '("~#,,,'*@a ~a ~a ~a" 1 1 1 1) "***1 1 1 1")

   ; argument jumping

   (fmt-test '("~a ~* ~a" 10 20 30) "10  30")
   (fmt-test '("~a ~2* ~a" 10 20 30 40) "10  40")
   (fmt-test '("~a ~:* ~a" 10) "10  10")
   (fmt-test '("~a ~a ~2:* ~a ~a" 10 20) "10 20  10 20")
   (fmt-test '("~a ~a ~@* ~a ~a" 10 20) "10 20  10 20")
   (fmt-test '("~a ~a ~4@* ~a ~a" 10 20 30 40 50 60) "10 20  50 60")

   ; conditionals

   (fmt-test '("~[abc~;xyz~]" 0) "abc")
   (fmt-test '("~[abc~;xyz~]" 1) "xyz")
   (fmt-test '("~[abc~;xyz~:;456~]" 99) "456")
   (fmt-test '("~0[abc~;xyz~:;456~]") "abc")
   (fmt-test '("~1[abc~;xyz~:;456~] ~a" 100) "xyz 100")
   (fmt-test '("~#[no arg~;~a~;~a and ~a~;~a, ~a and ~a~]") "no arg")
   (fmt-test '("~#[no arg~;~a~;~a and ~a~;~a, ~a and ~a~]" 10) "10")
   (fmt-test '("~#[no arg~;~a~;~a and ~a~;~a, ~a and ~a~]" 10 20) "10 and 20")
   (fmt-test '("~#[no arg~;~a~;~a and ~a~;~a, ~a and ~a~]" 10 20 30) "10, 20 and 30")
   (fmt-test '("~:[hello~;world~] ~a" #t 10) "world 10")
   (fmt-test '("~:[hello~;world~] ~a" #f 10) "hello 10")
   (fmt-test '("~@[~a tests~]" #f) "")
   (fmt-test '("~@[~a tests~]" 10) "10 tests")
   (fmt-test '("~@[~a test~:p~] ~a" 10 done) "10 tests DONE")
   (fmt-test '("~@[~a test~:p~] ~a" 1 done) "1 test DONE")
   (fmt-test '("~@[~a test~:p~] ~a" 0 done) "0 tests DONE")
   (fmt-test '("~@[~a test~:p~] ~a" #f done) " DONE")
   (fmt-test '("~@[ level = ~d~]~@[ length = ~d~]" #f 5) " length = 5")
   (fmt-test '("~[abc~;~[4~;5~;6~]~;xyz~]" 0) "abc")
   (fmt-test '("~[abc~;~[4~;5~;6~]~;xyz~]" 2) "xyz")
   (fmt-test '("~[abc~;~[4~;5~;6~]~;xyz~]" 1 2) "6")

   ; iteration

   (fmt-test '("~{ ~a ~}" (a b c)) " A  B  C ")
   (fmt-test '("~{ ~a ~}" ()) "")
   (fmt-test '("~{ ~a ~5,,,'*a~}" (a b c d)) " A B**** C D****")
   (fmt-test '("~{ ~a,~a ~}" (a 1 b 2 c 3)) " A,1  B,2  C,3 ")
   (fmt-test '("~2{ ~a,~a ~}" (a 1 b 2 c 3)) " A,1  B,2 ")
   (fmt-test '("~3{~a ~} ~a" (a b c d e) 100) "A B C  100")
   (fmt-test '("~0{~a ~} ~a" (a b c d e) 100) " 100")
   (fmt-test '("~:{ ~a,~a ~}" ((a b) (c d e f) (g h))) " A,B  C,D  G,H ")
   (fmt-test '("~2:{ ~a,~a ~}" ((a b) (c d e f) (g h))) " A,B  C,D ")
   (fmt-test '("~@{ ~a,~a ~}" a 1 b 2 c 3) " A,1  B,2  C,3 ")
   (fmt-test '("~2@{ ~a,~a ~} <~a|~a>" a 1 b 2 c 3) " A,1  B,2  <C|3>")
   (fmt-test '("~:@{ ~a,~a ~}" (a 1) (b 2) (c 3)) " A,1  B,2  C,3 ")
   (fmt-test '("~2:@{ ~a,~a ~} ~a" (a 1) (b 2) (c 3)) " A,1  B,2  (C 3)")
   (fmt-test '("~{~}" "<~a,~a>" (a 1 b 2 c 3)) "<A,1><B,2><C,3>")
   (fmt-test '("~{ ~a ~{<~a>~}~} ~a" (a (1 2) b (3 4)) 10) " A <1><2> B <3><4> 10")

   ; up and out

   (fmt-test '("abc ~^ xyz") "abc ")
   (fmt-test '("~@(abc ~^ xyz~) ~a" 10) "ABC  xyz 10")
   (fmt-test '("done. ~^ ~d warning~:p. ~^ ~d error~:p.") "done. ")
   (fmt-test '("done. ~^ ~d warning~:p. ~^ ~d error~:p." 10) "done.  10 warnings. ")
   (fmt-test '("done. ~^ ~d warning~:p. ~^ ~d error~:p." 10 1)
	     "done.  10 warnings.  1 error.")
   (fmt-test '("~{ ~a ~^<~a>~} ~a" (a b c d e f) 10) " A <B> C <D> E <F> 10")
   (fmt-test '("~{ ~a ~^<~a>~} ~a" (a b c d e) 10) " A <B> C <D> E  10")
   (fmt-test '("abc~0^ xyz") "abc")
   (fmt-test '("abc~9^ xyz") "abc xyz")
   (fmt-test '("abc~7,4^ xyz") "abc xyz")
   (fmt-test '("abc~7,7^ xyz") "abc")
   (fmt-test '("abc~3,7,9^ xyz") "abc")
   (fmt-test '("abc~8,7,9^ xyz") "abc xyz")
   (fmt-test '("abc~3,7,5^ xyz") "abc xyz")

   ; complexity tests (oh my god, I hardly understand them myself (see CL std))

   (define fmt "Items:~#[ none~; ~a~; ~a and ~a~:;~@{~#[~; and~] ~a~^,~}~].")

   (fmt-test `(,fmt ) "Items: none.")
   (fmt-test `(,fmt foo) "Items: FOO.")
   (fmt-test `(,fmt foo bar) "Items: FOO and BAR.")
   (fmt-test `(,fmt foo bar baz) "Items: FOO, BAR, and BAZ.")
   (fmt-test `(,fmt foo bar baz zok) "Items: FOO, BAR, BAZ, and ZOK.")

   ; fixed floating points

   (cond
      (format:floats
       (fmt-test '("~6,2f" 3.14159) "  3.14")
       (fmt-test '("~6,1f" 3.14159) "   3.1")
       (fmt-test '("~6,0f" 3.14159) "    3.")
       (fmt-test '("~5,1f" 0) "  0.0")
       (fmt-test '("~10,7f" 3.14159) " 3.1415900")
       (fmt-test '("~10,7f" -3.14159) "-3.1415900")
       (fmt-test '("~10,7@f" 3.14159) "+3.1415900")
       (fmt-test '("~6,3f" 0.0) " 0.000")
       (fmt-test '("~6,4f" 0.007) "0.0070")
       (fmt-test '("~6,3f" 0.007) " 0.007")
       (fmt-test '("~6,2f" 0.007) "  0.01")
       (fmt-test '("~3,2f" 0.007) ".01")
       (fmt-test '("~3,2f" -0.007) "-.01")
       (fmt-test '("~6,2,,,'*f" 3.14159) "**3.14")
       (fmt-test '("~6,3,,'?f" 12345.56789) "??????")
       (fmt-test '("~6,3f" 12345.6789) "12345.679")
       (fmt-test '("~,3f" 12345.6789) "12345.679")
       (fmt-test '("~,3f" 9.9999) "10.000")
       (fmt-test '("~6f" 23.4) "  23.4")
       (fmt-test '("~6f" 1234.5) "1234.5")
       (fmt-test '("~6f" 12345678) "12345678.0")
       (fmt-test '("~6,,,'?f" 12345678) "??????")
       (fmt-test '("~6f" 123.56789) "123.57")
       (fmt-test '("~6f" 123.0) " 123.0")
       (fmt-test '("~6f" -123.0) "-123.0")
       (fmt-test '("~6f" 0.0) "   0.0")
       (fmt-test '("~3f" 3.141) "3.1")
       (fmt-test '("~2f" 3.141) "3.")
       (fmt-test '("~1f" 3.141) "3.141")
       (fmt-test '("~f" 123.56789) "123.56789")
       (fmt-test '("~f" -314.0) "-314.0")
       (fmt-test '("~f" 1e4) "10000.0")
       (fmt-test '("~f" -1.23e10) "-12300000000.0")
       (fmt-test '("~f" 1e-4) "0.0001")
       (fmt-test '("~f" -1.23e-10) "-0.000000000123")
       (fmt-test '("~@f" 314.0) "+314.0")
       (fmt-test '("~,,3f" 0.123456) "123.456")
       (fmt-test '("~,,-3f" -123.456) "-0.123456")
       (fmt-test '("~5,,3f" 0.123456) "123.5")
       ))

   ; exponent floating points

   (cond
      (format:floats
       (fmt-test '("~e" 3.14159) "3.14159E+0")
       (fmt-test '("~e" 0.00001234) "1.234E-5")
       (fmt-test '("~,,,0e" 0.00001234) "0.1234E-4")
       (fmt-test '("~,3e" 3.14159) "3.142E+0")
       (fmt-test '("~,3@e" 3.14159) "+3.142E+0")
       (fmt-test '("~,3@e" 0.0) "+0.000E+0")
       (fmt-test '("~,0e" 3.141) "3.E+0")
       (fmt-test '("~,3,,0e" 3.14159) "0.314E+1")
       (fmt-test '("~,5,3,-2e" 3.14159) "0.00314E+003")
       (fmt-test '("~,5,3,-5e" -3.14159) "-0.00000E+006")
       (fmt-test '("~,5,2,2e" 3.14159) "31.4159E-01")
       (fmt-test '("~,5,2,,,,'ee" 0.0) "0.00000e+00")
       (fmt-test '("~12,3e" -3.141) "   -3.141E+0")
       (fmt-test '("~12,3,,,,'#e" -3.141) "###-3.141E+0")
       (fmt-test '("~10,2e" -1.236e-4) "  -1.24E-4")
       (fmt-test '("~5,3e" -3.141) "-3.141E+0")
       (fmt-test '("~5,3,,,'*e" -3.141) "*****")
       (fmt-test '("~3e" 3.14159) "3.14159E+0")
       (fmt-test '("~4e" 3.14159) "3.14159E+0")
       (fmt-test '("~5e" 3.14159) "3.E+0")
       (fmt-test '("~5,,,,'*e" 3.14159) "3.E+0")
       (fmt-test '("~6e" 3.14159) "3.1E+0")
       (fmt-test '("~7e" 3.14159) "3.14E+0")
       (fmt-test '("~7e" -3.14159) "-3.1E+0")
       (fmt-test '("~8e" 3.14159) "3.142E+0")
       (fmt-test '("~9e" 3.14159) "3.1416E+0")
       (fmt-test '("~9,,,,,,'ee" 3.14159) "3.1416e+0")
       (fmt-test '("~10e" 3.14159) "3.14159E+0")
       (fmt-test '("~11e" 3.14159) " 3.14159E+0")
       (fmt-test '("~12e" 3.14159) "  3.14159E+0")
       (fmt-test '("~13,6,2,-5e" 3.14159) " 0.000003E+06")
       (fmt-test '("~13,6,2,-4e" 3.14159) " 0.000031E+05")
       (fmt-test '("~13,6,2,-3e" 3.14159) " 0.000314E+04")
       (fmt-test '("~13,6,2,-2e" 3.14159) " 0.003142E+03")
       (fmt-test '("~13,6,2,-1e" 3.14159) " 0.031416E+02")
       (fmt-test '("~13,6,2,0e" 3.14159)  " 0.314159E+01")
       (fmt-test '("~13,6,2,1e" 3.14159)  " 3.141590E+00")
       (fmt-test '("~13,6,2,2e" 3.14159)  " 31.41590E-01")
       (fmt-test '("~13,6,2,3e" 3.14159)  " 314.1590E-02")
       (fmt-test '("~13,6,2,4e" 3.14159)  " 3141.590E-03")
       (fmt-test '("~13,6,2,5e" 3.14159)  " 31415.90E-04")
       (fmt-test '("~13,6,2,6e" 3.14159)  " 314159.0E-05")
       (fmt-test '("~13,6,2,7e" 3.14159)  " 3141590.E-06")
       (fmt-test '("~13,6,2,8e" 3.14159)  "31415900.E-07")
       (fmt-test '("~7,3,,-2e" 0.001) ".001E+0")
       (fmt-test '("~8,3,,-2@e" 0.001) "+.001E+0")
       (fmt-test '("~8,3,,-2@e" -0.001) "-.001E+0")
       (fmt-test '("~8,3,,-2e" 0.001) "0.001E+0")
       (fmt-test '("~7,,,-2e" 0.001) "0.00E+0")
       (fmt-test '("~12,3,1e" 3.14159e12) "   3.142E+12")
       (fmt-test '("~12,3,1,,'*e" 3.14159e12) "************")
       (fmt-test '("~5,3,1e" 3.14159e12) "3.142E+12")
       ))

   ; general floating point (this test is from Steele's CL book)

   (cond
      (format:floats
       (fmt-test '("~9,2,1,,'*g|~9,3,2,3,'?,,'$g|~9,3,2,0,'%g|~9,2g"
		   0.0314159 0.0314159 0.0314159 0.0314159)
		 "  3.14E-2|314.2$-04|0.314E-01|  3.14E-2")
       (fmt-test '("~9,2,1,,'*g|~9,3,2,3,'?,,'$g|~9,3,2,0,'%g|~9,2g"
		   0.314159 0.314159 0.314159 0.314159)
		 "  0.31   |0.314    |0.314    | 0.31    ")
       (fmt-test '("~9,2,1,,'*g|~9,3,2,3,'?,,'$g|~9,3,2,0,'%g|~9,2g"
		   3.14159 3.14159 3.14159 3.14159)
		 "   3.1   | 3.14    | 3.14    |  3.1    ")
       (fmt-test '("~9,2,1,,'*g|~9,3,2,3,'?,,'$g|~9,3,2,0,'%g|~9,2g"
		   31.4159 31.4159 31.4159 31.4159)
		 "   31.   | 31.4    | 31.4    |  31.    ")
       (fmt-test '("~9,2,1,,'*g|~9,3,2,3,'?,,'$g|~9,3,2,0,'%g|~9,2g"
		   314.159 314.159 314.159 314.159)
		 "  3.14E+2| 314.    | 314.    |  3.14E+2") 
       (fmt-test '("~9,2,1,,'*g|~9,3,2,3,'?,,'$g|~9,3,2,0,'%g|~9,2g"
		   3141.59 3141.59 3141.59 3141.59)
		 "  3.14E+3|314.2$+01|0.314E+04|  3.14E+3")
       (fmt-test '("~9,2,1,,'*g|~9,3,2,3,'?,,'$g|~9,3,2,0,'%g|~9,2g"
		   3.14E12 3.14E12 3.14E12 3.14E12)
		 "*********|314.0$+10|0.314E+13| 3.14E+12")
       (fmt-test '("~9,2,1,,'*g|~9,3,2,3,'?,,'$g|~9,3,2,0,'%g|~9,2g"
		   3.14E120 3.14E120 3.14E120 3.14E120)
		 "*********|?????????|%%%%%%%%%|3.14E+120")
  
       (fmt-test '("~g" 0.0) "0.0    ")
       (fmt-test '("~g" 0.1) "0.1    ")
       (fmt-test '("~g" 0.01) "1.0E-2")
       (fmt-test '("~g" 123.456) "123.456    ")
       (fmt-test '("~g" 123456.7) "123456.7    ")
       (fmt-test '("~g" 123456.78) "123456.78    ")
       (fmt-test '("~g" 0.9282) "0.9282    ")
       (fmt-test '("~g" 0.09282) "9.282E-2")
       (fmt-test '("~g" 1) "1.0    ")
       (fmt-test '("~g" 12) "12.0    ")
       ))

   ; dollar floating point

   (cond
      (format:floats
       (fmt-test '("~$" 1.23) "1.23")
       (fmt-test '("~$" 1.2) "1.20")
       (fmt-test '("~$" 0.0) "0.00")
       (fmt-test '("~$" 9.999) "10.00")
       (fmt-test '("~3$" 9.9999) "10.000")
       (fmt-test '("~,4$" 3.2) "0003.20")
       (fmt-test '("~,4$" 10000.2) "10000.20")
       (fmt-test '("~,4,10$" 3.2) "   0003.20")
       (fmt-test '("~,4,10@$" 3.2) "  +0003.20")
       (fmt-test '("~,4,10:@$" 3.2) "+  0003.20")
       (fmt-test '("~,4,10:$" -3.2) "-  0003.20")
       (fmt-test '("~,4,10$" -3.2) "  -0003.20")
       (fmt-test '("~,,10@$" 3.2) "     +3.20")
       (fmt-test '("~,,10:@$" 3.2) "+     3.20")
       (fmt-test '("~,,10:@$" -3.2) "-     3.20")
       (fmt-test '("~,,10,'_@$" 3.2) "_____+3.20")
       (fmt-test '("~,,4$" 1234.4) "1234.40")
       ))

   ; complex numbers
   
   (cond 
      (format:complex-numbers
       (fmt-test '("~i" 3.0) "3.0+0.0i")
       (fmt-test '("~,3i" 3.0) "3.000+0.000i")
       (fmt-test `("~7,2i" ,(string->number "3.0+5.0i")) "   3.00  +5.00i")
       (fmt-test `("~7,2,1i" ,(string->number "3.0+5.0i")) "  30.00 +50.00i")
       (fmt-test `("~7,2@i" ,(string->number "3.0+5.0i")) "  +3.00  +5.00i")
       (fmt-test `("~7,2,,,'*@i" ,(string->number "3.0+5.0i")) "**+3.00**+5.00i")
       ))
   )

