;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/cigloo0.1/Engine/translate.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Nov 24 10:53:17 1995                          */
;*    Last change :  Mon Feb 12 10:42:02 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The translation on an input-port                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module ...                                                   */
;*---------------------------------------------------------------------*/
(module engine_translate
   (include "Parser/coord.sch"
	    "Translate/ast.sch")
   (import  engine_param
	    parser_parser
	    parser_lexer
	    translate_function
	    translate_declaration
	    translate_type
	    tools_speek
	    tools_error)
   (export  (translate ::input-port ::bstring ::symbol)))

;*---------------------------------------------------------------------*/
;*    translate ...                                                    */
;*---------------------------------------------------------------------*/
(define (translate iport name mode)
   (verbose 0 name #\: #\Newline)
   (let ((old-iname *iname*))
      (set! *iname* (prefix (basename name)))
      (try (begin
	      ;; we must print the name of the file before 
	      ;; starting parsing.
	      (if (eq? mode 'open)
		  (fprint *oport* "   ;; beginning of " name))
	      ;; if the -include-directive has been used we produce
	      ;; a bigloo include directive
	      (if *include-directive*
		  (fprint *oport* "   (include \"" name "\")"))
	      (let ((ast (parse iport)))
		 (for-each translate-ast ast)
		 (translate-function-declarations)
		 (translate-types!)
		 (if (eq? mode 'open)
		     (fprint *oport* "   ;; end of " name))))
	   (lambda (espace proc mes obj)
	      (notify-error proc mes obj)
	      (if (string? *dest*)
		  (begin
		     (close-output-port *oport*)
		     (if (file-exists? *dest*)
			 (delete-file *dest*))
		     (exit -1)))))
      (set! *iname* old-iname)))

;*---------------------------------------------------------------------*/
;*    parse ...                                                        */
;*---------------------------------------------------------------------*/
(define (parse iport) 
   (try (reverse! (read/lalrp parser lexer iport))
	(lambda (escape proc mes obj)
	   (match-case obj
	      ((cpp ?coord ?obj)
	       (error/location proc
			       mes
			       obj
			       (coord-fname coord)
			       (coord-pos coord)))
	      ((?token #{coord ?fname ?pos} . ?-)
	       (error/location "cyloo" proc "parse error" fname pos))
	      (else
	       (error proc mes obj))))))

;*---------------------------------------------------------------------*/
;*    translate-ast ...                                                */
;*---------------------------------------------------------------------*/
(define (translate-ast ast)
   (if (not (ast? ast))
       'ignore
       (ast-case ast
	  ((fun-def)
	   (translate-function-definition ast))
	  ((declare)
	   (translate-declaration ast))
	  (else
	   (error/ast "cyloo"
		      "Don't know what to do with this expression"
		      ast)))))
	    
