;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/tmp/cyloo/Tools/error.scm                                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Nov 28 10:12:19 1995                          */
;*    Last change :  Tue Nov 28 10:15:35 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Error handling                                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tools_error
   (include "Translate/ast.sch"
	    "Parser/coord.sch")
   (export  (error/ast symbol mes ast)))

;*---------------------------------------------------------------------*/
;*    error/ast ...                                                    */
;*---------------------------------------------------------------------*/
(define (error/ast symbol mes ast)
   (let ((coord (ast-coord ast)))
      (if (coord? coord)
	  (error/location "cyloo"
			  symbol
			  mes
			  (coord-fname coord)
			  (coord-pos coord))
	  (error "cyloo" symbol mes))))
