;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cc/exec.scm                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Apr 29 09:09:34 1995                          */
;*    Last change :  Tue Jan 20 15:04:08 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    When we don't need to make any action after invoking the C       */
;*    compiler (i.e. when the C compiler is called in a tail           */
;*    call position), rather than invoking it with the `system'        */
;*    we use the `execp' command. This module implements a             */
;*    private version of `exec' which take  parameters that            */
;*    tells if the command must return or not.                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cc_exec
   (include "Tools/trace.sch")
   (foreign (macro int execl (string string string string long) "execl"))
   (import  tools_error
	    engine_param
	    init_main)
   (export  (exec ::bstring ::bool ::bstring)))

;*---------------------------------------------------------------------*/
;*    exec-fname ...                                                   */
;*---------------------------------------------------------------------*/
(define (exec-fname)
   "$myselfx1001")

;*---------------------------------------------------------------------*/
;*    exec ...                                                         */
;*---------------------------------------------------------------------*/
(define (exec cmd flag name)
   (if (or flag (not (string? *shell*)))
       (begin
	  (trace cc "system: " cmd #\Newline)
	  (let ((res (system cmd)))
	     (if (not (=fx res 0))
		 (exit-bigloo 1)
		 res)))
       (begin
	  (trace cc "system/kill: " cmd #\Newline)
	  (system/kill cmd))))

;*---------------------------------------------------------------------*/
;*    system/kill ...                                                  */
;*---------------------------------------------------------------------*/
(define (system/kill cmd)
   (print (execl *shell* *shell* "-c" cmd 0))
   (internal-error "system/kill" "Can't execute cmd" cmd))
 
   


