;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Cfa/show.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar  8 18:51:37 1995                          */
;*    Last change :  Fri Aug  9 08:23:55 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We show the result of the cfa.                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_show
   (include "Tools/trace.sch")
   (import  tools_shape
	    tools_trace
	    tools_speek
	    write_scheme
	    type_type
	    ast_var
	    ast_node
	    cfa_info
	    cfa_approx
	    cfa_collect
	    cfa_iterate)
   (export  (show-cfa-nb-iterations)
	    (show-cfa-results globals)))

;*---------------------------------------------------------------------*/
;*    show-cfa-nb-iterations ...                                       */
;*---------------------------------------------------------------------*/
(define (show-cfa-nb-iterations)
   (verbose 2 "      (" (+fx 1 *cfa-stamp*) " Iterations)" #\Newline))

;*---------------------------------------------------------------------*/
;*    show-cfa-results ...                                             */
;*---------------------------------------------------------------------*/
(define (show-cfa-results globals)
   (trace cfa
	  #\Newline
	  "============================================" #\Newline
	  "cfa-results:" #\Newline)
   (if (pair? (get-allocs)) (trace cfa #\Newline))
   (for-each (lambda (a)
		(trace cfa (node-key a) ": " (shape a) " """ #\Newline))
	     (get-allocs))
   (trace cfa #\Newline)
   (trace cfa
	  (let ((old-case *pp-case*))
	     (set! *pp-case* 'lower)
	     (for-each (lambda (g)
			  (let ((fun (global-value g)))
			     (write-scheme-comment *trace-port* (shape g))
			     (pp `(,(case (sfun-class fun)
				       ((sgfun)
					'define-generic)
				       ((sifun)
					'define-inline)
				       ((smfun)
					'define-method)
				       (else
					'define))
				   (,(shape g)
				    ,@(map shape (sfun-args fun)))
				   ,(shape (sfun-body fun)))
				 *trace-port*)))
		       globals)
	     (set! *pp-case* old-case)
	     #\Newline #\Newline)))

;*---------------------------------------------------------------------*/
;*    shape ...                                                        */
;*---------------------------------------------------------------------*/
(define-method (shape local::reshaped-local)
   (let ((port (open-output-string)))
      (display (call-next-method) port)
      (cfa-variable-shape local port)))

;*---------------------------------------------------------------------*/
;*    shape ...                                                        */
;*---------------------------------------------------------------------*/
(define-method (shape global::reshaped-global)
   (let ((port (open-output-string)))
      (display (call-next-method) port)
      (cfa-variable-shape global port)))
   
;*---------------------------------------------------------------------*/
;*    cfa-variable-shape ...                                           */
;*---------------------------------------------------------------------*/
(define (cfa-variable-shape variable port)
   (let ((value (variable-value variable)))
      (cond 
	 ((svar/Cinfo? value)
	  (display " " port)
	  (display (shape (svar/Cinfo-approx value)) port))
	 ((cvar/Cinfo? value)
	  (display " " port)
	  (display (shape (cvar/Cinfo-approx value)) port))
	 ((scnst/Cinfo? value)
	  (display " " port)
	  (display (shape (scnst/Cinfo-approx value)) port))
	 ((intern-sfun/Cinfo? value)
	  (display " " port)
	  (display (shape (intern-sfun/Cinfo-approx value)) port))
	 ((extern-sfun/Cinfo? value)
	  (display " " port)
	  (display (shape (extern-sfun/Cinfo-approx value)) port))
	 ((cfun/Cinfo? value)
	  (display " " port)
	  (display (shape (cfun/Cinfo-approx value)) port)))
      (string->symbol (close-output-port port))))
