;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Cfa/specialize.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  SERRANO Manuel                                    */
;*    Creation    :  Fri Apr 11 13:18:21 1997                          */
;*    Last change :  Tue Apr 15 08:07:05 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    This module implements an optimization asked by John Gerard      */
;*    Malecki <johnm@vlibs.com>. What is does is, for each generic     */
;*    operation (e.g. +, max, ...) is a specialized operation exists,  */
;*    regarding Cfa type informations, the generic operation is        */
;*    replaced by the specific one.                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_specialize
   (include "Tools/trace.sch")
   (import  engine_param
	    type_type
	    type_cache
	    tools_shape
	    tools_speek
	    tools_error
	    coerce_typeof
	    ast_var
	    ast_node
	    ast_env
	    inline_inline
	    inline_walk)
   (static  (wide-class specialized-global::global
	       (fix read-only)))
   (export  (specialize! globals)))

;*---------------------------------------------------------------------*/
;*    specialize-optimization? ...                                     */
;*---------------------------------------------------------------------*/
(define (specialize-optimization?)
   (and (>=fx *optim* 1) (not *lib-mode*)))

;*---------------------------------------------------------------------*/
;*    show-specialize ...                                              */
;*---------------------------------------------------------------------*/
(define (show-specialize)
   (verbose 1 "   . specializing" #\newline)
   (for-each (lambda (type.num)
		(if (>fx (cdr type.num) 0)
		    (verbose 2 "        (-> " (shape (car type.num))
			     ": " (cdr type.num) #")\n")))
	     *specialized-types*))

;*---------------------------------------------------------------------*/
;*    *specialize* ...                                                 */
;*---------------------------------------------------------------------*/
(define *specialize*        '())
(define *specialized-types* '())

;*---------------------------------------------------------------------*/
;*    install-specialized-type! ...                                    */
;*---------------------------------------------------------------------*/
(define (install-specialized-type! type)
   (if (not (pair? (assq type *specialized-types*)))
       (set! *specialized-types* (cons (cons type 0) *specialized-types*))))

;*---------------------------------------------------------------------*/
;*    add-specialized-type! ...                                        */
;*---------------------------------------------------------------------*/
(define (add-specialized-type! type)
   (let ((cell (assq type *specialized-types*)))
      (if (not (pair? cell))
	  (internal-error "add-specialized-type!"
			  "Unspecialized type"
			  (shape type))
	  (set-cdr! cell (+fx 1 (cdr cell))))))

;*---------------------------------------------------------------------*/
;*    install-specialize! ...                                          */
;*---------------------------------------------------------------------*/
(define (install-specialize! gen-id gen-mod . fixes)
   (let ((generic (find-global gen-id gen-mod)))
      (if (global? generic)
	  (let loop ((fixes fixes)
		     (res   '()))
	     (if (null? fixes)
		 (begin
		    (widen!::specialized-global generic
		       (fix res))
		    (set! *specialize* (cons generic *specialize*)))
		 (let* ((id     (car fixes))
			(mod    (cadr fixes))
			(global (find-global id mod)))
		    (if (and (global? global)
			     (sfun? (global-value global))
			     (pair? (sfun-args (global-value global))))
			(let ((type (local-type
				     (car
				      (sfun-args
				       (global-value
					global))))))
			   (install-specialized-type! type)
			   (loop (cddr fixes)
				 (cons (cons type global) res)))
			(begin
			   (warning "install-specialize!"
				    "Can't find global"
				    " -- "
				    (cons id mod))
			   (loop (cddr fixes) res))))))
	  (warning "install-specialize!"
		   "Can't fund global"
		   " -- "
		   (cons gen-id gen-mod)))))

;*---------------------------------------------------------------------*/
;*    uninstall-specializes! ...                                       */
;*---------------------------------------------------------------------*/
(define (uninstall-specializes!)
   (set! *specialized-types* '())
   (for-each shrink! *specialize*))
   
;*---------------------------------------------------------------------*/
;*    specialize! ...                                                  */
;*---------------------------------------------------------------------*/
(define (specialize! globals)
   (if (specialize-optimization?)
       (begin
	  (install-specialize! '2= '__r4_numbers_6_5
			       '=fx '__r4_numbers_6_5_fixnum
			       '=fl '__r4_numbers_6_5_flonum)
	  (install-specialize! '2< '__r4_numbers_6_5
			       '<fx '__r4_numbers_6_5_fixnum
			       '<fl '__r4_numbers_6_5_flonum)
	  (install-specialize! '2> '__r4_numbers_6_5
			       '>fx '__r4_numbers_6_5_fixnum
			       '>fl '__r4_numbers_6_5_flonum)
	  (install-specialize! '2<= '__r4_numbers_6_5
			       '<=fx '__r4_numbers_6_5_fixnum
			       '<=fl '__r4_numbers_6_5_flonum)
	  (install-specialize! '2>= '__r4_numbers_6_5
			       '>=fx '__r4_numbers_6_5_fixnum
			       '>=fl '__r4_numbers_6_5_flonum)
	  (install-specialize! 'zero? '__r4_numbers_6_5
			       'zerofx? '__r4_numbers_6_5_fixnum
			       'zerofl? '__r4_numbers_6_5_flonum)
	  (install-specialize! 'positive? '__r4_numbers_6_5
			       'positivefx? '__r4_numbers_6_5_fixnum
			       'positivefl? '__r4_numbers_6_5_flonum)
	  (install-specialize! 'negative? '__r4_numbers_6_5
			       'negativefx? '__r4_numbers_6_5_fixnum
			       'negativefl? '__r4_numbers_6_5_flonum)
	  (install-specialize! '2+ '__r4_numbers_6_5
			       '+fx '__r4_numbers_6_5_fixnum
			       '+fl '__r4_numbers_6_5_flonum)
	  (install-specialize! '2- '__r4_numbers_6_5
			       '-fx '__r4_numbers_6_5_fixnum
			       '-fl '__r4_numbers_6_5_flonum)
	  (install-specialize! '2* '__r4_numbers_6_5
			       '*fx '__r4_numbers_6_5_fixnum
			       '*fl '__r4_numbers_6_5_flonum)
	  (install-specialize! '2/ '__r4_numbers_6_5
			       '/fl '__r4_numbers_6_5_flonum)
	  (install-specialize! 'abs '__r4_numbers_6_5
			       'absfx '__r4_numbers_6_5_fixnum
			       'absfl '__r4_numbers_6_5_flonum)
	  (install-specialize! 'log '__r4_numbers_6_5
			       'logfl '__r4_numbers_6_5_flonum)
	  (install-specialize! 'exp '__r4_numbers_6_5
			       'expfl '__r4_numbers_6_5_flonum)
	  (install-specialize! 'sin '__r4_numbers_6_5
			       'sinfl '__r4_numbers_6_5_flonum)
	  (install-specialize! 'cos '__r4_numbers_6_5
			       'cosfl '__r4_numbers_6_5_flonum)
	  (install-specialize! 'tan '__r4_numbers_6_5
			       'tanfl '__r4_numbers_6_5_flonum)
	  (install-specialize! 'asin '__r4_numbers_6_5
			       'asinfl '__r4_numbers_6_5_flonum)
	  (install-specialize! 'acos '__r4_numbers_6_5
			       'acosfl '__r4_numbers_6_5_flonum)
	  (install-specialize! 'sqrt '__r4_numbers_6_5
			       'sqrtfl '__r4_numbers_6_5_flonum)
	  (patch-tree! globals)
	  (show-specialize)
	  (uninstall-specializes!)))
   globals)

;*---------------------------------------------------------------------*/
;*    patch-tree! ...                                                  */
;*---------------------------------------------------------------------*/
(define (patch-tree! globals)
   (for-each patch-fun! globals))

;*---------------------------------------------------------------------*/
;*    patch-fun! ...                                                   */
;*---------------------------------------------------------------------*/
(define (patch-fun! variable)
   (let ((fun (variable-value variable)))
      (sfun-body-set! fun (patch! (sfun-body fun)))))

;*---------------------------------------------------------------------*/
;*    patch! ...                                                       */
;*---------------------------------------------------------------------*/
(define-generic (patch! node::node))

;*---------------------------------------------------------------------*/
;*    patch! ::atom ...                                                */
;*---------------------------------------------------------------------*/
(define-method (patch! node::atom)
   node)

;*---------------------------------------------------------------------*/
;*    patch! ::kwote ...                                               */
;*---------------------------------------------------------------------*/
(define-method (patch! node::kwote)
   node)
		    
;*---------------------------------------------------------------------*/
;*    patch! ::var ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (patch! node::var)
   node)
 
;*---------------------------------------------------------------------*/
;*    patch! ::closure ...                                             */
;*---------------------------------------------------------------------*/
(define-method (patch! node::closure)
   (internal-error "patch!" "Unexpected closure" (shape node)))

;*---------------------------------------------------------------------*/
;*    patch! ::sequence ...                                            */
;*---------------------------------------------------------------------*/
(define-method (patch! node::sequence)
   (with-access::sequence node (nodes)
      (patch*! nodes)
      node))

;*---------------------------------------------------------------------*/
;*    patch! ::app-ly ...                                              */
;*---------------------------------------------------------------------*/
(define-method (patch! node::app-ly)
   (with-access::app-ly node (fun arg)
      (set! fun (patch! fun))
      (set! arg (patch! arg))
      node))

;*---------------------------------------------------------------------*/
;*    patch! ::funcall ...                                             */
;*---------------------------------------------------------------------*/
(define-method (patch! node::funcall)
   (with-access::funcall node (fun args)
      (set! fun (patch! fun))
      (patch*! args)
      node))

;*---------------------------------------------------------------------*/
;*    patch! ::pragma ...                                              */
;*---------------------------------------------------------------------*/
(define-method (patch! node::pragma)
   (with-access::pragma node (args type)
      (patch*! args)
      node))

;*---------------------------------------------------------------------*/
;*    patch! ::cast ...                                                */
;*---------------------------------------------------------------------*/
(define-method (patch! node::cast)
   (with-access::cast node (arg)
      (patch! arg)
      node))

;*---------------------------------------------------------------------*/
;*    patch! ::setq ...                                                */
;*---------------------------------------------------------------------*/
(define-method (patch! node::setq)
   (with-access::setq node (var value)
      (set! value (patch! value))
      (set! var (patch! var))
      node))

;*---------------------------------------------------------------------*/
;*    patch! ::conditional ...                                         */
;*---------------------------------------------------------------------*/
(define-method (patch! node::conditional)
   (with-access::conditional node (test true false)
       (set! test (patch! test))
       (set! true (patch! true))
       (set! false (patch! false))
       node))

;*---------------------------------------------------------------------*/
;*    patch! ::fail ...                                                */
;*---------------------------------------------------------------------*/
(define-method (patch! node::fail)
   (with-access::fail node (type proc msg obj)
      (set! proc (patch! proc))
      (set! msg (patch! msg))
      (set! obj (patch! obj))
      node))

;*---------------------------------------------------------------------*/
;*    patch! ::select ...                                              */
;*---------------------------------------------------------------------*/
(define-method (patch! node::select)
   (with-access::select node (clauses test)
      (set! test (patch! test))
      (for-each (lambda (clause)
		   (set-cdr! clause (patch! (cdr clause))))
		clauses)
      node))

;*---------------------------------------------------------------------*/
;*    patch! ::let-fun ...                                             */
;*---------------------------------------------------------------------*/
(define-method (patch! node::let-fun)
   (with-access::let-fun node (body locals)
      (for-each patch-fun! locals)
      (set! body (patch! body))
      node))

;*---------------------------------------------------------------------*/
;*    patch! ::let-var ...                                             */
;*---------------------------------------------------------------------*/
(define-method (patch! node::let-var)
   (with-access::let-var node (body bindings)
      (for-each (lambda (binding)
		   (let ((val (cdr binding)))
		      (set-cdr! binding (patch! val))))
		bindings)
      (set! body (patch! body))
      node))

;*---------------------------------------------------------------------*/
;*    patch! ::set-ex-it ...                                           */
;*---------------------------------------------------------------------*/
(define-method (patch! node::set-ex-it)
   (with-access::set-ex-it node (var body)
      (set! body (patch! body))
      (patch! var)
      node))

;*---------------------------------------------------------------------*/
;*    patch! ::jump-ex-it ...                                          */
;*---------------------------------------------------------------------*/
(define-method (patch! node::jump-ex-it)
   (with-access::jump-ex-it node (exit value)
      (set! exit (patch! exit))
      (set! value (patch! value))
      node))

;*---------------------------------------------------------------------*/
;*    patch! ::make-box ...                                            */
;*---------------------------------------------------------------------*/
(define-method (patch! node::make-box)
   (with-access::make-box node (value)
      (set! value (patch! value))
      node))

;*---------------------------------------------------------------------*/
;*    patch! ::box-set! ...                                            */
;*---------------------------------------------------------------------*/
(define-method (patch! node::box-set!)
   (with-access::box-set! node (var value)
      (set! var (patch! var))
      (set! value (patch! value))
      node))

;*---------------------------------------------------------------------*/
;*    patch! ::box-ref ...                                             */
;*---------------------------------------------------------------------*/
(define-method (patch! node::box-ref)
   (with-access::box-ref node (var)
      (set! var (patch! var))
      node))

;*---------------------------------------------------------------------*/
;*    patch*! ...                                                      */
;*---------------------------------------------------------------------*/
(define (patch*! node*)
   (let loop ((node* node*))
      (if (null? node*)
	  'done
	  (begin
	     (set-car! node* (patch! (car node*)))
	     (loop (cdr node*))))))

;*---------------------------------------------------------------------*/
;*    patch! ::app ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (patch! node::app)
   (with-access::app node (fun args)
      (patch*! args)
      (set! fun (patch! fun))
      (let ((v (var-variable fun)))
	 (if (specialized-global? v)
	     (specialize-app! node)
	     node))))

;*---------------------------------------------------------------------*/
;*    specialize-app! ...                                              */
;*---------------------------------------------------------------------*/
(define (specialize-app!::node node::app)
   (with-access::app node (fun args)
      (if (null? args)
	  node
	  ;; we check if the type of all the argument
	  ;; is either fixnum or flonum
	  (let* ((type (typeof (car args)))
		 (glo  (var-variable fun))
		 (spec (assq type (specialized-global-fix glo))))
	     (if (pair? spec)
		 (let loop ((args (cdr args)))
		    (cond
		       ((null? args)
			(add-specialized-type! type)
			(var-variable-set! fun (cdr spec))
			(node-type-set! node type)
			node)
		       ((eq? (typeof (car args)) type)
			(loop (cdr args)))
		       (else
			;; sorry, it fails
			node)))
		 node)))))
			
