;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9c/Engine/link.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Jan 15 11:16:02 1994                          */
;*    Last change :  Tue Aug  5 16:54:10 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On link quand l'utilisateur n'a passe que des `.o'               */
;*    -------------------------------------------------------------    */
;*    Pour ce faire on essaye de trouver des `.scm' correspondants.    */
;*    On genere un petit fichier `.scm' qui les initialise puis on     */
;*    le compile normalement ou alors, on se contente d'invoquer le    */
;*    linker `*ld*'.                                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module engine_link
   (export (link))
   (import cc_ld
	   engine_compiler
	   engine_param
	   tools_error
	   tools_file))

;*---------------------------------------------------------------------*/
;*    *tmp-main-file-name* ...                                         */
;*---------------------------------------------------------------------*/
(define *tmp-main-file-name* (make-file-name *bigloo-tmp*
					     (string-append
					      "main-tmp"
					      "@"
					      (let ((user (getenv "USER")))
						 (if (not (string? user))
						     ""
						     user))
					      (car *src-suffix*))))
			      
;*---------------------------------------------------------------------*/
;*    link ...                                                         */
;*---------------------------------------------------------------------*/
(define (link)
   ;; we start by looking for the source files
   (let loop ((o-files   *o-files*)
	      (scm-files '()))
      (if (null? o-files)
	  ;; and with launch the linking process
	  (link-with scm-files)
	  (let* ((pref     (prefix (car o-files)))
		 (bpref    (basename pref))
		 (scm-file (find-src-file pref bpref)))
	     (if (string? scm-file)
		 (loop (cdr o-files) (cons scm-file scm-files))
		 (begin
		    (warning  "link"
			      "No Bigloo module found for -- "
			      (car o-files))
		    (loop (cdr o-files) scm-files)))))))

;*---------------------------------------------------------------------*/
;*    find-src-file ...                                                */
;*---------------------------------------------------------------------*/
(define (find-src-file prefix bname)
   (let loop ((suffix *src-suffix*))
      (if (null? suffix)
	  #f
	  (let* ((suf (car suffix))
		 (f   (find-file/path (string-append prefix "." suf)
				      *load-path*)))
	     (if (string? f)
		 f
		 (let ((f (find-file/path (string-append bname "." suf)
					  *load-path*)))
		    (if (string? f)
			f
			(loop (cdr suffix)))))))))

;*---------------------------------------------------------------------*/
;*    link-with ...                                                    */
;*---------------------------------------------------------------------*/
(define (link-with scm-files)
   (if (null? scm-files)
       (let ((first (prefix (car *o-files*))))
	  (warning "link" "No source file found" " -- " *o-files*)
	  (set! *o-files* (cdr *o-files*))
	  (ld first #f))
       ;; on construit la clause du module
       (let loop ((scm-files scm-files)
		  (cls       '())
		  (main      #f)
		  (fmain     ""))
	  (if (null? scm-files)
	      (if main
		  ;; ce n'est pas la peine de generer un main, il y en a
		  ;; deja un
		  (let ((first (prefix (car *o-files*))))
		     (set! *o-files* (cdr *o-files*))
		     (ld first #f))
		  ;; on genere un main puis on link.
		  (begin
		     (make-tmp-main cls main)
		     (set! *src-files* (list *tmp-main-file-name*))
		     (unwind-protect
			(compiler)
			(let* ((scm-file *tmp-main-file-name*)
			       (pre      (prefix scm-file))
			       (c-file   (string-append pre ".c"))
			       (o-file   (string-append pre ".o")))
			   (for-each (lambda (f)
					(if (file-exists? f)
					    (delete-file f)))
				     (list scm-file c-file o-file))))
		     0))
	      (let ((port (open-input-file (car scm-files))))
		 (if (not (input-port? port))
		     (error "" "Illegal file" (car scm-files))
		     (let ((exp (read port)))
			(close-input-port port)
			(match-case exp
			   ((module ?name ??- (main ?new-main) . ?-)
			    (if main
				(error ""
				       (string-append
					"Redeclaration of the main (files "
					fmain
					" and "
					(car scm-files) ")")
				       (cons main new-main)))
			    (loop (cdr scm-files)
				  (cons (list name
					      (string-append
					       "\""
					       (car scm-files)
					       "\""))
					cls)
				  new-main
				  (car scm-files)))
			   ((module ?name . ?-)
			    (loop (cdr scm-files)
				  (cons (list name
					      (string-append
					       "\""
					       (car scm-files)
					       "\""))
					cls)
				  main
				  fmain))
			   (else
			    ;; ah, ce n'etait pas un fichier bigloo,
			    ;; on saute (en meprisant :-)
			    (loop (cdr scm-files)
				  cls
				  main
				  fmain))))))))))

;*---------------------------------------------------------------------*/
;*    make-tmp-main ...                                                */
;*---------------------------------------------------------------------*/
(define (make-tmp-main clauses main)
   (let ((pout (open-output-file *tmp-main-file-name*)))
      (if (not (output-port? pout))
	  (error ""
			 "Can't open output file"
			 *tmp-main-file-name*)
	  (begin
	     (fprint pout ";; " *bigloo-name*)
	     (fprint pout ";; !!! generated file, don't edit !!!")
	     (fprint pout ";; ==================================")
	     (newline pout)
	     (fprint pout `(module ,(gensym 'main)
			      (import ,@(reverse clauses))))
	     (newline pout)
	     (if main
		 (begin
		    (fprint pout "(main *the-command-line*)")
		    (newline pout)))
	     (close-output-port pout)))))
	  
	  

