;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Module/with.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun  4 16:28:03 1996                          */
;*    Last change :  Tue Jun 11 12:00:05 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The with clauses compilation.                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_with
   (import module_module
	   engine_param
	   tools_error
	   module_impuse
	   read_access)
   (export (make-with-compiler)))

;*---------------------------------------------------------------------*/
;*    make-with-compiler ...                                           */
;*---------------------------------------------------------------------*/
(define (make-with-compiler)
   (instantiate::ccomp (id 'with) (producer with-producer)))

;*---------------------------------------------------------------------*/
;*    with-producer ...                                                */
;*---------------------------------------------------------------------*/
(define (with-producer clause)
   (match-case clause
      ((?- . ?protos)
       (for-each (lambda (proto) (with-parser proto clause)) protos))
      (else
       (user-error "Parse error"
		   (string-append "Illegal `with' clause")
		   clause
		   '()))))
   
;*---------------------------------------------------------------------*/
;*    with-parser ...                                                  */
;*---------------------------------------------------------------------*/
(define (with-parser proto clause)
   (match-case proto
      (((and ?name (? symbol?)) (and ?file (? string?)) . ?rest)
       (let loop ((rest   rest)
		  (fnames (list file)))
	  (cond
	     ((null? rest)
	      (add-access! name (reverse! fnames)))
	     ((string? (car rest))
	      (loop (cdr rest)
		    (cons (car rest) fnames)))
	     (else
	      (user-error "Parse error"
			  (string-append "Illegal `with' clause")
			  clause
			  '()))))
       (set! *with-files* (cons (o-name file) *with-files*))
       (import-with-module! name))
      (else
       (if (not (symbol? proto))
	   (user-error "Parse error"
		       (string-append "Illegal `with' clause")
		       clause
		       '())
	   (let ((b (assq proto *access-table*)))
	      (if (not b)
		  (user-error proto "can't access module" clause '())
		  (begin
		     (set! *with-files* (cons (o-name (cadr b)) *with-files*))
		     (import-with-module! proto))))))))

;*---------------------------------------------------------------------*/
;*    o-name ...                                                       */
;*---------------------------------------------------------------------*/
(define (o-name file)   
   (string-append (prefix file) ".o"))
	     
	
   
   
