;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Tvector/cnst.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr 19 14:44:40 1995                          */
;*    Last change :  Tue Jul 16 17:09:16 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The compilation of constant tvectors                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tvector_cnst
   (include "Tvector/tvector.sch")
   (import  type_type
	    type_env
	    type_cache
	    tvector_tvector)
   (export  (tvector-C-static?::bool    tvector)
	    (tvector->c-vector::bstring tvector)))

;*---------------------------------------------------------------------*/
;*    tvector-C-static? ...                                            */
;*    -------------------------------------------------------------    */
;*    Is this tvector can be compiled as a static C vector ?           */
;*    It is possible only if the item type is an immediat C type.      */
;*---------------------------------------------------------------------*/
(define (tvector-C-static? tvect)
      (let ((itype (tvec-item-type (a-tvector-type tvect))))
	 (cond
	    ((eq? itype *long*)   #t)
	    ((eq? itype *int*)    #t)
	    ((eq? itype *char*)   #t)
	    ((eq? itype *bool*)   #t)
	    ((eq? itype *string*) #t)
	    ((eq? itype *real*)   #t)
	    (else #f))))

;*---------------------------------------------------------------------*/
;*    tvector-c-printer ...                                            */
;*---------------------------------------------------------------------*/
(define (tvector-c-printer tvect)
   (let ((itype (tvec-item-type (a-tvector-type tvect))))
      (cond
	 ((eq? itype *long*)   display)
	 ((eq? itype *int*)    display)
	 ((eq? itype *char*)   (lambda (x port)
				  (display "(unsigned char)" port)
				  (display (char->integer x) port)))
	 ((eq? itype *bool*)   (lambda (x port)
				  (if x
				      (display "1" port)
				      (display "0" port))))
	 ((eq? itype *string*) write)
	 ((eq? itype *real*)   display)
	 (else (error "tvector-c-printer"
		      "This tvector can't not be compiled as a static C vector"
		      tvect)))))
			   
;*---------------------------------------------------------------------*/
;*    tvector->c-vector ...                                            */
;*---------------------------------------------------------------------*/
(define (tvector->c-vector::bstring tvector)
   (let* ((vect      (a-tvector-vector tvector)) 
	  (c-printer (tvector-c-printer tvector))
	  (len-1     (-fx (vector-length vect) 1))
	  (port      (open-output-string)))
      (display #\{ port)
      (let loop ((i 0))
	 (if (=fx i len-1)
	     (begin
		(c-printer (vector-ref vect i) port)
		(display #\} port)
		(close-output-port port))
	     (begin
		(c-printer (vector-ref vect i) port)
		(display ", " port)
		(loop (+fx i 1)))))))
   
      
      
		
