;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Write/ast.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Dec 31 07:29:03 1994                          */
;*    Last change :  Fri Sep  6 14:26:00 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The ast pretty-printer                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module write_ast
   (include "Engine/pass.sch"
	    "Ast/node.sch")
   (import  engine_param
	    init_main
	    write_scheme
	    type_pptype
	    tools_shape
	    tools_args)
   (export  (write-ast ast)))

;*---------------------------------------------------------------------*/
;*    write-ast ...                                                    */
;*---------------------------------------------------------------------*/
(define (write-ast globals)
   (let* ((output-name (if (string? *dest*)
			   *dest*
			   (if (and (pair? *src-files*)
				    (string? (car *src-files*)))
			       (string-append (prefix (car *src-files*))
					      ".ast")
			       #f)))
	  (port        (if (string? output-name)
			   (open-output-file output-name)
			   (current-output-port))))
      (if (not (output-port? port))
	  (error "write-ast" "Can't open output file" output-name)
	  (let ((handler (lambda (escape proc mes obj)
			    (notify-error proc mes obj)
			    (close-output-port port)
			    (exit-bigloo -8))))
	     (try (begin
		     (if (not *case-sensitive*)
			 (set! *pp-case* 'lower))
		     (write-scheme-file-header port
					       (string-append "The AST ("
							      *current-pass*
							      ")"))
		     (for-each
		      (lambda (g)
			 (let ((fun (global-value g)))
			    (write-scheme-comment port (shape g))
			    (write-scheme-comment port
						  (function-type->string g))
			    (write-scheme-comment port (make-sfun-sinfo g))
			    (pp `(,(case (sfun-class fun)
				      ((sgfun)
				       'define-generic)
				      ((sifun)
				       'define-inline)
				      ((smfun)
				       'define-method)
				      (else
				       'define))
				  ,(cons (shape g)
					 (args-list->args*
					  (map shape (sfun-args fun))
					  (sfun-arity fun)))
				  ,(shape (sfun-body fun)))
				port)))
		      globals)
		     (close-output-port port))
		  handler)))))

;*---------------------------------------------------------------------*/
;*    make-sfun-sinfo ...                                              */
;*---------------------------------------------------------------------*/
(define (make-sfun-sinfo::bstring g::global)
   (define (atom->string atom)
      (case atom
	 ((#t)
	  "#t")
	 ((#f)
	  "#f")
	 ((#unspecified)
	  "#unspecified")
	 (else
	  (cond
	     ((symbol? atom)
	      (if *case-sensitive*
		  (symbol->string atom)
		  (string-downcase (symbol->string atom))))
	     ((number? atom)
	      (number->string atom))
	     ((string? atom)
	      atom)
	     (else
	      (let ((p (open-output-string)))
		 (display atom p)
		 (close-output-port p)))))))
   (let ((sfun (global-value g)))
      (string-append "["
		     (if *case-sensitive*
			 (symbol->string (global-import g))
			 (string-downcase (symbol->string (global-import g))))
		     "  side-effect: " (atom->string (sfun-side-effect? sfun))
		     (let ((t (sfun-predicate-of sfun)))
			(if (type? t)
			    (string-append "  predicate-of: "
					   (atom->string (shape t)))
			    ""))
		     "  occ: " (integer->string (global-occurrence g))
		     "  rm: " (atom->string (global-removable g))
		     "]")))
