/* --------------------------------------------------------------------*/
/*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \   /  '                               */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome. Send them to                                          */
/*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
/*-------------------------------------------------------------------- */
/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime/Clib/main.c                  */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Jul 17 09:40:49 1992                          */
/*    Last change :  Fri Mar 20 09:14:32 1998 (serrano)                */
/*                                                                     */
/*    Le fichier de main de toute application. Comme je m'y prends     */
/*    plus intelligement que dans la version 0.8 (si, si :-), je       */
/*    peux compiler une fois pour toute ce fichier. Je ne suis plus    */
/*    oblige de le construire et le compiler pour chaque application.  */
/*---------------------------------------------------------------------*/
#include <bigloo1.9c.h>
#if( (defined( sun ) && !defined( __svr4__) && !defined( __SVR4 )) \
     || defined( sony_news ) )
#   include <machine/vmparam.h>
#else
#   if( defined( sun ) && (defined( __svr4__ ) || defined( __SVR4 )) )
#      include <sys/vmparam.h>
#   endif
#endif

/*---------------------------------------------------------------------*/
/*    Quelques macros de calcul de taille memoire pour les GCs         */
/*---------------------------------------------------------------------*/
#define MegToByte(x) ((x) * (1024 * 1024))
#define MegToKilo(x) ((x) * 1024)
#define MegTo4K(x)   ((x) * (1024 >> 2))

#define DEFAULT_HEAP_SIZE 4

/*---------------------------------------------------------------------*/
/*    Des recuperations externes                                       */
/*---------------------------------------------------------------------*/
extern void cref();
extern void memshow();
extern char *getenv();
extern void init_eval_cnst();
extern obj_t c_constant_string_to_string();
extern obj_t c_error();
extern void init_objects();
extern int bigloo_main();

/*---------------------------------------------------------------------*/
/*    Une variable pour memoriser le bas de la pile                    */
/*---------------------------------------------------------------------*/
char *stack_bottom;
long  glob_dummy;

obj_t command_line    = 0L;
char *executable_name = 0L;

/*---------------------------------------------------------------------*/
/*    bigloo_exit ...                                                  */
/*---------------------------------------------------------------------*/
obj_t
bigloo_exit( obj_t val )
{
   FREE_ALLOCATION();
   exit( (long)INTEGERP( val ) ? (long)CINT( val ) : 0 );
}

/*---------------------------------------------------------------------*/
/*    bigloo_main ...                                                  */
/*    -------------------------------------------------------------    */
/*    Le vrai point d'entree d'une application `bigloo'. La fonction   */
/*    `main' qui est cree par le compilo ne sert a rien. Elle existe   */
/*    uniquement car je ne suis pas que tous les compilos supporte que */
/*    la fonction C `main' soit mise en librairie. Comme ca, je suis   */
/*    tranquile.                                                       */
/*---------------------------------------------------------------------*/
int
_bigloo_main( int argc, char *argv[] )
{
   long  heap_size;
   long  mega_size;
   char *env_size;
   obj_t cons;
   long  i;

   /* on memorise l'adresse du bas de la pile */
   stack_bottom = (char *)&argc;
   
   /* on initialise le tas */
   if( !(env_size = getenv( "BIGLOOHEAP" )) )
      mega_size = DEFAULT_HEAP_SIZE;
   else
      mega_size = atoi( env_size );

#if( (THE_GC == BOEHM_GC) &&                                     \
     ( (!defined( BOEHM_GC_VERSION)) ||                          \
       (BOEHM_GC_VERSION == 2)       ||                          \
       (BOEHM_GC_VERSION == 3) ) )
   heap_size = MegTo4K( mega_size );
#else
   heap_size = MegToByte( mega_size );
#endif

   if( !INIT_ALLOCATION( heap_size ) )
   {
      char mes[ 600 ];

      sprintf( mes, "%ld Meg wanted", heap_size / (1024 * 1024) );
      c_error( "Can't allocate heap", mes, -10 );
   }
   else
   {
      /* on initialise les objects pre-alloues (les chars, bool, ...) */
      init_objects();

      /* on initialise les constantes du fichier `Clib/eval.c' */
      init_eval_cnst();
	 
      /* on construit la liste des argv */
      for( i = argc - 1, cons = BNIL; i >= 0; i-- )
         cons = MAKE_PAIR( c_constant_string_to_string( argv[ i ] ), cons );

      /* on sauve le nom de l'executable */
      executable_name = argv[ 0 ];
      
      /* on met a jour la variable `command-line' */
      command_line = cons;
		 
      /* on appelle le main de l'utilisateur */
      bigloo_main( cons );
   }

   return 0;
}


