/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.file.impl;

import com.aelitis.azureus.core.diskmanager.file.FMFile;
import com.aelitis.azureus.core.diskmanager.file.FMFileManager;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.FMFileOwner;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileImpl;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileLimited;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileUnlimited;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;

public class FMFileManagerImpl
implements FMFileManager {
    public static final boolean DEBUG = false;
    protected static FMFileManagerImpl singleton;
    protected static AEMonitor class_mon;
    protected LinkedHashMap map;
    protected AEMonitor map_mon = new AEMonitor("FMFileManager:Map");
    protected boolean limited;
    protected int limit_size;
    protected AESemaphore close_queue_sem;
    protected List close_queue;
    protected AEMonitor close_queue_mon = new AEMonitor("FMFileManager:CQ");
    protected List files;
    protected AEMonitor files_mon = new AEMonitor("FMFileManager:File");

    static {
        class_mon = new AEMonitor("FMFileManager:class");
    }

    public static FMFileManager getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new FMFileManagerImpl();
            }
            FMFileManagerImpl fMFileManagerImpl = singleton;
            class_mon.exit();
            return fMFileManagerImpl;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    protected FMFileManagerImpl() {
        this.limit_size = COConfigurationManager.getIntParameter("File Max Open");
        this.limited = this.limit_size > 0;
        this.map = new LinkedHashMap(this.limit_size, 0.75f, true);
        if (this.limited) {
            this.close_queue_sem = new AESemaphore("FMFileManager::closeqsem");
            this.close_queue = new LinkedList();
            AEThread t = new AEThread("FMFileManager::closeQueueDispatcher"){

                public void runSupport() {
                    FMFileManagerImpl.this.closeQueueDispatch();
                }
            };
            t.setDaemon(true);
            t.start();
        }
    }

    public FMFile createFile(FMFileOwner owner, File file) throws FMFileManagerException {
        FMFileImpl res = this.limited ? new FMFileLimited(owner, this, file) : new FMFileUnlimited(owner, file);
        return res;
    }

    protected void getSlot(FMFileLimited file) {
        FMFileLimited oldest_file = null;
        try {
            this.map_mon.enter();
            if (this.map.size() >= this.limit_size) {
                Iterator it = this.map.keySet().iterator();
                oldest_file = (FMFileLimited)it.next();
                it.remove();
            }
            this.map.put(file, file);
        }
        finally {
            this.map_mon.exit();
        }
        if (oldest_file != null) {
            this.closeFile(oldest_file);
        }
    }

    protected void releaseSlot(FMFileLimited file) {
        try {
            this.map_mon.enter();
            this.map.remove(file);
        }
        finally {
            this.map_mon.exit();
        }
    }

    protected void usedSlot(FMFileLimited file) {
        try {
            this.map_mon.enter();
            if (this.map.containsKey(file)) {
                this.map.put(file, file);
            }
        }
        finally {
            this.map_mon.exit();
        }
    }

    protected void closeFile(FMFileLimited file) {
        try {
            this.close_queue_mon.enter();
            this.close_queue.add(file);
        }
        finally {
            this.close_queue_mon.exit();
        }
        this.close_queue_sem.release();
    }

    protected void closeQueueDispatch() {
        while (true) {
            this.close_queue_sem.reserve();
            FMFileLimited file = null;
            try {
                this.close_queue_mon.enter();
                if (this.close_queue.size() > 0) {
                    file = (FMFileLimited)this.close_queue.remove(0);
                }
            }
            finally {
                this.close_queue_mon.exit();
            }
            if (file == null) continue;
            try {
                file.close(false);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                continue;
            }
            break;
        }
    }
}

