/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class SelectorGuard {
    private final int countThreshold;
    private boolean marked = false;
    private int consecutiveZeroSelects = 0;
    private long beforeSelectTime;
    private long afterSelectTime;
    private static final boolean DISABLED = System.getProperty("java.version").startsWith("1.5");

    public SelectorGuard(int _count_threshold) {
        this.countThreshold = _count_threshold;
    }

    public void markPreSelectTime() {
        this.beforeSelectTime = SystemTime.getCurrentTime();
        this.marked = true;
    }

    public boolean isSelectorOK(int _num_keys_ready, long _time_threshold) {
        if (_num_keys_ready > 0) {
            this.consecutiveZeroSelects = 0;
            return true;
        }
        if (this.marked) {
            this.marked = false;
        } else {
            Debug.out("Error: You must run markPreSelectTime() before calling isSelectorOK");
        }
        this.afterSelectTime = SystemTime.getCurrentTime();
        long elapsedTime = this.afterSelectTime - this.beforeSelectTime;
        if (elapsedTime > _time_threshold) {
            this.consecutiveZeroSelects = 0;
            return true;
        }
        ++this.consecutiveZeroSelects;
        if (this.consecutiveZeroSelects > this.countThreshold) {
            this.consecutiveZeroSelects = 0;
            if (DISABLED) {
                LGLogger.log("WARNING: It looks like the socket selector is spinning, even though you are running JRE 1.5 series.");
                return true;
            }
            return false;
        }
        return true;
    }

    public Selector repairSelector(Selector _bad_selector) {
        String msg = "Likely network disconnect/reconnect: Repairing 1 selector, " + _bad_selector.keys().size() + " keys.\n";
        msg = String.valueOf(msg) + MessageText.getString("SelectorGuard.repairmessage");
        Debug.out(msg);
        LGLogger.logUnrepeatableAlert(1, msg);
        try {
            Thread.sleep(5000L);
            Selector newSelector = Selector.open();
            Iterator<SelectionKey> i = _bad_selector.keys().iterator();
            while (i.hasNext()) {
                SelectionKey key = i.next();
                i.remove();
                SelectableChannel channel = key.channel();
                channel.register(newSelector, key.interestOps(), key.attachment());
            }
            _bad_selector.close();
            Thread.sleep(2000L);
            return newSelector;
        }
        catch (Exception e) {
            Debug.out(e.getMessage());
            Debug.out("Unable to repair bad selector; returning original as still-bad");
            return _bad_selector;
        }
    }
}

