/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.networkmanager.RateControlledWriteEntity;
import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;

public class WriteController {
    private final VirtualChannelSelector write_selector = new VirtualChannelSelector(4);
    private volatile ArrayList normal_priority_entities = new ArrayList();
    private volatile ArrayList high_priority_entities = new ArrayList();
    private final AEMonitor entities_mon = new AEMonitor("WriteController:EM");
    private int next_normal_position = 0;
    private int next_high_position = 0;
    private static final int SELECT_TIME = 50;
    private static final int PROCESSOR_SLEEP_TIME = 20;

    protected WriteController() {
        AEThread write_selector_thread = new AEThread("WriteController:WriteSelector"){

            public void runSupport() {
                WriteController.this.writeSelectorLoop();
            }
        };
        write_selector_thread.setDaemon(true);
        write_selector_thread.start();
        AEThread write_processor_thread = new AEThread("WriteController:WriteProcessor"){

            public void runSupport() {
                WriteController.this.writeProcessorLoop();
            }
        };
        write_processor_thread.setDaemon(true);
        write_processor_thread.setPriority(9);
        write_processor_thread.start();
    }

    private void writeSelectorLoop() {
        while (true) {
            this.write_selector.select(50L);
        }
    }

    private void writeProcessorLoop() {
        boolean check_high_first = true;
        while (true) {
            if (check_high_first) {
                check_high_first = false;
                if (this.doHighPriorityWrite() || this.doNormalPriorityWrite()) continue;
                try {
                    Thread.sleep(20L);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
                continue;
            }
            check_high_first = true;
            if (this.doNormalPriorityWrite() || this.doHighPriorityWrite()) continue;
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
                continue;
            }
            break;
        }
    }

    private boolean doNormalPriorityWrite() {
        RateControlledWriteEntity ready_entity = this.getNextReadyNormalPriorityEntity();
        return ready_entity != null && ready_entity.doWrite();
    }

    private boolean doHighPriorityWrite() {
        RateControlledWriteEntity ready_entity = this.getNextReadyHighPriorityEntity();
        return ready_entity != null && ready_entity.doWrite();
    }

    private RateControlledWriteEntity getNextReadyNormalPriorityEntity() {
        ArrayList ref = this.normal_priority_entities;
        int size = ref.size();
        for (int num_checked = 0; num_checked < size; ++num_checked) {
            this.next_normal_position = this.next_normal_position >= size ? 0 : this.next_normal_position;
            RateControlledWriteEntity entity = (RateControlledWriteEntity)ref.get(this.next_normal_position);
            ++this.next_normal_position;
            if (!entity.canWrite()) continue;
            return entity;
        }
        return null;
    }

    private RateControlledWriteEntity getNextReadyHighPriorityEntity() {
        ArrayList ref = this.high_priority_entities;
        int size = ref.size();
        for (int num_checked = 0; num_checked < size; ++num_checked) {
            this.next_high_position = this.next_high_position >= size ? 0 : this.next_high_position;
            RateControlledWriteEntity entity = (RateControlledWriteEntity)ref.get(this.next_high_position);
            ++this.next_high_position;
            if (!entity.canWrite()) continue;
            return entity;
        }
        return null;
    }

    protected void addWriteEntity(RateControlledWriteEntity entity) {
        try {
            this.entities_mon.enter();
            if (entity.getPriority() == 1) {
                ArrayList<RateControlledWriteEntity> high_new = new ArrayList<RateControlledWriteEntity>(this.high_priority_entities.size() + 1);
                high_new.addAll(this.high_priority_entities);
                high_new.add(entity);
                this.high_priority_entities = high_new;
            } else {
                ArrayList<RateControlledWriteEntity> norm_new = new ArrayList<RateControlledWriteEntity>(this.normal_priority_entities.size() + 1);
                norm_new.addAll(this.normal_priority_entities);
                norm_new.add(entity);
                this.normal_priority_entities = norm_new;
            }
        }
        finally {
            this.entities_mon.exit();
        }
    }

    protected void removeWriteEntity(RateControlledWriteEntity entity) {
        try {
            this.entities_mon.enter();
            if (entity.getPriority() == 1) {
                ArrayList high_new = new ArrayList(this.high_priority_entities);
                high_new.remove(entity);
                this.high_priority_entities = high_new;
            } else {
                ArrayList norm_new = new ArrayList(this.normal_priority_entities);
                norm_new.remove(entity);
                this.normal_priority_entities = norm_new;
            }
        }
        finally {
            this.entities_mon.exit();
        }
    }

    protected VirtualChannelSelector getWriteSelector() {
        return this.write_selector;
    }
}

