/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messages.bittorrent;

import com.aelitis.azureus.core.peermanager.messages.bittorrent.BTProtocolMessage;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class BTRequest
implements BTProtocolMessage {
    private final DirectByteBuffer buffer;
    private final int piece_number;
    private final int piece_offset;
    private final int length;
    private final int total_byte_size;
    private final int hashcode;

    public BTRequest(int piece_number, int piece_offset, int length) {
        this.piece_number = piece_number;
        this.piece_offset = piece_offset;
        this.length = length;
        this.hashcode = piece_number + piece_offset + length;
        this.buffer = new DirectByteBuffer(ByteBuffer.allocate(17));
        this.buffer.putInt((byte)6, 13);
        this.buffer.put((byte)6, (byte)6);
        this.buffer.putInt((byte)6, piece_number);
        this.buffer.putInt((byte)6, piece_offset);
        this.buffer.putInt((byte)6, length);
        this.buffer.position((byte)6, 0);
        this.buffer.limit((byte)6, 17);
        this.total_byte_size = this.buffer.limit((byte)6);
    }

    public int getType() {
        return 6;
    }

    public DirectByteBuffer getPayload() {
        return this.buffer;
    }

    public int getTotalMessageByteSize() {
        return this.total_byte_size;
    }

    public String getDescription() {
        return "Request piece #" + this.piece_number + ": " + this.piece_offset + "->" + (this.piece_offset + this.length - 1);
    }

    public int getPriority() {
        return 1;
    }

    public boolean isNoDelay() {
        return true;
    }

    public boolean isDataMessage() {
        return false;
    }

    public void destroy() {
    }

    public int[] typesToRemove() {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof BTRequest) {
            BTRequest other = (BTRequest)obj;
            if (other.piece_number == this.piece_number && other.piece_offset == this.piece_offset && other.length == this.length) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode;
    }
}

