/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.utils;

import java.util.LinkedList;
import org.gudy.azureus2.core3.util.AEMonitor;

public class PeerConnectInfoStorage {
    private int capacity;
    private final LinkedList peer_infos = new LinkedList();
    private final AEMonitor peer_infos_mon = new AEMonitor("PeerConnectInfoStorage:PI");

    public PeerConnectInfoStorage(int max_capacity) {
        this.capacity = max_capacity;
    }

    public void setMaxCapacity(int new_max) {
        this.capacity = new_max;
    }

    public void addPeerInfo(PeerInfo peer_info) {
        try {
            this.peer_infos_mon.enter();
            if (this.capacity > 0 && !this.peer_infos.contains(peer_info)) {
                if (this.peer_infos.size() < this.capacity) {
                    this.peer_infos.addLast(peer_info);
                } else {
                    this.peer_infos.removeFirst();
                    this.peer_infos.addLast(peer_info);
                }
            }
        }
        finally {
            this.peer_infos_mon.exit();
        }
    }

    public PeerInfo getPeerInfo() {
        block3: {
            try {
                this.peer_infos_mon.enter();
                if (this.peer_infos.isEmpty()) break block3;
                PeerInfo peerInfo = (PeerInfo)this.peer_infos.removeFirst();
                this.peer_infos_mon.exit();
                return peerInfo;
            }
            catch (Throwable throwable) {
                this.peer_infos_mon.exit();
                throw throwable;
            }
        }
        PeerInfo peerInfo = null;
        this.peer_infos_mon.exit();
        return peerInfo;
    }

    public int getStoredCount() {
        try {
            this.peer_infos_mon.enter();
            int n = this.peer_infos.size();
            this.peer_infos_mon.exit();
            return n;
        }
        catch (Throwable throwable) {
            this.peer_infos_mon.exit();
            throw throwable;
        }
    }

    public static class PeerInfo {
        private final String address;
        private final int port;
        private final int hashcode;

        public PeerInfo(String address, int port) {
            this.address = address;
            this.port = port;
            this.hashcode = address.hashCode() + port;
        }

        public String getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && obj instanceof PeerInfo) {
                PeerInfo other = (PeerInfo)obj;
                if (this.port == other.port && this.address.equals(other.address)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.hashcode;
        }
    }
}

