/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.update.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.update.AzureusRestarter;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Properties;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.PluginInterface;

public class AzureusRestarterImpl
implements AzureusRestarter {
    private static final String MAIN_CLASS = "org.gudy.azureus2.update.Updater";
    private static final String UPDATER_JAR = "Updater.jar";
    public static final String UPDATE_PROPERTIES = "update.properties";
    protected static boolean restarted = false;
    protected AzureusCore azureus_core;
    protected String classpath_prefix;
    private static final String restartScriptName = "restartScript";

    public AzureusRestarterImpl(AzureusCore _azureus_core) {
        this.azureus_core = _azureus_core;
    }

    public void restart(boolean update_only) {
        if (restarted) {
            LGLogger.log("AzureusRestarted: already restarted!!!!");
            return;
        }
        restarted = true;
        PluginInterface pi = this.azureus_core.getPluginManager().getPluginInterfaceByID("azupdater");
        if (pi == null) {
            LGLogger.logUnrepeatableAlert(3, "Can't restart, mandatory plugin 'azupdater' not found");
            return;
        }
        String updater_dir = pi.getPluginDirectoryName();
        this.classpath_prefix = String.valueOf(updater_dir) + File.separator + UPDATER_JAR;
        String app_path = SystemProperties.getApplicationPath();
        while (app_path.endsWith(File.separator)) {
            app_path = app_path.substring(0, app_path.length() - 1);
        }
        String user_path = SystemProperties.getUserPath();
        while (user_path.endsWith(File.separator)) {
            user_path = user_path.substring(0, user_path.length() - 1);
        }
        String config_override = System.getProperty("azureus.config.path");
        if (config_override == null) {
            config_override = "";
        }
        String[] parameters = new String[]{update_only ? "updateonly" : "restart", app_path, user_path, config_override};
        FileOutputStream fos = null;
        try {
            try {
                Properties restart_properties = new Properties();
                long max_mem = Runtime.getRuntime().maxMemory();
                restart_properties.put("max_mem", "" + max_mem);
                fos = new FileOutputStream(new File(user_path, UPDATE_PROPERTIES));
                restart_properties.store(fos, "Azureus restart properties");
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        String[] properties = new String[]{"-Duser.dir=\"" + app_path + "\""};
        this.restartAzureus(new PrintWriter(new ByteArrayOutputStream()){

            public void println(String str) {
                LGLogger.log(str);
            }
        }, MAIN_CLASS, properties, parameters);
    }

    private String getClassPath() {
        String classPath = System.getProperty("java.class.path");
        classPath = String.valueOf(this.classpath_prefix) + System.getProperty("path.separator") + classPath;
        return "-classpath \"" + classPath + "\" ";
    }

    private boolean win32NativeRestart(PrintWriter log, String exec) {
        try {
            PlatformManager pm = PlatformManagerFactory.getPlatformManager();
            pm.createProcess(exec, false);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace(log);
            return false;
        }
    }

    private boolean isOSX() {
        return Constants.isOSX;
    }

    private boolean isLinux() {
        return Constants.isLinux;
    }

    public void restartAzureus(PrintWriter log, String mainClass, String[] properties, String[] parameters) {
        if (this.isOSX()) {
            this.restartAzureus_OSX(log, mainClass, properties, parameters);
        } else if (this.isLinux()) {
            this.restartAzureus_Linux(log, mainClass, properties, parameters);
        } else {
            this.restartAzureus_win32(log, mainClass, properties, parameters);
        }
    }

    private void restartAzureus_win32(PrintWriter log, String mainClass, String[] properties, String[] parameters) {
        String javaPath = String.valueOf(System.getProperty("java.home")) + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator");
        String exec = "\"" + javaPath + "javaw\" " + this.getClassPath() + this.getLibraryPath();
        int i = 0;
        while (i < properties.length) {
            exec = String.valueOf(exec) + properties[i] + " ";
            ++i;
        }
        exec = String.valueOf(exec) + mainClass;
        i = 0;
        while (i < parameters.length) {
            exec = String.valueOf(exec) + " \"" + parameters[i] + "\"";
            ++i;
        }
        if (log != null) {
            log.println("  " + exec);
        }
        if (!this.win32NativeRestart(log, exec)) {
            try {
                log.println("Using java spawn");
                Process p = Runtime.getRuntime().exec(exec);
                log.println("    -> " + p);
            }
            catch (Throwable f) {
                f.printStackTrace(log);
            }
        }
    }

    private void restartAzureus_OSX(PrintWriter log, String mainClass, String[] properties, String[] parameters) {
        String userPath = System.getProperty("user.dir");
        String exec = "#!/bin/bash\nulimit -H -S -n 8192\n\"" + userPath + "/Azureus.app/Contents/MacOS/java_swt\" " + this.getClassPath() + this.getLibraryPath();
        int i = 0;
        while (i < properties.length) {
            exec = String.valueOf(exec) + properties[i] + " ";
            ++i;
        }
        exec = String.valueOf(exec) + mainClass;
        i = 0;
        while (i < parameters.length) {
            exec = String.valueOf(exec) + " \"" + parameters[i] + "\"";
            ++i;
        }
        if (log != null) {
            log.println("  " + exec);
        }
        String fileName = String.valueOf(userPath) + "/Azureus.app/" + restartScriptName;
        File fUpdate = new File(fileName);
        try {
            FileOutputStream fosUpdate = new FileOutputStream(fUpdate, false);
            fosUpdate.write(exec.getBytes());
            fosUpdate.close();
            this.chMod(fileName, "755", log);
            Runtime.getRuntime().exec("Azureus.app/restartScript");
        }
        catch (Exception e) {
            log.println(e);
            e.printStackTrace(log);
        }
    }

    private void restartAzureus_Linux(PrintWriter log, String mainClass, String[] properties, String[] parameters) {
        String userPath = System.getProperty("user.dir");
        String javaPath = String.valueOf(System.getProperty("java.home")) + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator");
        String exec = "#!/bin/bash\n\"" + javaPath + "java\" " + this.getClassPath() + this.getLibraryPath();
        int i = 0;
        while (i < properties.length) {
            exec = String.valueOf(exec) + properties[i] + " ";
            ++i;
        }
        exec = String.valueOf(exec) + mainClass;
        i = 0;
        while (i < parameters.length) {
            exec = String.valueOf(exec) + " \"" + parameters[i] + "\"";
            ++i;
        }
        if (log != null) {
            log.println("  " + exec);
        }
        String fileName = String.valueOf(userPath) + "/" + restartScriptName;
        File fUpdate = new File(fileName);
        try {
            FileOutputStream fosUpdate = new FileOutputStream(fUpdate, false);
            fosUpdate.write(exec.getBytes());
            fosUpdate.close();
            this.chMod(fileName, "755", log);
            Runtime.getRuntime().exec("./restartScript");
        }
        catch (Exception e) {
            log.println(e);
            e.printStackTrace(log);
        }
    }

    private String getLibraryPath() {
        String libraryPath = System.getProperty("java.library.path");
        if (libraryPath == null) {
            libraryPath = "";
        } else {
            String temp = "";
            int i = 0;
            while (i < libraryPath.length()) {
                char c = libraryPath.charAt(i);
                if (c != '\"') {
                    temp = String.valueOf(temp) + c;
                }
                ++i;
            }
            libraryPath = temp;
            while (libraryPath.endsWith(File.separator)) {
                libraryPath = libraryPath.substring(0, libraryPath.length() - 1);
            }
            if (libraryPath.length() > 0) {
                libraryPath = "-Djava.library.path=\"" + libraryPath + "\" ";
            }
        }
        return libraryPath;
    }

    private void logStream(String message, InputStream stream, PrintWriter log) {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        String line = null;
        log.println(message);
        try {
            while ((line = br.readLine()) != null) {
                log.println(line);
            }
        }
        catch (Exception e) {
            log.println(e);
            e.printStackTrace(log);
        }
    }

    private void chMod(String fileName, String rights, PrintWriter log) {
        String[] execStr = new String[]{"chmod", rights, fileName};
        log.println("About to execute : " + execStr[0] + " " + execStr[1] + " " + execStr[2]);
        try {
            Process pChMod = Runtime.getRuntime().exec(execStr);
            pChMod.waitFor();
            this.logStream("Execution Output", pChMod.getInputStream(), log);
            this.logStream("Execution Error", pChMod.getErrorStream(), log);
        }
        catch (Exception e) {
            log.println(e);
            e.printStackTrace(log);
        }
    }
}

