/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.upnp;

import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.azureus.plugins.upnp.UPnPMappingListener;
import com.aelitis.azureus.plugins.upnp.UPnPMappingManager;
import com.aelitis.azureus.plugins.upnp.UPnPMappingManagerListener;
import com.aelitis.azureus.plugins.upnp.UPnPPluginService;
import com.aelitis.net.upnp.UPnP;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPFactory;
import com.aelitis.net.upnp.UPnPListener;
import com.aelitis.net.upnp.UPnPLogListener;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.UPnPRootDeviceListener;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.services.UPnPWANConnection;
import com.aelitis.net.upnp.services.UPnPWANConnectionPortMapping;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;

public class UPnPPlugin
implements Plugin,
UPnPMappingListener {
    protected PluginInterface plugin_interface;
    protected LoggerChannel log;
    protected UPnPMappingManager mapping_manager = UPnPMappingManager.getSingleton();
    protected UPnP upnp;
    protected BooleanParameter alert_success_param;
    protected BooleanParameter grab_ports_param;
    protected BooleanParameter alert_other_port_param;
    protected BooleanParameter alert_device_probs_param;
    protected BooleanParameter release_mappings_param;
    protected List mappings = new ArrayList();
    protected List services = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("UPnPPlugin");

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Universal Plug and Play (UPnP)");
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
            }

            public void closedownInitiated() {
            }

            public void closedownComplete() {
                UPnPPlugin.this.closeDown(true);
            }
        });
        this.log = this.plugin_interface.getLogger().getChannel("UPnP");
        UIManager ui_manager = this.plugin_interface.getUIManager();
        final BasicPluginViewModel model = ui_manager.createBasicPluginViewModel("UPnP");
        BasicPluginConfigModel config = ui_manager.createBasicPluginConfigModel("Plugins", "UPnP");
        config.addLabelParameter2("upnp.info");
        final BooleanParameter enable_param = config.addBooleanParameter2("upnp.enable", "upnp.enable", true);
        this.grab_ports_param = config.addBooleanParameter2("upnp.grabports", "upnp.grabports", false);
        this.release_mappings_param = config.addBooleanParameter2("upnp.releasemappings", "upnp.releasemappings", true);
        ActionParameter refresh_param = config.addActionParameter2("upnp.refresh.label", "upnp.refresh.button");
        refresh_param.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                UPnPPlugin.this.upnp.reset();
            }
        });
        config.addLabelParameter2("blank.resource");
        this.alert_success_param = config.addBooleanParameter2("upnp.alertsuccess", "upnp.alertsuccess", false);
        this.alert_other_port_param = config.addBooleanParameter2("upnp.alertothermappings", "upnp.alertothermappings", true);
        this.alert_device_probs_param = config.addBooleanParameter2("upnp.alertdeviceproblems", "upnp.alertdeviceproblems", true);
        enable_param.addEnabledOnSelection(this.alert_success_param);
        enable_param.addEnabledOnSelection(this.grab_ports_param);
        enable_param.addEnabledOnSelection(refresh_param);
        enable_param.addEnabledOnSelection(this.alert_other_port_param);
        enable_param.addEnabledOnSelection(this.alert_device_probs_param);
        enable_param.addEnabledOnSelection(this.release_mappings_param);
        boolean enabled = enable_param.getValue();
        model.getStatus().setText(enabled ? "Running" : "Disabled");
        enable_param.addListener(new ParameterListener(){

            public void parameterChanged(Parameter p) {
                boolean e = enable_param.getValue();
                model.getStatus().setText(e ? "Running" : "Disabled");
                if (e) {
                    UPnPPlugin.this.startUp();
                } else {
                    UPnPPlugin.this.closeDown(true);
                }
            }
        });
        model.getActivity().setVisible(false);
        model.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String message) {
                model.getLogArea().appendText(String.valueOf(message) + "\n");
            }

            public void messageLogged(String str, Throwable error) {
                model.getLogArea().appendText(String.valueOf(error.toString()) + "\n");
            }
        });
        if (enabled) {
            this.startUp();
        }
    }

    protected void startUp() {
        if (this.upnp != null) {
            this.upnp.reset();
            return;
        }
        try {
            this.upnp = UPnPFactory.getSingleton(this.plugin_interface);
            this.upnp.addRootDeviceListener(new UPnPListener(){

                public void rootDeviceFound(UPnPRootDevice device) {
                    try {
                        UPnPPlugin.this.processDevice(device.getDevice());
                    }
                    catch (Throwable e) {
                        UPnPPlugin.this.log.log("Root device processing fails", e);
                    }
                }
            });
            this.upnp.addLogListener(new UPnPLogListener(){

                public void log(String str) {
                    UPnPPlugin.this.log.log(str);
                }
            });
            this.mapping_manager.addListener(new UPnPMappingManagerListener(){

                public void mappingAdded(UPnPMapping mapping) {
                    UPnPPlugin.this.addMapping(mapping);
                }
            });
            UPnPMapping[] upnp_mappings = this.mapping_manager.getMappings();
            int i = 0;
            while (i < upnp_mappings.length) {
                this.addMapping(upnp_mappings[i]);
                ++i;
            }
        }
        catch (Throwable e) {
            this.log.log(e);
        }
    }

    protected void closeDown(boolean end_of_day) {
        int i = 0;
        while (i < this.mappings.size()) {
            UPnPMapping mapping = (UPnPMapping)this.mappings.get(i);
            if (mapping.isEnabled()) {
                int j = 0;
                while (j < this.services.size()) {
                    UPnPPluginService service = (UPnPPluginService)this.services.get(j);
                    service.removeMapping(this.log, mapping, end_of_day);
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void processDevice(UPnPDevice device) throws UPnPException {
        if (device.getDeviceType().equalsIgnoreCase("urn:schemas-upnp-org:device:WANConnectionDevice:1")) {
            this.log.log("Found WANConnectionDevice");
            this.processServices(device, device.getServices());
        } else {
            UPnPDevice[] kids = device.getSubDevices();
            int i = 0;
            while (i < kids.length) {
                this.processDevice(kids[i]);
                ++i;
            }
        }
    }

    protected void processServices(UPnPDevice device, UPnPService[] device_services) throws UPnPException {
        int i = 0;
        while (i < device_services.length) {
            UPnPService s = device_services[i];
            String service_type = s.getServiceType();
            if (service_type.equalsIgnoreCase("urn:schemas-upnp-org:service:WANIPConnection:1") || service_type.equalsIgnoreCase("urn:schemas-upnp-org:service:WANPPPConnection:1")) {
                final UPnPWANConnection wan_service = (UPnPWANConnection)s.getSpecificService();
                device.getRootDevice().addListener(new UPnPRootDeviceListener(){

                    public void lost(UPnPRootDevice root, boolean replaced) {
                        UPnPPlugin.this.removeService(wan_service, replaced);
                    }
                });
                this.addService(wan_service);
            }
            ++i;
        }
    }

    protected void addService(UPnPWANConnection wan_service) throws UPnPException {
        try {
            this.this_mon.enter();
            this.log.log("    Found " + (wan_service.getGenericService().getServiceType().indexOf("PPP") == -1 ? "WANIPConnection" : "WANPPPConnection"));
            UPnPWANConnectionPortMapping[] ports = wan_service.getPortMappings();
            int j = 0;
            while (j < ports.length) {
                this.log.log("      mapping [" + j + "] " + ports[j].getExternalPort() + "/" + (ports[j].isTCP() ? "TCP" : "UDP") + " [" + ports[j].getDescription() + "] -> " + ports[j].getInternalHost());
                ++j;
            }
            this.services.add(new UPnPPluginService(wan_service, ports, this.alert_success_param, this.grab_ports_param, this.alert_other_port_param, this.release_mappings_param));
            this.checkState();
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void removeService(UPnPWANConnection wan_service, boolean replaced) {
        try {
            this.this_mon.enter();
            String name = wan_service.getGenericService().getServiceType().indexOf("PPP") == -1 ? "WANIPConnection" : "WANPPPConnection";
            String text = MessageText.getString("upnp.alert.lostdevice", new String[]{name, wan_service.getGenericService().getDevice().getRootDevice().getLocation().getHost()});
            this.log.log(text);
            if (!replaced && this.alert_device_probs_param.getValue()) {
                this.log.logAlertRepeatable(2, text);
            }
            int i = 0;
            while (i < this.services.size()) {
                UPnPPluginService ps = (UPnPPluginService)this.services.get(i);
                if (ps.getService() == wan_service) {
                    this.services.remove(i);
                    break;
                }
                ++i;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void addMapping(UPnPMapping mapping) {
        try {
            this.this_mon.enter();
            this.mappings.add(mapping);
            this.log.log("Mapping request: " + mapping.getString() + ", enabled = " + mapping.isEnabled());
            mapping.addListener(this);
            this.checkState();
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void mappingChanged(UPnPMapping mapping) {
        this.checkState();
    }

    public void mappingDestroyed(UPnPMapping mapping) {
        try {
            this.this_mon.enter();
            this.mappings.remove(mapping);
            int j = 0;
            while (j < this.services.size()) {
                UPnPPluginService service = (UPnPPluginService)this.services.get(j);
                service.removeMapping(this.log, mapping, false);
                ++j;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void checkState() {
        try {
            this.this_mon.enter();
            int i = 0;
            while (i < this.mappings.size()) {
                UPnPMapping mapping = (UPnPMapping)this.mappings.get(i);
                int j = 0;
                while (j < this.services.size()) {
                    UPnPPluginService service = (UPnPPluginService)this.services.get(j);
                    service.checkMapping(this.log, mapping);
                    ++j;
                }
                ++i;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public UPnPMapping addMapping(String desc_resource, boolean tcp, int port, boolean enabled) {
        return UPnPMappingManager.getSingleton().addMapping(desc_resource, tcp, port, enabled);
    }

    public UPnPMapping getMapping(boolean tcp, int port) {
        return UPnPMappingManager.getSingleton().getMapping(tcp, port);
    }
}

