/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl.device;

import com.aelitis.net.upnp.UPnPAction;
import com.aelitis.net.upnp.UPnPActionArgument;
import com.aelitis.net.upnp.UPnPActionInvocation;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.impl.device.UPnPServiceImpl;
import com.aelitis.net.upnp.services.UPnPWANConnectionPortMapping;
import java.util.ArrayList;

public class UPnPSSWANConnectionImpl {
    protected UPnPServiceImpl service;

    protected UPnPSSWANConnectionImpl(UPnPServiceImpl _service) {
        this.service = _service;
    }

    public UPnPService getGenericService() {
        return this.service;
    }

    public void addPortMapping(boolean tcp, int port, String description) throws UPnPException {
        UPnPAction act = this.service.getAction("AddPortMapping");
        if (act == null) {
            this.service.getDevice().getRootDevice().getUPnP().log("Action 'AddPortMapping' not supported, binding not established");
        } else {
            UPnPActionInvocation inv = act.getInvocation();
            inv.addArgument("NewRemoteHost", "");
            inv.addArgument("NewExternalPort", "" + port);
            inv.addArgument("NewProtocol", tcp ? "TCP" : "UDP");
            inv.addArgument("NewInternalPort", "" + port);
            inv.addArgument("NewInternalClient", this.service.getDevice().getRootDevice().getLocalAddress().getHostAddress());
            inv.addArgument("NewEnabled", "1");
            inv.addArgument("NewPortMappingDescription", description);
            inv.addArgument("NewLeaseDuration", "0");
            inv.invoke();
        }
    }

    public void deletePortMapping(boolean tcp, int port) throws UPnPException {
        UPnPAction act = this.service.getAction("DeletePortMapping");
        if (act == null) {
            this.service.getDevice().getRootDevice().getUPnP().log("Action 'DeletePortMapping' not supported, binding not removed");
        } else {
            UPnPActionInvocation inv = act.getInvocation();
            inv.addArgument("NewRemoteHost", "");
            inv.addArgument("NewProtocol", tcp ? "TCP" : "UDP");
            inv.addArgument("NewExternalPort", "" + port);
            inv.invoke();
        }
    }

    public UPnPWANConnectionPortMapping[] getPortMappings() throws UPnPException {
        int entries = 0;
        UPnPAction act = this.service.getAction("GetGenericPortMappingEntry");
        if (act == null) {
            this.service.getDevice().getRootDevice().getUPnP().log("Action 'GetGenericPortMappingEntry' not supported, can't enumerate bindings");
            return new UPnPWANConnectionPortMapping[0];
        }
        ArrayList<portMapping> res = new ArrayList<portMapping>();
        portMapping prev_mapping = null;
        int i = 0;
        while (i < (entries == 0 ? 512 : entries)) {
            UPnPActionInvocation inv = act.getInvocation();
            inv.addArgument("NewPortMappingIndex", "" + i);
            try {
                UPnPActionArgument[] outs = inv.invoke();
                int port = 0;
                boolean tcp = false;
                String internal_host = null;
                String description = "";
                int j = 0;
                while (j < outs.length) {
                    UPnPActionArgument out = outs[j];
                    String out_name = out.getName();
                    if (out_name.equalsIgnoreCase("NewExternalPort")) {
                        port = Integer.parseInt(out.getValue());
                    } else if (out_name.equalsIgnoreCase("NewProtocol")) {
                        tcp = out.getValue().equalsIgnoreCase("TCP");
                    } else if (out_name.equalsIgnoreCase("NewInternalClient")) {
                        internal_host = out.getValue();
                    } else if (out_name.equalsIgnoreCase("NewPortMappingDescription")) {
                        description = out.getValue();
                    }
                    ++j;
                }
                if (prev_mapping != null && prev_mapping.getExternalPort() == port && prev_mapping.isTCP() == tcp) break;
                prev_mapping = new portMapping(port, tcp, internal_host, description);
                res.add(prev_mapping);
            }
            catch (UPnPException e) {
                if (entries == 0) break;
                throw e;
            }
            ++i;
        }
        UPnPWANConnectionPortMapping[] res2 = new UPnPWANConnectionPortMapping[res.size()];
        res.toArray(res2);
        return res2;
    }

    protected class portMapping
    implements UPnPWANConnectionPortMapping {
        protected int external_port;
        protected boolean tcp;
        protected String internal_host;
        protected String description;

        protected portMapping(int _external_port, boolean _tcp, String _internal_host, String _description) {
            this.external_port = _external_port;
            this.tcp = _tcp;
            this.internal_host = _internal_host;
            this.description = _description;
        }

        public boolean isTCP() {
            return this.tcp;
        }

        public int getExternalPort() {
            return this.external_port;
        }

        public String getInternalHost() {
            return this.internal_host;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

