/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralNames;

public class IssuerSerial
implements DEREncodable {
    GeneralNames issuer;
    DERInteger serial;
    DERBitString issuerUID;

    public IssuerSerial(ASN1Sequence seq) {
        this.issuer = GeneralNames.getInstance(seq.getObjectAt(0));
        this.serial = (DERInteger)seq.getObjectAt(1);
        if (seq.size() == 3) {
            this.issuerUID = (DERBitString)seq.getObjectAt(2);
        }
    }

    public GeneralNames getIssuer() {
        return this.issuer;
    }

    public DERInteger getSerial() {
        return this.serial;
    }

    public DERBitString getIssuerUID() {
        return this.issuerUID;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.issuer);
        v.add(this.serial);
        if (this.issuerUID != null) {
            v.add(this.issuerUID);
        }
        return new DERSequence(v);
    }
}

